package jp.sf.stconv.hatena.pipeline.valve;

import java.io.BufferedWriter;
import java.io.IOException;

/**
 * Definition List
 * 定義リスト(DL)
 * @author takeharu
 *
 */
public class ConvertDefinitionListValve extends AbstractHatenaValve
{

	private String pattern = "^[\\:].*?";

	private boolean tagStartFlg;

	protected String getPattern()
	{
		return pattern;
	}

	protected void writeMatchLine(BufferedWriter writer, String line)
			throws IOException
	{
		if(!tagStartFlg)
		{
			writer.write("<dl>");
			writer.newLine();
			tagStartFlg = true;
		}
		String[] strArray = line.split(":");
		for(int i = 1;i<strArray.length;i++)
		{
			if(i==1) {
				writer.write("<dt>" + strArray[i] + "</dt>");
			}else {
			writer.write("<dd>" + strArray[i] + "</dd>");
			}
		}
		writer.newLine();
	}

	protected void writeUnmatchLine(BufferedWriter writer, String line)
			throws IOException
	{
		if(tagStartFlg)
		{
			writer.write("</dl>");
			writer.newLine();
			tagStartFlg = false;
			super.writeUnmatchLine(writer,line);
		}
		else
		{
			super.writeUnmatchLine(writer, line);
		}
	}

	protected void finish(BufferedWriter writer) throws IOException
	{
		if(tagStartFlg)
		{
			writer.write("</dl>");
			writer.newLine();
			tagStartFlg = false;
		}
		else
		{
			super.finish(writer);
		}
	}
}
