/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.stconv.wiki.pipeline.callback.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jp.sf.stconv.wiki.pipeline.callback.LinkGeneratorCallback;

public class SimpleLinkGeneratorCallbackImpl
implements LinkGeneratorCallback {
    private Map attributes;
    private String baseUrl;
    private String encoding;

    public SimpleLinkGeneratorCallbackImpl(String baseUrl) {
        this(baseUrl, "UTF-8");
    }

    public SimpleLinkGeneratorCallbackImpl(String baseUrl, String encoding) {
        this.baseUrl = baseUrl;
        this.encoding = encoding;
    }

    public void addAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public String getUrl() {
        StringBuffer url = new StringBuffer(this.baseUrl);
        boolean newParam = this.baseUrl.endsWith("?");
        Set entries = this.attributes.entrySet();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (newParam) {
                url.append("&");
            } else {
                url.append("?");
                newParam = true;
            }
            try {
                url.append(URLEncoder.encode((String)entry.getKey(), this.encoding));
            }
            catch (UnsupportedEncodingException e) {
                url.append((String)entry.getKey());
            }
            url.append("=");
            try {
                url.append(URLEncoder.encode((String)entry.getValue(), this.encoding));
            }
            catch (UnsupportedEncodingException e) {
                url.append((String)entry.getValue());
            }
        }
        return url.toString();
    }

    public void init() {
        if (this.attributes != null) {
            this.attributes.clear();
        } else {
            this.attributes = new HashMap();
        }
    }
}

