/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.util.Locale;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.render.PrintRendererConfigurator;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.intermediate.IFDocumentHandler;
import org.apache.fop.render.intermediate.IFDocumentHandlerConfigurator;
import org.apache.fop.render.ps.PSDocumentHandler;
import org.apache.fop.render.ps.PSRenderingMode;
import org.apache.fop.render.ps.PSRenderingUtil;

public class PSRendererConfigurator
extends PrintRendererConfigurator
implements IFDocumentHandlerConfigurator {
    public PSRendererConfigurator(FOUserAgent userAgent) {
        super(userAgent);
    }

    public void configure(Renderer renderer) {
        throw new UnsupportedOperationException();
    }

    private void configure(PSRenderingUtil psUtil, Configuration cfg) {
        psUtil.setAutoRotateLandscape(cfg.getChild("auto-rotate-landscape").getValueAsBoolean(false));
        Configuration child = cfg.getChild("language-level");
        if (child != null) {
            psUtil.setLanguageLevel(child.getValueAsInteger(3));
        }
        if ((child = cfg.getChild("optimize-resources")) != null) {
            psUtil.setOptimizeResources(child.getValueAsBoolean(false));
        }
        if ((child = cfg.getChild("rendering")) != null) {
            psUtil.setRenderingMode(PSRenderingMode.valueOf(child.getValue(psUtil.getRenderingMode().toString()).toUpperCase(Locale.ENGLISH)));
        }
        psUtil.setSafeSetPageDevice(cfg.getChild("safe-set-page-device").getValueAsBoolean(false));
        psUtil.setDSCComplianceEnabled(cfg.getChild("dsc-compliant").getValueAsBoolean(true));
    }

    public void configure(IFDocumentHandler documentHandler) throws FOPException {
        Configuration cfg = super.getRendererConfig(documentHandler.getMimeType());
        if (cfg != null) {
            PSDocumentHandler psDocumentHandler = (PSDocumentHandler)documentHandler;
            this.configure(psDocumentHandler.getPSUtil(), cfg);
        }
    }
}

