
 id=F104;
 object[id].max_draw_dist=5000;
 object[id].always_draw_dist=50;

 object[id].nvertices = 161;
 object[id].nfacets   =  94; /* Excluding control surface polys */
 object[id].nctrl_srf =  13;

 object[id].ctrl_surface[0].hinge.x      =  -6.40;
 object[id].ctrl_surface[0].hinge.y      =   0;
 object[id].ctrl_surface[0].hinge.z      =   2.34;
 object[id].ctrl_surface[0].rudder_gain  =   0;
 object[id].ctrl_surface[0].aileron_gain =   0;
 object[id].ctrl_surface[0].elevator_gain=   1;
 object[id].ctrl_surface[0].flap_gain    =   0;
 object[id].ctrl_surface[0].brake_gain   =   0;
 object[id].ctrl_surface[0].gear_gain    =   0;
 object[id].ctrl_surface[0].gear_id      =  -1;
 object[id].ctrl_surface[0].nctrlpoly    =   4;
 object[id].ctrl_surface[0].poly_id[0]   =  94;
 object[id].ctrl_surface[0].poly_id[1]   =  95;
 object[id].ctrl_surface[0].poly_id[2]   =  96;
 object[id].ctrl_surface[0].poly_id[3]   =  97;

 object[id].ctrl_surface[1].hinge.x      =  -6.81;
 object[id].ctrl_surface[1].hinge.y      =   0;
 object[id].ctrl_surface[1].hinge.z      =   2.34;
 object[id].ctrl_surface[1].rudder_gain  =   1;
 object[id].ctrl_surface[1].aileron_gain =   0;
 object[id].ctrl_surface[1].elevator_gain=   0;
 object[id].ctrl_surface[1].flap_gain    =   0;
 object[id].ctrl_surface[1].brake_gain   =   0;
 object[id].ctrl_surface[1].gear_gain    =   0;
 object[id].ctrl_surface[1].gear_id      =  -1;
 object[id].ctrl_surface[1].nctrlpoly    =   2;
 object[id].ctrl_surface[1].poly_id[0]   =  98;
 object[id].ctrl_surface[1].poly_id[1]   =  99;

 object[id].ctrl_surface[2].hinge.x      =  -1.69;
 object[id].ctrl_surface[2].hinge.y      =   2.42;
 object[id].ctrl_surface[2].hinge.z      =  -0.23;
 object[id].ctrl_surface[2].rudder_gain  =   0;
 object[id].ctrl_surface[2].aileron_gain =   1;
 object[id].ctrl_surface[2].elevator_gain=   0;
 object[id].ctrl_surface[2].flap_gain    =   0;
 object[id].ctrl_surface[2].brake_gain   =   0;
 object[id].ctrl_surface[2].gear_gain    =   0;
 object[id].ctrl_surface[2].gear_id      =  -1;
 object[id].ctrl_surface[2].nctrlpoly    =   2;
 object[id].ctrl_surface[2].poly_id[0]   = 100;
 object[id].ctrl_surface[2].poly_id[1]   = 101;

 object[id].ctrl_surface[3].hinge.x      =  -1.69;
 object[id].ctrl_surface[3].hinge.y      =  -2.42;
 object[id].ctrl_surface[3].hinge.z      =  -0.23;
 object[id].ctrl_surface[3].rudder_gain  =   0;
 object[id].ctrl_surface[3].aileron_gain =  -1;
 object[id].ctrl_surface[3].elevator_gain=   0;
 object[id].ctrl_surface[3].flap_gain    =   0;
 object[id].ctrl_surface[3].brake_gain   =   0;
 object[id].ctrl_surface[3].gear_gain    =   0;
 object[id].ctrl_surface[3].gear_id      =  -1;
 object[id].ctrl_surface[3].nctrlpoly    =   2;
 object[id].ctrl_surface[3].poly_id[0]   = 102;
 object[id].ctrl_surface[3].poly_id[1]   = 103;

 object[id].ctrl_surface[4].hinge.x      =  -1.69;
 object[id].ctrl_surface[4].hinge.y      =   2.42;
 object[id].ctrl_surface[4].hinge.z      =  -0.23;
 object[id].ctrl_surface[4].rudder_gain  =   0;
 object[id].ctrl_surface[4].aileron_gain =   0;
 object[id].ctrl_surface[4].elevator_gain=   0;
 object[id].ctrl_surface[4].flap_gain    =   1.5;
 object[id].ctrl_surface[4].brake_gain   =   0;
 object[id].ctrl_surface[4].gear_gain    =   0;
 object[id].ctrl_surface[4].gear_id      =  -1;
 object[id].ctrl_surface[4].nctrlpoly    =   2;
 object[id].ctrl_surface[4].poly_id[0]   = 104;
 object[id].ctrl_surface[4].poly_id[1]   = 105;

 object[id].ctrl_surface[5].hinge.x      =  -1.69;
 object[id].ctrl_surface[5].hinge.y      =  -2.42;
 object[id].ctrl_surface[5].hinge.z      =  -0.23;
 object[id].ctrl_surface[5].rudder_gain  =   0;
 object[id].ctrl_surface[5].aileron_gain =   0;
 object[id].ctrl_surface[5].elevator_gain=   0;
 object[id].ctrl_surface[5].flap_gain    =   1.5;
 object[id].ctrl_surface[5].brake_gain   =   0;
 object[id].ctrl_surface[5].gear_gain    =   0;
 object[id].ctrl_surface[5].gear_id      =  -1;
 object[id].ctrl_surface[5].nctrlpoly    =   2;
 object[id].ctrl_surface[5].poly_id[0]   = 106;
 object[id].ctrl_surface[5].poly_id[1]   = 107;

 object[id].ctrl_surface[6].hinge.x      =   0.15;
 object[id].ctrl_surface[6].hinge.y      =   1.05;
 object[id].ctrl_surface[6].hinge.z      =   0.00;
 object[id].ctrl_surface[6].rudder_gain  =   0;
 object[id].ctrl_surface[6].aileron_gain =   0;
 object[id].ctrl_surface[6].elevator_gain=   0;
 object[id].ctrl_surface[6].flap_gain    =   0.75;
 object[id].ctrl_surface[6].brake_gain   =   0;
 object[id].ctrl_surface[6].gear_gain    =   0;
 object[id].ctrl_surface[6].gear_id      =  -1;
 object[id].ctrl_surface[6].nctrlpoly    =   2;
 object[id].ctrl_surface[6].poly_id[0]   = 108;
 object[id].ctrl_surface[6].poly_id[1]   = 109;

 object[id].ctrl_surface[7].hinge.x      =   0.15;
 object[id].ctrl_surface[7].hinge.y      =  -1.05;
 object[id].ctrl_surface[7].hinge.z      =   0.00;
 object[id].ctrl_surface[7].rudder_gain  =   0;
 object[id].ctrl_surface[7].aileron_gain =   0;
 object[id].ctrl_surface[7].elevator_gain=   0;
 object[id].ctrl_surface[7].flap_gain    =   0.75;
 object[id].ctrl_surface[7].brake_gain   =   0;
 object[id].ctrl_surface[7].gear_gain    =   0;
 object[id].ctrl_surface[7].gear_id      =  -1;
 object[id].ctrl_surface[7].nctrlpoly    =   2;
 object[id].ctrl_surface[7].poly_id[0]   = 110;
 object[id].ctrl_surface[7].poly_id[1]   = 111;

 object[id].ctrl_surface[8].hinge.x      =  -3.34;
 object[id].ctrl_surface[8].hinge.y      =   0.65;
 object[id].ctrl_surface[8].hinge.z      =   0.00;
 object[id].ctrl_surface[8].rudder_gain  =   0;
 object[id].ctrl_surface[8].aileron_gain =   0;
 object[id].ctrl_surface[8].elevator_gain=   0;
 object[id].ctrl_surface[8].flap_gain    =   0;
 object[id].ctrl_surface[8].brake_gain   = -45;
 object[id].ctrl_surface[8].gear_gain    =   0;
 object[id].ctrl_surface[8].gear_id      =  -1;
 object[id].ctrl_surface[8].nctrlpoly    =   2;
 object[id].ctrl_surface[8].poly_id[0]   = 112;
 object[id].ctrl_surface[8].poly_id[1]   = 113;

 object[id].ctrl_surface[9].hinge.x      =  -3.34;
 object[id].ctrl_surface[9].hinge.y      =  -0.65;
 object[id].ctrl_surface[9].hinge.z      =   0.00;
 object[id].ctrl_surface[9].rudder_gain  =   0;
 object[id].ctrl_surface[9].aileron_gain =   0;
 object[id].ctrl_surface[9].elevator_gain=   0;
 object[id].ctrl_surface[9].flap_gain    =   0;
 object[id].ctrl_surface[9].brake_gain   =  45;
 object[id].ctrl_surface[9].gear_gain    =   0;
 object[id].ctrl_surface[9].gear_id      =  -1;
 object[id].ctrl_surface[9].nctrlpoly    =   2;
 object[id].ctrl_surface[9].poly_id[0]   = 114;
 object[id].ctrl_surface[9].poly_id[1]   = 115;

 object[id].ctrl_surface[10].hinge.x      =  -0.62;
 object[id].ctrl_surface[10].hinge.y      =   0.50;
 object[id].ctrl_surface[10].hinge.z      =  -0.50;
 object[id].ctrl_surface[10].rudder_gain  =   0;
 object[id].ctrl_surface[10].aileron_gain =   0;
 object[id].ctrl_surface[10].elevator_gain=   0;
 object[id].ctrl_surface[10].flap_gain    =   0;
 object[id].ctrl_surface[10].brake_gain   =   0;
 object[id].ctrl_surface[10].gear_gain    =  90;
 object[id].ctrl_surface[10].gear_id      =   1;
 object[id].ctrl_surface[10].nctrlpoly    =   4;
 object[id].ctrl_surface[10].poly_id[0]   = 116;
 object[id].ctrl_surface[10].poly_id[1]   = 117;
 object[id].ctrl_surface[10].poly_id[2]   = 118;
 object[id].ctrl_surface[10].poly_id[3]   = 119;

 object[id].ctrl_surface[11].hinge.x      =  -0.62;
 object[id].ctrl_surface[11].hinge.y      =  -0.50;
 object[id].ctrl_surface[11].hinge.z      =  -0.50;
 object[id].ctrl_surface[11].rudder_gain  =   0;
 object[id].ctrl_surface[11].aileron_gain =   0;
 object[id].ctrl_surface[11].elevator_gain=   0;
 object[id].ctrl_surface[11].flap_gain    =   0;
 object[id].ctrl_surface[11].brake_gain   =   0;
 object[id].ctrl_surface[11].gear_gain    =  90;
 object[id].ctrl_surface[11].gear_id      =   2;
 object[id].ctrl_surface[11].nctrlpoly    =   4;
 object[id].ctrl_surface[11].poly_id[0]   = 120;
 object[id].ctrl_surface[11].poly_id[1]   = 121;
 object[id].ctrl_surface[11].poly_id[2]   = 122;
 object[id].ctrl_surface[11].poly_id[3]   = 123;

 object[id].ctrl_surface[12].hinge.x      =   4.02;
 object[id].ctrl_surface[12].hinge.y      =   0.00;
 object[id].ctrl_surface[12].hinge.z      =  -0.67;
 object[id].ctrl_surface[12].rudder_gain  =   0;
 object[id].ctrl_surface[12].aileron_gain =   0;
 object[id].ctrl_surface[12].elevator_gain=   0;
 object[id].ctrl_surface[12].flap_gain    =   0;
 object[id].ctrl_surface[12].brake_gain   =   0;
 object[id].ctrl_surface[12].gear_gain    =  90;
 object[id].ctrl_surface[12].gear_id      =   0;
 object[id].ctrl_surface[12].nctrlpoly    =   4;
 object[id].ctrl_surface[12].poly_id[0]   = 124;
 object[id].ctrl_surface[12].poly_id[1]   = 125;
 object[id].ctrl_surface[12].poly_id[2]   = 126;
 object[id].ctrl_surface[12].poly_id[3]   = 127;

 nfacets=object[id].nfacets;
 for (j=0; j<object[id].nctrl_srf; j++) nfacets+=object[id].ctrl_surface[j].nctrlpoly;

 if ((object[id].vertex = malloc(object[id].nvertices*sizeof(cartvektor))) == NULL)
 {
   printf("Not enough memory\n");
   exit(1);
 }

 if ((object[id].facet = malloc(nfacets*sizeof(polygon_struct))) == NULL)
 {
   printf("Not enough memory\n");
   exit(1);
 }
 facetid=object[id].facet;


 (object[id].vertex+0)->x= 9.31;
 (object[id].vertex+0)->y= 0.00;
 (object[id].vertex+0)->z=-0.05;

 (object[id].vertex+1)->x= 7.28;
 (object[id].vertex+1)->y=-0.18;
 (object[id].vertex+1)->z= 0.42;

 (object[id].vertex+2)->x= 7.28;
 (object[id].vertex+2)->y=-0.42;
 (object[id].vertex+2)->z= 0.18;

 (object[id].vertex+3)->x= 7.28;
 (object[id].vertex+3)->y=-0.42;
 (object[id].vertex+3)->z=-0.18;

 (object[id].vertex+4)->x= 7.28;
 (object[id].vertex+4)->y=-0.18;
 (object[id].vertex+4)->z=-0.42;

 (object[id].vertex+5)->x= 7.28;
 (object[id].vertex+5)->y= 0.18;
 (object[id].vertex+5)->z=-0.42;

 (object[id].vertex+6)->x= 7.28;
 (object[id].vertex+6)->y= 0.42;
 (object[id].vertex+6)->z=-0.18;

 (object[id].vertex+7)->x= 7.28;
 (object[id].vertex+7)->y= 0.42;
 (object[id].vertex+7)->z= 0.18;

 (object[id].vertex+8)->x= 7.28;
 (object[id].vertex+8)->y= 0.18;
 (object[id].vertex+8)->z= 0.42;

 (object[id].vertex+9)->x= 3.89;
 (object[id].vertex+9)->y=-0.22;
 (object[id].vertex+9)->z= 0.83;

 (object[id].vertex+10)->x= 3.89;
 (object[id].vertex+10)->y=-0.65;
 (object[id].vertex+10)->z= 0.55;

 (object[id].vertex+11)->x= 3.89;
 (object[id].vertex+11)->y=-0.65;
 (object[id].vertex+11)->z=-0.42;

 (object[id].vertex+12)->x= 3.89;
 (object[id].vertex+12)->y=-0.22;
 (object[id].vertex+12)->z=-0.64;

 (object[id].vertex+13)->x= 3.89;
 (object[id].vertex+13)->y= 0.22;
 (object[id].vertex+13)->z=-0.64;

 (object[id].vertex+14)->x= 3.89;
 (object[id].vertex+14)->y= 0.65;
 (object[id].vertex+14)->z=-0.42;

 (object[id].vertex+15)->x= 3.89;
 (object[id].vertex+15)->y= 0.65;
 (object[id].vertex+15)->z= 0.55;

 (object[id].vertex+16)->x= 3.89;
 (object[id].vertex+16)->y= 0.22;
 (object[id].vertex+16)->z= 0.83;

 (object[id].vertex+17)->x=-3.22;
 (object[id].vertex+17)->y=-0.22;
 (object[id].vertex+17)->z= 0.83;

 (object[id].vertex+18)->x=-3.22;
 (object[id].vertex+18)->y=-0.65;
 (object[id].vertex+18)->z= 0.55;

 (object[id].vertex+19)->x=-3.22;
 (object[id].vertex+19)->y=-0.65;
 (object[id].vertex+19)->z=-0.42;

 (object[id].vertex+20)->x=-3.22;
 (object[id].vertex+20)->y=-0.22;
 (object[id].vertex+20)->z=-0.64;

 (object[id].vertex+21)->x=-3.22;
 (object[id].vertex+21)->y= 0.22;
 (object[id].vertex+21)->z=-0.64;

 (object[id].vertex+22)->x=-3.22;
 (object[id].vertex+22)->y= 0.65;
 (object[id].vertex+22)->z=-0.42;

 (object[id].vertex+23)->x=-3.22;
 (object[id].vertex+23)->y= 0.65;
 (object[id].vertex+23)->z= 0.55;

 (object[id].vertex+24)->x=-3.22;
 (object[id].vertex+24)->y= 0.22;
 (object[id].vertex+24)->z= 0.83;

 for (i=0; i<8; i++){
  float xc=-6.74, yc=0.00, zc=0.33, radius=0.52;

  (object[id].vertex+25+i)->x=xc+radius;
  (object[id].vertex+25+i)->y=yc-radius*sin(i*PI/4+PI/8);
  (object[id].vertex+25+i)->z=zc+radius*cos(i*PI/4+PI/8);
 }

 (object[id].vertex+33)->x=-3.11;
 (object[id].vertex+33)->y= 0.00;
 (object[id].vertex+33)->z= 0.83;

 (object[id].vertex+34)->x=-6.89;
 (object[id].vertex+34)->y= 0.00;
 (object[id].vertex+34)->z= 0.83;

 (object[id].vertex+35)->x=-7.31;
 (object[id].vertex+35)->y= 0.00;
 (object[id].vertex+35)->z= 2.34;

 (object[id].vertex+36)->x=-6.39;
 (object[id].vertex+36)->y= 0.00;
 (object[id].vertex+36)->z= 2.59;

 (object[id].vertex+37)->x=-5.70;
 (object[id].vertex+37)->y= 0.00;
 (object[id].vertex+37)->z= 2.67;

 (object[id].vertex+38)->x=-4.11;
 (object[id].vertex+38)->y= 0.00;
 (object[id].vertex+38)->z= 1.28;

 (object[id].vertex+39)->x=-7.55;
 (object[id].vertex+39)->y= 0.00;
 (object[id].vertex+39)->z= 2.34;

 (object[id].vertex+40)->x=-6.76;
 (object[id].vertex+40)->y=-1.82;
 (object[id].vertex+40)->z= 2.34;

 (object[id].vertex+41)->x=-6.17;
 (object[id].vertex+41)->y=-1.82;
 (object[id].vertex+41)->z= 2.34;

 (object[id].vertex+42)->x=-5.50;
 (object[id].vertex+42)->y= 0.00;
 (object[id].vertex+42)->z= 2.34;

 (object[id].vertex+43)->x=-6.17;
 (object[id].vertex+43)->y= 1.82;
 (object[id].vertex+43)->z= 2.34;

 (object[id].vertex+44)->x=-6.76;
 (object[id].vertex+44)->y= 1.82;
 (object[id].vertex+44)->z= 2.34;

 (object[id].vertex+45)->x=-6.81;
 (object[id].vertex+45)->y= 0.00;
 (object[id].vertex+45)->z= 2.34;

 (object[id].vertex+46)->x=-5.36;
 (object[id].vertex+46)->y= 0.00;
 (object[id].vertex+46)->z= 2.34;

 /* air intakes */
 for (i=0; i<6; i++){
  float xc=2.56, yc=0.65, zc=0.07, radius=0.47;
  float x,y,z;

  y=radius*sin(i*PI/5);
  z=radius*cos(i*PI/5);
  x=0.1*z-0.1*y;

  (object[id].vertex+47+i)->x=xc+x;
  (object[id].vertex+47+i)->y=yc+y;
  (object[id].vertex+47+i)->z=zc+z;
 }

 for (i=0; i<6; i++){
  float xc=2.56, yc=-0.65, zc=0.07, radius=0.47;
  float x,y,z;

  y=radius*sin(i*PI/5);
  z=radius*cos(i*PI/5);
  x=0.1*z-0.1*y;

  (object[id].vertex+53+i)->x=xc+x;
  (object[id].vertex+53+i)->y=yc-y;
  (object[id].vertex+53+i)->z=zc+z;
 }

 for (i=0; i<6; i++){
  float xc=0.53, yc=0.65, zc=0.07, radius=0.47;
  float x,y,z;

  y=radius*sin(i*PI/5);
  z=radius*cos(i*PI/5);
  x=0;

  (object[id].vertex+59+i)->x=xc+x;
  (object[id].vertex+59+i)->y=yc+y;
  (object[id].vertex+59+i)->z=zc+z;
 }

 for (i=0; i<6; i++){
  float xc=0.53, yc=-0.65, zc=0.07, radius=0.47;
  float x,y,z;

  y=radius*sin(i*PI/5);
  z=radius*cos(i*PI/5);
  x=0;

  (object[id].vertex+65+i)->x=xc+x;
  (object[id].vertex+65+i)->y=yc-y;
  (object[id].vertex+65+i)->z=zc+z;
 }

 (object[id].vertex+71)->x=-2.72;
 (object[id].vertex+71)->y= 0.65;
 (object[id].vertex+71)->z= 0.00;

 (object[id].vertex+72)->x=-2.72;
 (object[id].vertex+72)->y=-0.65;
 (object[id].vertex+72)->z= 0.00;

 (object[id].vertex+73)->x=-3.22;
 (object[id].vertex+73)->y= 0.65;
 (object[id].vertex+73)->z= 0.00;

 (object[id].vertex+74)->x=-3.22;
 (object[id].vertex+74)->y=-0.65;
 (object[id].vertex+74)->z= 0.00;

 (object[id].vertex+75)->x= 2.56;
 (object[id].vertex+75)->y= 0.65;
 (object[id].vertex+75)->z= 0.24;

 (object[id].vertex+76)->x= 2.56;
 (object[id].vertex+76)->y= 0.65;
 (object[id].vertex+76)->z=-0.10;

 (object[id].vertex+77)->x= 2.56;
 (object[id].vertex+77)->y= 0.82;
 (object[id].vertex+77)->z= 0.07;

 (object[id].vertex+78)->x= 3.06;
 (object[id].vertex+78)->y= 0.65;
 (object[id].vertex+78)->z= 0.07;

 (object[id].vertex+79)->x= 2.56;
 (object[id].vertex+79)->y=-0.65;
 (object[id].vertex+79)->z= 0.24;

 (object[id].vertex+80)->x= 2.56;
 (object[id].vertex+80)->y=-0.65;
 (object[id].vertex+80)->z=-0.10;

 (object[id].vertex+81)->x= 2.56;
 (object[id].vertex+81)->y=-0.82;
 (object[id].vertex+81)->z= 0.07;

 (object[id].vertex+82)->x= 3.06;
 (object[id].vertex+82)->y=-0.65;
 (object[id].vertex+82)->z= 0.07;

 /* belly fin */
 (object[id].vertex+83)->x=-1.72;
 (object[id].vertex+83)->y= 0.00;
 (object[id].vertex+83)->z=-0.64;

 (object[id].vertex+84)->x=-2.17;
 (object[id].vertex+84)->y= 0.00;
 (object[id].vertex+84)->z=-1.03;

 (object[id].vertex+85)->x=-4.67;
 (object[id].vertex+85)->y= 0.00;
 (object[id].vertex+85)->z=-0.43;

 (object[id].vertex+86)->x=-3.22;
 (object[id].vertex+86)->y= 0.00;
 (object[id].vertex+86)->z=-0.64;

 /* Wings */
 (object[id].vertex+87)->x= 0.53;
 (object[id].vertex+87)->y= 1.10;
 (object[id].vertex+87)->z= 0.00;

 (object[id].vertex+88)->x=-0.56;
 (object[id].vertex+88)->y= 3.34;
 (object[id].vertex+88)->z=-0.36;

 (object[id].vertex+89)->x=-2.03;
 (object[id].vertex+89)->y= 3.34;
 (object[id].vertex+89)->z=-0.36;

 (object[id].vertex+90)->x= 0.53;
 (object[id].vertex+90)->y=-1.10;
 (object[id].vertex+90)->z= 0.00;

 (object[id].vertex+91)->x=-0.56;
 (object[id].vertex+91)->y=-3.34;
 (object[id].vertex+91)->z=-0.36;

 (object[id].vertex+92)->x=-2.03;
 (object[id].vertex+92)->y=-3.34;
 (object[id].vertex+92)->z=-0.36;

 (object[id].vertex+93)->x= 6.44;
 (object[id].vertex+93)->y= 0.15;
 (object[id].vertex+93)->z= 0.89;

 (object[id].vertex+94)->x= 6.44;
 (object[id].vertex+94)->y=-0.15;
 (object[id].vertex+94)->z= 0.89;

 (object[id].vertex+95)->x= 6.28;
 (object[id].vertex+95)->y= 0.36;
 (object[id].vertex+95)->z= 0.49;

 (object[id].vertex+96)->x= 6.28;
 (object[id].vertex+96)->y=-0.36;
 (object[id].vertex+96)->z= 0.49;

 (object[id].vertex+97)->x= 5.32;
 (object[id].vertex+97)->y= 0.39;
 (object[id].vertex+97)->z= 0.58;

 (object[id].vertex+98)->x= 5.32;
 (object[id].vertex+98)->y= 0.18;
 (object[id].vertex+98)->z= 0.96;

 (object[id].vertex+99)->x= 5.32;
 (object[id].vertex+99)->y=-0.18;
 (object[id].vertex+99)->z= 0.96;

 (object[id].vertex+100)->x= 5.32;
 (object[id].vertex+100)->y=-0.39;
 (object[id].vertex+100)->z= 0.58;

 (object[id].vertex+101)->x= 4.45;
 (object[id].vertex+101)->y= 0.27;
 (object[id].vertex+101)->z= 0.83;

 (object[id].vertex+102)->x= 4.45;
 (object[id].vertex+102)->y=-0.27;
 (object[id].vertex+102)->z= 0.83;

 /* Rudder */
 (object[id].vertex+103)->x=-7.55;
 (object[id].vertex+103)->y= 0.00;
 (object[id].vertex+103)->z= 0.85;

 (object[id].vertex+104)->x=-7.42;
 (object[id].vertex+104)->y= 0.00;
 (object[id].vertex+104)->z= 2.20;

 /* Flaps, ailerons */
 (object[id].vertex+105)->x= 0.15;
 (object[id].vertex+105)->y= 1.05;
 (object[id].vertex+105)->z= 0.00;

 (object[id].vertex+106)->x=-1.69;
 (object[id].vertex+106)->y= 0.79;
 (object[id].vertex+106)->z= 0.00;

 (object[id].vertex+107)->x= 0.15;
 (object[id].vertex+107)->y=-1.05;
 (object[id].vertex+107)->z= 0.00;

 (object[id].vertex+108)->x=-1.69;
 (object[id].vertex+108)->y=-0.79;
 (object[id].vertex+108)->z= 0.00;

 (object[id].vertex+109)->x=-0.80;
 (object[id].vertex+109)->y= 3.34;
 (object[id].vertex+109)->z=-0.36;

 (object[id].vertex+110)->x=-1.69;
 (object[id].vertex+110)->y= 3.34;
 (object[id].vertex+110)->z=-0.36;

 (object[id].vertex+111)->x=-0.80;
 (object[id].vertex+111)->y=-3.34;
 (object[id].vertex+111)->z=-0.36;

 (object[id].vertex+112)->x=-1.69;
 (object[id].vertex+112)->y=-3.34;
 (object[id].vertex+112)->z=-0.36;

 (object[id].vertex+113)->x=-1.69;
 (object[id].vertex+113)->y= 2.42;
 (object[id].vertex+113)->z=-0.23;

 (object[id].vertex+114)->x=-2.28;
 (object[id].vertex+114)->y= 2.42;
 (object[id].vertex+114)->z=-0.23;

 (object[id].vertex+115)->x=-1.69;
 (object[id].vertex+115)->y=-2.42;
 (object[id].vertex+115)->z=-0.23;

 (object[id].vertex+116)->x=-2.28;
 (object[id].vertex+116)->y=-2.42;
 (object[id].vertex+116)->z=-0.23;

 /* Air brakes */
 (object[id].vertex+117)->x=-3.34;
 (object[id].vertex+117)->y= 0.65;
 (object[id].vertex+117)->z= 0.39;

 (object[id].vertex+118)->x=-3.34;
 (object[id].vertex+118)->y= 0.65;
 (object[id].vertex+118)->z=-0.22;

 (object[id].vertex+119)->x=-4.11;
 (object[id].vertex+119)->y= 0.65;
 (object[id].vertex+119)->z=-0.22;

 (object[id].vertex+120)->x=-4.11;
 (object[id].vertex+120)->y= 0.65;
 (object[id].vertex+120)->z= 0.39;

 (object[id].vertex+121)->x=-3.34;
 (object[id].vertex+121)->y=-0.65;
 (object[id].vertex+121)->z= 0.39;

 (object[id].vertex+122)->x=-3.34;
 (object[id].vertex+122)->y=-0.65;
 (object[id].vertex+122)->z=-0.22;

 (object[id].vertex+123)->x=-4.11;
 (object[id].vertex+123)->y=-0.65;
 (object[id].vertex+123)->z=-0.22;

 (object[id].vertex+124)->x=-4.11;
 (object[id].vertex+124)->y=-0.65;
 (object[id].vertex+124)->z= 0.39;

 /* Port undercarriage */
 for (i=0; i<8; i++){
  float xc=-0.67, yc=1.39, zc=-1.32, radius=0.32;

  (object[id].vertex+125+i)->x=xc+radius*sin(i*PI/4+PI/8);
  (object[id].vertex+125+i)->y=yc;
  (object[id].vertex+125+i)->z=zc+radius*cos(i*PI/4+PI/8);
 }

 (object[id].vertex+133)->x=-0.62;
 (object[id].vertex+133)->y= 0.50;
 (object[id].vertex+133)->z=-0.50;

 (object[id].vertex+134)->x=-0.72;
 (object[id].vertex+134)->y= 0.50;
 (object[id].vertex+134)->z=-0.50;

 (object[id].vertex+135)->x=-0.72;
 (object[id].vertex+135)->y= 1.35;
 (object[id].vertex+135)->z=-1.37;

 (object[id].vertex+136)->x=-0.62;
 (object[id].vertex+136)->y= 1.35;
 (object[id].vertex+136)->z=-1.37;

 /* Stb. undercarriage */
 for (i=0; i<8; i++){
  float xc=-0.67, yc=-1.39, zc=-1.32, radius=0.32;

  (object[id].vertex+137+i)->x=xc+radius*sin(i*PI/4+PI/8);
  (object[id].vertex+137+i)->y=yc;
  (object[id].vertex+137+i)->z=zc+radius*cos(i*PI/4+PI/8);
 }

 (object[id].vertex+145)->x=-0.62;
 (object[id].vertex+145)->y=-0.50;
 (object[id].vertex+145)->z=-0.50;

 (object[id].vertex+146)->x=-0.72;
 (object[id].vertex+146)->y=-0.50;
 (object[id].vertex+146)->z=-0.50;

 (object[id].vertex+147)->x=-0.72;
 (object[id].vertex+147)->y=-1.35;
 (object[id].vertex+147)->z=-1.37;

 (object[id].vertex+148)->x=-0.62;
 (object[id].vertex+148)->y=-1.35;
 (object[id].vertex+148)->z=-1.37;

 /* Nose wheel */
 for (i=0; i<8; i++){
  float xc=4.02, yc= 0.00, zc=-1.25, radius=0.19;

  (object[id].vertex+149+i)->x=xc+radius*sin(i*PI/4+PI/8);
  (object[id].vertex+149+i)->y=yc;
  (object[id].vertex+149+i)->z=zc+radius*cos(i*PI/4+PI/8);
 }

 (object[id].vertex+157)->x= 4.07;
 (object[id].vertex+157)->y= 0.00;
 (object[id].vertex+157)->z=-0.67;

 (object[id].vertex+158)->x= 3.97;
 (object[id].vertex+158)->y= 0.00;
 (object[id].vertex+158)->z=-0.67;

 (object[id].vertex+159)->x= 3.97;
 (object[id].vertex+159)->y= 0.00;
 (object[id].vertex+159)->z=-1.30;

 (object[id].vertex+160)->x= 4.07;
 (object[id].vertex+160)->y= 0.00;
 (object[id].vertex+160)->z=-1.30;


 /*
 (object[id].vertex+)->x=;
 (object[id].vertex+)->y=;
 (object[id].vertex+)->z=;
 */

 /**********/
 /* Facets */
 /**********/

 /*0 Nose */
 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=1;
 facetid->edge[1]=2;
 facetid->edge[2]=0;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=8;
 facetid->edge[1]=1;
 facetid->edge[2]=0;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=7;
 facetid->edge[1]=8;
 facetid->edge[2]=0;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=3;
 facetid->edge[1]=4;
 facetid->edge[2]=0;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=4;
 facetid->edge[1]=5;
 facetid->edge[2]=0;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=5;
 facetid->edge[1]=6;
 facetid->edge[2]=0;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=6;
 facetid->edge[1]=7;
 facetid->edge[2]=0;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=2;
 facetid->edge[1]=3;
 facetid->edge[2]=0;
 facetid++;

 /* 8 Fore body */
 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=14;
 facetid->edge[1]=15;
 facetid->edge[2]=7;
 facetid->edge[3]=6;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=3;
 facetid->edge[0]=13;
 facetid->edge[1]=14;
 facetid->edge[2]=5;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=12;
 facetid->edge[1]=13;
 facetid->edge[2]=5;
 facetid->edge[3]=4;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=3;
 facetid->edge[0]=11;
 facetid->edge[1]=12;
 facetid->edge[2]=4;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=10;
 facetid->edge[1]=11;
 facetid->edge[2]=3;
 facetid->edge[3]=2;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=3;
 facetid->edge[0]=8;
 facetid->edge[1]=7;
 facetid->edge[2]=95;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=3;
 facetid->edge[0]=6;
 facetid->edge[1]=5;
 facetid->edge[2]=14;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=3;
 facetid->edge[0]=4;
 facetid->edge[1]=3;
 facetid->edge[2]=11;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=3;
 facetid->edge[0]=2;
 facetid->edge[1]=1;
 facetid->edge[2]=96;
 facetid++;

 /*17 Mid body */
 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=24;
 facetid->edge[1]=17;
 facetid->edge[2]=9;
 facetid->edge[3]=16;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=17;
 facetid->edge[1]=18;
 facetid->edge[2]=10;
 facetid->edge[3]=9;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=7;
 facetid->edge[0]=11;
 facetid->edge[1]=10;
 facetid->edge[2]=53;
 facetid->edge[3]=79;
 facetid->edge[4]=82;
 facetid->edge[5]=80;
 facetid->edge[6]=58;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=18;
 facetid->edge[1]=74;
 facetid->edge[2]=72;
 facetid->edge[3]=65;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=74;
 facetid->edge[1]=19;
 facetid->edge[2]=70;
 facetid->edge[3]=72;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=19;
 facetid->edge[1]=20;
 facetid->edge[2]=12;
 facetid->edge[3]=11;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=20;
 facetid->edge[1]=21;
 facetid->edge[2]=13;
 facetid->edge[3]=12;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=21;
 facetid->edge[1]=22;
 facetid->edge[2]=14;
 facetid->edge[3]=13;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=7;
 facetid->edge[0]=15;
 facetid->edge[1]=14;
 facetid->edge[2]=52;
 facetid->edge[3]=76;
 facetid->edge[4]=78;
 facetid->edge[5]=75;
 facetid->edge[6]=47;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=73;
 facetid->edge[1]=23;
 facetid->edge[2]=59;
 facetid->edge[3]=71;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=22;
 facetid->edge[1]=73;
 facetid->edge[2]=71;
 facetid->edge[3]=64;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=23;
 facetid->edge[1]=24;
 facetid->edge[2]=16;
 facetid->edge[3]=15;
 facetid++;

 /*29 rear body */
 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=32;
 facetid->edge[1]=25;
 facetid->edge[2]=17;
 facetid->edge[3]=24;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=25;
 facetid->edge[1]=26;
 facetid->edge[2]=18;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=26;
 facetid->edge[1]=27;
 facetid->edge[2]=19;
 facetid->edge[3]=18;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=27;
 facetid->edge[1]=28;
 facetid->edge[2]=19;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=28;
 facetid->edge[1]=29;
 facetid->edge[2]=21;
 facetid->edge[3]=20;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=29;
 facetid->edge[1]=30;
 facetid->edge[2]=22;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=30;
 facetid->edge[1]=31;
 facetid->edge[2]=23;
 facetid->edge[3]=22;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=31;
 facetid->edge[1]=32;
 facetid->edge[2]=23;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=18;
 facetid->edge[1]=17;
 facetid->edge[2]=25;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=20;
 facetid->edge[1]=19;
 facetid->edge[2]=28;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=22;
 facetid->edge[1]=21;
 facetid->edge[2]=29;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=24;
 facetid->edge[1]=23;
 facetid->edge[2]=32;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=32;
 facetid->edge[1]=31;
 facetid->edge[2]=30;
 facetid->edge[3]=29;
 facetid->edge[4]=28;
 facetid->edge[5]=27;
 facetid->edge[6]=26;
 facetid->edge[7]=25;
 facetid++;

 /*42 Tail fin */
 facetid->color=LIGHTRED;
 facetid->nedges=5;
 facetid->edge[0]=33;
 facetid->edge[1]=34;
 facetid->edge[2]=45;
 facetid->edge[3]=46;
 facetid->edge[4]=38;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=5;
 facetid->edge[0]=38;
 facetid->edge[1]=46;
 facetid->edge[2]=45;
 facetid->edge[3]=34;
 facetid->edge[4]=33;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=46;
 facetid->edge[1]=35;
 facetid->edge[2]=36;
 facetid->edge[3]=37;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=35;
 facetid->edge[1]=46;
 facetid->edge[2]=37;
 facetid->edge[3]=36;
 facetid++;

 /*46 air intakes */
 facetid->color=DARKGRAY;
 facetid->nedges=6;
 facetid->edge[0]=47;
 facetid->edge[1]=52;
 facetid->edge[2]=51;
 facetid->edge[3]=50;
 facetid->edge[4]=49;
 facetid->edge[5]=48;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=6;
 facetid->edge[0]=53;
 facetid->edge[1]=54;
 facetid->edge[2]=55;
 facetid->edge[3]=56;
 facetid->edge[4]=57;
 facetid->edge[5]=58;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=59;
 facetid->edge[1]=47;
 facetid->edge[2]=48;
 facetid->edge[3]=60;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=60;
 facetid->edge[1]=48;
 facetid->edge[2]=49;
 facetid->edge[3]=61;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=61;
 facetid->edge[1]=49;
 facetid->edge[2]=50;
 facetid->edge[3]=62;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=62;
 facetid->edge[1]=50;
 facetid->edge[2]=51;
 facetid->edge[3]=63;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=63;
 facetid->edge[1]=51;
 facetid->edge[2]=52;
 facetid->edge[3]=64;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=65;
 facetid->edge[1]=66;
 facetid->edge[2]=54;
 facetid->edge[3]=53;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=66;
 facetid->edge[1]=67;
 facetid->edge[2]=55;
 facetid->edge[3]=54;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=67;
 facetid->edge[1]=68;
 facetid->edge[2]=56;
 facetid->edge[3]=55;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=68;
 facetid->edge[1]=69;
 facetid->edge[2]=57;
 facetid->edge[3]=56;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=69;
 facetid->edge[1]=70;
 facetid->edge[2]=58;
 facetid->edge[3]=57;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=3;
 facetid->edge[0]=71;
 facetid->edge[1]=59;
 facetid->edge[2]=60;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=3;
 facetid->edge[0]=71;
 facetid->edge[1]=60;
 facetid->edge[2]=61;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=3;
 facetid->edge[0]=71;
 facetid->edge[1]=61;
 facetid->edge[2]=62;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=3;
 facetid->edge[0]=71;
 facetid->edge[1]=62;
 facetid->edge[2]=63;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=3;
 facetid->edge[0]=71;
 facetid->edge[1]=63;
 facetid->edge[2]=64;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=3;
 facetid->edge[0]=72;
 facetid->edge[1]=70;
 facetid->edge[2]=69;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=3;
 facetid->edge[0]=72;
 facetid->edge[1]=69;
 facetid->edge[2]=68;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=3;
 facetid->edge[0]=72;
 facetid->edge[1]=68;
 facetid->edge[2]=67;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=3;
 facetid->edge[0]=72;
 facetid->edge[1]=67;
 facetid->edge[2]=66;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=3;
 facetid->edge[0]=72;
 facetid->edge[1]=66;
 facetid->edge[2]=65;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=3;
 facetid->edge[0]=75;
 facetid->edge[1]=78;
 facetid->edge[2]=77;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=3;
 facetid->edge[0]=76;
 facetid->edge[1]=77;
 facetid->edge[2]=78;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=3;
 facetid->edge[0]=79;
 facetid->edge[1]=81;
 facetid->edge[2]=82;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=3;
 facetid->edge[0]=82;
 facetid->edge[1]=81;
 facetid->edge[2]=80;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=83;
 facetid->edge[1]=84;
 facetid->edge[2]=85;
 facetid->edge[3]=86;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=85;
 facetid->edge[1]=84;
 facetid->edge[2]=83;
 facetid->edge[3]=86;
 facetid++;

 /*74 wings */
 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=106;
 facetid->edge[1]=105;
 facetid->edge[2]=109;
 facetid->edge[3]=110;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=106;
 facetid->edge[1]=110;
 facetid->edge[2]=109;
 facetid->edge[3]=105;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=108;
 facetid->edge[1]=112;
 facetid->edge[2]=111;
 facetid->edge[3]=107;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=108;
 facetid->edge[1]=107;
 facetid->edge[2]=111;
 facetid->edge[3]=112;
 facetid++;

 /*78 canopy */
 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=1;
 facetid->edge[1]=8;
 facetid->edge[2]=93;
 facetid->edge[3]=94;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=3;
 facetid->edge[0]=93;
 facetid->edge[1]=8;
 facetid->edge[2]=95;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=3;
 facetid->edge[0]=94;
 facetid->edge[1]=96;
 facetid->edge[2]=1;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=97;
 facetid->edge[1]=98;
 facetid->edge[2]=93;
 facetid->edge[3]=95;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=98;
 facetid->edge[1]=99;
 facetid->edge[2]=94;
 facetid->edge[3]=93;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=99;
 facetid->edge[1]=100;
 facetid->edge[2]=96;
 facetid->edge[3]=94;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=101;
 facetid->edge[1]=102;
 facetid->edge[2]=99;
 facetid->edge[3]=98;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=3;
 facetid->edge[0]=101;
 facetid->edge[1]=98;
 facetid->edge[2]=97;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=3;
 facetid->edge[0]=102;
 facetid->edge[1]=100;
 facetid->edge[2]=99;
 facetid++;

 /*87 body framing canopy */
 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=16;
 facetid->edge[1]=9;
 facetid->edge[2]=102;
 facetid->edge[3]=101;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=3;
 facetid->edge[0]=15;
 facetid->edge[1]=16;
 facetid->edge[2]=101;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=3;
 facetid->edge[0]=102;
 facetid->edge[1]=9;
 facetid->edge[2]=10;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=3;
 facetid->edge[0]=15;
 facetid->edge[1]=101;
 facetid->edge[2]=97;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=3;
 facetid->edge[0]=10;
 facetid->edge[1]=100;
 facetid->edge[2]=102;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=7;
 facetid->edge[1]=15;
 facetid->edge[2]=97;
 facetid->edge[3]=95;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=10;
 facetid->edge[1]=2;
 facetid->edge[2]=96;
 facetid->edge[3]=100;
 facetid++;

 /* Control surfaces below */

 /*94 Tail plane */
 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=39;
 facetid->edge[1]=42;
 facetid->edge[2]=43;
 facetid->edge[3]=44;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=39;
 facetid->edge[1]=40;
 facetid->edge[2]=41;
 facetid->edge[3]=42;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=39;
 facetid->edge[1]=44;
 facetid->edge[2]=43;
 facetid->edge[3]=42;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=39;
 facetid->edge[1]=42;
 facetid->edge[2]=41;
 facetid->edge[3]=40;
 facetid++;

 /* 98 Rudder */
 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]= 34;
 facetid->edge[1]=103;
 facetid->edge[2]=104;
 facetid->edge[3]= 45;
 facetid++;

 facetid->color=LIGHTRED;
 facetid->nedges=4;
 facetid->edge[0]=104;
 facetid->edge[1]=103;
 facetid->edge[2]= 34;
 facetid->edge[3]= 45;
 facetid++;

 /* 100 Ailerons */
 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=114;
 facetid->edge[1]=113;
 facetid->edge[2]=110;
 facetid->edge[3]= 89;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=110;
 facetid->edge[1]=113;
 facetid->edge[2]=114;
 facetid->edge[3]= 89;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=116;
 facetid->edge[1]= 92;
 facetid->edge[2]=112;
 facetid->edge[3]=115;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=115;
 facetid->edge[1]=112;
 facetid->edge[2]= 92;
 facetid->edge[3]=116;
 facetid++;

 /* 104 trailing edge flaps */
 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]= 71;
 facetid->edge[1]=106;
 facetid->edge[2]=113;
 facetid->edge[3]=114;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=113;
 facetid->edge[1]=106;
 facetid->edge[2]= 71;
 facetid->edge[3]=114;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]= 72;
 facetid->edge[1]=116;
 facetid->edge[2]=115;
 facetid->edge[3]=108;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=115;
 facetid->edge[1]=116;
 facetid->edge[2]= 72;
 facetid->edge[3]=108;
 facetid++;

 /* 108 leading edge flaps */
 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=105;
 facetid->edge[1]= 87;
 facetid->edge[2]= 88;
 facetid->edge[3]=109;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]= 88;
 facetid->edge[1]= 87;
 facetid->edge[2]=105;
 facetid->edge[3]=109;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=111;
 facetid->edge[1]= 91;
 facetid->edge[2]= 90;
 facetid->edge[3]=107;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]= 90;
 facetid->edge[1]= 91;
 facetid->edge[2]=111;
 facetid->edge[3]=107;
 facetid++;

 /* 112 air brakes */
 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=117;
 facetid->edge[1]=118;
 facetid->edge[2]=119;
 facetid->edge[3]=120;
 facetid++;

 facetid->color=RED;
 facetid->nedges=4;
 facetid->edge[0]=119;
 facetid->edge[1]=118;
 facetid->edge[2]=117;
 facetid->edge[3]=120;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=124;
 facetid->edge[1]=123;
 facetid->edge[2]=122;
 facetid->edge[3]=121;
 facetid++;

 facetid->color=RED;
 facetid->nedges=4;
 facetid->edge[0]=122;
 facetid->edge[1]=123;
 facetid->edge[2]=124;
 facetid->edge[3]=121;
 facetid++;

 /* 116 Port undercarriage */
 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=125;
 facetid->edge[1]=126;
 facetid->edge[2]=127;
 facetid->edge[3]=128;
 facetid->edge[4]=129;
 facetid->edge[5]=130;
 facetid->edge[6]=131;
 facetid->edge[7]=132;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=132;
 facetid->edge[1]=131;
 facetid->edge[2]=130;
 facetid->edge[3]=129;
 facetid->edge[4]=128;
 facetid->edge[5]=127;
 facetid->edge[6]=126;
 facetid->edge[7]=125;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=133;
 facetid->edge[1]=134;
 facetid->edge[2]=135;
 facetid->edge[3]=136;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=135;
 facetid->edge[1]=134;
 facetid->edge[2]=133;
 facetid->edge[3]=136;
 facetid++;

 /* 120 Port undercarriage */
 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=137;
 facetid->edge[1]=138;
 facetid->edge[2]=139;
 facetid->edge[3]=140;
 facetid->edge[4]=141;
 facetid->edge[5]=142;
 facetid->edge[6]=143;
 facetid->edge[7]=144;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=144;
 facetid->edge[1]=143;
 facetid->edge[2]=142;
 facetid->edge[3]=141;
 facetid->edge[4]=140;
 facetid->edge[5]=139;
 facetid->edge[6]=138;
 facetid->edge[7]=137;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=145;
 facetid->edge[1]=146;
 facetid->edge[2]=147;
 facetid->edge[3]=148;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=147;
 facetid->edge[1]=146;
 facetid->edge[2]=145;
 facetid->edge[3]=148;
 facetid++;

 /* 124 Nose wheel */
 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=149;
 facetid->edge[1]=150;
 facetid->edge[2]=151;
 facetid->edge[3]=152;
 facetid->edge[4]=153;
 facetid->edge[5]=154;
 facetid->edge[6]=155;
 facetid->edge[7]=156;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=156;
 facetid->edge[1]=155;
 facetid->edge[2]=154;
 facetid->edge[3]=153;
 facetid->edge[4]=152;
 facetid->edge[5]=151;
 facetid->edge[6]=150;
 facetid->edge[7]=149;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=157;
 facetid->edge[1]=158;
 facetid->edge[2]=159;
 facetid->edge[3]=160;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=159;
 facetid->edge[1]=158;
 facetid->edge[2]=157;
 facetid->edge[3]=160;
 facetid++;


 if (object[id].facet+nfacets!=facetid)
 {
   printf("F104: Incorrect number of facets\n");
   exit(1);
 }

 /*
 facetid->color=;
 facetid->nedges=;
 facetid->edge[0]=;
 facetid->edge[1]=;
 facetid->edge[2]=;
 facetid->edge[3]=;
 facetid++;
 */

 /* Define control surface rotation axis */
 object[id].ctrl_surface[0].axis =
   vminus(*(object[id].vertex+43),*(object[id].vertex+41));
 object[id].ctrl_surface[1].axis =
   vminus(*(object[id].vertex+45),*(object[id].vertex+34));
 object[id].ctrl_surface[2].axis =
   vminus(*(object[id].vertex+113),*(object[id].vertex+110));
 object[id].ctrl_surface[3].axis =
   vminus(*(object[id].vertex+112),*(object[id].vertex+115));
 object[id].ctrl_surface[4].axis =
   vminus(*(object[id].vertex+106),*(object[id].vertex+113));
 object[id].ctrl_surface[5].axis =
   vminus(*(object[id].vertex+115),*(object[id].vertex+108));
 object[id].ctrl_surface[6].axis =
   vminus(*(object[id].vertex+109),*(object[id].vertex+105));
 object[id].ctrl_surface[7].axis =
   vminus(*(object[id].vertex+107),*(object[id].vertex+111));
 object[id].ctrl_surface[8].axis =
   vminus(*(object[id].vertex+117),*(object[id].vertex+118));
 object[id].ctrl_surface[9].axis =
   vminus(*(object[id].vertex+121),*(object[id].vertex+122));
 object[id].ctrl_surface[10].axis =
   vminus(*(object[id].vertex+76),*(object[id].vertex+77));
 object[id].ctrl_surface[11].axis =
   vminus(*(object[id].vertex+81),*(object[id].vertex+80));
 object[id].ctrl_surface[12].axis =
   vminus(*(object[id].vertex+82),*(object[id].vertex+78));

 for (j=0; j<object[id].nctrl_srf; j++){
  float norm;
  cartvektor tmp, tmp2;

  /* Generate orthonormal-system */
  norm=sqrt(VPRIK(object[id].ctrl_surface[j].axis,
                  object[id].ctrl_surface[j].axis));
  object[id].ctrl_surface[j].front=
                  svmult(1./norm,object[id].ctrl_surface[j].axis);
  /* Rotate 90 deg about z */
  tmp.x = -object[id].ctrl_surface[j].front.y;
  tmp.y =  object[id].ctrl_surface[j].front.x;
  tmp.z =  object[id].ctrl_surface[j].front.z;

  /* Rotate 90 deg about x - then the vector is not parallel with front vector */
  tmp2.x =  tmp.x;
  tmp2.y = -tmp.z;
  tmp2.z =  tmp.y;

  object[id].ctrl_surface[j].left =
   vkryds(object[id].ctrl_surface[j].front,tmp2);
  norm=sqrt(VPRIK(object[id].ctrl_surface[j].left,
                  object[id].ctrl_surface[j].left));
  object[id].ctrl_surface[j].left=
                  svmult(1./norm,object[id].ctrl_surface[j].left);

  object[id].ctrl_surface[j].top =
   vkryds(object[id].ctrl_surface[j].front,object[id].ctrl_surface[j].left);
 }

  object[id].colarr[WHITE].r = 255;
 object[id].colarr[WHITE].g = 255;
 object[id].colarr[WHITE].b = 255;

 object[id].colarr[LIGHTGRAY].r = 192;
 object[id].colarr[LIGHTGRAY].g = 192;
 object[id].colarr[LIGHTGRAY].b = 192;

 object[id].colarr[DARKGRAY].r =  80;
 object[id].colarr[DARKGRAY].g =  80;
 object[id].colarr[DARKGRAY].b =  80;

 object[id].colarr[RED].r = 255;
 object[id].colarr[RED].g =  32;
 object[id].colarr[RED].b =  32;

 object[id].colarr[GREEN].r =  32;
 object[id].colarr[GREEN].g = 255;
 object[id].colarr[GREEN].b =  32;

 object[id].colarr[BLUE].r =  32;
 object[id].colarr[BLUE].g =  32;
 object[id].colarr[BLUE].b = 255;

 object[id].colarr[LIGHTRED].r = 255;
 object[id].colarr[LIGHTRED].g =  96;
 object[id].colarr[LIGHTRED].b =  96;

 object[id].colarr[LIGHTBLUE].r = 96;
 object[id].colarr[LIGHTBLUE].g = 96;
 object[id].colarr[LIGHTBLUE].b = 255;

 object[id].colarr[CYAN].r =  96;
 object[id].colarr[CYAN].g = 192;
 object[id].colarr[CYAN].b = 192;

 object[id].colarr[LIGHTCYAN].r =  64;
 object[id].colarr[LIGHTCYAN].g = 255;
 object[id].colarr[LIGHTCYAN].b = 255;

 object[id].colarr[DARKGREEN].r =  50;
 object[id].colarr[DARKGREEN].g = 100;
 object[id].colarr[DARKGREEN].b =  40;

 nobjects++;
