program codesize;
{Quick'n'dirty utillity to take a turbo pascal .MAP file and spit out the
size of every major chunk of code in decimal, sorted by size.  
Sizes of 0 are not printed.}

uses
  support;

const
  headerskip=3;
  lengthcol=16;
  codenamecol=23;
  codenamelen=19;
  maxsegs=256;

type
  segrec=record
    segname:string[codenamelen];
    segsize:word;
  end;

var
  f:text;
  s:string;
  w:word;
  b:byte;
  cs:word;
  lenstr,namestr:string;
  totalsize:longint;
  segsizes:array[0..maxsegs-1] of segrec;
  tempseg:segrec;
  numsegs:byte;

begin
  numsegs:=0;
  assign(f,paramstr(1));
  reset(f);
  for w:=0 to headerskip-1 do readln(f,s);
  while not eof(f) do begin
    readln(f,s);
    {blank line?  We're done with the code section}
    if s='' then break;
    lenstr:=copy(s,lengthcol,5);
    delete(lenstr,1,1); {trim leading 0 since code segments can't be > $FFFF}
    cs:=hexStrToLong(lenstr);
    if cs<>0 then begin
      namestr:=copy(s,codenamecol,codenamelen);
      writeln(namestr,': ',cs);
      segsizes[numsegs].segname:=namestr;
      segsizes[numsegs].segsize:=cs;
      inc(numsegs);
      inc(totalsize,cs);
    end;
  end;

  writeln('segments ordered by size: ');
  {do bubblesort}
  for b:=numsegs-2 downto 0 do
    for w:=0 to b do 
      if segsizes[w].segsize > segsizes[w+1].segsize then begin
        tempseg:=segsizes[w];
        segsizes[w]:=segsizes[w+1];
        segsizes[w+1]:=tempseg;
      end;
  for w:=0 to numsegs-1 do writeln(segsizes[w].segname,': ',segsizes[w].segsize);

  close(f);
  writeln('Total memory size of code + data: ',totalsize);
end.

(*
 Start  Stop   Length Name               Class

 00000H 06392H 06393H topbench           CODE
 063A0H 06984H 005E5H inifiles           CODE
 06990H 06A7DH 000EEH CmdLin             CODE
 06A80H 088D4H 01E55H btsuites           CODE
 088E0H 089DBH 000FCH TInterrupts        CODE
 089E0H 08CD6H 002F7H ZTimer             CODE
 08CE0H 0D1C2H 044E3H topb_detect        CODE
 0D1D0H 0D200H 00031H Crc16              CODE
 0D210H 0D5FAH 003EBH vadapter           CODE
 0D600H 1163FH 04040H CPUType            CODE
 11640H 11BE2H 005A3H support            CODE
 11BF0H 164B1H 048C2H DetectGraphics     CODE
 164C0H 164D9H 0001AH DetectTime         CODE
 164E0H 164E0H 00000H DetectBios         CODE
 164E0H 164E0H 00000H DetectConstants    CODE
 164E0H 176C8H 011E9H DetectGlobal       CODE
 176D0H 17DE7H 00718H topb_datastructures CODE
 17DF0H 17DF0H 00000H topb_constants     CODE
 17DF0H 17E11H 00022H m6845ctl           CODE
 17E20H 1A08EH 0226FH totMENU            CODE
 1A090H 1A09DH 0000EH totIO3             CODE
 1A0A0H 1B870H 017D1H totIO2             CODE
 1B880H 1BDE4H 00565H totDATE            CODE
 1BDF0H 1BDFDH 0000EH totLINK            CODE
 1BE00H 1C9F9H 00BFAH totMSG             CODE
 1CA00H 1F9E9H 02FEAH totIO1             CODE
 1F9F0H 21036H 01647H totWIN             CODE
 21040H 210AAH 0006BH totMISC            CODE
 210B0H 22283H 011D4H totSTR             CODE
 22290H 2229DH 0000EH totReal            CODE
 222A0H 253A9H 0310AH totFAST            CODE
 253B0H 2635CH 00FADH totINPUT           CODE
 26360H 26642H 002E3H totLOOK            CODE
 26650H 26909H 002BAH totSYS             CODE
 26910H 26A93H 00184H Dos                CODE
 26AA0H 270BEH 0061FH Crt                CODE
 270C0H 2774FH 00690H Objects            CODE
 27750H 27771H 00022H Strings            CODE
 27780H 27780H 00000H Memory             CODE
 27780H 293EFH 01C70H System             CODE
 293F0H 2BDF7H 02A08H DATA               DATA
 2BE00H 2FDFFH 04000H STACK              STACK
 2FE00H 2FE00H 00000H HEAP               HEAP

  Address         Publics by Value

 0000:0538       PrepFWindow
 0000:060A       PopUserMessage
 0000:073A       PopAbout
 0000:0901       PopIntro
 0000:0A60       PromptYN
 0000:0B1E       PromptForFilename
 0000:0C84       CommitSystem
 0000:0D39       MakeNewSystem
 0000:0E70       DetectSystem
 0000:12F1       ImportSystemFile
 0000:1F55       SaveDatabase
 0000:273A       SaveDatabaseCSV
 0000:283E       repaintSysList
 0000:2D99       repaintSysInfo
 0000:338B       repaintSysTimings
 0000:3B02       EditSystem
 0000:4578       RealtimeCompare
 0000:4718       DeleteSystem
 0000:494E       SystemBrowser
 0000:4FE1       CompareSystems
 0000:52AA       initTOPB
 0000:59C1       doTOPB
 0000:5D7C       doneTOPB
 0000:5E3F       @
 0000:5EBC       introtext
 0699:00C9       Is_Param
 06A8:0004       testMemoryBlockOps
 06A8:009B       testCPUOpcodes
 06A8:04C3       testVideoAdapterWrites
 06A8:0523       testMemEA
 06A8:0AB0       test3DGames
 06A8:1D56       TOPScore
 06A8:1DB4       TOPScoreFingerprint
 06A8:1E29       @
 088E:0000       InitChannel
 088E:0081       SetTimer
 088E:00D7       CleanUpTimer
 089E:016B       _PZTimerOn
 089E:01C2       _PZTimerOff
 089E:0279       _PZTimerReport
 089E:02CD       _PZTimerCount
 08CE:0F5B       WhatMachineType
 08CE:3D49       WhatCPU
 08CE:3D75       WhatMHzReal
 08CE:3E39       WhatVideoAdapter
 08CE:4006       WhatVideoSubsystem
 08CE:4025       WhatBIOSDate
 08CE:4046       WhatBIOSRevision
 08CE:40F2       WhatBIOS
 08CE:42CD       WhatBIOSDateNormalized
 08CE:4456       WhatMachineUID
 08CE:44C2       @
 0D1D:0000       CRC16buf
 0D60:1CBB       cpu_Type
 0D60:3039       cpu_Speed
 0D60:31FF       fcpu_Speed
 0D60:3A7B       isV86
 0D60:3BF9       CxCPUIDEnable
 0D60:3C4C       getCPUID
 1164:0000       upstring
 1164:0025       FileExists
 1164:0086       IntToStr
 1164:00BC       StrToInt
 1164:010B       RealToStr
 1164:0208       StrToReal
 1164:027A       KeyPressed
 1164:0285       ReadKeyChar
 1164:0292       hex
 1164:032C       hexword
 1164:03DE       HexStrToLong
 1164:050C       WaitFloppySpindown
 11BF:1028       WhatSVGACard
 11BF:477C       VesaInf
 164C:0000       @
 164E:0000       StrFnWord
 164E:003F       StrFnByte
 164E:0080       Misc
 164E:01A1       ATIinfo
 164E:021D       AltIntr
 164E:022E       AltMsDos
 164E:023B       TsengCK
 164E:025D       ZyMOSCK
 164E:026E       PopAdbugtst
 164E:0296       MulBugTst
 164E:02BA       FDivBugTst
 164E:0E04       TestCache
 164E:0E9B       TestCach286
 17DF:0000       m6845_GetModeTable
 17DF:000B       @
 17E2:2261       menuINIT
 17E2:2266       @
 1A09:0000       IO3Init
 1A09:0005       @
 1A0A:17B5       IO2Init
 1A0A:17C8       @
 1B88:0544       DateInit
 1B88:055C       @
 1BDF:0000       LINKInit
 1BDF:0005       @
 1BE0:0BEC       MsgInit
 1BE0:0BF1       @
 1CA0:0000       NoCharHook
 1CA0:0013       NoEnterHook
 1CA0:0026       NoLeaveHook
 1CA0:0039       NoHelpHook
 1CA0:0045       AssignColors
 1CA0:2FC9       IO1Init
 1CA0:2FE1       @
 1F9F:1639       WinInit
 1F9F:163E       @
 2104:0000       Beep
 2104:002E       MiscInit
 2104:0062       @
 210B:0000       TruncFormat
 210B:00C2       Pad
 210B:016B       PadLeft
 210B:01F9       PadCenter
 210B:02B7       PadRight
 210B:035A       AdjCase
 210B:0408       SetUpper
 210B:0483       SetLower
 210B:04FE       SetProper
 210B:05DC       Strip
 210B:072F       IntToStr
 210B:076E       ValidReal
 210B:08B4       StrToReal
 210B:0A27       RealToStr
 210B:0B17       Decimals
 210B:0B5E       RealToSciStr
 210B:11CB       @
 2229:0000       RealInit
 2229:0005       @
 222A:0135       CAttr
 222A:015A       BAttr
 222A:0178       Replicate
 222A:2F3B       fastINIT
 222A:2F93       @
 253B:0000       NoInputIdleHook
 253B:0005       NoInputPressedHook
 253B:0F66       inputINIT
 253B:0FA4       @
 2636:0000       DING
 2636:02C2       LOOKinit
 2636:02DA       @
 2665:0299       sysINIT
 2665:02B1       @
 2691:0000       FindFirst
 2691:003E       FindNext
 2691:0080       GetIntVec
 2691:0098       SetIntVec
 2691:00AC       GetEnv
 2691:011C       MsDos
 2691:0127       Intr
 26AA:000D       @
 26AA:0177       TextMode
 26AA:018C       Window
 26AA:01CC       ClrScr
 26AA:01E6       ClrEol
 26AA:01FA       InsLine
 26AA:01FF       DelLine
 26AA:021F       GotoXY
 26AA:024B       WhereX
 26AA:0257       WhereY
 26AA:0263       TextColor
 26AA:027D       TextBackground
 26AA:0295       LowVideo
 26AA:029B       HighVideo
 26AA:02A1       NormVideo
 26AA:02A8       Delay
 26AA:02D4       Sound
 26AA:0301       NoSound
 26AA:0308       KeyPressed
 26AA:031A       ReadKey
 26AA:033C       AssignCrt
 270C:0613       NewStr
 270C:066C       DisposeStr
 2775:0000       StrPas
 293F:001A       DBdirty
 293F:001B       cnormal
 293F:001C       creverse
 293F:001D       chigh
 293F:001E       cunderline
 293F:001F       cblink
 293F:0020       _sound
 293F:0021       _skiptests
 293F:0082       screenseg
 293F:0486       cpu
 293F:0487       fpu
 293F:0488       extFlags
 293F:048A       cpuid0
 293F:0496       cpuid1
 293F:049A       cpuBrand
 293F:049E       cpuFeatures
 293F:05D2       HexNybble
 293F:06FC       mainmenuLookup
 293F:08E0       benchmenuLookup
 293F:09B0       dbmenuLookup
 293F:0B90       VidSysLabels
 293F:0BAE       AboutText
 293F:0E30       NumberError
 293F:0EAA       DateError
 293F:13CE       OvrCodeList
 293F:13D0       OvrHeapSize
 293F:13D2       OvrDebugPtr
 293F:13D6       OvrHeapOrg
 293F:13D8       OvrHeapPtr
 293F:13DA       OvrHeapEnd
 293F:13DC       OvrLoadList
 293F:13DE       OvrDosHandle
 293F:13E0       OvrEmsHandle
 293F:13E2       HeapOrg
 293F:13E6       HeapPtr
 293F:13EA       HeapEnd
 293F:13EE       FreeList
 293F:13F2       FreeZero
 293F:13F6       HeapError
 293F:13FA       ExitProc
 293F:13FE       ExitCode
 293F:1400       ErrorAddr
 293F:1404       PrefixSeg
 293F:1406       StackLimit
 293F:1408       InOutRes
 293F:140A       RandSeed
 293F:140E       SelectorInc
 293F:1410       Seg0040
 293F:1412       SegA000
 293F:1414       SegB000
 293F:1416       SegB800
 293F:1418       Test8086
 293F:1419       Test8087
 293F:141A       FileMode
 293F:141E       Systems
 293F:1422       SystemsByName
 293F:1426       mematstart
 293F:142A       MainMenu
 293F:142E       BenchMenu
 293F:1458       DBMenu
 293F:1482       MsgConsole
 293F:1486       FStatus
 293F:1B1E       BIOSTimerHandler
 293F:1B22       PITcycles
 293F:1B26       Chan0Counter
 293F:1B2A       WhatBIOSCRC16
 293F:2442       Regs
 293F:2456       CPU_Info
 293F:246A       AltPtr
 293F:246E       TempFreq
 293F:2474       pReal
 293F:2478       pByte
 293F:247C       p
 293F:2480       xByte
 293F:2481       xByte1
 293F:2482       xbyte2
 293F:2483       xbyte3
 293F:2484       xByte4
 293F:2485       xbyte5
 293F:2486       xbyte6
 293F:2487       xbyte7
 293F:2488       xBool
 293F:2489       xBool2
 293F:248A       xChar
 293F:248C       xWord
 293F:248E       xWord1
 293F:2490       xword2
 293F:2492       xword3
 293F:2494       xword4
 293F:2496       xword5
 293F:2498       xword6
 293F:249A       xword7
 293F:249C       xword8
 293F:249E       xLong
 293F:24A2       xLong2
 293F:24A6       xLong3
 293F:24AA       S
 293F:25AA       EndString
 293F:26AA       Result
 293F:26C6       xPointer
 293F:26E8       Int1D_mode_table
 293F:26EC       FmtNumberTOT
 293F:2700       DateTOT
 293F:2704       IOTOT
 293F:270A       LPTport
 293F:2710       Screen
 293F:2724       ScrollTOT
 293F:2728       ShadowTOT
 293F:272C       SnowProne
 293F:272E       AlphabetTOT
 293F:2732       Mouse
 293F:273C       Key
 293F:279C       LookTOT
 293F:27A0       Monitor
 293F:27A4       DosError
 293F:27A6       CheckBreak
 293F:27A7       CheckEOF
 293F:27A8       DirectVideo
 293F:27A9       CheckSnow
 293F:27AA       LastMode
 293F:27AC       TextAttr
 293F:27AE       WindMin
 293F:27B0       WindMax
 293F:27BA       Input
 293F:28BA       Output
 293F:29BA       SaveInt00
 293F:29BE       SaveInt02
 293F:29C2       SaveInt1B
 293F:29C6       SaveInt21
 293F:29CA       SaveInt23
 293F:29CE       SaveInt24
 293F:29D2       SaveInt34
 293F:29D6       SaveInt35
 293F:29DA       SaveInt36
 293F:29DE       SaveInt37
 293F:29E2       SaveInt38
 293F:29E6       SaveInt39
 293F:29EA       SaveInt3A
 293F:29EE       SaveInt3B
 293F:29F2       SaveInt3C
 293F:29F6       SaveInt3D
 293F:29FA       SaveInt3E
 293F:29FE       SaveInt3F
 293F:2A02       SaveInt75

Line numbers for topbench(TOPBENCH.PAS) segment topbench

   119 0000:0000   120 0000:002D   122 0000:003A   123 0000:0052
   124 0000:0069   125 0000:007C   126 0000:008F   129 0000:009A
   130 0000:009D   131 0000:00AA   134 0000:00B5   135 0000:00D3
   136 0000:00E6   137 0000:0107   138 0000:011A   143 0000:017E
   144 0000:018D   146 0000:019A   147 0000:01A2   148 0000:01A7
   149 0000:01AC   150 0000:01B1   152 0000:01B6   153 0000:01D2
   155 0000:01D7   156 0000:01EF   157 0000:020F   158 0000:022D
   161 0000:0236   162 0000:0239   163 0000:024A   165 0000:025C
   166 0000:0269   169 0000:0274   170 0000:0277   171 0000:028F
   172 0000:029A   173 0000:02A8   176 0000:02AC   177 0000:02AF
   178 0000:02BD   179 0000:02CE   184 0000:0328   186 0000:0346
   187 0000:0349   188 0000:036D   189 0000:039B   190 0000:03C9
   193 0000:03F5   194 0000:041B   195 0000:041E   196 0000:042F
   197 0000:0440   198 0000:0448   200 0000:0453   203 0000:047B
   204 0000:0484   205 0000:048E   206 0000:049D   207 0000:04A4
   209 0000:04A9   210 0000:04AD   211 0000:04B0   212 0000:04B3
   214 0000:04B5   215 0000:04E7   216 0000:052A   218 0000:0532
   221 0000:0538   223 0000:055A   224 0000:056E   225 0000:0578
   226 0000:05AD   227 0000:05BC   228 0000:05C9   229 0000:05D6
   231 0000:05E6   239 0000:060A   241 0000:062D   242 0000:0630
   243 0000:064A   244 0000:0664   246 0000:067C   247 0000:0694
   248 0000:06A4   249 0000:06B4   250 0000:06BF   251 0000:06CF
   253 0000:06E2   259 0000:073A   262 0000:0741   263 0000:0765
   264 0000:079C   266 0000:0833   267 0000:08A3   268 0000:08B2
   269 0000:08BC   272 0000:08CB   287 0000:0901   288 0000:0908
   289 0000:090D   290 0000:0912   293 0000:095D   294 0000:0969
   295 0000:0974   296 0000:0980   297 0000:0986   298 0000:0992
   299 0000:099C   300 0000:09C7   302 0000:09CF   303 0000:09F7
   304 0000:09FB   305 0000:0A0B   306 0000:0A10   310 0000:0A14
   311 0000:0A17   312 0000:0A1A   313 0000:0A3E   314 0000:0A48
   320 0000:0A60   322 0000:0A83   323 0000:0A9A   324 0000:0AAA
   325 0000:0AC4   326 0000:0ADE   327 0000:0AED   329 0000:0AFD
   330 0000:0B0A   339 0000:0B1E   340 0000:0B41   341 0000:0B54
   342 0000:0B5D   343 0000:0B73   344 0000:0B82   345 0000:0B8F
   346 0000:0B9C   348 0000:0BB1   349 0000:0BD0   350 0000:0BD9
   351 0000:0BE8   352 0000:0BF4   354 0000:0C12   355 0000:0C21
   356 0000:0C31   364 0000:0C84   365 0000:0C8B   366 0000:0C97
   367 0000:0CA9   369 0000:0CAC   371 0000:0CB7   373 0000:0CCD
   374 0000:0CE7   375 0000:0D15   376 0000:0D26   378 0000:0D28
   380 0000:0D2D   384 0000:0D39   385 0000:0D3C   387 0000:0DA2
   394 0000:0E70   395 0000:0E77   396 0000:0E7F   397 0000:0E8E
   398 0000:0E9D   399 0000:0EAC   400 0000:0EBB   401 0000:0ECA
   402 0000:0ED9   403 0000:0EE8   404 0000:0EFB   406 0000:0F0A
   407 0000:0F11   408 0000:0F20   410 0000:0F38   411 0000:0F47
   414 0000:0F5E   415 0000:0F6D   417 0000:0F85   418 0000:0F94
   420 0000:0FA7   421 0000:0FB6   423 0000:0FC3   424 0000:0FD2
   425 0000:0FEB   426 0000:0FF4   427 0000:101F   429 0000:1032
   430 0000:1039   431 0000:1048   433 0000:1060   434 0000:106F
   436 0000:1087   438 0000:109F   439 0000:10AE   440 0000:10BF
   459 0000:10FA   460 0000:1101   461 0000:110B   463 0000:1123
   464 0000:112E   466 0000:1139   467 0000:1173   469 0000:1186
   470 0000:118F   472 0000:12F1   473 0000:1315   474 0000:1337
   475 0000:1341   476 0000:1369   479 0000:136C   481 0000:138A
   482 0000:1393   485 0000:1398   486 0000:13AB   488 0000:13BC
   490 0000:13D6   491 0000:13E3   493 0000:13F6   495 0000:1403
   497 0000:1412   499 0000:1416   501 0000:141F   503 0000:1430
   504 0000:143B   507 0000:1463   508 0000:1471   516 0000:147D
   517 0000:14A9   518 0000:14C0   519 0000:14CC   520 0000:14D8
   522 0000:14EA   523 0000:1516   524 0000:152D   525 0000:1539
   526 0000:1545   528 0000:1557   529 0000:1583   530 0000:159A
   531 0000:15A6   532 0000:15B2   534 0000:15C4   535 0000:15F0
   536 0000:1607   537 0000:1613   538 0000:161F   540 0000:1631
   541 0000:165D   542 0000:1674   543 0000:1680   544 0000:168C
   546 0000:169E   547 0000:16CA   548 0000:16E1   550 0000:16EB
   551 0000:1717   552 0000:1732   554 0000:173C   555 0000:1768
   556 0000:177D   558 0000:1787   559 0000:17B3   560 0000:17C8
   561 0000:17F4   563 0000:180D   564 0000:1830   566 0000:184B
   567 0000:1877   568 0000:1882   569 0000:18B3   570 0000:18C6
   571 0000:18F2   572 0000:1907   573 0000:1933   574 0000:1948
   575 0000:1974   576 0000:198F   577 0000:19BB   578 0000:19D0
   579 0000:19FC   582 0000:1A11   584 0000:1A14   586 0000:1A18
   587 0000:1A27   588 0000:1A38   612 0000:1AEA   613 0000:1AF1
   614 0000:1AFA   615 0000:1B04   617 0000:1B3A   619 0000:1BA2
   620 0000:1BC3   621 0000:1BED   622 0000:1C17   623 0000:1C41
   624 0000:1C6B   625 0000:1C95   627 0000:1CBF   628 0000:1CE9
   629 0000:1D3D   630 0000:1D67   631 0000:1DA4   632 0000:1DD4
   633 0000:1E0F   634 0000:1E39   635 0000:1E63   636 0000:1E8D
   638 0000:1EB7   640 0000:1F55   641 0000:1F79   645 0000:1F97
   646 0000:1FB9   647 0000:1FC3   648 0000:1FD3   649 0000:1FE3
   650 0000:1FF5   651 0000:2004   652 0000:2006   655 0000:202E
   656 0000:203F   673 0000:2049   677 0000:2050   678 0000:205B
   679 0000:2065   681 0000:2079   682 0000:2092   683 0000:20DF
   684 0000:2125   685 0000:216B   686 0000:21B1   687 0000:21F7
   688 0000:223D   689 0000:2283   690 0000:22EA   691 0000:2371
   692 0000:23EC   693 0000:2432   694 0000:2474   696 0000:24BC
   697 0000:24DD   698 0000:2542   699 0000:2563   700 0000:25C8
   701 0000:25E9   702 0000:264E   704 0000:266F   705 0000:2682
   707 0000:273A   708 0000:275E   709 0000:277C   710 0000:278D
   712 0000:279D   713 0000:27B1   714 0000:27DB   715 0000:27F9
   716 0000:280B   717 0000:281B   718 0000:282C   729 0000:283E
   730 0000:2860   731 0000:2873   732 0000:287D   733 0000:2883
   734 0000:288B   735 0000:2896   736 0000:28AE   737 0000:28BB
   738 0000:28CA   741 0000:28D5   742 0000:28E3   744 0000:28ED
   745 0000:2906   748 0000:2944   749 0000:296A   750 0000:2984
   751 0000:29AF   752 0000:29D1   753 0000:29F3   754 0000:2A00
   755 0000:2A0B   756 0000:2A11   757 0000:2A2F   758 0000:2A4E
   759 0000:2A59   760 0000:2A63   761 0000:2A6D   763 0000:2A7A
   781 0000:2A80   782 0000:2A9E   784 0000:2AA7   786 0000:2AC6
   787 0000:2ADB   788 0000:2AEA   791 0000:2AF3   793 0000:2AFF
   794 0000:2B08   795 0000:2B39   796 0000:2B56   797 0000:2B59
   799 0000:2B5C   800 0000:2B7C   801 0000:2B8B   803 0000:2B95
   804 0000:2BC2   805 0000:2BDF   806 0000:2BE8   807 0000:2BEC
   809 0000:2BEE   811 0000:2BF8   813 0000:2C03   814 0000:2C31
   815 0000:2C4E   816 0000:2C56   817 0000:2C5A   820 0000:2C5C
   822 0000:2C5F   831 0000:2C67   832 0000:2C8A   833 0000:2CE2
   834 0000:2CF5   836 0000:2D99   837 0000:2DA0   839 0000:2DB3
   840 0000:2DC1   841 0000:2DCB   843 0000:2DDD   846 0000:2E1B
   847 0000:2E41   855 0000:2E53   856 0000:2E71   858 0000:2E97
   859 0000:2EB5   860 0000:2EE5   861 0000:2F03   862 0000:2F33
   863 0000:2F51   864 0000:2F81   865 0000:2F9F   866 0000:2FCF
   867 0000:2FED   868 0000:301D   869 0000:303B   870 0000:3044
   874 0000:3084   875 0000:30A2   876 0000:30BB   877 0000:30D7
   879 0000:312D   880 0000:314B   881 0000:3173   882 0000:3180
   884 0000:31D1   885 0000:31F5   887 0000:3202   890 0000:3221
   891 0000:324F   893 0000:325C   896 0000:3285   897 0000:32B3
   899 0000:32C0   902 0000:32E9   903 0000:32F3   904 0000:32FD
   906 0000:330A   921 0000:338B   922 0000:3392   924 0000:33A5
   925 0000:33B3   926 0000:33BD   928 0000:33CF   931 0000:340D
   932 0000:3433   939 0000:3445   940 0000:3450   941 0000:345B
   942 0000:3461   944 0000:3467   945 0000:3480   946 0000:34A1
   948 0000:34D1   949 0000:34EA   950 0000:350B   952 0000:3545
   953 0000:355E   954 0000:357F   956 0000:35B9   957 0000:35D2
   958 0000:35F3   960 0000:362D   961 0000:3646   962 0000:3667
   964 0000:36A1   965 0000:36BA   966 0000:36DB   968 0000:3715
   969 0000:372E   970 0000:374F   971 0000:3758   973 0000:379C
   975 0000:37A2   976 0000:37BB   977 0000:37D8   978 0000:37F4
   980 0000:384E   981 0000:3867   982 0000:3893   983 0000:38A0
   991 0000:38F5   992 0000:38FF   993 0000:3909   995 0000:3916
  1030 0000:3B02  1031 0000:3B09  1032 0000:3B1E  1033 0000:3B33
  1034 0000:3B48  1036 0000:3B5D  1037 0000:3B63  1038 0000:3B6E
  1040 0000:3B74  1041 0000:3B89  1043 0000:3B98  1044 0000:3BC5
  1045 0000:3BD5  1046 0000:3BF6  1047 0000:3C19  1050 0000:3C27
  1051 0000:3C48  1052 0000:3C58  1053 0000:3C79  1054 0000:3C9C
  1057 0000:3CAA  1058 0000:3CCD  1059 0000:3CDD  1060 0000:3CFE
  1063 0000:3D19  1064 0000:3D48  1065 0000:3D58  1066 0000:3D79
  1067 0000:3D9C  1070 0000:3DAA  1071 0000:3DD9  1072 0000:3DE9
  1073 0000:3E0A  1074 0000:3E2D  1077 0000:3E3B  1078 0000:3E67
  1079 0000:3E77  1080 0000:3E98  1081 0000:3EBB  1084 0000:3EC9
  1085 0000:3EF4  1086 0000:3F15  1087 0000:3F20  1090 0000:3F5C
  1091 0000:3F8B  1092 0000:3F9B  1093 0000:3FBC  1094 0000:3FDF
  1097 0000:3FED  1098 0000:4015  1099 0000:4024  1100 0000:404B
  1102 0000:405A  1103 0000:4069  1107 0000:40C3  1108 0000:40ED
  1110 0000:40FB  1111 0000:410A  1112 0000:411B  1113 0000:412C
  1114 0000:413D  1115 0000:414E  1116 0000:415F  1117 0000:4170
  1118 0000:4181  1119 0000:4192  1120 0000:41A3  1121 0000:41B4
  1122 0000:41CB  1123 0000:41D5  1125 0000:41F8  1126 0000:4205
  1128 0000:420F  1130 0000:421E  1131 0000:4228  1132 0000:4235
  1133 0000:4239  1134 0000:4240  1136 0000:424C  1137 0000:4268
  1138 0000:4284  1139 0000:42A0  1140 0000:42BC  1141 0000:42D8
  1142 0000:42F4  1143 0000:4307  1144 0000:4322  1146 0000:4327
  1147 0000:4353  1148 0000:4357  1149 0000:4359  1150 0000:435D
  1151 0000:4389  1154 0000:438D  1156 0000:439D  1160 0000:43AE
  1161 0000:43BE  1162 0000:43CE  1163 0000:43DE  1164 0000:43EE
  1165 0000:43FE  1166 0000:440E  1167 0000:441E  1168 0000:442E
  1169 0000:443E  1170 0000:444E  1171 0000:4464  1191 0000:44FA
  1192 0000:44FD  1193 0000:4527  1194 0000:4552  1195 0000:4574
  1197 0000:4578  1198 0000:457E  1199 0000:4592  1200 0000:459C
  1202 0000:45A1  1204 0000:45A9  1205 0000:45B9  1206 0000:45C5
  1207 0000:45D1  1208 0000:45DD  1209 0000:45E9  1210 0000:45F5
  1211 0000:4601  1212 0000:4611  1213 0000:461B  1217 0000:4635
  1218 0000:463B  1219 0000:4641  1220 0000:4644  1221 0000:4648
  1222 0000:4659  1223 0000:4663  1224 0000:4668  1225 0000:4676
  1234 0000:4718  1235 0000:471F  1236 0000:4729  1237 0000:473B
  1242 0000:473E  1244 0000:4743  1246 0000:4756  1247 0000:476B
  1249 0000:477A  1250 0000:4788  1251 0000:47B3  1253 0000:47B5
  1256 0000:47E0  1257 0000:47E5  1260 0000:47E8  1261 0000:47FD
  1263 0000:480C  1264 0000:4841  1266 0000:484F  1267 0000:4851
  1268 0000:487C  1293 0000:48D0  1294 0000:48D3  1295 0000:48FD
  1296 0000:4928  1297 0000:494A  1299 0000:494E  1300 0000:4954
  1301 0000:4968  1302 0000:4972  1304 0000:4977  1306 0000:497B
  1307 0000:4981  1308 0000:498B  1309 0000:4990  1310 0000:499C
  1311 0000:49A8  1312 0000:49AB  1313 0000:49AD  1314 0000:49B2
  1316 0000:49C1  1317 0000:49D4  1318 0000:49D6  1319 0000:49E0
  1320 0000:49EA  1321 0000:49FB  1322 0000:4A0C  1323 0000:4A18
  1326 0000:4A29  1328 0000:4A31  1329 0000:4A49  1332 0000:4A54
  1333 0000:4A58  1334 0000:4A6A  1367 0000:4AD4  1368 0000:4ADA
  1369 0000:4AEF  1370 0000:4AF8  1371 0000:4B14  1372 0000:4B1A
  1373 0000:4B5C  1374 0000:4B7B  1375 0000:4B7F  1376 0000:4B84
  1377 0000:4B9B  1378 0000:4B9D  1379 0000:4BA2  1380 0000:4BB9
  1381 0000:4BBB  1382 0000:4BC0  1387 0000:4BD7  1388 0000:4C16
  1389 0000:4C1F  1390 0000:4C74  1391 0000:4CBB  1392 0000:4D02
  1393 0000:4D49  1394 0000:4D90  1395 0000:4DD7  1396 0000:4E12
  1398 0000:4E1B  1400 0000:4E5C  1403 0000:4E9F  1405 0000:4EFE
  1409 0000:4F5F  1410 0000:4F8B  1412 0000:4FE1  1413 0000:4FE7
  1415 0000:5004  1416 0000:5014  1421 0000:5036  1422 0000:503A
  1423 0000:5044  1424 0000:5054  1425 0000:5067  1426 0000:507A
  1427 0000:5096  1428 0000:50B2  1429 0000:50C7  1432 0000:50E3
  1433 0000:5113  1434 0000:5130  1435 0000:5142  1443 0000:52AA
  1444 0000:52B1  1445 0000:52CC  1446 0000:52D1  1447 0000:52ED
  1448 0000:5309  1449 0000:5325  1450 0000:5341  1451 0000:535D
  1453 0000:5365  1454 0000:5371  1456 0000:537C  1457 0000:5389
  1459 0000:5397  1460 0000:53A8  1465 0000:53B9  1469 0000:53C6
  1472 0000:53D9  1474 0000:53E5  1475 0000:53F9  1476 0000:5405
  1477 0000:5418  1478 0000:5432  1479 0000:543D  1480 0000:5457
  1481 0000:545B  1482 0000:54AD  1484 0000:54FE  1487 0000:554A
  1491 0000:5554  1492 0000:5562  1493 0000:5574  1494 0000:558D
  1495 0000:55B2  1499 0000:5604  1500 0000:5612  1501 0000:5624
  1502 0000:563D  1503 0000:5662  1504 0000:56B4  1507 0000:56C4
  1509 0000:56D4  1511 0000:5702  1513 0000:571E  1514 0000:5732
  1515 0000:575A  1516 0000:5769  1517 0000:579D  1518 0000:57A6
  1537 0000:57AA  1539 0000:57B0  1540 0000:57CC  1541 0000:57D5
  1542 0000:57F0  1543 0000:5814  1546 0000:581A  1547 0000:581D
  1548 0000:582C  1550 0000:59C1  1551 0000:59C8  1554 0000:59CD
  1555 0000:59DD  1556 0000:59F0  1557 0000:59FA  1559 0000:5A04
  1560 0000:5A07  1561 0000:5A0E  1562 0000:5A12  1563 0000:5A16
  1564 0000:5A21  1565 0000:5A25  1566 0000:5A28  1567 0000:5A2C
  1568 0000:5A30  1569 0000:5A3B  1570 0000:5A3F  1571 0000:5A42
  1572 0000:5A4C  1573 0000:5A50  1574 0000:5A54  1576 0000:5A5F
  1577 0000:5A63  1578 0000:5A66  1579 0000:5A70  1580 0000:5A74
  1581 0000:5A7E  1582 0000:5A83  1583 0000:5A8D  1584 0000:5A90
  1585 0000:5A97  1586 0000:5AB4  1587 0000:5ABE  1589 0000:5AD5
  1590 0000:5AE7  1591 0000:5AFF  1592 0000:5B2A  1593 0000:5B3F
  1594 0000:5B46  1595 0000:5B65  1596 0000:5B70  1597 0000:5B72
  1599 0000:5B7D  1600 0000:5B80  1601 0000:5B84  1602 0000:5B94
  1603 0000:5B99  1604 0000:5B9C  1605 0000:5BAE  1606 0000:5BB2
  1607 0000:5BCF  1608 0000:5BE0  1609 0000:5BE3  1610 0000:5BED
  1611 0000:5BF4  1612 0000:5BFD  1613 0000:5C06  1614 0000:5C0F
  1615 0000:5C19  1617 0000:5C26  1618 0000:5C2A  1619 0000:5C51
  1620 0000:5C71  1622 0000:5C75  1625 0000:5C78  1626 0000:5CAE
  1627 0000:5CC4  1628 0000:5CD3  1629 0000:5CE2  1630 0000:5CF1
  1631 0000:5CFB  1635 0000:5D0A  1636 0000:5D14  1637 0000:5D21
  1638 0000:5D2A  1639 0000:5D35  1640 0000:5D3C  1641 0000:5D48
  1642 0000:5D58  1645 0000:5D7C  1646 0000:5D83  1647 0000:5D93
  1648 0000:5DA1  1649 0000:5DAF  1651 0000:5DBF  1653 0000:5DCE
  1654 0000:5DDF  1655 0000:5E2C  1656 0000:5E3B  1658 0000:5E3F
  1659 0000:5EAB  1660 0000:5EAE  1661 0000:5EB1  1662 0000:5EB4

Line numbers for inifiles(INIFILES.PAS) segment inifiles

   102 063A:0008   103 063A:003A   105 063A:0047   106 063A:004D
   107 063A:005C   109 063A:0060   110 063A:0066   111 063A:0075
   113 063A:0078   114 063A:008D   115 063A:009E   116 063A:00A8
   118 063A:00C4   119 063A:00D1   120 063A:00ED   121 063A:0106
   123 063A:0122   124 063A:012A   125 063A:013B   126 063A:014F
   129 063A:0161   130 063A:016A   131 063A:0170   132 063A:0176
   133 063A:017C   136 063A:0190   137 063A:019A   138 063A:01A6
   139 063A:01B1   140 063A:01BF   141 063A:01D5   142 063A:01E2
   145 063A:01F3   146 063A:022C   147 063A:023A   148 063A:0272
   149 063A:02AC   152 063A:02B4   153 063A:02DA   154 063A:030B
   157 063A:0313   158 063A:034C   159 063A:0387   167 063A:0399
   170 063A:03A8   171 063A:03B3   172 063A:03C0   176 063A:03C3
   177 063A:03D5   178 063A:03DD   183 063A:03E0   185 063A:0400
   194 063A:0477   196 063A:0480   197 063A:0488   201 063A:048B
   202 063A:0496   203 063A:04E0   204 063A:04E9   205 063A:04EF
   206 063A:04F5   208 063A:04F8   209 063A:0521   210 063A:0527
   211 063A:0558   215 063A:0590   216 063A:05A0   227 063A:05AC
   228 063A:05BA   229 063A:05C5   232 063A:05CE   233 063A:05D8
   234 063A:05E1

Line numbers for CmdLin(CMDLIN.PAS) segment CmdLin

    79 0699:0000    80 0699:0006    81 0699:001F    82 0699:0025
    94 0699:002E    95 0699:0035    96 0699:0040    97 0699:0044
    98 0699:0049    99 0699:0051   100 0699:0057   101 0699:005F
   102 0699:0063   103 0699:0068   104 0699:006A   105 0699:0087
   107 0699:00AF   108 0699:00B8   109 0699:00BA   110 0699:00C0
   114 0699:00C9   115 0699:00CF   116 0699:00E5

Line numbers for btsuites(BTSUITES.PAS) segment btsuites

   112 06A8:0000   114 06A8:0001   121 06A8:0002   127 06A8:0003

Line numbers for btsuites(_MBLOCK.INC) segment btsuites

     2 06A8:0004     5 06A8:000A     7 06A8:0016    13 06A8:0028
    14 06A8:002D    23 06A8:002F    24 06A8:0030    25 06A8:0032
    26 06A8:0036    27 06A8:0039    28 06A8:003B    29 06A8:003D
    30 06A8:0040    32 06A8:0042    33 06A8:0046    34 06A8:004A
    35 06A8:004D    36 06A8:004F    37 06A8:0051    38 06A8:0054
    40 06A8:0056    41 06A8:005A    42 06A8:005E    44 06A8:0064
    45 06A8:0067    46 06A8:0069    48 06A8:006B    49 06A8:006F
    50 06A8:0072    52 06A8:0074    53 06A8:0078    54 06A8:007B
    55 06A8:007D    57 06A8:007F    59 06A8:0081    62 06A8:0086
    63 06A8:0091

Line numbers for btsuites(_OPCODES.INC) segment btsuites

     2 06A8:009B    27 06A8:00A1    28 06A8:00A6    29 06A8:00A9
    36 06A8:00AC    37 06A8:00AF    38 06A8:00B3    39 06A8:00B5
    40 06A8:00B8    41 06A8:00BC    42 06A8:00C0    43 06A8:00C4
    44 06A8:00C8    45 06A8:00CC    46 06A8:00D0    47 06A8:00D4
    48 06A8:00D8    49 06A8:00DA    50 06A8:00DC    51 06A8:00DE
    53 06A8:00E0    54 06A8:00E1    56 06A8:00E2    57 06A8:00E5
    58 06A8:00E9    59 06A8:00EB    60 06A8:00EE    61 06A8:00F2
    62 06A8:00F6    63 06A8:00FA    64 06A8:00FE    65 06A8:0102
    66 06A8:0106    67 06A8:010A    68 06A8:010E    69 06A8:0110
    70 06A8:0112    71 06A8:0114    73 06A8:0116    74 06A8:0117
    78 06A8:0118    79 06A8:011B    80 06A8:011F    81 06A8:0121
    82 06A8:0124    83 06A8:0128    84 06A8:012C    85 06A8:0130
    86 06A8:0134    87 06A8:0138    88 06A8:013C    89 06A8:0140
    90 06A8:0144    91 06A8:0146    92 06A8:0148    93 06A8:014A
    95 06A8:014C    96 06A8:014D    97 06A8:014F    98 06A8:0150
    99 06A8:0151   100 06A8:0153   102 06A8:0154   103 06A8:0157
   104 06A8:015B   105 06A8:015D   106 06A8:0160   107 06A8:0164
   108 06A8:0168   109 06A8:016C   110 06A8:0170   111 06A8:0174
   112 06A8:0178   113 06A8:017C   114 06A8:0180   115 06A8:0182
   116 06A8:0184   117 06A8:0186   119 06A8:0188   120 06A8:0189
   122 06A8:018A   123 06A8:018D   124 06A8:0191   125 06A8:0193
   126 06A8:0196   127 06A8:019A   128 06A8:019E   129 06A8:01A2
   130 06A8:01A6   131 06A8:01AA   132 06A8:01AE   133 06A8:01B2
   134 06A8:01B6   135 06A8:01B8   136 06A8:01BA   137 06A8:01BC
   139 06A8:01BE   141 06A8:01C1   143 06A8:01C2   144 06A8:01C5
   145 06A8:01C9   146 06A8:01CB   147 06A8:01CE   148 06A8:01D2
   149 06A8:01D6   150 06A8:01DA   151 06A8:01DE   152 06A8:01E2
   153 06A8:01E6   154 06A8:01EA   155 06A8:01EE   156 06A8:01F0
   157 06A8:01F2   158 06A8:01F4   160 06A8:01F6   162 06A8:01F9
   164 06A8:01FA   165 06A8:01FD   166 06A8:0201   167 06A8:0203
   168 06A8:0206   169 06A8:020A   170 06A8:020E   171 06A8:0212
   172 06A8:0216   173 06A8:021A   174 06A8:021E   175 06A8:0222
   176 06A8:0226   177 06A8:0228   178 06A8:022A   179 06A8:022C
   181 06A8:022E   183 06A8:0231   185 06A8:0232   186 06A8:0235
   187 06A8:0239   188 06A8:023B   189 06A8:023E   190 06A8:0242
   191 06A8:0246   192 06A8:024A   193 06A8:024E   194 06A8:0252
   195 06A8:0256   196 06A8:025A   197 06A8:025E   198 06A8:0260
   199 06A8:0262   200 06A8:0264   202 06A8:0266   204 06A8:0268
   206 06A8:0269   207 06A8:026A   208 06A8:026B   209 06A8:026C
   210 06A8:026D   211 06A8:026E   212 06A8:026F   213 06A8:0270
   214 06A8:0271   215 06A8:0272   216 06A8:0273   217 06A8:0274
   219 06A8:0275   220 06A8:0276   221 06A8:0277   222 06A8:0278
   223 06A8:0279   224 06A8:027A   225 06A8:027B   227 06A8:027C
   228 06A8:027D   229 06A8:027E   230 06A8:027F   231 06A8:0280
   232 06A8:0281   233 06A8:0282   234 06A8:0283   235 06A8:0284
   236 06A8:0285   237 06A8:0286   238 06A8:0287   239 06A8:0288
   240 06A8:0289   245 06A8:028A   246 06A8:028C   247 06A8:028D
   248 06A8:028E   249 06A8:0290   251 06A8:0291   252 06A8:0292
   253 06A8:0294   254 06A8:0295   255 06A8:0297   256 06A8:029A
   258 06A8:029C   259 06A8:029D   261 06A8:029E   262 06A8:02A0
   264 06A8:02A3   265 06A8:02A4   269 06A8:02A6   270 06A8:02A9
   271 06A8:02AD   272 06A8:02AF   273 06A8:02B2   274 06A8:02B6
   275 06A8:02BA   276 06A8:02BE   277 06A8:02C2   278 06A8:02C6
   279 06A8:02CA   280 06A8:02CE   281 06A8:02D2   282 06A8:02D4
   283 06A8:02D6   284 06A8:02D8   286 06A8:02DA   289 06A8:02DE
   291 06A8:02E2   293 06A8:02E6   295 06A8:02E7   296 06A8:02EB
   297 06A8:02EF   298 06A8:02F3   299 06A8:02F7   300 06A8:02FB
   301 06A8:02FF   302 06A8:0303   303 06A8:0307   304 06A8:0308
   305 06A8:0309   306 06A8:030B   308 06A8:030D   311 06A8:030E
   312 06A8:0311   314 06A8:0316   315 06A8:0317   316 06A8:0318
   317 06A8:0319   318 06A8:031A   320 06A8:031B   321 06A8:031C
   322 06A8:031D   323 06A8:031F   324 06A8:0320   325 06A8:0321
   326 06A8:0322   327 06A8:0323   328 06A8:0324   329 06A8:0325
   330 06A8:0326   331 06A8:0327   332 06A8:0328   333 06A8:0329
   334 06A8:032A   336 06A8:032B   337 06A8:032C   338 06A8:032D
   339 06A8:032E   340 06A8:032F   341 06A8:0330   342 06A8:0331
   343 06A8:0332   346 06A8:0333   347 06A8:0335   348 06A8:0337
   349 06A8:0339   350 06A8:033B   351 06A8:033D   352 06A8:033F
   353 06A8:0341   354 06A8:0343   355 06A8:0346   356 06A8:0349
   357 06A8:034C   359 06A8:034F   360 06A8:0350   361 06A8:0351
   362 06A8:0353   363 06A8:0356   364 06A8:0358   365 06A8:035A
   366 06A8:035D   367 06A8:035F   368 06A8:0360   369 06A8:0363
   371 06A8:0366   372 06A8:036A   373 06A8:036B   374 06A8:036C
   375 06A8:036D   376 06A8:0371   377 06A8:0372   379 06A8:0373
   380 06A8:0376   381 06A8:0378   382 06A8:037C   383 06A8:037E
   384 06A8:0382   385 06A8:0384   386 06A8:0388   387 06A8:038A
   388 06A8:038E   389 06A8:0390   390 06A8:0394   391 06A8:0396
   392 06A8:039A   393 06A8:039C   394 06A8:03A0   395 06A8:03A2
   396 06A8:03A6   397 06A8:03A8   398 06A8:03AC   399 06A8:03AE
   400 06A8:03B2   401 06A8:03B4   402 06A8:03B8   403 06A8:03BA
   404 06A8:03BE   405 06A8:03C0   406 06A8:03C4   407 06A8:03C6
   408 06A8:03CA   409 06A8:03CC   410 06A8:03D0   411 06A8:03D2
   415 06A8:03D6   416 06A8:03D8   417 06A8:03DA   418 06A8:03DE
   419 06A8:03E0   420 06A8:03E4   421 06A8:03E6   422 06A8:03EA
   423 06A8:03EC   424 06A8:03F0   425 06A8:03F2   426 06A8:03F6
   427 06A8:03F8   428 06A8:03FC   429 06A8:03FE   430 06A8:0402
   431 06A8:0404   432 06A8:0408   433 06A8:040A   434 06A8:040E
   435 06A8:0410   436 06A8:0414   437 06A8:0416   438 06A8:041A
   439 06A8:041C   440 06A8:0420   441 06A8:0422   442 06A8:0426
   443 06A8:0428   444 06A8:042C   445 06A8:042E   446 06A8:0432
   447 06A8:0434   449 06A8:0438   450 06A8:043A   451 06A8:043C
   453 06A8:043D   454 06A8:0440   456 06A8:0443   458 06A8:0444
   459 06A8:0446   460 06A8:0448   461 06A8:044A   464 06A8:044C
   465 06A8:044F   466 06A8:0451   467 06A8:0454   468 06A8:0456
   469 06A8:0458   471 06A8:045A   472 06A8:045B   473 06A8:045C
   474 06A8:045D   476 06A8:045E   477 06A8:045F   483 06A8:0460
   499 06A8:0462   500 06A8:0463   511 06A8:0468   512 06A8:046B
   513 06A8:046E   514 06A8:0470   515 06A8:0472   516 06A8:0475
   517 06A8:0479   518 06A8:047C   519 06A8:0480   520 06A8:0483
   521 06A8:0487   522 06A8:048A   523 06A8:048E   524 06A8:0490
   525 06A8:0492   526 06A8:0494   528 06A8:0496   529 06A8:0499
   530 06A8:049C   531 06A8:049F   533 06A8:04A1   535 06A8:04A5
   536 06A8:04A7   538 06A8:04A9   540 06A8:04AE   541 06A8:04B9

Line numbers for btsuites(_VIDMEM.INC) segment btsuites

     3 06A8:04C3     5 06A8:04C9    13 06A8:04D5    14 06A8:04DA
    16 06A8:04DC    17 06A8:04E0    18 06A8:04E4    19 06A8:04E7
    20 06A8:04E9    21 06A8:04EA    22 06A8:04EC    23 06A8:04EE
    24 06A8:04F2    25 06A8:04F6    26 06A8:04F7    27 06A8:04F8
    28 06A8:04F9    29 06A8:04FA    30 06A8:04FD    31 06A8:0500
    32 06A8:0503    33 06A8:0505    35 06A8:0507    37 06A8:0509
    41 06A8:050E    42 06A8:0519

Line numbers for btsuites(_EA.INC) segment btsuites

     2 06A8:0523     8 06A8:0529    14 06A8:052E    15 06A8:0532
    16 06A8:0534    17 06A8:0536    18 06A8:0537    19 06A8:0539
    20 06A8:053B    22 06A8:053D    23 06A8:053F    24 06A8:0541
    25 06A8:0543    26 06A8:0545    27 06A8:0547    28 06A8:0549
    29 06A8:054B    30 06A8:054D    31 06A8:054F    32 06A8:0551
    33 06A8:0553    34 06A8:0555    35 06A8:0558    36 06A8:055B
    37 06A8:055D    38 06A8:055F    39 06A8:0562    40 06A8:0565
    41 06A8:0568    42 06A8:056B    43 06A8:056E    44 06A8:0571
    45 06A8:0574    46 06A8:0577    47 06A8:057A    48 06A8:057D
    49 06A8:0580    50 06A8:0583    51 06A8:0586    52 06A8:0589
    53 06A8:058C    54 06A8:058F    55 06A8:0593    56 06A8:0597
    57 06A8:059B    58 06A8:059F    59 06A8:05A3    60 06A8:05A7
    61 06A8:05AB    62 06A8:05AF    63 06A8:05B3    64 06A8:05B7
    65 06A8:05BB    66 06A8:05BF    67 06A8:05C3    68 06A8:05C7
    69 06A8:05CB    71 06A8:05CF    72 06A8:05D2    73 06A8:05D5
    74 06A8:05D8    75 06A8:05DB    76 06A8:05DE    77 06A8:05E1
    78 06A8:05E4    79 06A8:05E7    80 06A8:05EA    81 06A8:05ED
    82 06A8:05F0    83 06A8:05F3    84 06A8:05F7    85 06A8:05FB
    86 06A8:05FE    87 06A8:0601    88 06A8:0605    89 06A8:0609
    90 06A8:060D    91 06A8:0611    92 06A8:0615    93 06A8:0619
    94 06A8:061D    95 06A8:0621    96 06A8:0625    97 06A8:0629
    98 06A8:062D    99 06A8:0631   100 06A8:0635   101 06A8:0639
   102 06A8:063D   103 06A8:0641   104 06A8:0646   105 06A8:064B
   106 06A8:0650   107 06A8:0655   108 06A8:065A   109 06A8:065F
   110 06A8:0664   111 06A8:0669   112 06A8:066E   113 06A8:0673
   114 06A8:0678   115 06A8:067D   116 06A8:0682   117 06A8:0687
   118 06A8:068C   120 06A8:0691   121 06A8:0693   122 06A8:0695
   123 06A8:0697   124 06A8:0699   125 06A8:069B   126 06A8:069D
   127 06A8:069F   128 06A8:06A1   129 06A8:06A3   130 06A8:06A5
   131 06A8:06A7   132 06A8:06A9   133 06A8:06AC   134 06A8:06AF
   135 06A8:06B1   136 06A8:06B3   137 06A8:06B6   138 06A8:06B9
   139 06A8:06BC   140 06A8:06BF   141 06A8:06C2   142 06A8:06C5
   143 06A8:06C8   144 06A8:06CB   145 06A8:06CE   146 06A8:06D1
   147 06A8:06D4   148 06A8:06D7   149 06A8:06DA   150 06A8:06DD
   151 06A8:06E0   152 06A8:06E3   153 06A8:06E7   154 06A8:06EB
   155 06A8:06EF   156 06A8:06F3   157 06A8:06F7   158 06A8:06FB
   159 06A8:06FF   160 06A8:0703   161 06A8:0707   162 06A8:070B
   163 06A8:070F   164 06A8:0713   165 06A8:0717   166 06A8:071B
   167 06A8:071F   169 06A8:0723   170 06A8:0726   171 06A8:0729
   172 06A8:072C   173 06A8:072F   174 06A8:0732   175 06A8:0735
   176 06A8:0738   177 06A8:073B   178 06A8:073E   179 06A8:0741
   180 06A8:0744   181 06A8:0747   182 06A8:074B   183 06A8:074F
   184 06A8:0752   185 06A8:0755   186 06A8:0759   187 06A8:075D
   188 06A8:0761   189 06A8:0765   190 06A8:0769   191 06A8:076D
   192 06A8:0771   193 06A8:0775   194 06A8:0779   195 06A8:077D
   196 06A8:0781   197 06A8:0785   198 06A8:0789   199 06A8:078D
   200 06A8:0791   201 06A8:0795   202 06A8:079A   203 06A8:079F
   204 06A8:07A4   205 06A8:07A9   206 06A8:07AE   207 06A8:07B3
   208 06A8:07B8   209 06A8:07BD   210 06A8:07C2   211 06A8:07C7
   212 06A8:07CC   213 06A8:07D1   214 06A8:07D6   215 06A8:07DB
   216 06A8:07E0   218 06A8:07E5   219 06A8:07E7   220 06A8:07E9
   221 06A8:07EB   222 06A8:07ED   223 06A8:07EF   224 06A8:07F1
   225 06A8:07F3   226 06A8:07F5   227 06A8:07F7   228 06A8:07F9
   229 06A8:07FB   230 06A8:07FD   231 06A8:0801   232 06A8:0805
   233 06A8:0807   234 06A8:0809   235 06A8:080C   236 06A8:080F
   237 06A8:0812   238 06A8:0815   239 06A8:0818   240 06A8:081B
   241 06A8:081E   242 06A8:0821   243 06A8:0824   244 06A8:0827
   245 06A8:082A   246 06A8:082D   247 06A8:0830   248 06A8:0833
   249 06A8:0836   250 06A8:0839   251 06A8:083D   252 06A8:0841
   253 06A8:0845   254 06A8:0849   255 06A8:084D   256 06A8:0851
   257 06A8:0855   258 06A8:0859   259 06A8:085D   260 06A8:0861
   261 06A8:0865   262 06A8:0869   263 06A8:086D   264 06A8:0871
   265 06A8:0875   267 06A8:0879   268 06A8:087C   269 06A8:087F
   270 06A8:0882   271 06A8:0885   272 06A8:0888   273 06A8:088B
   274 06A8:088E   275 06A8:0891   276 06A8:0894   277 06A8:0897
   278 06A8:089A   279 06A8:089D   280 06A8:08A2   281 06A8:08A7
   282 06A8:08AA   283 06A8:08AD   284 06A8:08B1   285 06A8:08B5
   286 06A8:08B9   287 06A8:08BD   288 06A8:08C1   289 06A8:08C5
   290 06A8:08C9   291 06A8:08CD   292 06A8:08D1   293 06A8:08D5
   294 06A8:08D9   295 06A8:08DD   296 06A8:08E1   297 06A8:08E5
   298 06A8:08E9   299 06A8:08ED   300 06A8:08F2   301 06A8:08F7
   302 06A8:08FC   303 06A8:0901   304 06A8:0906   305 06A8:090B
   306 06A8:0910   307 06A8:0915   308 06A8:091A   309 06A8:091F
   310 06A8:0924   311 06A8:0929   312 06A8:092E   313 06A8:0933
   314 06A8:0938   316 06A8:093D   317 06A8:093F   318 06A8:0941
   319 06A8:0943   320 06A8:0945   321 06A8:0947   322 06A8:0949
   323 06A8:094B   324 06A8:094D   325 06A8:094F   326 06A8:0951
   327 06A8:0953   328 06A8:0955   329 06A8:0959   330 06A8:095D
   331 06A8:095F   332 06A8:0961   333 06A8:0964   334 06A8:0967
   335 06A8:096A   336 06A8:096D   337 06A8:0970   338 06A8:0973
   339 06A8:0976   340 06A8:0979   341 06A8:097C   342 06A8:097F
   343 06A8:0982   344 06A8:0985   345 06A8:0988   346 06A8:098B
   347 06A8:098E   348 06A8:0991   349 06A8:0995   350 06A8:0999
   351 06A8:099D   352 06A8:09A1   353 06A8:09A5   354 06A8:09A9
   355 06A8:09AD   356 06A8:09B1   357 06A8:09B5   358 06A8:09B9
   359 06A8:09BD   360 06A8:09C1   361 06A8:09C5   362 06A8:09C9
   363 06A8:09CD   365 06A8:09D1   366 06A8:09D4   367 06A8:09D7
   368 06A8:09DA   369 06A8:09DD   370 06A8:09E0   371 06A8:09E3
   372 06A8:09E6   373 06A8:09E9   374 06A8:09EC   375 06A8:09EF
   376 06A8:09F2   377 06A8:09F5   378 06A8:09FA   379 06A8:09FF
   380 06A8:0A02   381 06A8:0A05   382 06A8:0A09   383 06A8:0A0D
   384 06A8:0A11   385 06A8:0A15   386 06A8:0A19   387 06A8:0A1D
   388 06A8:0A21   389 06A8:0A25   390 06A8:0A29   391 06A8:0A2D
   392 06A8:0A31   393 06A8:0A35   394 06A8:0A39   395 06A8:0A3D
   396 06A8:0A41   397 06A8:0A45   398 06A8:0A4A   399 06A8:0A4F
   400 06A8:0A54   401 06A8:0A59   402 06A8:0A5E   403 06A8:0A63
   404 06A8:0A68   405 06A8:0A6D   406 06A8:0A72   407 06A8:0A77
   408 06A8:0A7C   409 06A8:0A81   410 06A8:0A86   411 06A8:0A8B
   412 06A8:0A90   415 06A8:0A95   417 06A8:0A96   419 06A8:0A9B
   420 06A8:0AA6

Line numbers for btsuites(_3DGAMES.INC) segment btsuites

     2 06A8:0AB0     4 06A8:0AB6     6 06A8:0AC2   107 06A8:0AD4
   111 06A8:0AD9   112 06A8:0ADC   113 06A8:0ADE   114 06A8:0AE0
   115 06A8:0AE2   116 06A8:0AE5   117 06A8:0AE8   120 06A8:0AEC
   121 06A8:0AF0   122 06A8:0AF4   123 06A8:0AF8   124 06A8:0AFA
   125 06A8:0AFC   126 06A8:0AFE   127 06A8:0B00   128 06A8:0B02
   129 06A8:0B06   130 06A8:0B0A   131 06A8:0B0D   132 06A8:0B10
   133 06A8:0B12   134 06A8:0B14   135 06A8:0B18   136 06A8:0B1C
   137 06A8:0B1E   138 06A8:0B20   139 06A8:0B22   140 06A8:0B26
   141 06A8:0B2A   142 06A8:0B2E   143 06A8:0B32   144 06A8:0B36
   145 06A8:0B38   146 06A8:0B3A   147 06A8:0B3C   148 06A8:0B3E
   149 06A8:0B44   150 06A8:0B46   151 06A8:0B48   152 06A8:0B4C
   153 06A8:0B50   154 06A8:0B52   155 06A8:0B54   156 06A8:0B57
   157 06A8:0B5A   158 06A8:0B5D   159 06A8:0B60   160 06A8:0B65
   161 06A8:0B68   162 06A8:0B6B   163 06A8:0B6E   164 06A8:0B71
   165 06A8:0B75   166 06A8:0B79   167 06A8:0B7D   168 06A8:0B81
   169 06A8:0B85   170 06A8:0B87   171 06A8:0B89   172 06A8:0B8B
   173 06A8:0B8C   174 06A8:0B8D   175 06A8:0B8E   176 06A8:0B92
   177 06A8:0B94   178 06A8:0B95   179 06A8:0B96   180 06A8:0B97
   181 06A8:0B98   182 06A8:0B9A   183 06A8:0B9C   184 06A8:0BA0
   185 06A8:0BA2   186 06A8:0BA4   187 06A8:0BA6   188 06A8:0BA8
   189 06A8:0BAC   190 06A8:0BAE   191 06A8:0BB0   192 06A8:0BB4
   195 06A8:0BB6   196 06A8:0BBA   197 06A8:0BBC   201 06A8:0BC0
   202 06A8:0BC1   203 06A8:0BC3   205 06A8:0BC4   206 06A8:0BC6
   209 06A8:0BC7   210 06A8:0BC9   211 06A8:0BCB   214 06A8:0BCC
   215 06A8:0BCE   216 06A8:0BD0   218 06A8:0BD1   219 06A8:0BD6
   220 06A8:0BD8   222 06A8:0BD9   223 06A8:0BDB   224 06A8:0BDD
   226 06A8:0BDE   227 06A8:0BE0   229 06A8:0BE1   230 06A8:0BE3
   232 06A8:0BE4   233 06A8:0BE6   235 06A8:0BE7   236 06A8:0BE9
   238 06A8:0BEA   239 06A8:0BEC   241 06A8:0BED   242 06A8:0BEF
   244 06A8:0BF0   245 06A8:0BF2   247 06A8:0BF3   248 06A8:0BF5
   250 06A8:0BF6   251 06A8:0BF8   253 06A8:0BF9   254 06A8:0BFB
   257 06A8:0BFC   258 06A8:0BFE   260 06A8:0C01   261 06A8:0C03
   263 06A8:0C04   264 06A8:0C06   266 06A8:0C07   267 06A8:0C09
   269 06A8:0C0A   270 06A8:0C0C   272 06A8:0C0D   273 06A8:0C0F
   275 06A8:0C10   276 06A8:0C12   278 06A8:0C13   279 06A8:0C15
   281 06A8:0C16   282 06A8:0C18   284 06A8:0C19   285 06A8:0C1B
   287 06A8:0C1C   288 06A8:0C1E   290 06A8:0C1F   291 06A8:0C21
   294 06A8:0C22   295 06A8:0C24   296 06A8:0C26   298 06A8:0C28
   299 06A8:0C2A   301 06A8:0C2B   302 06A8:0C2D   304 06A8:0C2E
   305 06A8:0C30   307 06A8:0C31   308 06A8:0C33   310 06A8:0C34
   311 06A8:0C36   313 06A8:0C37   314 06A8:0C39   316 06A8:0C3A
   317 06A8:0C3C   319 06A8:0C3D   320 06A8:0C3F   322 06A8:0C40
   323 06A8:0C42   325 06A8:0C43   326 06A8:0C45   328 06A8:0C46
   329 06A8:0C48   332 06A8:0C49   333 06A8:0C4B   335 06A8:0C4C
   336 06A8:0C4E   338 06A8:0C4F   339 06A8:0C51   341 06A8:0C52
   342 06A8:0C54   344 06A8:0C55   345 06A8:0C57   347 06A8:0C58
   348 06A8:0C5A   351 06A8:0C5B   352 06A8:0C5C   353 06A8:0C5E
   355 06A8:0C5F   356 06A8:0C61   358 06A8:0C62   359 06A8:0C64
   362 06A8:0C65   363 06A8:0C68   364 06A8:0C6A   365 06A8:0C6E
   367 06A8:0C6F   368 06A8:0C73   369 06A8:0C75   371 06A8:0C76
   372 06A8:0C7A   373 06A8:0C7C   375 06A8:0C7D   376 06A8:0C81
   377 06A8:0C83   379 06A8:0C84   380 06A8:0C88   381 06A8:0C8A
   383 06A8:0C8B   384 06A8:0C8D   385 06A8:0C8F   387 06A8:0C90
   388 06A8:0C94   389 06A8:0C96   391 06A8:0C97   392 06A8:0C99
   393 06A8:0C9B   395 06A8:0C9C   396 06A8:0CA0   397 06A8:0CA2
   399 06A8:0CA3   400 06A8:0CA5   401 06A8:0CA7   405 06A8:0CA8
   406 06A8:0CAB   408 06A8:0CAD   409 06A8:0CAE   411 06A8:0CB0
   413 06A8:0CB2   414 06A8:0CB3   416 06A8:0CB5   418 06A8:0CB7
   419 06A8:0CB8   421 06A8:0CBA   423 06A8:0CBC   424 06A8:0CBD
   426 06A8:0CBF   427 06A8:0CC3   428 06A8:0CC7   429 06A8:0CCB
   430 06A8:0CCF   431 06A8:0CD3   432 06A8:0CD5   433 06A8:0CD8
   434 06A8:0CDB   435 06A8:0CDE   436 06A8:0CE1   437 06A8:0CE4
   438 06A8:0CE8   439 06A8:0CEC   440 06A8:0CF0   441 06A8:0CF4
   442 06A8:0CF8   443 06A8:0CFC   444 06A8:0D00   445 06A8:0D04
   446 06A8:0D08   447 06A8:0D0C   448 06A8:0D10   449 06A8:0D13
   450 06A8:0D16   451 06A8:0D19   452 06A8:0D1C   453 06A8:0D1F
   454 06A8:0D22   455 06A8:0D25   456 06A8:0D27   457 06A8:0D2B
   458 06A8:0D2F   459 06A8:0D32   460 06A8:0D34   461 06A8:0D36
   462 06A8:0D38   463 06A8:0D3A   464 06A8:0D3C   465 06A8:0D3E
   466 06A8:0D43   467 06A8:0D47   468 06A8:0D4B   469 06A8:0D4E
   470 06A8:0D50   471 06A8:0D52   472 06A8:0D55   473 06A8:0D59
   474 06A8:0D5D   475 06A8:0D61   476 06A8:0D65   477 06A8:0D67
   478 06A8:0D6B   479 06A8:0D6F   480 06A8:0D73   481 06A8:0D77
   482 06A8:0D7B   483 06A8:0D7F   484 06A8:0D83   485 06A8:0D87
   486 06A8:0D8B   487 06A8:0D8F   488 06A8:0D93   489 06A8:0D95
   490 06A8:0D97   491 06A8:0D99   492 06A8:0D9B   493 06A8:0D9D
   494 06A8:0D9F   495 06A8:0DA1   496 06A8:0DA3   497 06A8:0DA5
   498 06A8:0DA7   499 06A8:0DA9   500 06A8:0DAB   501 06A8:0DAD
   502 06A8:0DB0   503 06A8:0DB3   504 06A8:0DB6   505 06A8:0DB9
   506 06A8:0DBB   507 06A8:0DBD   508 06A8:0DBF   509 06A8:0DC1
   510 06A8:0DC3   511 06A8:0DC5   512 06A8:0DC7   513 06A8:0DC9
   514 06A8:0DCB   515 06A8:0DCD   516 06A8:0DCF   517 06A8:0DD1
   518 06A8:0DD3   519 06A8:0DD5   520 06A8:0DD7   521 06A8:0DD9
   522 06A8:0DDE   523 06A8:0DE0   524 06A8:0DE2   525 06A8:0DE4
   526 06A8:0DE6   527 06A8:0DE8   528 06A8:0DEA   529 06A8:0DEF
   530 06A8:0DF4   531 06A8:0DF8   533 06A8:0DFD   535 06A8:0DFE
   536 06A8:0E00   537 06A8:0E01   538 06A8:0E03   539 06A8:0E05
   540 06A8:0E07   541 06A8:0E09   542 06A8:0E0B   544 06A8:0E0D
   545 06A8:0E0F   546 06A8:0E12   547 06A8:0E15   548 06A8:0E17
   549 06A8:0E19   550 06A8:0E1B   551 06A8:0E1D   552 06A8:0E1F
   553 06A8:0E21   554 06A8:0E23   559 06A8:0E25   560 06A8:0E26
   561 06A8:0E28   563 06A8:0E29   564 06A8:0E2A   565 06A8:0E2C
   567 06A8:0E2D   568 06A8:0E2E   569 06A8:0E30   571 06A8:0E31
   572 06A8:0E32   573 06A8:0E34   575 06A8:0E35   576 06A8:0E36
   577 06A8:0E38   579 06A8:0E39   580 06A8:0E3A   581 06A8:0E3C
   583 06A8:0E3D   584 06A8:0E3E   585 06A8:0E40   587 06A8:0E41
   588 06A8:0E42   589 06A8:0E44   591 06A8:0E45   592 06A8:0E46
   593 06A8:0E48   595 06A8:0E49   596 06A8:0E4A   597 06A8:0E4C
   598 06A8:0E4D   600 06A8:0E4F   601 06A8:0E50   602 06A8:0E52
   604 06A8:0E53   605 06A8:0E54   606 06A8:0E56   608 06A8:0E58
   609 06A8:0E5A   611 06A8:0E5B   612 06A8:0E5D   613 06A8:0E5F
   614 06A8:0E61   615 06A8:0E63   616 06A8:0E65   617 06A8:0E67
   618 06A8:0E69   619 06A8:0E6B   620 06A8:0E6D   621 06A8:0E6F
   622 06A8:0E71   623 06A8:0E73   624 06A8:0E75   625 06A8:0E77
   626 06A8:0E79   627 06A8:0E7B   628 06A8:0E7D   629 06A8:0E7F
   630 06A8:0E81   631 06A8:0E83   632 06A8:0E85   633 06A8:0E87
   634 06A8:0E89   635 06A8:0E8B   636 06A8:0E8D   637 06A8:0E8F
   638 06A8:0E91   639 06A8:0E93   640 06A8:0E95   641 06A8:0E97
   642 06A8:0E99   643 06A8:0E9B   644 06A8:0E9D   645 06A8:0E9F
   646 06A8:0EA1   647 06A8:0EA3   648 06A8:0EA7   649 06A8:0EA8
   650 06A8:0EA9   651 06A8:0EAA   652 06A8:0EAB   653 06A8:0EAC
   654 06A8:0EAD   655 06A8:0EB1   656 06A8:0EB5   657 06A8:0EB7
   658 06A8:0EBB   659 06A8:0EBF   660 06A8:0EC3   662 06A8:0EC5
   663 06A8:0EC7   664 06A8:0EC9   665 06A8:0ECB   666 06A8:0ECD
   667 06A8:0ECF   668 06A8:0ED1   669 06A8:0ED3   670 06A8:0ED5
   671 06A8:0EDA   672 06A8:0EDD   673 06A8:0EDF   674 06A8:0EE3
   675 06A8:0EE5   676 06A8:0EE7   677 06A8:0EE9   679 06A8:0EEB
   681 06A8:0EF0   682 06A8:0EFB

Line numbers for btsuites(_RUNALL.INC) segment btsuites

     5 06A8:0F05     6 06A8:0F08     8 06A8:0F13    10 06A8:0F1F
    16 06A8:0F31    25 06A8:0F33    26 06A8:0F34    27 06A8:0F36
    28 06A8:0F3A    29 06A8:0F3D    30 06A8:0F3F    31 06A8:0F41
    32 06A8:0F44    34 06A8:0F46    35 06A8:0F4A    36 06A8:0F4E
    37 06A8:0F51    38 06A8:0F53    39 06A8:0F55    40 06A8:0F58
    42 06A8:0F5A    43 06A8:0F5E    44 06A8:0F62    46 06A8:0F68
    47 06A8:0F6B    48 06A8:0F6D    50 06A8:0F6F    51 06A8:0F73
    52 06A8:0F76    54 06A8:0F78    55 06A8:0F7C    56 06A8:0F7F
    57 06A8:0F81    59 06A8:0F83    72 06A8:0F85    73 06A8:0F89
    74 06A8:0F8B    75 06A8:0F8D    76 06A8:0F8E    77 06A8:0F90
    78 06A8:0F92    80 06A8:0F94    81 06A8:0F96    82 06A8:0F98
    83 06A8:0F9A    84 06A8:0F9C    85 06A8:0F9E    86 06A8:0FA0
    87 06A8:0FA2    88 06A8:0FA4    89 06A8:0FA6    90 06A8:0FA8
    91 06A8:0FAA    92 06A8:0FAC    93 06A8:0FAF    94 06A8:0FB2
    95 06A8:0FB4    96 06A8:0FB6    97 06A8:0FB9    98 06A8:0FBC
    99 06A8:0FBF   100 06A8:0FC2   101 06A8:0FC5   102 06A8:0FC8
   103 06A8:0FCB   104 06A8:0FCE   105 06A8:0FD1   106 06A8:0FD4
   107 06A8:0FD7   108 06A8:0FDA   109 06A8:0FDD   110 06A8:0FE0
   111 06A8:0FE3   112 06A8:0FE6   113 06A8:0FEA   114 06A8:0FEE
   115 06A8:0FF2   116 06A8:0FF6   117 06A8:0FFA   118 06A8:0FFE
   119 06A8:1002   120 06A8:1006   121 06A8:100A   122 06A8:100E
   123 06A8:1012   124 06A8:1016   125 06A8:101A   126 06A8:101E
   127 06A8:1022   129 06A8:1026   130 06A8:1029   131 06A8:102C
   132 06A8:102F   133 06A8:1032   134 06A8:1035   135 06A8:1038
   136 06A8:103B   137 06A8:103E   138 06A8:1041   139 06A8:1044
   140 06A8:1047   141 06A8:104A   142 06A8:104E   143 06A8:1052
   144 06A8:1055   145 06A8:1058   146 06A8:105C   147 06A8:1060
   148 06A8:1064   149 06A8:1068   150 06A8:106C   151 06A8:1070
   152 06A8:1074   153 06A8:1078   154 06A8:107C   155 06A8:1080
   156 06A8:1084   157 06A8:1088   158 06A8:108C   159 06A8:1090
   160 06A8:1094   161 06A8:1098   162 06A8:109D   163 06A8:10A2
   164 06A8:10A7   165 06A8:10AC   166 06A8:10B1   167 06A8:10B6
   168 06A8:10BB   169 06A8:10C0   170 06A8:10C5   171 06A8:10CA
   172 06A8:10CF   173 06A8:10D4   174 06A8:10D9   175 06A8:10DE
   176 06A8:10E3   178 06A8:10E8   179 06A8:10EA   180 06A8:10EC
   181 06A8:10EE   182 06A8:10F0   183 06A8:10F2   184 06A8:10F4
   185 06A8:10F6   186 06A8:10F8   187 06A8:10FA   188 06A8:10FC
   189 06A8:10FE   190 06A8:1100   191 06A8:1103   192 06A8:1106
   193 06A8:1108   194 06A8:110A   195 06A8:110D   196 06A8:1110
   197 06A8:1113   198 06A8:1116   199 06A8:1119   200 06A8:111C
   201 06A8:111F   202 06A8:1122   203 06A8:1125   204 06A8:1128
   205 06A8:112B   206 06A8:112E   207 06A8:1131   208 06A8:1134
   209 06A8:1137   210 06A8:113A   211 06A8:113E   212 06A8:1142
   213 06A8:1146   214 06A8:114A   215 06A8:114E   216 06A8:1152
   217 06A8:1156   218 06A8:115A   219 06A8:115E   220 06A8:1162
   221 06A8:1166   222 06A8:116A   223 06A8:116E   224 06A8:1172
   225 06A8:1176   227 06A8:117A   228 06A8:117D   229 06A8:1180
   230 06A8:1183   231 06A8:1186   232 06A8:1189   233 06A8:118C
   234 06A8:118F   235 06A8:1192   236 06A8:1195   237 06A8:1198
   238 06A8:119B   239 06A8:119E   240 06A8:11A2   241 06A8:11A6
   242 06A8:11A9   243 06A8:11AC   244 06A8:11B0   245 06A8:11B4
   246 06A8:11B8   247 06A8:11BC   248 06A8:11C0   249 06A8:11C4
   250 06A8:11C8   251 06A8:11CC   252 06A8:11D0   253 06A8:11D4
   254 06A8:11D8   255 06A8:11DC   256 06A8:11E0   257 06A8:11E4
   258 06A8:11E8   259 06A8:11EC   260 06A8:11F1   261 06A8:11F6
   262 06A8:11FB   263 06A8:1200   264 06A8:1205   265 06A8:120A
   266 06A8:120F   267 06A8:1214   268 06A8:1219   269 06A8:121E
   270 06A8:1223   271 06A8:1228   272 06A8:122D   273 06A8:1232
   274 06A8:1237   276 06A8:123C   277 06A8:123E   278 06A8:1240
   279 06A8:1242   280 06A8:1244   281 06A8:1246   282 06A8:1248
   283 06A8:124A   284 06A8:124C   285 06A8:124E   286 06A8:1250
   287 06A8:1252   288 06A8:1254   289 06A8:1258   290 06A8:125C
   291 06A8:125E   292 06A8:1260   293 06A8:1263   294 06A8:1266
   295 06A8:1269   296 06A8:126C   297 06A8:126F   298 06A8:1272
   299 06A8:1275   300 06A8:1278   301 06A8:127B   302 06A8:127E
   303 06A8:1281   304 06A8:1284   305 06A8:1287   306 06A8:128A
   307 06A8:128D   308 06A8:1290   309 06A8:1294   310 06A8:1298
   311 06A8:129C   312 06A8:12A0   313 06A8:12A4   314 06A8:12A8
   315 06A8:12AC   316 06A8:12B0   317 06A8:12B4   318 06A8:12B8
   319 06A8:12BC   320 06A8:12C0   321 06A8:12C4   322 06A8:12C8
   323 06A8:12CC   325 06A8:12D0   326 06A8:12D3   327 06A8:12D6
   328 06A8:12D9   329 06A8:12DC   330 06A8:12DF   331 06A8:12E2
   332 06A8:12E5   333 06A8:12E8   334 06A8:12EB   335 06A8:12EE
   336 06A8:12F1   337 06A8:12F4   338 06A8:12F9   339 06A8:12FE
   340 06A8:1301   341 06A8:1304   342 06A8:1308   343 06A8:130C
   344 06A8:1310   345 06A8:1314   346 06A8:1318   347 06A8:131C
   348 06A8:1320   349 06A8:1324   350 06A8:1328   351 06A8:132C
   352 06A8:1330   353 06A8:1334   354 06A8:1338   355 06A8:133C
   356 06A8:1340   357 06A8:1344   358 06A8:1349   359 06A8:134E
   360 06A8:1353   361 06A8:1358   362 06A8:135D   363 06A8:1362
   364 06A8:1367   365 06A8:136C   366 06A8:1371   367 06A8:1376
   368 06A8:137B   369 06A8:1380   370 06A8:1385   371 06A8:138A
   372 06A8:138F   374 06A8:1394   375 06A8:1396   376 06A8:1398
   377 06A8:139A   378 06A8:139C   379 06A8:139E   380 06A8:13A0
   381 06A8:13A2   382 06A8:13A4   383 06A8:13A6   384 06A8:13A8
   385 06A8:13AA   386 06A8:13AC   387 06A8:13B0   388 06A8:13B4
   389 06A8:13B6   390 06A8:13B8   391 06A8:13BB   392 06A8:13BE
   393 06A8:13C1   394 06A8:13C4   395 06A8:13C7   396 06A8:13CA
   397 06A8:13CD   398 06A8:13D0   399 06A8:13D3   400 06A8:13D6
   401 06A8:13D9   402 06A8:13DC   403 06A8:13DF   404 06A8:13E2
   405 06A8:13E5   406 06A8:13E8   407 06A8:13EC   408 06A8:13F0
   409 06A8:13F4   410 06A8:13F8   411 06A8:13FC   412 06A8:1400
   413 06A8:1404   414 06A8:1408   415 06A8:140C   416 06A8:1410
   417 06A8:1414   418 06A8:1418   419 06A8:141C   420 06A8:1420
   421 06A8:1424   423 06A8:1428   424 06A8:142B   425 06A8:142E
   426 06A8:1431   427 06A8:1434   428 06A8:1437   429 06A8:143A
   430 06A8:143D   431 06A8:1440   432 06A8:1443   433 06A8:1446
   434 06A8:1449   435 06A8:144C   436 06A8:1451   437 06A8:1456
   438 06A8:1459   439 06A8:145C   440 06A8:1460   441 06A8:1464
   442 06A8:1468   443 06A8:146C   444 06A8:1470   445 06A8:1474
   446 06A8:1478   447 06A8:147C   448 06A8:1480   449 06A8:1484
   450 06A8:1488   451 06A8:148C   452 06A8:1490   453 06A8:1494
   454 06A8:1498   455 06A8:149C   456 06A8:14A1   457 06A8:14A6
   458 06A8:14AB   459 06A8:14B0   460 06A8:14B5   461 06A8:14BA
   462 06A8:14BF   463 06A8:14C4   464 06A8:14C9   465 06A8:14CE
   466 06A8:14D3   467 06A8:14D8   468 06A8:14DD   469 06A8:14E2
   470 06A8:14E7   473 06A8:14EC   499 06A8:14ED   500 06A8:14F0
   507 06A8:14F3   508 06A8:14F6   509 06A8:14FA   510 06A8:14FC
   511 06A8:14FF   512 06A8:1503   513 06A8:1507   514 06A8:150B
   515 06A8:150F   516 06A8:1513   517 06A8:1517   518 06A8:151B
   519 06A8:151F   520 06A8:1521   521 06A8:1523   522 06A8:1525
   524 06A8:1527   525 06A8:1528   527 06A8:1529   528 06A8:152C
   529 06A8:1530   530 06A8:1532   531 06A8:1535   532 06A8:1539
   533 06A8:153D   534 06A8:1541   535 06A8:1545   536 06A8:1549
   537 06A8:154D   538 06A8:1551   539 06A8:1555   540 06A8:1557
   541 06A8:1559   542 06A8:155B   544 06A8:155D   545 06A8:155E
   549 06A8:155F   550 06A8:1562   551 06A8:1566   552 06A8:1568
   553 06A8:156B   554 06A8:156F   555 06A8:1573   556 06A8:1577
   557 06A8:157B   558 06A8:157F   559 06A8:1583   560 06A8:1587
   561 06A8:158B   562 06A8:158D   563 06A8:158F   564 06A8:1591
   566 06A8:1593   567 06A8:1594   568 06A8:1596   569 06A8:1597
   570 06A8:1598   571 06A8:159A   573 06A8:159B   574 06A8:159E
   575 06A8:15A2   576 06A8:15A4   577 06A8:15A7   578 06A8:15AB
   579 06A8:15AF   580 06A8:15B3   581 06A8:15B7   582 06A8:15BB
   583 06A8:15BF   584 06A8:15C3   585 06A8:15C7   586 06A8:15C9
   587 06A8:15CB   588 06A8:15CD   590 06A8:15CF   591 06A8:15D0
   593 06A8:15D1   594 06A8:15D4   595 06A8:15D8   596 06A8:15DA
   597 06A8:15DD   598 06A8:15E1   599 06A8:15E5   600 06A8:15E9
   601 06A8:15ED   602 06A8:15F1   603 06A8:15F5   604 06A8:15F9
   605 06A8:15FD   606 06A8:15FF   607 06A8:1601   608 06A8:1603
   610 06A8:1605   612 06A8:1608   614 06A8:1609   615 06A8:160C
   616 06A8:1610   617 06A8:1612   618 06A8:1615   619 06A8:1619
   620 06A8:161D   621 06A8:1621   622 06A8:1625   623 06A8:1629
   624 06A8:162D   625 06A8:1631   626 06A8:1635   627 06A8:1637
   628 06A8:1639   629 06A8:163B   631 06A8:163D   633 06A8:1640
   635 06A8:1641   636 06A8:1644   637 06A8:1648   638 06A8:164A
   639 06A8:164D   640 06A8:1651   641 06A8:1655   642 06A8:1659
   643 06A8:165D   644 06A8:1661   645 06A8:1665   646 06A8:1669
   647 06A8:166D   648 06A8:166F   649 06A8:1671   650 06A8:1673
   652 06A8:1675   654 06A8:1678   656 06A8:1679   657 06A8:167C
   658 06A8:1680   659 06A8:1682   660 06A8:1685   661 06A8:1689
   662 06A8:168D   663 06A8:1691   664 06A8:1695   665 06A8:1699
   666 06A8:169D   667 06A8:16A1   668 06A8:16A5   669 06A8:16A7
   670 06A8:16A9   671 06A8:16AB   673 06A8:16AD   675 06A8:16AF
   677 06A8:16B0   678 06A8:16B1   679 06A8:16B2   680 06A8:16B3
   681 06A8:16B4   682 06A8:16B5   683 06A8:16B6   684 06A8:16B7
   685 06A8:16B8   686 06A8:16B9   687 06A8:16BA   688 06A8:16BB
   690 06A8:16BC   691 06A8:16BD   692 06A8:16BE   693 06A8:16BF
   694 06A8:16C0   695 06A8:16C1   696 06A8:16C2   698 06A8:16C3
   699 06A8:16C4   700 06A8:16C5   701 06A8:16C6   702 06A8:16C7
   703 06A8:16C8   704 06A8:16C9   705 06A8:16CA   706 06A8:16CB
   707 06A8:16CC   708 06A8:16CD   709 06A8:16CE   710 06A8:16CF
   711 06A8:16D0   716 06A8:16D1   717 06A8:16D3   718 06A8:16D4
   719 06A8:16D5   720 06A8:16D7   722 06A8:16D8   723 06A8:16D9
   724 06A8:16DB   725 06A8:16DC   726 06A8:16DE   727 06A8:16E1
   729 06A8:16E3   730 06A8:16E4   732 06A8:16E5   733 06A8:16E7
   735 06A8:16EA   736 06A8:16EB   740 06A8:16ED   741 06A8:16F0
   742 06A8:16F4   743 06A8:16F6   744 06A8:16F9   745 06A8:16FD
   746 06A8:1701   747 06A8:1705   748 06A8:1709   749 06A8:170D
   750 06A8:1711   751 06A8:1715   752 06A8:1719   753 06A8:171B
   754 06A8:171D   755 06A8:171F   757 06A8:1721   760 06A8:1725
   762 06A8:1729   764 06A8:172D   766 06A8:172E   767 06A8:1732
   768 06A8:1736   769 06A8:173A   770 06A8:173E   771 06A8:1742
   772 06A8:1746   773 06A8:174A   774 06A8:174E   775 06A8:174F
   776 06A8:1750   777 06A8:1752   779 06A8:1754   782 06A8:1755
   783 06A8:1758   785 06A8:175D   786 06A8:175E   787 06A8:175F
   788 06A8:1760   789 06A8:1761   791 06A8:1762   792 06A8:1763
   793 06A8:1764   794 06A8:1766   795 06A8:1767   796 06A8:1768
   797 06A8:1769   798 06A8:176A   799 06A8:176B   800 06A8:176C
   801 06A8:176D   802 06A8:176E   803 06A8:176F   804 06A8:1770
   805 06A8:1771   807 06A8:1772   808 06A8:1773   809 06A8:1774
   810 06A8:1775   811 06A8:1776   812 06A8:1777   813 06A8:1778
   814 06A8:1779   817 06A8:177A   818 06A8:177C   819 06A8:177E
   820 06A8:1780   821 06A8:1782   822 06A8:1784   823 06A8:1786
   824 06A8:1788   825 06A8:178A   826 06A8:178D   827 06A8:1790
   828 06A8:1793   830 06A8:1796   831 06A8:1797   832 06A8:1798
   833 06A8:179A   834 06A8:179D   835 06A8:179F   836 06A8:17A1
   837 06A8:17A4   838 06A8:17A6   839 06A8:17A7   840 06A8:17AA
   842 06A8:17AD   843 06A8:17B1   844 06A8:17B2   845 06A8:17B3
   846 06A8:17B4   847 06A8:17B8   848 06A8:17B9   850 06A8:17BA
   851 06A8:17BD   852 06A8:17BF   853 06A8:17C3   854 06A8:17C5
   855 06A8:17C9   856 06A8:17CB   857 06A8:17CF   858 06A8:17D1
   859 06A8:17D5   860 06A8:17D7   861 06A8:17DB   862 06A8:17DD
   863 06A8:17E1   864 06A8:17E3   865 06A8:17E7   866 06A8:17E9
   867 06A8:17ED   868 06A8:17EF   869 06A8:17F3   870 06A8:17F5
   871 06A8:17F9   872 06A8:17FB   873 06A8:17FF   874 06A8:1801
   875 06A8:1805   876 06A8:1807   877 06A8:180B   878 06A8:180D
   879 06A8:1811   880 06A8:1813   881 06A8:1817   882 06A8:1819
   886 06A8:181D   887 06A8:181F   888 06A8:1821   889 06A8:1825
   890 06A8:1827   891 06A8:182B   892 06A8:182D   893 06A8:1831
   894 06A8:1833   895 06A8:1837   896 06A8:1839   897 06A8:183D
   898 06A8:183F   899 06A8:1843   900 06A8:1845   901 06A8:1849
   902 06A8:184B   903 06A8:184F   904 06A8:1851   905 06A8:1855
   906 06A8:1857   907 06A8:185B   908 06A8:185D   909 06A8:1861
   910 06A8:1863   911 06A8:1867   912 06A8:1869   913 06A8:186D
   914 06A8:186F   915 06A8:1873   916 06A8:1875   917 06A8:1879
   918 06A8:187B   920 06A8:187F   921 06A8:1881   922 06A8:1883
   924 06A8:1884   925 06A8:1887   927 06A8:188A   929 06A8:188B
   930 06A8:188D   931 06A8:188F   932 06A8:1891   935 06A8:1893
   936 06A8:1896   937 06A8:1898   938 06A8:189B   939 06A8:189D
   940 06A8:189F   942 06A8:18A1   943 06A8:18A2   944 06A8:18A3
   945 06A8:18A4   947 06A8:18A5   948 06A8:18A6   954 06A8:18A7
   970 06A8:18A9   971 06A8:18AA   982 06A8:18AF   983 06A8:18B2
   984 06A8:18B5   985 06A8:18B7   986 06A8:18B9   987 06A8:18BC
   988 06A8:18C0   989 06A8:18C3   990 06A8:18C7   991 06A8:18CA
   992 06A8:18CE   993 06A8:18D1   994 06A8:18D5   995 06A8:18D7
   996 06A8:18D9   997 06A8:18DB   999 06A8:18DD  1000 06A8:18E0
  1001 06A8:18E3  1002 06A8:18E6  1004 06A8:18E8  1006 06A8:18EC
  1007 06A8:18EE  1112 06A8:18F0  1113 06A8:18F3  1114 06A8:18F5
  1115 06A8:18F7  1116 06A8:18F9  1117 06A8:18FC  1118 06A8:18FF
  1121 06A8:1903  1122 06A8:1907  1123 06A8:190B  1124 06A8:190F
  1125 06A8:1911  1126 06A8:1913  1127 06A8:1915  1128 06A8:1917
  1129 06A8:1919  1130 06A8:191D  1131 06A8:1921  1132 06A8:1924
  1133 06A8:1927  1134 06A8:1929  1135 06A8:192B  1136 06A8:192F
  1137 06A8:1933  1138 06A8:1935  1139 06A8:1937  1140 06A8:1939
  1141 06A8:193D  1142 06A8:1941  1143 06A8:1945  1144 06A8:1949
  1145 06A8:194D  1146 06A8:194F  1147 06A8:1951  1148 06A8:1953
  1149 06A8:1955  1150 06A8:195B  1151 06A8:195D  1152 06A8:195F
  1153 06A8:1963  1154 06A8:1967  1155 06A8:1969  1156 06A8:196B
  1157 06A8:196E  1158 06A8:1971  1159 06A8:1974  1160 06A8:1977
  1161 06A8:197C  1162 06A8:197F  1163 06A8:1982  1164 06A8:1985
  1165 06A8:1988  1166 06A8:198C  1167 06A8:1990  1168 06A8:1994
  1169 06A8:1998  1170 06A8:199C  1171 06A8:199E  1172 06A8:19A0
  1173 06A8:19A2  1174 06A8:19A3  1175 06A8:19A4  1176 06A8:19A5
  1177 06A8:19A9  1178 06A8:19AB  1179 06A8:19AC  1180 06A8:19AD
  1181 06A8:19AE  1182 06A8:19AF  1183 06A8:19B1  1184 06A8:19B3
  1185 06A8:19B7  1186 06A8:19B9  1187 06A8:19BB  1188 06A8:19BD
  1189 06A8:19BF  1190 06A8:19C3  1191 06A8:19C5  1192 06A8:19C7
  1193 06A8:19CB  1196 06A8:19CD  1197 06A8:19D1  1198 06A8:19D3
  1202 06A8:19D7  1203 06A8:19D8  1204 06A8:19DA  1206 06A8:19DB
  1207 06A8:19DD  1210 06A8:19DE  1211 06A8:19E0  1212 06A8:19E2
  1215 06A8:19E3  1216 06A8:19E5  1217 06A8:19E7  1219 06A8:19E8
  1220 06A8:19ED  1221 06A8:19EF  1223 06A8:19F0  1224 06A8:19F2
  1225 06A8:19F4  1227 06A8:19F5  1228 06A8:19F7  1230 06A8:19F8
  1231 06A8:19FA  1233 06A8:19FB  1234 06A8:19FD  1236 06A8:19FE
  1237 06A8:1A00  1239 06A8:1A01  1240 06A8:1A03  1242 06A8:1A04
  1243 06A8:1A06  1245 06A8:1A07  1246 06A8:1A09  1248 06A8:1A0A
  1249 06A8:1A0C  1251 06A8:1A0D  1252 06A8:1A0F  1254 06A8:1A10
  1255 06A8:1A12  1258 06A8:1A13  1259 06A8:1A15  1261 06A8:1A18
  1262 06A8:1A1A  1264 06A8:1A1B  1265 06A8:1A1D  1267 06A8:1A1E
  1268 06A8:1A20  1270 06A8:1A21  1271 06A8:1A23  1273 06A8:1A24
  1274 06A8:1A26  1276 06A8:1A27  1277 06A8:1A29  1279 06A8:1A2A
  1280 06A8:1A2C  1282 06A8:1A2D  1283 06A8:1A2F  1285 06A8:1A30
  1286 06A8:1A32  1288 06A8:1A33  1289 06A8:1A35  1291 06A8:1A36
  1292 06A8:1A38  1295 06A8:1A39  1296 06A8:1A3B  1297 06A8:1A3D
  1299 06A8:1A3F  1300 06A8:1A41  1302 06A8:1A42  1303 06A8:1A44
  1305 06A8:1A45  1306 06A8:1A47  1308 06A8:1A48  1309 06A8:1A4A
  1311 06A8:1A4B  1312 06A8:1A4D  1314 06A8:1A4E  1315 06A8:1A50
  1317 06A8:1A51  1318 06A8:1A53  1320 06A8:1A54  1321 06A8:1A56
  1323 06A8:1A57  1324 06A8:1A59  1326 06A8:1A5A  1327 06A8:1A5C
  1329 06A8:1A5D  1330 06A8:1A5F  1333 06A8:1A60  1334 06A8:1A62
  1336 06A8:1A63  1337 06A8:1A65  1339 06A8:1A66  1340 06A8:1A68
  1342 06A8:1A69  1343 06A8:1A6B  1345 06A8:1A6C  1346 06A8:1A6E
  1348 06A8:1A6F  1349 06A8:1A71  1352 06A8:1A72  1353 06A8:1A73
  1354 06A8:1A75  1356 06A8:1A76  1357 06A8:1A78  1359 06A8:1A79
  1360 06A8:1A7B  1363 06A8:1A7C  1364 06A8:1A7F  1365 06A8:1A81
  1366 06A8:1A85  1368 06A8:1A86  1369 06A8:1A8A  1370 06A8:1A8C
  1372 06A8:1A8D  1373 06A8:1A91  1374 06A8:1A93  1376 06A8:1A94
  1377 06A8:1A98  1378 06A8:1A9A  1380 06A8:1A9B  1381 06A8:1A9F
  1382 06A8:1AA1  1384 06A8:1AA2  1385 06A8:1AA4  1386 06A8:1AA6
  1388 06A8:1AA7  1389 06A8:1AAB  1390 06A8:1AAD  1392 06A8:1AAE
  1393 06A8:1AB0  1394 06A8:1AB2  1396 06A8:1AB3  1397 06A8:1AB7
  1398 06A8:1AB9  1400 06A8:1ABA  1401 06A8:1ABC  1402 06A8:1ABE
  1406 06A8:1ABF  1407 06A8:1AC2  1409 06A8:1AC4  1410 06A8:1AC5
  1412 06A8:1AC7  1414 06A8:1AC9  1415 06A8:1ACA  1417 06A8:1ACC
  1419 06A8:1ACE  1420 06A8:1ACF  1422 06A8:1AD1  1424 06A8:1AD3
  1425 06A8:1AD4  1427 06A8:1AD6  1428 06A8:1ADA  1429 06A8:1ADE
  1430 06A8:1AE2  1431 06A8:1AE6  1432 06A8:1AEA  1433 06A8:1AEC
  1434 06A8:1AEF  1435 06A8:1AF2  1436 06A8:1AF5  1437 06A8:1AF8
  1438 06A8:1AFB  1439 06A8:1AFF  1440 06A8:1B03  1441 06A8:1B07
  1442 06A8:1B0B  1443 06A8:1B0F  1444 06A8:1B13  1445 06A8:1B17
  1446 06A8:1B1B  1447 06A8:1B1F  1448 06A8:1B23  1449 06A8:1B27
  1450 06A8:1B2A  1451 06A8:1B2D  1452 06A8:1B30  1453 06A8:1B33
  1454 06A8:1B36  1455 06A8:1B39  1456 06A8:1B3C  1457 06A8:1B3E
  1458 06A8:1B42  1459 06A8:1B46  1460 06A8:1B49  1461 06A8:1B4B
  1462 06A8:1B4D  1463 06A8:1B4F  1464 06A8:1B51  1465 06A8:1B53
  1466 06A8:1B55  1467 06A8:1B5A  1468 06A8:1B5E  1469 06A8:1B62
  1470 06A8:1B65  1471 06A8:1B67  1472 06A8:1B69  1473 06A8:1B6C
  1474 06A8:1B70  1475 06A8:1B74  1476 06A8:1B78  1477 06A8:1B7C
  1478 06A8:1B7E  1479 06A8:1B82  1480 06A8:1B86  1481 06A8:1B8A
  1482 06A8:1B8E  1483 06A8:1B92  1484 06A8:1B96  1485 06A8:1B9A
  1486 06A8:1B9E  1487 06A8:1BA2  1488 06A8:1BA6  1489 06A8:1BAA
  1490 06A8:1BAC  1491 06A8:1BAE  1492 06A8:1BB0  1493 06A8:1BB2
  1494 06A8:1BB4  1495 06A8:1BB6  1496 06A8:1BB8  1497 06A8:1BBA
  1498 06A8:1BBC  1499 06A8:1BBE  1500 06A8:1BC0  1501 06A8:1BC2
  1502 06A8:1BC4  1503 06A8:1BC7  1504 06A8:1BCA  1505 06A8:1BCD
  1506 06A8:1BD0  1507 06A8:1BD2  1508 06A8:1BD4  1509 06A8:1BD6
  1510 06A8:1BD8  1511 06A8:1BDA  1512 06A8:1BDC  1513 06A8:1BDE
  1514 06A8:1BE0  1515 06A8:1BE2  1516 06A8:1BE4  1517 06A8:1BE6
  1518 06A8:1BE8  1519 06A8:1BEA  1520 06A8:1BEC  1521 06A8:1BEE
  1522 06A8:1BF0  1523 06A8:1BF5  1524 06A8:1BF7  1525 06A8:1BF9
  1526 06A8:1BFB  1527 06A8:1BFD  1528 06A8:1BFF  1529 06A8:1C01
  1530 06A8:1C06  1531 06A8:1C0B  1532 06A8:1C0F  1534 06A8:1C14
  1536 06A8:1C15  1537 06A8:1C17  1538 06A8:1C18  1539 06A8:1C1A
  1540 06A8:1C1C  1541 06A8:1C1E  1542 06A8:1C20  1543 06A8:1C22
  1545 06A8:1C24  1546 06A8:1C26  1547 06A8:1C29  1548 06A8:1C2C
  1549 06A8:1C2E  1550 06A8:1C30  1551 06A8:1C32  1552 06A8:1C34
  1553 06A8:1C36  1554 06A8:1C38  1555 06A8:1C3A  1560 06A8:1C3C
  1561 06A8:1C3D  1562 06A8:1C3F  1564 06A8:1C40  1565 06A8:1C41
  1566 06A8:1C43  1568 06A8:1C44  1569 06A8:1C45  1570 06A8:1C47
  1572 06A8:1C48  1573 06A8:1C49  1574 06A8:1C4B  1576 06A8:1C4C
  1577 06A8:1C4D  1578 06A8:1C4F  1580 06A8:1C50  1581 06A8:1C51
  1582 06A8:1C53  1584 06A8:1C54  1585 06A8:1C55  1586 06A8:1C57
  1588 06A8:1C58  1589 06A8:1C59  1590 06A8:1C5B  1592 06A8:1C5C
  1593 06A8:1C5D  1594 06A8:1C5F  1596 06A8:1C60  1597 06A8:1C61
  1598 06A8:1C63  1599 06A8:1C64  1601 06A8:1C66  1602 06A8:1C67
  1603 06A8:1C69  1605 06A8:1C6A  1606 06A8:1C6B  1607 06A8:1C6D
  1609 06A8:1C6F  1610 06A8:1C71  1612 06A8:1C72  1613 06A8:1C74
  1614 06A8:1C76  1615 06A8:1C78  1616 06A8:1C7A  1617 06A8:1C7C
  1618 06A8:1C7E  1619 06A8:1C80  1620 06A8:1C82  1621 06A8:1C84
  1622 06A8:1C86  1623 06A8:1C88  1624 06A8:1C8A  1625 06A8:1C8C
  1626 06A8:1C8E  1627 06A8:1C90  1628 06A8:1C92  1629 06A8:1C94
  1630 06A8:1C96  1631 06A8:1C98  1632 06A8:1C9A  1633 06A8:1C9C
  1634 06A8:1C9E  1635 06A8:1CA0  1636 06A8:1CA2  1637 06A8:1CA4
  1638 06A8:1CA6  1639 06A8:1CA8  1640 06A8:1CAA  1641 06A8:1CAC
  1642 06A8:1CAE  1643 06A8:1CB0  1644 06A8:1CB2  1645 06A8:1CB4
  1646 06A8:1CB6  1647 06A8:1CB8  1648 06A8:1CBA  1649 06A8:1CBE
  1650 06A8:1CBF  1651 06A8:1CC0  1652 06A8:1CC1  1653 06A8:1CC2
  1654 06A8:1CC3  1655 06A8:1CC4  1656 06A8:1CC8  1657 06A8:1CCC
  1658 06A8:1CCE  1659 06A8:1CD2  1660 06A8:1CD6  1661 06A8:1CDA
  1663 06A8:1CDC  1664 06A8:1CDE  1665 06A8:1CE0  1666 06A8:1CE2
  1667 06A8:1CE4  1668 06A8:1CE6  1669 06A8:1CE8  1670 06A8:1CEA
  1671 06A8:1CEC  1672 06A8:1CF1  1673 06A8:1CF4  1674 06A8:1CF6
  1675 06A8:1CFA  1676 06A8:1CFC  1677 06A8:1CFE  1678 06A8:1D00
  1687 06A8:1D02  1689 06A8:1D04  1690 06A8:1D08  1691 06A8:1D0C
  1692 06A8:1D0F  1693 06A8:1D11  1694 06A8:1D12  1695 06A8:1D14
  1696 06A8:1D16  1697 06A8:1D1A  1698 06A8:1D1E  1699 06A8:1D1F
  1700 06A8:1D20  1701 06A8:1D21  1702 06A8:1D22  1703 06A8:1D25
  1704 06A8:1D28  1705 06A8:1D2B  1706 06A8:1D2D  1708 06A8:1D2F
  1712 06A8:1D31

Line numbers for btsuites(BTSUITES.PAS) segment btsuites

   171 06A8:1D33   172 06A8:1D43   173 06A8:1D47   174 06A8:1D48
   175 06A8:1D4C   193 06A8:1D56   194 06A8:1D5C   198 06A8:1D6D
   201 06A8:1D75   202 06A8:1D77   203 06A8:1D78   205 06A8:1D7B
   206 06A8:1D7C   207 06A8:1D80   212 06A8:1D82   214 06A8:1D85
   216 06A8:1D88   217 06A8:1D8D   218 06A8:1D8F   219 06A8:1D93
   220 06A8:1D97   223 06A8:1D99   224 06A8:1D9E   225 06A8:1DAA
   236 06A8:1DB4   237 06A8:1DBA   241 06A8:1DCB   244 06A8:1DD3
   245 06A8:1DD5   246 06A8:1DD6   248 06A8:1DD9   249 06A8:1DDA
   250 06A8:1DDE   252 06A8:1DE0   254 06A8:1DE3   256 06A8:1DE6
   257 06A8:1DEB   258 06A8:1DED   259 06A8:1DF1   260 06A8:1DF5
   263 06A8:1DF7   264 06A8:1DFC   265 06A8:1E1F   267 06A8:1E29
   270 06A8:1E2C   271 06A8:1E39   272 06A8:1E47   273 06A8:1E53

Line numbers for TInterrupts(TINTERRUPTS.PAS) segment TInterrupts

   162 088E:0000   166 088E:0006   169 088E:001E   170 088E:0046
   171 088E:004C   172 088E:0052   174 088E:005D   175 088E:005F
   176 088E:0064   177 088E:006F   178 088E:007A   179 088E:007B
   182 088E:0081   184 088E:0084   185 088E:008C   188 088E:00A7
   189 088E:00B4   192 088E:00C2   193 088E:00D3   196 088E:00D7
   199 088E:00DA   202 088E:00EA   203 088E:00FA

Line numbers for topb_detect(TOPB_DETECT.PAS) segment topb_detect

    99 08CE:0F5B   100 08CE:0F6A   101 08CE:0F6F   102 08CE:0F87
   103 08CE:0F8C   104 08CE:0FE3   105 08CE:0FF8   106 08CE:100C
   107 08CE:1011   108 08CE:1020   110 08CE:1087   111 08CE:10D5
   113 08CE:10DA   117 08CE:1104   118 08CE:110A   119 08CE:1110
   120 08CE:111B   121 08CE:1129   123 08CE:1150   124 08CE:1156
   125 08CE:1164   127 08CE:1180   128 08CE:1185   129 08CE:118B
   130 08CE:1191   131 08CE:119C   132 08CE:11AA   133 08CE:11C2
   134 08CE:11C9   135 08CE:11D0   136 08CE:11E5   137 08CE:11FB
   138 08CE:11FF   140 08CE:1207   141 08CE:1231   142 08CE:125B
   143 08CE:1285   144 08CE:1288   145 08CE:12A3   146 08CE:12CF
   147 08CE:12FC   148 08CE:132E   149 08CE:133A   150 08CE:136A
   151 08CE:139A   153 08CE:13CB   154 08CE:13D7   155 08CE:13F4
   156 08CE:1420   157 08CE:1436   158 08CE:1462   159 08CE:1492
   161 08CE:14C3   162 08CE:14CB   163 08CE:14D2   164 08CE:14FE
   165 08CE:1528   166 08CE:1552   167 08CE:1555   168 08CE:1587
   169 08CE:15B9   170 08CE:15EB   171 08CE:161D   172 08CE:1629
   173 08CE:1630   174 08CE:1673   175 08CE:16B6   176 08CE:16F9
   177 08CE:173C   178 08CE:177E   179 08CE:17C0   180 08CE:17EA
   181 08CE:17EC   183 08CE:181C   185 08CE:1849   186 08CE:187B
   187 08CE:18AD   188 08CE:18F8   189 08CE:193A   190 08CE:197C
   191 08CE:19A9   192 08CE:19B5   193 08CE:19E1   194 08CE:1A0E
   195 08CE:1A1A   196 08CE:1A22   197 08CE:1A4F   198 08CE:1A69
   199 08CE:1A95   200 08CE:1AC2   201 08CE:1AF2   203 08CE:1B22
   205 08CE:1B4F   206 08CE:1B81   207 08CE:1BB3   208 08CE:1BE5
   209 08CE:1BF1   210 08CE:1C1D   211 08CE:1C24   212 08CE:1C51
   213 08CE:1C5A   214 08CE:1C62   215 08CE:1C8E   216 08CE:1C96
   218 08CE:1CC3   219 08CE:1CCF   221 08CE:1CFB   222 08CE:1D28
   223 08CE:1D34   224 08CE:1D64   225 08CE:1D6C   226 08CE:1D98
   228 08CE:1DC9   229 08CE:1DD8   230 08CE:1DEE   231 08CE:1E1A
   232 08CE:1E44   233 08CE:1E4D   234 08CE:1E7A   235 08CE:1E83
   236 08CE:1EB3   238 08CE:1EE4   239 08CE:1F02   240 08CE:1F2E
   241 08CE:1F44   242 08CE:1F71   243 08CE:1FA3   244 08CE:1FAC
   245 08CE:1FB4   247 08CE:1FE0   249 08CE:200D   250 08CE:203F
   251 08CE:2071   252 08CE:20A3   253 08CE:20D5   254 08CE:2107
   255 08CE:2139   256 08CE:216B   257 08CE:219D   258 08CE:21CF
   259 08CE:2201   260 08CE:220D   261 08CE:2227   263 08CE:2253
   264 08CE:227F   266 08CE:22B0   267 08CE:22E2   268 08CE:22FD
   270 08CE:2329   271 08CE:2356   272 08CE:2388   273 08CE:23BA
   274 08CE:23EC   275 08CE:241E   276 08CE:2427   277 08CE:2457
   279 08CE:2488   280 08CE:2494   281 08CE:24C4   282 08CE:24F4
   284 08CE:2525   285 08CE:2557   286 08CE:2589   287 08CE:25BB
   288 08CE:25ED   289 08CE:25F6   290 08CE:2626   292 08CE:2657
   293 08CE:2689   294 08CE:26BB   295 08CE:26C4   296 08CE:26F4
   298 08CE:2725   299 08CE:2757   300 08CE:2789   301 08CE:27BB
   303 08CE:27CA   304 08CE:27F7   305 08CE:2829   306 08CE:285B
   307 08CE:288D   308 08CE:28BF   309 08CE:28F1   310 08CE:2923
   311 08CE:2955   312 08CE:2987   313 08CE:29B9   314 08CE:29EB
   315 08CE:2A1D   316 08CE:2A4F   317 08CE:2A81   318 08CE:2AB3
   319 08CE:2AE5   320 08CE:2B17   321 08CE:2B49   322 08CE:2B7B
   323 08CE:2BAD   324 08CE:2BDF   325 08CE:2C11   326 08CE:2C43
   327 08CE:2C75   328 08CE:2CA7   329 08CE:2CD9   330 08CE:2CE2
   331 08CE:2D12   333 08CE:2D43   334 08CE:2D75   335 08CE:2DA7
   336 08CE:2DD9   337 08CE:2E0B   338 08CE:2E3D   339 08CE:2E6F
   340 08CE:2EA1   341 08CE:2ED3   342 08CE:2F05   343 08CE:2F37
   344 08CE:2F69   345 08CE:2F9B   346 08CE:2FCD   347 08CE:2FFF
   348 08CE:3031   349 08CE:303A   350 08CE:306A   352 08CE:309B
   353 08CE:30CD   354 08CE:30E8   356 08CE:3114   357 08CE:3141
   358 08CE:3173   359 08CE:31A5   360 08CE:31D7   361 08CE:3209
   362 08CE:323B   363 08CE:326D   364 08CE:329F   365 08CE:32D1
   366 08CE:3303   367 08CE:3335   368 08CE:333D   369 08CE:3355
   370 08CE:3361   371 08CE:338E   372 08CE:33A4   373 08CE:33D0
   374 08CE:33E6   375 08CE:3410   376 08CE:3413   377 08CE:3420
   378 08CE:344D   379 08CE:347F   380 08CE:348C   381 08CE:34B9
   382 08CE:34EB   383 08CE:351D   384 08CE:354F   385 08CE:3581
   386 08CE:358A   387 08CE:35BA   389 08CE:35EB   390 08CE:361D
   391 08CE:3626   392 08CE:3656   394 08CE:3687   395 08CE:3693
   396 08CE:36B0   398 08CE:36DC   399 08CE:36F2   401 08CE:371E
   402 08CE:374A   403 08CE:377A   405 08CE:37AB   406 08CE:37C9
   407 08CE:37F5   408 08CE:380B   409 08CE:3838   410 08CE:386A
   411 08CE:389C   412 08CE:38CE   413 08CE:3900   414 08CE:3932
   415 08CE:3950   416 08CE:397D   417 08CE:3993   418 08CE:39BF
   419 08CE:39EB   420 08CE:3A17   425 08CE:3A46   426 08CE:3A5B
   427 08CE:3A6D   428 08CE:3A99   429 08CE:3AC6   430 08CE:3ACE
   431 08CE:3AFB   432 08CE:3B2C   433 08CE:3B5D   434 08CE:3B8E
   435 08CE:3BBF   436 08CE:3BF0   437 08CE:3C21   438 08CE:3C52
   439 08CE:3C83   440 08CE:3CB3   442 08CE:3CE3   445 08CE:3D16
   446 08CE:3D31   447 08CE:3D45   450 08CE:3D49   451 08CE:3D58
   452 08CE:3D71   472 08CE:3D75   473 08CE:3D83   474 08CE:3D91
   486 08CE:3E39   487 08CE:3E48   488 08CE:3E5B   489 08CE:3E85
   496 08CE:3E99   497 08CE:3E9C   498 08CE:3E9E   499 08CE:3EA1
   500 08CE:3EA5   501 08CE:3EA7   502 08CE:3EAB   504 08CE:3EAD
   505 08CE:3EB1   506 08CE:3EB3   507 08CE:3EB6   508 08CE:3EB8
   509 08CE:3EBA   510 08CE:3EBC   511 08CE:3EC0   512 08CE:3EC2
   513 08CE:3EC4   514 08CE:3EC6   515 08CE:3EC8   516 08CE:3ECC
   518 08CE:3ECE   519 08CE:3ED2   521 08CE:3ED4   525 08CE:3ED8
   526 08CE:3EDB   527 08CE:3EF4   528 08CE:3F0D   540 08CE:3F24
   541 08CE:3F26   542 08CE:3F28   543 08CE:3F2A   544 08CE:3F2E
   545 08CE:3F31   546 08CE:3F33   550 08CE:3F35   551 08CE:3F38
   552 08CE:3F39   553 08CE:3F3B   554 08CE:3F3D   555 08CE:3F40
   570 08CE:3F42   571 08CE:3F44   572 08CE:3F46   573 08CE:3F49
   574 08CE:3F4B   575 08CE:3F4D   576 08CE:3F4F   577 08CE:3F52
   578 08CE:3F53   579 08CE:3F55   580 08CE:3F57   581 08CE:3F59
   582 08CE:3F5B   583 08CE:3F5E   584 08CE:3F62   585 08CE:3F64
   586 08CE:3F66   587 08CE:3F6A   589 08CE:3F6C   594 08CE:3F70
   595 08CE:3F75   596 08CE:3F8E   597 08CE:3FA7   599 08CE:3FBE
   601 08CE:3FEF   602 08CE:4002   607 08CE:4006   608 08CE:4010
   609 08CE:4023   612 08CE:4025   613 08CE:402F   614 08CE:4030
   615 08CE:4031   616 08CE:4034   617 08CE:4037   618 08CE:4039
   619 08CE:403C   620 08CE:403E   621 08CE:403F   622 08CE:4040
   623 08CE:4041   624 08CE:4042   625 08CE:4043   626 08CE:4044
   631 08CE:4046   632 08CE:4048   633 08CE:404A   634 08CE:404C
   635 08CE:4050   637 08CE:4052   639 08CE:4054   660 08CE:4055
   662 08CE:407B   663 08CE:407E   664 08CE:4082   665 08CE:4084
   666 08CE:4087   667 08CE:4088   668 08CE:408B   669 08CE:408E
   670 08CE:408F   671 08CE:4091   673 08CE:4094   674 08CE:4097
   676 08CE:4098   677 08CE:409A   678 08CE:409C   679 08CE:409D
   680 08CE:409F   681 08CE:40A2   683 08CE:40A4   684 08CE:40A5
   685 08CE:40A6   686 08CE:40A8   687 08CE:40AA   688 08CE:40AD
   690 08CE:40AE   691 08CE:40B0   692 08CE:40B2   693 08CE:40B6
   694 08CE:40B8   695 08CE:40BB   696 08CE:40BC   698 08CE:40BE
   700 08CE:40C0   701 08CE:40C1   703 08CE:40C4   705 08CE:40F2
   707 08CE:4101   708 08CE:4123   709 08CE:4155   711 08CE:4177
   713 08CE:417C   714 08CE:4187   715 08CE:41B9   716 08CE:41C2
   717 08CE:41C9   718 08CE:41D0   719 08CE:41E3   722 08CE:41E6
   723 08CE:41F5   724 08CE:4204   725 08CE:420A   727 08CE:420E
   728 08CE:421D   729 08CE:4255   730 08CE:4259   731 08CE:425B
   732 08CE:42C1   740 08CE:42CD   741 08CE:42DC   742 08CE:42E4
   743 08CE:42FC   744 08CE:4324   745 08CE:4360   746 08CE:43AF
   747 08CE:43FA   748 08CE:4406   753 08CE:4410   754 08CE:441E
   755 08CE:444B   758 08CE:4456   759 08CE:4465   760 08CE:44BE
   774 08CE:44C2   776 08CE:44CC   778 08CE:44DA   779 08CE:44E1

Line numbers for Crc16(CRC16.PAS) segment Crc16

    94 0D1D:0000    95 0D1D:000A    96 0D1D:000D    97 0D1D:000F
    98 0D1D:0011    99 0D1D:0015   100 0D1D:0018   101 0D1D:0019
   105 0D1D:001C   106 0D1D:001E   107 0D1D:001F   108 0D1D:0021
   109 0D1D:0023   110 0D1D:0025   111 0D1D:0028   112 0D1D:002A
   113 0D1D:002C   115 0D1D:002D

Line numbers for vadapter(VADAPTER.PAS) segment vadapter

    57 0D21:0014    58 0D21:002F    59 0D21:0037    62 0D21:003C
    64 0D21:0044    66 0D21:004D    67 0D21:0055    68 0D21:006C
    69 0D21:00A8    71 0D21:00AA    72 0D21:00E4    74 0D21:00FF
    77 0D21:0139    78 0D21:0143    79 0D21:014A    80 0D21:0184
    82 0D21:018D    83 0D21:0195    84 0D21:01AC    85 0D21:01E8
    86 0D21:01EA    87 0D21:0224    89 0D21:025E    92 0D21:0269
    93 0D21:0273    94 0D21:0280

Line numbers for vadapter(D:\TOPBENCH\VIDEOID.ASM) segment vadapter

    80 0D21:028B    81 0D21:028C    82 0D21:028E    83 0D21:028F
    87 0D21:0290    89 0D21:0293    90 0D21:0297    96 0D21:029C
    97 0D21:02A1    98 0D21:02A6   100 0D21:02AB   101 0D21:02AE
   103 0D21:02B1   104 0D21:02B2   105 0D21:02B4   106 0D21:02B5
   108 0D21:02B7   109 0D21:02B8   110 0D21:02B9   111 0D21:02BB
   112 0D21:02BC   114 0D21:02BD   118 0D21:02BF   120 0D21:02C2
   121 0D21:02C3   122 0D21:02C4   123 0D21:02C6   124 0D21:02C7
   138 0D21:02C8   139 0D21:02CB   141 0D21:02CD   142 0D21:02CF
   147 0D21:02D1   148 0D21:02D3   150 0D21:02D5   151 0D21:02D7
   153 0D21:02D9   154 0D21:02DB   155 0D21:02DD   157 0D21:02E1
   159 0D21:02E4   160 0D21:02E6   162 0D21:02E8   163 0D21:02EA
   165 0D21:02EE   169 0D21:02F0   170 0D21:02F5   171 0D21:02FA
   173 0D21:02FF   174 0D21:0301   175 0D21:0304   177 0D21:0306
   178 0D21:0309   179 0D21:030C   181 0D21:030E   182 0D21:0312
   184 0D21:0317   200 0D21:0318   201 0D21:031A   202 0D21:031C
   206 0D21:031E   207 0D21:0321   209 0D21:0323   210 0D21:0325
   211 0D21:0327   212 0D21:032A   213 0D21:032B   214 0D21:032D
   215 0D21:032F   217 0D21:0332   218 0D21:0335   220 0D21:0337
   221 0D21:033C   223 0D21:033E   225 0D21:0343   238 0D21:0344
   239 0D21:0347   240 0D21:034A   242 0D21:034C   243 0D21:034E
   244 0D21:0350   246 0D21:0353   269 0D21:0354   270 0D21:0357
   271 0D21:035A   273 0D21:035C   274 0D21:035E   275 0D21:035F
   276 0D21:0361   278 0D21:0363   279 0D21:0366   280 0D21:0367
   281 0D21:0369   282 0D21:036B   284 0D21:036D   286 0D21:036F
   287 0D21:0371   288 0D21:0373   289 0D21:0376   291 0D21:0378
   292 0D21:0379   294 0D21:037B   296 0D21:037D   297 0D21:037F
   298 0D21:0382   300 0D21:0384   301 0D21:0386   302 0D21:0389
   304 0D21:038B   305 0D21:038D   307 0D21:038F   309 0D21:0392
   325 0D21:0393   326 0D21:0395   327 0D21:0396   328 0D21:0397
   329 0D21:0398   330 0D21:039A   331 0D21:039C   333 0D21:039D
   334 0D21:03A0   336 0D21:03A2   337 0D21:03A3   339 0D21:03A5
   341 0D21:03A6   342 0D21:03A9   344 0D21:03AB   346 0D21:03AC
   360 0D21:03AD   361 0D21:03B1   363 0D21:03B3   364 0D21:03B6
   365 0D21:03B8   366 0D21:03BC   368 0D21:03BE   369 0D21:03C0
   371 0D21:03C2   372 0D21:03C4   373 0D21:03C6   375 0D21:03C8
   376 0D21:03CC   377 0D21:03CE   379 0D21:03D0   380 0D21:03D4
   382 0D21:03D6   383 0D21:03D8   384 0D21:03DB   386 0D21:03DD
   400 0D21:03DE   401 0D21:03E0   402 0D21:03E3   404 0D21:03E5
   406 0D21:03E8   407 0D21:03EA

Line numbers for CPUType(CPUTYPE.PAS) segment CPUType

   425 0D60:093A   426 0D60:0940   427 0D60:094A   429 0D60:096F
   430 0D60:0973   431 0D60:097A   432 0D60:0983   435 0D60:0992
   436 0D60:0995   437 0D60:09AF   438 0D60:09C9   439 0D60:09E3
   440 0D60:09FD   441 0D60:0A17   442 0D60:0A31   443 0D60:0A4B
   444 0D60:0A65   445 0D60:0A7F   446 0D60:0A99   447 0D60:0AB3
   448 0D60:0ACD   449 0D60:0AE7   450 0D60:0B01   452 0D60:0B0D
   453 0D60:0B23   455 0D60:0B2F   456 0D60:0B45   457 0D60:0B49
   458 0D60:0B4F   460 0D60:0B64   461 0D60:0B77   462 0D60:0B80
   463 0D60:0B83   464 0D60:0B87   465 0D60:0B93   467 0D60:0BA8
   468 0D60:0BBB   469 0D60:0BC4   470 0D60:0BC7   471 0D60:0BCB
   472 0D60:0BD1   474 0D60:0BE6   475 0D60:0BF9   476 0D60:0C02
   477 0D60:0C05   479 0D60:0C13   480 0D60:0C18   481 0D60:0C2B
   482 0D60:0C34   483 0D60:0C37   484 0D60:0C51   485 0D60:0C6B
   486 0D60:0C84   487 0D60:0C9D   488 0D60:0CB6   489 0D60:0CCF
   490 0D60:0CE8   492 0D60:0CFF   493 0D60:0D02   495 0D60:0D10
   496 0D60:0D15   497 0D60:0D28   498 0D60:0D31   499 0D60:0D34
   500 0D60:0D3E   502 0D60:0D53   503 0D60:0D69   504 0D60:0D73
   506 0D60:0D88   507 0D60:0D9E   508 0D60:0DA8   510 0D60:0DBD
   511 0D60:0DD3   512 0D60:0DDD   514 0D60:0DF2   515 0D60:0E08
   516 0D60:0E12   518 0D60:0E27   519 0D60:0E3D   520 0D60:0E47
   522 0D60:0E5C   523 0D60:0E71   524 0D60:0E7B   526 0D60:0E90
   527 0D60:0EA5   528 0D60:0EAF   530 0D60:0EC4   532 0D60:0ED7
   533 0D60:0EDA   535 0D60:0EE8   536 0D60:0EED   537 0D60:0EF6
   538 0D60:0F09   539 0D60:0F0C   540 0D60:0F13   541 0D60:0F2C
   542 0D60:0F49   544 0D60:0F67   545 0D60:0F71   546 0D60:0F8E
   547 0D60:0FAB   548 0D60:0FC8   549 0D60:0FE1   552 0D60:0FF8
   553 0D60:0FFB   555 0D60:1009   556 0D60:100E   557 0D60:1021
   558 0D60:102A   559 0D60:102D   560 0D60:1047   561 0D60:1061
   562 0D60:107B   563 0D60:1095   564 0D60:10AF   565 0D60:10C9
   566 0D60:10E3   567 0D60:10FD   568 0D60:1117   569 0D60:1131
   570 0D60:114A   571 0D60:1163   572 0D60:117C   573 0D60:1195
   574 0D60:11AE   576 0D60:11C5   577 0D60:11C8   579 0D60:11D6
   580 0D60:11DB   581 0D60:11EE   582 0D60:11F7   583 0D60:11FA
   584 0D60:1214   585 0D60:122E   586 0D60:1248   587 0D60:1262
   588 0D60:127C   589 0D60:1295   590 0D60:12AE   591 0D60:12C7
   592 0D60:12E0   593 0D60:12F9   595 0D60:1310   596 0D60:1312
   597 0D60:132B   598 0D60:132F   599 0D60:1342   600 0D60:134B
   601 0D60:134D   603 0D60:1366   605 0D60:1379   613 0D60:137D
   614 0D60:1380   615 0D60:1381   616 0D60:1384   620 0D60:1387
   621 0D60:138A   622 0D60:138B   623 0D60:138D   624 0D60:138F
   625 0D60:1391   627 0D60:1393   628 0D60:1394   656 0D60:1CBB
   657 0D60:1CC2   658 0D60:1CC7   659 0D60:1CCE   660 0D60:1CD2
   661 0D60:1CD5   662 0D60:1CE9   664 0D60:1CFB   666 0D60:1D08
   667 0D60:1D2B   668 0D60:1D4E   669 0D60:1D71   670 0D60:1D8A
   671 0D60:1D8D   673 0D60:1D94   674 0D60:1DA1   675 0D60:1DA4
   676 0D60:1DAF   677 0D60:1DBA   678 0D60:1DBE   679 0D60:1DC3
   680 0D60:1DD6   681 0D60:1DD9   682 0D60:1DDB   683 0D60:1DDF
   684 0D60:1DE4   685 0D60:1DF7   686 0D60:1DFA   689 0D60:1DFC
   690 0D60:1E01   691 0D60:1E14   692 0D60:1E17   695 0D60:1E1A
   697 0D60:1E2A   698 0D60:1E34   699 0D60:1E39   700 0D60:1E3C
   701 0D60:1E56   702 0D60:1E70   703 0D60:1E7B   705 0D60:1E90
   706 0D60:1EA6   707 0D60:1EB3   709 0D60:1EC8   710 0D60:1EDE
   711 0D60:1EF7   712 0D60:1F10   713 0D60:1F29   714 0D60:1F42
   716 0D60:1F5B   718 0D60:1F6E   719 0D60:1F71   721 0D60:1F74
   723 0D60:1F84   724 0D60:1F89   725 0D60:1F93   726 0D60:1F98
   727 0D60:1F9B   728 0D60:1FB5   729 0D60:1FCF   730 0D60:1FE9
   731 0D60:2002   732 0D60:2010   734 0D60:2025   735 0D60:203A
   736 0D60:2053   738 0D60:206C   740 0D60:207F   741 0D60:2082
   744 0D60:2084   745 0D60:20C5   747 0D60:20C8   748 0D60:20CB
   749 0D60:20D2   752 0D60:20ED   753 0D60:20F2   754 0D60:20F5
   755 0D60:210E   756 0D60:2112   757 0D60:211D   759 0D60:2132
   760 0D60:2145   761 0D60:214A   762 0D60:214C   763 0D60:2150
   764 0D60:2163   765 0D60:2168   767 0D60:216A   769 0D60:217D
   770 0D60:2180   772 0D60:2183   774 0D60:2190   775 0D60:21A8
   776 0D60:21AB   778 0D60:21AE   780 0D60:21BB   781 0D60:21C0
   782 0D60:21C3   783 0D60:21C7   784 0D60:21DA   785 0D60:21DD
   788 0D60:21DF   789 0D60:21F2   792 0D60:21F5   794 0D60:21F8
   796 0D60:2208   797 0D60:220D   798 0D60:2210   799 0D60:2214
   800 0D60:2227   801 0D60:222A   802 0D60:222D   803 0D60:2231
   804 0D60:2244   805 0D60:2247   806 0D60:224A   807 0D60:2252
   808 0D60:2257   809 0D60:226A   810 0D60:226D   811 0D60:2270
   812 0D60:227F   813 0D60:2283   814 0D60:2288   815 0D60:229B
   816 0D60:229E   817 0D60:22A0   818 0D60:22A4   819 0D60:22A9
   820 0D60:22BC   821 0D60:22BF   822 0D60:22C1   823 0D60:22C5
   824 0D60:22CA   825 0D60:22DD   826 0D60:22E0   829 0D60:22E2
   830 0D60:22F5   833 0D60:22F8   835 0D60:22FB   837 0D60:230B
   838 0D60:2310   839 0D60:2313   840 0D60:2317   841 0D60:232A
   842 0D60:232F   843 0D60:2332   844 0D60:2336   845 0D60:2349
   846 0D60:234E   847 0D60:2351   848 0D60:2355   849 0D60:2368
   850 0D60:2381   851 0D60:2394   852 0D60:2397   853 0D60:23B1
   854 0D60:23BE   856 0D60:23D3   857 0D60:23E9   858 0D60:2403
   859 0D60:241D   860 0D60:2421   861 0D60:2434   862 0D60:244D
   863 0D60:2460   864 0D60:2462   866 0D60:247B   867 0D60:2484
   869 0D60:2499   870 0D60:24A2   872 0D60:24B7   874 0D60:24CA
   875 0D60:24CD   877 0D60:24D0   879 0D60:24E0   880 0D60:24E5
   881 0D60:24E8   882 0D60:2501   883 0D60:251A   884 0D60:2533
   886 0D60:254C   888 0D60:255F   889 0D60:2562   892 0D60:2564
   893 0D60:25A5   894 0D60:25A8   895 0D60:25AB   896 0D60:25B2
   898 0D60:25C2   899 0D60:25C7   900 0D60:25CA   902 0D60:25CE
   903 0D60:25E1   904 0D60:25E4   905 0D60:25E7   906 0D60:25EB
   907 0D60:25FE   908 0D60:2601   909 0D60:2604   910 0D60:2608
   911 0D60:2611   913 0D60:2626   914 0D60:2639   915 0D60:263C
   916 0D60:263F   917 0D60:2643   918 0D60:2656   919 0D60:2659
   920 0D60:265C   921 0D60:2663   922 0D60:2667   923 0D60:266F
   924 0D60:2684   925 0D60:269D   926 0D60:26B6   927 0D60:26BE
   929 0D60:26D3   931 0D60:26E6   932 0D60:26EF   933 0D60:26FE
   934 0D60:2718   936 0D60:2730   937 0D60:2733   938 0D60:2736
   939 0D60:273A   940 0D60:273E   941 0D60:2746   942 0D60:275B
   943 0D60:2774   945 0D60:278D   947 0D60:27A0   948 0D60:27A3
   949 0D60:27A6   950 0D60:27AD   951 0D60:27B6   952 0D60:27BA
   953 0D60:27D3   954 0D60:27EC   955 0D60:27F4   957 0D60:2809
   960 0D60:281E   961 0D60:282D   962 0D60:2847   963 0D60:2861
   965 0D60:287B   967 0D60:288E   968 0D60:2891   969 0D60:2894
   970 0D60:289B   971 0D60:28A4   972 0D60:28A8   973 0D60:28C1
   974 0D60:28DA   975 0D60:28E2   977 0D60:28F7   980 0D60:290C
   981 0D60:291B   982 0D60:2935   983 0D60:294F   985 0D60:2969
   987 0D60:297C   988 0D60:297F   989 0D60:2981   990 0D60:2985
   991 0D60:2998   992 0D60:299B   995 0D60:299D   996 0D60:29B0
   999 0D60:29B3  1001 0D60:29B6  1002 0D60:29C3  1003 0D60:29C6
  1004 0D60:29CA  1005 0D60:29CF  1006 0D60:29E7  1007 0D60:29EA
  1008 0D60:29EC  1009 0D60:29F0  1010 0D60:29F5  1011 0D60:2A0D
  1012 0D60:2A10  1015 0D60:2A12  1016 0D60:2A2A  1017 0D60:2A2F
  1018 0D60:2A32  1021 0D60:2A35  1023 0D60:2A45  1024 0D60:2A4A
  1025 0D60:2A4D  1026 0D60:2A66  1027 0D60:2A7F  1028 0D60:2A98
  1030 0D60:2AB1  1032 0D60:2AC4  1033 0D60:2AC7  1036 0D60:2AC9
  1037 0D60:2B0A  1038 0D60:2B0D  1039 0D60:2B0F  1040 0D60:2B13
  1041 0D60:2B20  1044 0D60:2B27  1045 0D60:2B68  1046 0D60:2B6B
  1047 0D60:2B6D  1049 0D60:2B71  1055 0D60:2B76  1061 0D60:2B79
  1062 0D60:2B93  1063 0D60:2BAD  1064 0D60:2BC7  1065 0D60:2BE1
  1066 0D60:2BFB  1067 0D60:2C15  1068 0D60:2C2F  1072 0D60:2C49
  1075 0D60:2C63  1076 0D60:2C7D  1077 0D60:2C97  1078 0D60:2CB1
  1079 0D60:2CCB  1080 0D60:2CE5  1081 0D60:2CFF  1082 0D60:2D19
  1083 0D60:2D33  1084 0D60:2D4D  1085 0D60:2D67  1086 0D60:2D81
  1087 0D60:2D9B  1088 0D60:2DB5  1089 0D60:2DCF  1090 0D60:2DE9
  1091 0D60:2E03  1092 0D60:2E22  1093 0D60:2E3C  1094 0D60:2E56
  1095 0D60:2E70  1096 0D60:2E8A  1097 0D60:2E92  1098 0D60:2EAD
  1099 0D60:2EB5  1100 0D60:2ECB  1101 0D60:2EE5  1102 0D60:2EFF
  1103 0D60:2F19  1104 0D60:2F33  1105 0D60:2F4D  1106 0D60:2F66
  1107 0D60:2F7F  1108 0D60:2F98  1109 0D60:2FB1  1111 0D60:2FCA
  1114 0D60:2FDD  1236 0D60:2FEF  1237 0D60:2FF6  1238 0D60:3022
  1278 0D60:3039  1279 0D60:3040  1280 0D60:3047  1283 0D60:3054
  1308 0D60:307A  1310 0D60:3082  1311 0D60:3089  1312 0D60:3090
  1313 0D60:3097  1314 0D60:30B8  1332 0D60:30BB  1333 0D60:3117
  1334 0D60:3173  1335 0D60:31CF  1337 0D60:31F0  1345 0D60:31FF
  1346 0D60:3206  1347 0D60:320D  1364 0D60:321A  1366 0D60:3283

Line numbers for CPUType(REALCODE.ASM) segment CPUType

    58 0D60:3290    59 0D60:3295    60 0D60:3298    61 0D60:329D
    62 0D60:32A2    63 0D60:32A5    64 0D60:32AA    67 0D60:32AF
    68 0D60:32B2    70 0D60:32B7    73 0D60:32BC    74 0D60:32BF
    75 0D60:32C4    78 0D60:32C9    79 0D60:32CC    80 0D60:32CE
    84 0D60:32D3    94 0D60:32D5    95 0D60:32D7    96 0D60:32D9
    97 0D60:32DB    98 0D60:32DE    99 0D60:32E4   100 0D60:32E6
   101 0D60:32E8   102 0D60:32EA   103 0D60:32EC   104 0D60:32EE
   105 0D60:32F1   106 0D60:32F5   107 0D60:32FA   108 0D60:3300
   109 0D60:3302   110 0D60:3308   111 0D60:330A   114 0D60:330F
   115 0D60:3312   116 0D60:3314   117 0D60:3316   118 0D60:331C
   119 0D60:3322   120 0D60:3324   121 0D60:3326   122 0D60:332A
   123 0D60:3333   124 0D60:333C   125 0D60:3345   126 0D60:334E
   127 0D60:3351   128 0D60:3353   129 0D60:3355   131 0D60:3357
   132 0D60:335C   133 0D60:3361   134 0D60:3366   135 0D60:3369
   136 0D60:336B   137 0D60:336D   138 0D60:3371   139 0D60:3378
   141 0D60:337D   142 0D60:3382   143 0D60:3385   144 0D60:3387
   146 0D60:338C   147 0D60:338F   148 0D60:3391   150 0D60:3396
   151 0D60:3399   152 0D60:339C   153 0D60:33A0   154 0D60:33A5
   155 0D60:33A8   156 0D60:33AC   157 0D60:33B1   158 0D60:33B4
   159 0D60:33B8   160 0D60:33BD   161 0D60:33C0   162 0D60:33C4
   163 0D60:33C9   165 0D60:33CC   166 0D60:33CF   167 0D60:33D1
   168 0D60:33D6   170 0D60:33D8   171 0D60:33DB   172 0D60:33DD
   174 0D60:33E2   175 0D60:33E5   176 0D60:33E7   179 0D60:33EC
   180 0D60:33EF   181 0D60:33F1   182 0D60:33F5   185 0D60:33F7
   186 0D60:33FA   188 0D60:33FC   189 0D60:3401   192 0D60:3403
   193 0D60:3406   194 0D60:3408   195 0D60:340D   198 0D60:340F
   199 0D60:3412   202 0D60:3414   203 0D60:3416   204 0D60:3419
   205 0D60:341B   206 0D60:3420   209 0D60:3422   210 0D60:3425
   213 0D60:3427   214 0D60:342A   215 0D60:342C   216 0D60:3430
   219 0D60:3432   220 0D60:3437   222 0D60:3439   223 0D60:343C
   226 0D60:343E   227 0D60:3440   228 0D60:3443   229 0D60:3445
   232 0D60:344A   233 0D60:344D   236 0D60:344F   237 0D60:3452
   238 0D60:3454   239 0D60:3459   240 0D60:345B   241 0D60:3460
   243 0D60:3462   245 0D60:3466   259 0D60:34F9   260 0D60:34FB
   261 0D60:3501   262 0D60:3502   263 0D60:3503   264 0D60:3504
   265 0D60:3507   266 0D60:350B   267 0D60:350E   268 0D60:350F
   269 0D60:3511   270 0D60:3512   271 0D60:3513   272 0D60:3514
   273 0D60:3515   275 0D60:3516   277 0D60:3517   278 0D60:3518
   279 0D60:351A   286 0D60:351B   287 0D60:351C   288 0D60:351D
   289 0D60:351F   291 0D60:3521   292 0D60:3522   294 0D60:3523
   295 0D60:3524   301 0D60:3525   302 0D60:3527   303 0D60:3529
   304 0D60:352A   305 0D60:352C   306 0D60:352E   312 0D60:3530
   313 0D60:3531   316 0D60:3537   317 0D60:3539   324 0D60:353B
   326 0D60:3540   327 0D60:3542   328 0D60:3544   334 0D60:3546
   335 0D60:3549   336 0D60:354A   337 0D60:354B   338 0D60:354C
   339 0D60:354D   340 0D60:354E   341 0D60:354F   342 0D60:3552
   343 0D60:3554   353 0D60:3556   354 0D60:3559   355 0D60:355B
   356 0D60:355D   357 0D60:3560   358 0D60:3562   359 0D60:3565
   360 0D60:3567   361 0D60:356A   362 0D60:356C   363 0D60:356F
   364 0D60:3571   365 0D60:3574   366 0D60:3576   367 0D60:3579
   368 0D60:357B   370 0D60:357D   371 0D60:3582   373 0D60:3584
   374 0D60:3589   376 0D60:358B   377 0D60:3590   379 0D60:3592
   380 0D60:3595   381 0D60:3597   382 0D60:359C   384 0D60:359E
   385 0D60:35A3   387 0D60:35A6   388 0D60:35AB   390 0D60:35AE
   391 0D60:35B1   392 0D60:35B6   393 0D60:35BB   422 0D60:35BE
   423 0D60:35BF   424 0D60:35C1   425 0D60:35C4   426 0D60:35C9
   427 0D60:35CB   428 0D60:35CD   439 0D60:35CF   440 0D60:35D1
   441 0D60:35D3   442 0D60:35D6   443 0D60:35D8   445 0D60:35DA
   446 0D60:35DC   447 0D60:35DE   452 0D60:35E3   453 0D60:35E5
   454 0D60:35E7   455 0D60:35EA   456 0D60:35EC   458 0D60:35EE
   459 0D60:35F0   460 0D60:35F2   467 0D60:35F7   468 0D60:35F9
   469 0D60:35FC   470 0D60:35FF   471 0D60:3601   472 0D60:3603
   473 0D60:3605   477 0D60:3607   478 0D60:360A   479 0D60:360B
   484 0D60:360D   485 0D60:360F   486 0D60:3611   487 0D60:3614
   488 0D60:3616   490 0D60:3618   491 0D60:361A   492 0D60:361C
   496 0D60:3621   497 0D60:3623   498 0D60:362B   499 0D60:3633
   508 0D60:3636   509 0D60:3639   510 0D60:363D   511 0D60:363F
   512 0D60:3641   513 0D60:3643   514 0D60:3646   515 0D60:364C
   516 0D60:364E   517 0D60:3650   518 0D60:3652   519 0D60:3654
   520 0D60:3656   521 0D60:3659   522 0D60:365D   523 0D60:365E
   524 0D60:3660   525 0D60:3663   526 0D60:3665   527 0D60:3667
   528 0D60:366A   529 0D60:366D   530 0D60:366E   531 0D60:366F
   532 0D60:3671   534 0D60:3674   535 0D60:3676   537 0D60:3678
   538 0D60:367A   539 0D60:367C   540 0D60:367F   541 0D60:3681
   542 0D60:3683   543 0D60:3684   545 0D60:3687   546 0D60:368A
   547 0D60:368B   548 0D60:368D   549 0D60:368F   550 0D60:3692
   551 0D60:3694   552 0D60:3696   553 0D60:3697   559 0D60:369A
   560 0D60:36A0   561 0D60:36A6   562 0D60:36A9   563 0D60:36AC
   565 0D60:36AF   566 0D60:36B1   567 0D60:36B3   568 0D60:36B8
   569 0D60:36BB   570 0D60:36BF   571 0D60:36C1   572 0D60:36C3
   578 0D60:36C6   579 0D60:36C8   580 0D60:36CB   581 0D60:36CD
   582 0D60:36CF   583 0D60:36D1   584 0D60:36D4   585 0D60:36DB
   586 0D60:36E2   587 0D60:36E4   588 0D60:36E6   589 0D60:36E8
   590 0D60:36EA   591 0D60:36EC   592 0D60:36EE   594 0D60:36F5
   595 0D60:36F8   596 0D60:36FC   604 0D60:36FF   605 0D60:3702
   606 0D60:3705   607 0D60:3709   608 0D60:370C   609 0D60:370F
   610 0D60:3712   611 0D60:3715   612 0D60:3719   619 0D60:371C
   620 0D60:371F   621 0D60:3722   622 0D60:3726   623 0D60:3729
   624 0D60:372C   625 0D60:372F   626 0D60:3732   629 0D60:3736
   630 0D60:373B   631 0D60:373D   632 0D60:3740   633 0D60:3743
   634 0D60:3745   635 0D60:3749   652 0D60:374C   653 0D60:374F
   654 0D60:3751   655 0D60:3753   656 0D60:3754   657 0D60:3757
   658 0D60:3759   659 0D60:375A   660 0D60:375B   661 0D60:375C
   662 0D60:375D   663 0D60:3760   664 0D60:3763   665 0D60:3765
   666 0D60:3768   667 0D60:376A   668 0D60:376B   669 0D60:376C
   670 0D60:376F   671 0D60:3772   672 0D60:3774   674 0D60:377C
   675 0D60:377D   676 0D60:3782   678 0D60:3784   679 0D60:3787
   680 0D60:3788   682 0D60:3789   683 0D60:378A   684 0D60:378B
   685 0D60:378C   686 0D60:378F   687 0D60:3791   688 0D60:3792
   689 0D60:3793   690 0D60:3794   691 0D60:3795   692 0D60:3798
   693 0D60:379A   694 0D60:379B   696 0D60:379C   702 0D60:379D
   703 0D60:37A0   704 0D60:37A2   705 0D60:37A3   706 0D60:37A6
   707 0D60:37A8   708 0D60:37A9   709 0D60:37AA   710 0D60:37AB
   711 0D60:37AC   712 0D60:37AF   713 0D60:37B2   714 0D60:37B4
   715 0D60:37BC   716 0D60:37C1   718 0D60:37C3   719 0D60:37C6
   720 0D60:37C7   721 0D60:37C8   723 0D60:37CD   724 0D60:37CE
   725 0D60:37CF   726 0D60:37D0   727 0D60:37D3   728 0D60:37D5
   730 0D60:37D6   736 0D60:37D7   737 0D60:37DA   738 0D60:37DC
   739 0D60:37DD   740 0D60:37E0   741 0D60:37E2   742 0D60:37E3
   743 0D60:37E4   744 0D60:37E5   745 0D60:37E6   746 0D60:37E9
   747 0D60:37EC   748 0D60:37EE   749 0D60:37F6   750 0D60:37FB
   752 0D60:37FD   753 0D60:3800   754 0D60:3801   756 0D60:3802
   757 0D60:3803   758 0D60:3804   759 0D60:3805   760 0D60:3808
   761 0D60:380A   763 0D60:380B   775 0D60:380C   776 0D60:380E
   777 0D60:380F   778 0D60:3812   779 0D60:3815   780 0D60:3817
   781 0D60:3818   782 0D60:381B   783 0D60:381F   788 0D60:3822
   789 0D60:3825   790 0D60:3827   791 0D60:382A   792 0D60:382C
   793 0D60:3830   801 0D60:3833   802 0D60:3838   804 0D60:383A
   805 0D60:383D   806 0D60:383F   808 0D60:3845   809 0D60:3847
   810 0D60:384C   812 0D60:384E   814 0D60:3853   822 0D60:3854
   823 0D60:3859   824 0D60:385E   826 0D60:3860   827 0D60:3861
   828 0D60:3864   829 0D60:3866   830 0D60:3868   832 0D60:386D
   834 0D60:386E   852 0D60:386F   853 0D60:387A   854 0D60:387C
   855 0D60:387E   857 0D60:3880   858 0D60:3885   859 0D60:3888
   860 0D60:388B   861 0D60:388D   862 0D60:3892   863 0D60:3895
   864 0D60:3898   865 0D60:389B   866 0D60:389E   867 0D60:38A3
   868 0D60:38A8   869 0D60:38AD   870 0D60:38B2   871 0D60:38B6
   872 0D60:38B9   873 0D60:38BD   874 0D60:38BE   875 0D60:38C3
   878 0D60:38C8   879 0D60:38CD   880 0D60:38CF   881 0D60:38D1
   882 0D60:38D3   883 0D60:38D5   884 0D60:38D7   885 0D60:38D9
   886 0D60:38DB   887 0D60:38DF   888 0D60:38E0   889 0D60:38E3
   890 0D60:38E4   891 0D60:38E6   892 0D60:38EB   893 0D60:38F0
   928 0D60:38F2   929 0D60:38F4   930 0D60:38F8   931 0D60:38FA
   932 0D60:38FC   933 0D60:38FE   934 0D60:3900   935 0D60:3905
   936 0D60:3907   937 0D60:390C   939 0D60:390F   940 0D60:3914
   941 0D60:3916   942 0D60:391B   944 0D60:391D   946 0D60:3922
   947 0D60:3924   948 0D60:3927   951 0D60:392D   952 0D60:392F
   953 0D60:3931   955 0D60:3934   956 0D60:3939   959 0D60:393C
   960 0D60:393E   961 0D60:3940   962 0D60:3942   963 0D60:3945
   964 0D60:3946   965 0D60:394B   966 0D60:394D   967 0D60:3952
   968 0D60:3954   969 0D60:3959   971 0D60:395B   972 0D60:3960
   973 0D60:3962   974 0D60:3967   976 0D60:3969   979 0D60:396E
   980 0D60:3970   981 0D60:3974   982 0D60:3978   983 0D60:397A
   984 0D60:397C   985 0D60:397F   986 0D60:3981   987 0D60:3982
   988 0D60:3984   989 0D60:3986   990 0D60:398A   991 0D60:398C
   992 0D60:3990   993 0D60:3992   994 0D60:3997   995 0D60:399C
   996 0D60:399E   997 0D60:39A3  1000 0D60:39A5  1001 0D60:39A8
  1002 0D60:39AC  1003 0D60:39AF  1004 0D60:39B3  1005 0D60:39B4
  1006 0D60:39B8  1007 0D60:39BA  1008 0D60:39BF  1011 0D60:39C1
  1012 0D60:39C6  1013 0D60:39C8  1014 0D60:39CA  1015 0D60:39CC
  1016 0D60:39CE  1017 0D60:39D0  1018 0D60:39D2  1019 0D60:39D4
  1020 0D60:39D6  1021 0D60:39D8  1022 0D60:39DA  1023 0D60:39DD
  1024 0D60:39DE  1025 0D60:39DF  1026 0D60:39E1  1028 0D60:39E6
  1029 0D60:39EB  1030 0D60:39ED  1031 0D60:39F2  1032 0D60:39F4
  1034 0D60:39F9  1035 0D60:39FE  1036 0D60:3A00  1037 0D60:3A05
  1038 0D60:3A07  1039 0D60:3A09  1040 0D60:3A0C  1041 0D60:3A10
  1042 0D60:3A12  1043 0D60:3A17  1044 0D60:3A1C  1046 0D60:3A1E
  1047 0D60:3A23  1048 0D60:3A25  1049 0D60:3A2A  1050 0D60:3A2C
  1051 0D60:3A2E  1052 0D60:3A33  1053 0D60:3A35  1055 0D60:3A3A
  1056 0D60:3A3F  1057 0D60:3A44  1059 0D60:3A46  1060 0D60:3A4B
  1061 0D60:3A4D  1062 0D60:3A51  1064 0D60:3A53  1065 0D60:3A58
  1066 0D60:3A5A  1067 0D60:3A5F  1068 0D60:3A61  1070 0D60:3A66
  1071 0D60:3A6B  1072 0D60:3A6D  1075 0D60:3A71  1076 0D60:3A74
  1077 0D60:3A77  1086 0D60:3A7B  1087 0D60:3A7E  1089 0D60:3A80
  1134 0D60:3B11  1135 0D60:3B18  1137 0D60:3B1B  1138 0D60:3B1D
  1139 0D60:3B26  1140 0D60:3B28  1141 0D60:3B2A  1142 0D60:3B2C
  1143 0D60:3B37  1144 0D60:3B40  1145 0D60:3B49  1146 0D60:3B4B
  1147 0D60:3B4D  1149 0D60:3B4F  1150 0D60:3B51  1152 0D60:3B5C
  1153 0D60:3B65  1154 0D60:3B67  1155 0D60:3B69  1156 0D60:3B74
  1157 0D60:3B7D  1158 0D60:3B86  1159 0D60:3B88  1160 0D60:3B8A
  1162 0D60:3B8C  1163 0D60:3B8E  1165 0D60:3B99  1166 0D60:3B9B
  1168 0D60:3B9D  1169 0D60:3BA6  1170 0D60:3BA8  1171 0D60:3BAA
  1172 0D60:3BAD  1173 0D60:3BB0  1175 0D60:3BBB  1176 0D60:3BC4
  1177 0D60:3BC6  1178 0D60:3BCF  1179 0D60:3BD1  1180 0D60:3BD3
  1181 0D60:3BDE  1183 0D60:3BE0  1184 0D60:3BE2  1185 0D60:3BE4
  1186 0D60:3BE7  1188 0D60:3BE9  1189 0D60:3BEB  1191 0D60:3BED
  1192 0D60:3BEF  1193 0D60:3BF0  1194 0D60:3BF3  1195 0D60:3BF6
  1196 0D60:3BF7  1212 0D60:3BF9  1213 0D60:3C00  1215 0D60:3C03
  1216 0D60:3C0C  1217 0D60:3C0E  1218 0D60:3C10  1219 0D60:3C12
  1220 0D60:3C14  1221 0D60:3C1F  1222 0D60:3C28  1223 0D60:3C2A
  1224 0D60:3C2C  1225 0D60:3C37  1226 0D60:3C39  1228 0D60:3C44
  1229 0D60:3C47  1230 0D60:3C4A  1243 0D60:3C4C  1244 0D60:3C56
  1245 0D60:3C58  1246 0D60:3C5B  1247 0D60:3C5D  1248 0D60:3C5F
  1249 0D60:3C61  1250 0D60:3C63  1251 0D60:3C65  1252 0D60:3C67
  1253 0D60:3C69  1259 0D60:3C6F  1260 0D60:3C71  1261 0D60:3C73
  1262 0D60:3C75  1263 0D60:3C77  1265 0D60:3C79  1266 0D60:3C7B
  1268 0D60:3C7D  1270 0D60:3C7F  1276 0D60:3C80  1277 0D60:3C83
  1278 0D60:3C85  1279 0D60:3C87  1280 0D60:3C89  1281 0D60:3C8B
  1283 0D60:3C8D  1284 0D60:3C93  1285 0D60:3C95  1286 0D60:3C98
  1287 0D60:3C9A  1288 0D60:3C9C  1289 0D60:3CA0  1290 0D60:3CA3
  1291 0D60:3CA5  1292 0D60:3CA7  1293 0D60:3CAA  1294 0D60:3CAD
  1295 0D60:3CAF  1296 0D60:3CB1  1297 0D60:3CB5  1298 0D60:3CB8
  1299 0D60:3CBA  1300 0D60:3CBC  1301 0D60:3CBF  1302 0D60:3CC2
  1303 0D60:3CC4  1304 0D60:3CC6  1305 0D60:3CCA  1306 0D60:3CCD
  1307 0D60:3CCF  1308 0D60:3CD1  1309 0D60:3CD4  1310 0D60:3CD7
  1311 0D60:3CD9  1312 0D60:3CDB  1313 0D60:3CDF  1315 0D60:3CE2

Line numbers for CPUType(CPUSPEED.ASM) segment CPUType

    30 0D60:3CE3    32 0D60:3CEE    35 0D60:3CF3    37 0D60:3CF7
    41 0D60:3CFA    42 0D60:3CFD    43 0D60:3D00    44 0D60:3D02
    48 0D60:3D06    49 0D60:3D08    50 0D60:3D0A    52 0D60:3D0C
    54 0D60:3D0E    55 0D60:3D0F    57 0D60:3D13    58 0D60:3D18
    62 0D60:3D1B    63 0D60:3D1E    64 0D60:3D1F    65 0D60:3D21
    66 0D60:3D22    72 0D60:3D28    73 0D60:3D2D    74 0D60:3D30
    75 0D60:3D33    76 0D60:3D35    77 0D60:3D37    78 0D60:3D39
    79 0D60:3D3B    80 0D60:3D3D    81 0D60:3D3F    82 0D60:3D41
    83 0D60:3D43    84 0D60:3D45    85 0D60:3D47    86 0D60:3D49
    87 0D60:3D4B    88 0D60:3D4D    89 0D60:3D4F    90 0D60:3D51
    91 0D60:3D53    92 0D60:3D57    94 0D60:3D5C    95 0D60:3D5D
   100 0D60:3D5F   101 0D60:3EF3   102 0D60:3EF4   103 0D60:3EF6
   105 0D60:3EF9   106 0D60:3EFA   108 0D60:3EFC   109 0D60:3EFE
   110 0D60:3F00   111 0D60:3F01   112 0D60:3F03   115 0D60:3F05
   116 0D60:3F07   117 0D60:3F09   118 0D60:3F0B   119 0D60:3F0C
   120 0D60:3F0E   121 0D60:3F10   122 0D60:3F12   123 0D60:3F14
   124 0D60:3F16   125 0D60:3F18   126 0D60:3F1A   127 0D60:3F1B
   128 0D60:3F1D   129 0D60:3F1F   130 0D60:3F21   132 0D60:3F23
   133 0D60:3F25   134 0D60:3F27   135 0D60:3F29   136 0D60:3F2B
   137 0D60:3F2D   138 0D60:3F2F   139 0D60:3F31   140 0D60:3F32

Line numbers for CPUType(P5SPEED.ASM) segment CPUType

    32 0D60:3F36    33 0D60:3F39    34 0D60:3F3B    35 0D60:3F3D
    36 0D60:3F3F    37 0D60:3F41    38 0D60:3F43    39 0D60:3F44
    41 0D60:3F45    42 0D60:3F46    46 0D60:3F47    47 0D60:3F48
    48 0D60:3F4B    49 0D60:3F4D    50 0D60:3F50    52 0D60:3F52
    53 0D60:3F53    57 0D60:3F54    58 0D60:3F55    59 0D60:3F58
    60 0D60:3F5A    61 0D60:3F5D    63 0D60:3F5F    64 0D60:3F60
    72 0D60:3F61    73 0D60:3F63    74 0D60:3F65    75 0D60:3F67
    76 0D60:3F69    78 0D60:3F6B    79 0D60:3F6D    80 0D60:3F6F
    81 0D60:3F71    82 0D60:3F73    84 0D60:3F75    92 0D60:3F76
    94 0D60:3F81    95 0D60:3F84    99 0D60:3F87   100 0D60:3FAB
   101 0D60:3FAE   103 0D60:3FB1   105 0D60:3FB4   106 0D60:3FB7
   107 0D60:3FBD   109 0D60:3FC0   114 0D60:3FC9   115 0D60:3FCD
   116 0D60:3FD0   117 0D60:3FD3   118 0D60:3FD5   120 0D60:3FD9
   121 0D60:3FDC   123 0D60:3FE0   124 0D60:3FE3   125 0D60:3FE5
   126 0D60:3FE8   127 0D60:3FEA   129 0D60:3FEE   130 0D60:3FF2
   131 0D60:3FF6   132 0D60:3FF9   133 0D60:3FFE   135 0D60:4001
   136 0D60:4004   137 0D60:4006   138 0D60:400C   139 0D60:400F
   140 0D60:4015   141 0D60:4018   142 0D60:401F   143 0D60:4021
   145 0D60:4023   146 0D60:4026   147 0D60:4029   148 0D60:402D
   150 0D60:4030   151 0D60:4032   155 0D60:4034   156 0D60:4037
   157 0D60:403B   158 0D60:403F

Line numbers for support(SUPPORT.PAS) segment support

   167 1164:0000   168 1164:0003   169 1164:0004   170 1164:0005
   171 1164:0008   172 1164:000B   173 1164:000C   174 1164:000D
   175 1164:000F   176 1164:0010   179 1164:0012   180 1164:0013
   181 1164:0015   182 1164:0017   183 1164:0019   184 1164:001B
   186 1164:001D   187 1164:001E   190 1164:0020   191 1164:0021
   204 1164:0025   205 1164:0043   207 1164:0054   208 1164:0063
   210 1164:006E   211 1164:007D   230 1164:0086   231 1164:008C
   232 1164:00A3   233 1164:00B6   239 1164:00BC   240 1164:00DE
   241 1164:00F3   242 1164:00FF   249 1164:010B   251 1164:0112
   252 1164:0144   253 1164:0166   255 1164:0186   256 1164:01AD
   257 1164:01C9   258 1164:01D8   260 1164:01EE   261 1164:0202
   267 1164:0208   268 1164:022A   269 1164:0242   270 1164:0248
   271 1164:025C   272 1164:026B   286 1164:027A   287 1164:027C
   288 1164:027E   289 1164:0281   290 1164:0283   292 1164:0284
   296 1164:0285   297 1164:0287   298 1164:0289   299 1164:028B
   300 1164:028D   302 1164:028F   307 1164:0292   308 1164:0299
   309 1164:029D   310 1164:02A5   311 1164:02BA   312 1164:02C2
   313 1164:02F9   314 1164:030F   316 1164:0311   317 1164:0324
   322 1164:032C   323 1164:0333   324 1164:0337   325 1164:033D
   326 1164:0352   327 1164:0358   328 1164:0388   329 1164:0393
   330 1164:0395   331 1164:03C5   332 1164:03D8   684 1164:03DE
   686 1164:03FC   687 1164:0416   688 1164:0430   689 1164:043A
   690 1164:0457   691 1164:0461   692 1164:0493   693 1164:04A1
   694 1164:04AD   696 1164:04AF   697 1164:04E5   698 1164:04F2
   699 1164:0500   720 1164:050C   721 1164:0512   724 1164:052B
   726 1164:052C   728 1164:0560   731 1164:0579   733 1164:057A
   734 1164:059F

Line numbers for DetectGraphics(DETECTGRAPHICS.PAS) segment DetectGraphics

   113 11BF:0000   114 11BF:000A   115 11BF:0010   116 11BF:0015
   117 11BF:001B   118 11BF:0028   119 11BF:002E   120 11BF:0034
   121 11BF:0039   122 11BF:003F   123 11BF:004C   151 11BF:004E
   152 11BF:005D   153 11BF:0062   154 11BF:007E   155 11BF:00C0
   156 11BF:00D3   172 11BF:00E1   173 11BF:00EF   174 11BF:0100
   176 11BF:010C   177 11BF:011D   179 11BF:0138   180 11BF:0149
   182 11BF:0158   183 11BF:0169   185 11BF:0182   186 11BF:0193
   188 11BF:01A2   189 11BF:01B3   191 11BF:01C9   192 11BF:01E0
   200 11BF:01F1   201 11BF:01FF   202 11BF:0208   203 11BF:021E
   204 11BF:022A   205 11BF:023E   206 11BF:024A   207 11BF:025B
   208 11BF:0272   214 11BF:0283   216 11BF:0291   217 11BF:0298
   218 11BF:02A1   219 11BF:02B2   220 11BF:02BE   225 11BF:02CF
   227 11BF:02DD   228 11BF:02E4   229 11BF:02ED   230 11BF:02FE
   231 11BF:0314   232 11BF:0316   233 11BF:0327   235 11BF:033D
   242 11BF:0343   243 11BF:0351   244 11BF:0362   245 11BF:0377
   252 11BF:037D   253 11BF:038B   254 11BF:03AF   255 11BF:03C0
   266 11BF:03C6   267 11BF:03D4   268 11BF:03D9   271 11BF:03DD
   272 11BF:03E3   273 11BF:03E9   274 11BF:03F6   275 11BF:040F
   276 11BF:0412   277 11BF:0418   279 11BF:041C   280 11BF:041D
   281 11BF:0423   284 11BF:0429   285 11BF:042F   286 11BF:0437
   288 11BF:0444   289 11BF:044B   290 11BF:0456   291 11BF:0462
   292 11BF:046E   293 11BF:047A   294 11BF:0480   297 11BF:0486
   298 11BF:048C   299 11BF:0494   301 11BF:04A1   302 11BF:04A2
   304 11BF:04B0   305 11BF:04BA   306 11BF:04C8   307 11BF:04D3
   308 11BF:04E1   309 11BF:04ED   311 11BF:04F3   312 11BF:04F6
   314 11BF:04F8   315 11BF:04FB   317 11BF:050A   318 11BF:0510
   319 11BF:0516   397 11BF:1028   398 11BF:1037   399 11BF:103B
   400 11BF:1040   401 11BF:1053   402 11BF:1058   465 11BF:105D
   467 11BF:1065   468 11BF:106C   469 11BF:1077   470 11BF:108C
   471 11BF:10A1   473 11BF:10B4   474 11BF:10B9   475 11BF:10BF
   477 11BF:10C3   481 11BF:10CC   482 11BF:10D6   484 11BF:10DE
   485 11BF:10E4   486 11BF:10EF   487 11BF:10FD   488 11BF:1108
   489 11BF:1114   490 11BF:111F   491 11BF:112B   492 11BF:1136
   494 11BF:114E   496 11BF:1158   497 11BF:115C   498 11BF:1162
   499 11BF:118A   500 11BF:1190   501 11BF:1197   502 11BF:119A
   503 11BF:11CD   505 11BF:11D5   506 11BF:11DB   507 11BF:11E8
   508 11BF:11F1   510 11BF:121B   511 11BF:1243   512 11BF:1246
   513 11BF:1278   515 11BF:12AA   518 11BF:12D2   519 11BF:12F8
   520 11BF:12FB   521 11BF:1330   522 11BF:1365   523 11BF:139A
   524 11BF:13CA   525 11BF:13FA   526 11BF:142A   527 11BF:1459
   528 11BF:1488   531 11BF:14B5   532 11BF:14BB   535 11BF:14C2
   536 11BF:14C8   537 11BF:14D5   539 11BF:14DC   541 11BF:14EA
   542 11BF:14F3   544 11BF:151D   545 11BF:1545   547 11BF:1547
   552 11BF:154C   556 11BF:1555   557 11BF:1579   559 11BF:158D
   560 11BF:1591   562 11BF:1597   563 11BF:159D   565 11BF:15A4
   566 11BF:15AA   568 11BF:15B0   570 11BF:15C8   571 11BF:15CE
   573 11BF:15D4   575 11BF:15E9   576 11BF:15EF   577 11BF:15F3
   578 11BF:161B   579 11BF:161D   580 11BF:1621   584 11BF:1649
   585 11BF:164F   587 11BF:1656   588 11BF:165C   589 11BF:1663
   590 11BF:167C   595 11BF:1693   599 11BF:169C   600 11BF:16C7
   602 11BF:16F8   603 11BF:16FC   604 11BF:1702   605 11BF:172A
   606 11BF:172D   607 11BF:175C   608 11BF:178B   609 11BF:17BA
   610 11BF:17E8   612 11BF:1816   615 11BF:183E   617 11BF:184C
   623 11BF:1852   627 11BF:185B   628 11BF:1861   629 11BF:1868
   630 11BF:186E   633 11BF:1878   634 11BF:187D   635 11BF:1882
   636 11BF:188F   638 11BF:1899   639 11BF:18A3   640 11BF:18D3
   641 11BF:1903   642 11BF:1933   643 11BF:1963   644 11BF:1993
   645 11BF:19C3   646 11BF:19F3   647 11BF:1A22   648 11BF:1A51
   650 11BF:1A7E   651 11BF:1A82   653 11BF:1A88   654 11BF:1A8B
   655 11BF:1A96   656 11BF:1AA1   658 11BF:1AAC   662 11BF:1AB1
   665 11BF:1AEF   668 11BF:1B22   669 11BF:1B2D   671 11BF:1B57
   676 11BF:1B7F   681 11BF:1B88   682 11BF:1B98   683 11BF:1BA1
   684 11BF:1BBB   685 11BF:1BC1   686 11BF:1BCA   688 11BF:1BD1
   690 11BF:1BDB   691 11BF:1BDF   692 11BF:1BE5   693 11BF:1BEE
   694 11BF:1BF1   695 11BF:1C25   696 11BF:1C59   697 11BF:1C89
   698 11BF:1CBE   699 11BF:1CEE   700 11BF:1D1E   701 11BF:1D4E
   702 11BF:1D7E   703 11BF:1DAE   704 11BF:1DDE   705 11BF:1E0D
   706 11BF:1E3C   708 11BF:1E6E   709 11BF:1E71   710 11BF:1E8A
   711 11BF:1EA4   712 11BF:1EA9   713 11BF:1EB4   714 11BF:1EBF
   715 11BF:1ECA   717 11BF:1ED3   718 11BF:1ED5   719 11BF:1EE9
   720 11BF:1F03   721 11BF:1F08   722 11BF:1F17   723 11BF:1F26
   724 11BF:1F35   725 11BF:1F40   729 11BF:1F49   730 11BF:1F4B
   732 11BF:1F66   733 11BF:1F6A   734 11BF:1F70   737 11BF:1F98
   741 11BF:1FA1   742 11BF:1FA7   743 11BF:1FAC   744 11BF:1FB9
   747 11BF:1FC3   748 11BF:1FC9   749 11BF:1FD7   750 11BF:1FDA
   751 11BF:200A   752 11BF:203A   753 11BF:2069   755 11BF:2098
   757 11BF:20C0   759 11BF:20D4   760 11BF:20DB   762 11BF:2126
   768 11BF:2162   772 11BF:216B   773 11BF:2173   775 11BF:217D
   776 11BF:2183   777 11BF:21AB   778 11BF:21B5   780 11BF:21BD
   782 11BF:21C3   783 11BF:21CE   784 11BF:21DA   785 11BF:21E8
   786 11BF:21F4   788 11BF:2200   789 11BF:2206   790 11BF:220C
   791 11BF:2220   792 11BF:2232   793 11BF:2267   794 11BF:229C
   797 11BF:22D2   799 11BF:22E0   801 11BF:2308   802 11BF:230E
   803 11BF:2314   806 11BF:231A   807 11BF:2320   808 11BF:2325
   809 11BF:2332   810 11BF:2339   812 11BF:2361   813 11BF:236C
   814 11BF:2378   815 11BF:2381   817 11BF:2388   818 11BF:238D
   819 11BF:239C   820 11BF:23A7   822 11BF:23B0   825 11BF:23B2
   826 11BF:23DA   829 11BF:23E0   830 11BF:23EB   833 11BF:23F7
   834 11BF:2400   836 11BF:242A   838 11BF:2452   839 11BF:2458
   843 11BF:245F   847 11BF:2465   849 11BF:246E   850 11BF:2496
   851 11BF:249A   855 11BF:24A0   859 11BF:24A9   861 11BF:24C1
   862 11BF:24C5   864 11BF:24CB   866 11BF:24E3   867 11BF:2520
   869 11BF:2548   870 11BF:2558   871 11BF:2564   872 11BF:2570
   873 11BF:257C   875 11BF:2586   878 11BF:2589   879 11BF:2593
   880 11BF:25C3   881 11BF:25F3   882 11BF:2622   884 11BF:2651
   887 11BF:2679   888 11BF:268B   889 11BF:2697   895 11BF:26A6
   900 11BF:26AF   901 11BF:26D3   903 11BF:26E7   904 11BF:26EB
   905 11BF:26F1   906 11BF:2719   907 11BF:2727   908 11BF:272A
   909 11BF:272E   910 11BF:2734   911 11BF:275C   912 11BF:275F
   913 11BF:2763   914 11BF:2769   915 11BF:2791   916 11BF:2794
   917 11BF:2798   918 11BF:279E   919 11BF:27C6   920 11BF:27C9
   921 11BF:27CD   922 11BF:27D3   923 11BF:27FB   924 11BF:27FE
   925 11BF:2802   926 11BF:2808   927 11BF:2830   928 11BF:2832
   929 11BF:2836   930 11BF:283C   931 11BF:2864   932 11BF:2866
   933 11BF:286A   934 11BF:2870   939 11BF:2898   940 11BF:28BC
   941 11BF:28CD   942 11BF:28F5   943 11BF:2906   944 11BF:292E
   945 11BF:293F   946 11BF:2967   947 11BF:298B   948 11BF:299C
   951 11BF:29C4   955 11BF:2A2E   960 11BF:2A37   961 11BF:2A51
   962 11BF:2A62   964 11BF:2A7A   965 11BF:2A8F   967 11BF:2AA7
   968 11BF:2AC1   969 11BF:2AD6   971 11BF:2AEB   972 11BF:2B13
   973 11BF:2B17   974 11BF:2B1D   977 11BF:2B20   978 11BF:2B31
   980 11BF:2B46   981 11BF:2B6E   982 11BF:2B72   983 11BF:2B78
   984 11BF:2B7B   986 11BF:2B93   987 11BF:2B97   988 11BF:2B9D
   989 11BF:2BDC   990 11BF:2C1B   991 11BF:2C43   992 11BF:2C54
   993 11BF:2C78   994 11BF:2C7B   996 11BF:2C93   997 11BF:2C97
   998 11BF:2C9D   999 11BF:2CC3  1000 11BF:2CC6  1001 11BF:2CF6
  1002 11BF:2D26  1003 11BF:2D56  1004 11BF:2D85  1006 11BF:2DB4
  1008 11BF:2DDC  1009 11BF:2DDE  1011 11BF:2DF3  1012 11BF:2E1B
  1013 11BF:2E1F  1014 11BF:2E25  1017 11BF:2E27  1018 11BF:2E4F
  1019 11BF:2E53  1022 11BF:2E59  1024 11BF:2E6C  1028 11BF:2E7F
  1030 11BF:2E88  1031 11BF:2E8E  1032 11BF:2EA0  1033 11BF:2EA7
  1036 11BF:2EB8  1037 11BF:2EEB  1041 11BF:2F13  1042 11BF:2F46
  1046 11BF:2F6E  1047 11BF:2F74  1048 11BF:2F7B  1049 11BF:2F84
  1051 11BF:2FAE  1052 11BF:2FD6  1053 11BF:2FE1  1054 11BF:2FED
  1055 11BF:2FF3  1060 11BF:2FFA  1064 11BF:3003  1065 11BF:3009
  1068 11BF:3010  1069 11BF:3016  1070 11BF:302A  1072 11BF:3031
  1075 11BF:3049  1077 11BF:3064  1079 11BF:3094  1080 11BF:3098
  1081 11BF:309E  1082 11BF:30C6  1083 11BF:30CC  1084 11BF:30D3
  1085 11BF:30EC  1086 11BF:3105  1087 11BF:311E  1090 11BF:3135
  1091 11BF:313B  1094 11BF:3142  1098 11BF:314B  1099 11BF:3165
  1100 11BF:3175  1102 11BF:318D  1103 11BF:319E  1105 11BF:31B6
  1106 11BF:31CB  1107 11BF:31CE  1108 11BF:31FE  1109 11BF:322E
  1110 11BF:325E  1111 11BF:32A1  1112 11BF:32CB  1114 11BF:32FA
  1116 11BF:3322  1118 11BF:3337  1119 11BF:3348  1120 11BF:3355
  1121 11BF:3361  1122 11BF:336D  1123 11BF:3379  1125 11BF:3383
  1126 11BF:3389  1127 11BF:338F  1130 11BF:3391  1131 11BF:3397
  1132 11BF:339C  1134 11BF:33A1  1135 11BF:33AE  1138 11BF:33BC
  1139 11BF:33C2  1142 11BF:33C6  1145 11BF:33D9  1149 11BF:33E2
  1150 11BF:33FC  1151 11BF:340C  1153 11BF:3424  1154 11BF:3435
  1156 11BF:344A  1157 11BF:344E  1158 11BF:3454  1159 11BF:3492
  1162 11BF:34BA  1166 11BF:34CD  1170 11BF:34D6  1172 11BF:34EE
  1173 11BF:34FE  1175 11BF:3516  1176 11BF:3527  1178 11BF:353F
  1179 11BF:3543  1180 11BF:3549  1181 11BF:355A  1182 11BF:358A
  1183 11BF:35B9  1184 11BF:35E8  1191 11BF:361A  1195 11BF:3620
  1197 11BF:3657  1198 11BF:365B  1199 11BF:3661  1204 11BF:3689
  1208 11BF:3692  1210 11BF:36D2  1211 11BF:36D6  1212 11BF:36DC
  1213 11BF:36EE  1214 11BF:371D  1215 11BF:374C  1217 11BF:3779
  1218 11BF:377F  1219 11BF:378C  1220 11BF:3793  1221 11BF:3796
  1222 11BF:37A1  1223 11BF:37AC  1224 11BF:37B7  1229 11BF:37C0
  1233 11BF:37C9  1234 11BF:37D0  1235 11BF:37D6  1237 11BF:37EE
  1238 11BF:37F4  1240 11BF:3809  1241 11BF:380D  1242 11BF:3813
  1243 11BF:383B  1244 11BF:3841  1245 11BF:384E  1246 11BF:385A
  1247 11BF:3866  1251 11BF:3875  1254 11BF:387C  1259 11BF:3885
  1260 11BF:389F  1261 11BF:38A6  1262 11BF:38AD  1263 11BF:38B7
  1265 11BF:38CF  1266 11BF:38E9  1267 11BF:38F0  1268 11BF:38F7
  1269 11BF:3901  1271 11BF:3927  1272 11BF:394F  1273 11BF:3953
  1276 11BF:3959  1279 11BF:396C  1283 11BF:3972  1285 11BF:3987
  1286 11BF:39AF  1287 11BF:39B3  1291 11BF:39B9  1295 11BF:39C2
  1296 11BF:39C8  1298 11BF:39CE  1300 11BF:39E6  1301 11BF:39EC
  1302 11BF:39F2  1305 11BF:3A0A  1306 11BF:3A10  1307 11BF:3A38
  1309 11BF:3A3C  1310 11BF:3A42  1311 11BF:3A49  1312 11BF:3A4C
  1313 11BF:3A7B  1314 11BF:3AAA  1315 11BF:3AD9  1316 11BF:3B08
  1317 11BF:3B3B  1318 11BF:3B6A  1319 11BF:3B9D  1320 11BF:3BCC
  1321 11BF:3BFA  1323 11BF:3C28  1326 11BF:3C50  1327 11BF:3C5D
  1329 11BF:3C67  1330 11BF:3C6D  1331 11BF:3C74  1332 11BF:3C84
  1333 11BF:3C96  1334 11BF:3C9D  1335 11BF:3CAF  1336 11BF:3CB6
  1337 11BF:3CC8  1338 11BF:3CCF  1339 11BF:3CE1  1340 11BF:3CE6
  1343 11BF:3CE8  1344 11BF:3CEE  1345 11BF:3CFF  1351 11BF:3D04
  1355 11BF:3D0D  1357 11BF:3D37  1358 11BF:3D3D  1359 11BF:3D41
  1360 11BF:3D69  1361 11BF:3D85  1365 11BF:3D8A  1371 11BF:3D93
  1372 11BF:3DAD  1373 11BF:3DBD  1375 11BF:3DD2  1376 11BF:3DE3
  1378 11BF:3E10  1379 11BF:3E20  1380 11BF:3E38  1381 11BF:3E3B
  1382 11BF:3E6B  1383 11BF:3E9B  1384 11BF:3ECB  1385 11BF:3EFB
  1386 11BF:3F30  1387 11BF:3F65  1388 11BF:3F9A  1389 11BF:3FCE
  1391 11BF:4002  1394 11BF:402D  1395 11BF:4045  1396 11BF:404D
  1397 11BF:407D  1398 11BF:40AC  1399 11BF:40DB  1402 11BF:410A
  1403 11BF:4132  1404 11BF:4136  1406 11BF:413C  1408 11BF:413E
  1412 11BF:4151  1419 11BF:415A  1420 11BF:4174  1422 11BF:4185
  1424 11BF:4199  1425 11BF:41AA  1427 11BF:41BF  1428 11BF:41CF
  1429 11BF:41D7  1430 11BF:4207  1431 11BF:4237  1432 11BF:4267
  1433 11BF:4296  1435 11BF:42C5  1437 11BF:42ED  1438 11BF:42F1
  1439 11BF:42F7  1440 11BF:4311  1441 11BF:432A  1442 11BF:4343
  1443 11BF:435C  1446 11BF:4373  1449 11BF:4386  1456 11BF:438F
  1457 11BF:43A9  1458 11BF:43C3  1459 11BF:43C9  1461 11BF:43D9
  1462 11BF:43FD  1464 11BF:4408  1465 11BF:4419  1466 11BF:4424
  1467 11BF:4427  1468 11BF:4457  1469 11BF:4486  1471 11BF:44B5
  1473 11BF:44DD  1474 11BF:44E1  1476 11BF:44E7  1477 11BF:44FA
  1480 11BF:450D  1482 11BF:4513  1485 11BF:453B  1500 11BF:457C
  1503 11BF:45C7  1505 11BF:45E6  1506 11BF:45EA  1509 11BF:4634
  1511 11BF:463D  1512 11BF:4642  1513 11BF:4647  1515 11BF:4654
  1516 11BF:465B  1517 11BF:465E  1518 11BF:4669  1519 11BF:4674
  1520 11BF:467F  1522 11BF:468A  1524 11BF:468F  1531 11BF:46DA
  1533 11BF:46ED  1552 11BF:46F6  1553 11BF:4705  1554 11BF:470B
  1555 11BF:4710  1556 11BF:4716  1557 11BF:4723  1558 11BF:4751
  1559 11BF:475B  1561 11BF:477C  1562 11BF:478B  1563 11BF:478E
  1565 11BF:4792  1566 11BF:47C3  1567 11BF:47C6  1569 11BF:47CA
  1570 11BF:47CE  1571 11BF:480D  1572 11BF:4810  1574 11BF:4817
  1575 11BF:481B  1576 11BF:4820  1577 11BF:482F  1578 11BF:4835
  1580 11BF:483C  1581 11BF:486E  1582 11BF:4872  1583 11BF:4881
  1584 11BF:4883  1585 11BF:4894  1587 11BF:48A9  1590 11BF:48BC

Line numbers for DetectTime(DETECTTIME.PAS) segment DetectTime

    75 164C:0000    76 164C:000A    77 164C:000B    78 164C:000F
    79 164C:0013    80 164C:0017    81 164C:0018

Line numbers for DetectGlobal(DETECTGLOBAL.PAS) segment DetectGlobal

   227 164E:0000   228 164E:000E   229 164E:0026   230 164E:0039
   237 164E:003F   238 164E:004D   239 164E:0067   240 164E:007A

Line numbers for DetectGlobal(DETECTGL.ASM) segment DetectGlobal

   189 164E:0080   190 164E:0081   191 164E:0083   192 164E:0084
   194 164E:0087   195 164E:008B   196 164E:008D   197 164E:0090
   199 164E:0093   200 164E:0097   201 164E:0099   203 164E:009C
   204 164E:00A0   205 164E:00A2   207 164E:00A5   208 164E:00A6
   209 164E:00A7   215 164E:00AA   216 164E:00AD   217 164E:00B1
   227 164E:00B5   228 164E:00B6   229 164E:00B9   230 164E:00BB
   231 164E:00BF   232 164E:00C3   236 164E:00C4   237 164E:00C5
   238 164E:00C8   239 164E:00CB   240 164E:00CD   241 164E:00D0
   242 164E:00D2   246 164E:00D3   247 164E:00D4   248 164E:00D5
   249 164E:00D8   250 164E:00D9   251 164E:00DA   255 164E:00DB
   260 164E:00DC   261 164E:00DD   262 164E:00E0   263 164E:00E4
   264 164E:00E6   265 164E:00E7   280 164E:00E8   281 164E:00E9
   282 164E:00EA   283 164E:00ED   284 164E:00EF   285 164E:00F1
   286 164E:00F5   288 164E:00F7   290 164E:00FB   291 164E:00FC
   292 164E:00FD   293 164E:0100   294 164E:0101   296 164E:0102
   297 164E:0103   306 164E:0104   307 164E:0108   321 164E:0109
   322 164E:010C   323 164E:010E   324 164E:0114   325 164E:0118
   326 164E:011C   327 164E:0122   328 164E:0126   329 164E:012A
   331 164E:012C   333 164E:0130   366 164E:0131   367 164E:0132
   368 164E:0134   369 164E:0137   370 164E:0139   371 164E:013B
   372 164E:013D   373 164E:0140   378 164E:0142   379 164E:0143
   380 164E:0144   381 164E:0147   382 164E:0149   383 164E:014B
   384 164E:014D   385 164E:014E   386 164E:014F   387 164E:0150
   388 164E:0153   389 164E:0158   390 164E:0159   393 164E:015B
   394 164E:015E   395 164E:0161   396 164E:0165   397 164E:0168
   398 164E:016C   399 164E:016F   400 164E:0173   401 164E:0176
   402 164E:017A   403 164E:017E   404 164E:0181   405 164E:0184
   407 164E:0185   409 164E:0187   410 164E:018A   411 164E:018D
   412 164E:0190   413 164E:0191   414 164E:0194   415 164E:0196
   416 164E:0197   417 164E:0198   418 164E:0199   419 164E:019B
   422 164E:019D   423 164E:019E   439 164E:01A1   440 164E:01A2
   441 164E:01A4   442 164E:01A7   443 164E:01AA   444 164E:01AB
   445 164E:01AC   446 164E:01AD   447 164E:01AE   448 164E:01AF
   449 164E:01B1   450 164E:01B2   482 164E:01B5   483 164E:01B8
   484 164E:01BD   485 164E:01C2   486 164E:01C3   487 164E:01C4
   488 164E:01C5   489 164E:01C6   490 164E:01C8   491 164E:01C9
   492 164E:01CB   493 164E:01CC   494 164E:01CE   495 164E:01CF
   496 164E:01D1   497 164E:01D2   498 164E:01D3   499 164E:01D4
   500 164E:01D6   501 164E:01D7   502 164E:01D8   503 164E:01D9
   504 164E:01DB   505 164E:01DC   506 164E:01DF   507 164E:01E0
   508 164E:01E2   509 164E:01E3   510 164E:01E4   511 164E:01E7
   512 164E:01E9   513 164E:01EA   514 164E:01EB   515 164E:01EC
   516 164E:01ED   517 164E:01EE   520 164E:01F1   521 164E:01F2
   522 164E:01F3   523 164E:01F4   524 164E:01F9   525 164E:01FE
   526 164E:01FF   527 164E:0200   528 164E:0202   529 164E:0203
   530 164E:0205   531 164E:0206   532 164E:0208   533 164E:0209
   534 164E:020B   535 164E:020C   536 164E:020E   537 164E:020F
   538 164E:0210   539 164E:0211   540 164E:0213   541 164E:0214
   542 164E:0215   543 164E:0216   544 164E:0217   545 164E:0218
   546 164E:0219   547 164E:021A   550 164E:021D   551 164E:021E
   552 164E:0220   553 164E:0221   554 164E:0224   555 164E:0228
   569 164E:022E   570 164E:022F   571 164E:0230   572 164E:0231
   573 164E:0232   574 164E:0234   575 164E:0235   576 164E:0236
   577 164E:0237   578 164E:0238   579 164E:0239   589 164E:023B
   590 164E:023E   591 164E:023F   592 164E:0241   593 164E:0243
   594 164E:0245   595 164E:0246   596 164E:0247   597 164E:0249
   598 164E:024B   599 164E:024D   600 164E:024E   601 164E:024F
   602 164E:0251   603 164E:0253   604 164E:0255   605 164E:0256
   606 164E:0258   608 164E:025A   610 164E:025C   619 164E:025D
   620 164E:0260   621 164E:0262   622 164E:0263   623 164E:0264
   624 164E:0265   625 164E:0267   626 164E:0269   627 164E:026B
   629 164E:026D   640 164E:026E   641 164E:0274   642 164E:027A
   643 164E:0280   644 164E:0282   649 164E:0284   651 164E:0289
   653 164E:028F   654 164E:0291   655 164E:0293   657 164E:0295
   667 164E:0296   669 164E:0298   670 164E:029E   671 164E:02A4
   672 164E:02A7   673 164E:02AB   674 164E:02AD   675 164E:02B3
   676 164E:02B5   678 164E:02B7   681 164E:02B9   689 164E:02BA
   690 164E:02BD   691 164E:02C1   692 164E:02C3   693 164E:02C7
   694 164E:02C9   695 164E:02CB   696 164E:02CD   697 164E:02CF
   698 164E:02D1   699 164E:02D4   700 164E:02D6   701 164E:02D8
   702 164E:02D9   703 164E:02DB   704 164E:02DD   707 164E:02DF
   751 164E:02E0   752 164E:02E1   753 164E:02E3   754 164E:02E6
   755 164E:02E7   757 164E:02E8   758 164E:02E9   759 164E:02EA
   760 164E:02EC   761 164E:02EF   762 164E:02F1   763 164E:02F3
   764 164E:02F6   765 164E:02F8   767 164E:02FA   770 164E:0304
   771 164E:0494   772 164E:04A2   773 164E:04A5   775 164E:04A8
   777 164E:04AA   778 164E:04AD   779 164E:04B0   780 164E:04B1
   781 164E:04B2   782 164E:04B4   783 164E:04B6   784 164E:04B9
   785 164E:04BB   786 164E:04BD   787 164E:04BF   788 164E:04C0
   789 164E:04C1   790 164E:04C3   791 164E:04C4   792 164E:04C5
   793 164E:04C8   794 164E:04C9   795 164E:04CA   796 164E:04CB
   797 164E:04CC   798 164E:04CF   799 164E:04D2   800 164E:04D4
   801 164E:04D6   802 164E:04D8   808 164E:04DA   809 164E:04DB
   810 164E:04DC   811 164E:04DD   812 164E:04DF   813 164E:04E0
   814 164E:04E1   815 164E:04E4   816 164E:04E7   817 164E:04E8
   818 164E:04EA   819 164E:04EE   821 164E:04F0   822 164E:04F1
   823 164E:04F2   825 164E:04F3   826 164E:04F5   827 164E:04F6
   828 164E:04F8   829 164E:04FA   830 164E:04FC   831 164E:04FF
   832 164E:0503   833 164E:0505   834 164E:0507   835 164E:0509
   836 164E:050C   837 164E:050D   838 164E:050E   839 164E:050F
   840 164E:0510   841 164E:0511   842 164E:0514   843 164E:0516
   844 164E:0519   845 164E:051A   846 164E:051B   847 164E:051C
   848 164E:051F   849 164E:0521   850 164E:0522   851 164E:0523
   852 164E:0526   853 164E:0528   854 164E:052B   855 164E:052D
   856 164E:052F   857 164E:0530   858 164E:0531   859 164E:0533
   860 164E:0535   861 164E:0537   862 164E:053B   863 164E:053D
   866 164E:0540   867 164E:0543   868 164E:0547   869 164E:0549
   870 164E:054B   871 164E:054E   872 164E:0554   873 164E:0556
   874 164E:0558   875 164E:055A   876 164E:055C   877 164E:055F
   878 164E:0561   879 164E:0563   880 164E:0566   881 164E:0569
   882 164E:056B   883 164E:056C   884 164E:0572   885 164E:0578
   886 164E:057B   887 164E:0581   888 164E:0587   889 164E:0589
   890 164E:058B   891 164E:0590   892 164E:0593   893 164E:0595
   894 164E:0598   895 164E:059A   896 164E:059C   897 164E:059D
   898 164E:05A1   899 164E:05A3   901 164E:05A6   902 164E:05A9
   903 164E:05AB   904 164E:05AC   905 164E:05AD   906 164E:05B0
   907 164E:05B3   908 164E:05B6   909 164E:05B9   910 164E:05BB
   911 164E:05BC   912 164E:05BD   913 164E:05C0   914 164E:05C3
   915 164E:05C7   916 164E:05CA   917 164E:05CE   918 164E:05D0
   919 164E:05D2   920 164E:05D6   921 164E:05D9   922 164E:05DC
   925 164E:05E6   926 164E:0622   927 164E:0630   928 164E:0633
   929 164E:0636   930 164E:0638   931 164E:063C   932 164E:063E
   933 164E:0641   934 164E:0643   935 164E:0645   936 164E:0647
   937 164E:0649   938 164E:064C   939 164E:0652   940 164E:0654
   941 164E:0656   942 164E:0658   943 164E:065A   944 164E:065C
   945 164E:065E   946 164E:0661   947 164E:0665   949 164E:066D
   950 164E:0671   951 164E:0675   952 164E:0677   953 164E:067B
   955 164E:067D   956 164E:067F   957 164E:0681   958 164E:0683
   959 164E:0685   960 164E:0688   961 164E:068A   962 164E:068D
   963 164E:0690   964 164E:0693   965 164E:0696   966 164E:0699
   967 164E:069B   968 164E:069E   969 164E:06A3   970 164E:06A5
   971 164E:06A7   972 164E:06AA   973 164E:06AC   974 164E:06AF
   975 164E:06B1   976 164E:06B3   977 164E:06B6   978 164E:06B9
   979 164E:06BC   980 164E:06BE   981 164E:06C0   982 164E:06C1
   983 164E:06C3   984 164E:06C4   985 164E:06C6   986 164E:06C7
   987 164E:06C9   988 164E:06CA   989 164E:06CC   990 164E:06CD
   991 164E:06CF   992 164E:06D0   993 164E:06D4   994 164E:06D7
   995 164E:06D8   996 164E:06DA   997 164E:06DD   998 164E:06DF
   999 164E:06E1  1000 164E:06E3  1001 164E:06E6  1002 164E:06E8
  1003 164E:06EA  1004 164E:06EC  1005 164E:06EF  1006 164E:06F1
  1007 164E:06F3  1008 164E:06F5  1009 164E:06F8  1010 164E:06FA
  1011 164E:06FC  1012 164E:06FE  1013 164E:0701  1014 164E:0703
  1015 164E:0705  1016 164E:0708  1017 164E:070A  1018 164E:070D
  1019 164E:070F  1020 164E:0714  1021 164E:0716  1022 164E:0718
  1023 164E:071A  1024 164E:071C  1025 164E:071F  1026 164E:0721
  1027 164E:0724  1028 164E:0726  1029 164E:0728  1030 164E:072D
  1031 164E:0732  1032 164E:0734  1033 164E:0736  1034 164E:0739
  1035 164E:073B  1036 164E:073D  1037 164E:073F  1038 164E:0740
  1039 164E:0744  1040 164E:0746  1041 164E:074A  1042 164E:074C
  1043 164E:074F  1044 164E:0751  1045 164E:0753  1046 164E:0758
  1047 164E:075A  1048 164E:075C  1049 164E:075E  1050 164E:0761
  1051 164E:0762  1052 164E:0766  1053 164E:0768  1054 164E:076B
  1055 164E:076F  1056 164E:0772  1057 164E:0776  1058 164E:0777
  1059 164E:077B  1060 164E:077D  1061 164E:077F  1062 164E:0781
  1063 164E:0784  1064 164E:0786  1065 164E:0788  1066 164E:078A
  1067 164E:078C  1068 164E:078E  1069 164E:0790  1070 164E:0791
  1071 164E:0793  1072 164E:0796  1073 164E:0798  1074 164E:079B
  1075 164E:079D  1076 164E:079F  1077 164E:07A1  1078 164E:07A3
  1079 164E:07A5  1080 164E:07A7  1081 164E:07A9  1082 164E:07AB
  1083 164E:07AD  1084 164E:07AF  1085 164E:07B2  1086 164E:07B3
  1087 164E:07B5  1088 164E:07B8  1089 164E:07BA  1090 164E:07BD
  1091 164E:07BF  1092 164E:07C1  1093 164E:07C3  1094 164E:07C5
  1095 164E:07C7  1096 164E:07C9  1097 164E:07CB  1098 164E:07CD
  1099 164E:07D0  1100 164E:07D2  1101 164E:07D4  1102 164E:07D6
  1103 164E:07D8  1104 164E:07DB  1105 164E:07DF  1106 164E:07E1
  1107 164E:07E4  1108 164E:07E7  1109 164E:07E9  1117 164E:080B
  1118 164E:080D  1119 164E:080F  1120 164E:0811  1121 164E:0813
  1122 164E:0816  1123 164E:0818  1124 164E:0822  1125 164E:0824
  1126 164E:0826  1127 164E:0829  1128 164E:082B  1129 164E:0839
  1130 164E:083C  1132 164E:083F  1133 164E:0841  1134 164E:0843
  1135 164E:0846  1136 164E:0848  1137 164E:0852  1138 164E:0855
  1139 164E:0857  1140 164E:0865  1141 164E:0868  1143 164E:086B
  1144 164E:086E  1145 164E:0871  1146 164E:0873  1147 164E:0875
  1148 164E:0877  1149 164E:0879  1150 164E:087B  1151 164E:087E
  1152 164E:0881  1153 164E:088B  1154 164E:088D  1155 164E:088F
  1156 164E:0892  1157 164E:0895  1158 164E:08A3  1159 164E:08A6
  1161 164E:08A9  1162 164E:08AC  1163 164E:08AE  1165 164E:08B1
  1166 164E:08B2  1167 164E:08B4  1168 164E:08B6  1169 164E:08B7
  1170 164E:08B9  1171 164E:08BB  1172 164E:08BD  1173 164E:08C0
  1174 164E:08C3  1175 164E:08C5  1177 164E:08C8  1178 164E:08CC
  1179 164E:08CE  1180 164E:08D0  1181 164E:08D3  1182 164E:08D5
  1183 164E:08D7  1184 164E:08D9  1185 164E:08DB  1186 164E:08DD
  1187 164E:08E0  1188 164E:08E2  1189 164E:08E5  1190 164E:08E8
  1191 164E:08EB  1192 164E:08F5  1193 164E:08F8  1194 164E:08FB
  1195 164E:08FD  1196 164E:08FF  1197 164E:0901  1198 164E:0904
  1199 164E:0907  1200 164E:0915  1201 164E:0918  1202 164E:091B
  1203 164E:091D  1204 164E:091F  1205 164E:0921  1207 164E:0923
  1208 164E:0927  1209 164E:0929  1210 164E:0933  1211 164E:0935
  1212 164E:0937  1213 164E:0939  1214 164E:093C  1215 164E:093F
  1216 164E:0941  1217 164E:0944  1218 164E:0949  1219 164E:094E
  1220 164E:0952  1221 164E:0956  1222 164E:095B  1223 164E:095E
  1224 164E:0960  1225 164E:0962  1226 164E:0964  1227 164E:0966
  1228 164E:0968  1229 164E:096A  1230 164E:096C  1231 164E:096E
  1232 164E:0970  1233 164E:0972  1234 164E:0974  1235 164E:0977
  1236 164E:097A  1237 164E:097D  1238 164E:0981  1239 164E:0983
  1240 164E:0986  1241 164E:0988  1242 164E:0996  1243 164E:0999
  1245 164E:099C  1247 164E:09A0  1249 164E:09A2  1250 164E:09A5
  1251 164E:09AF  1252 164E:09B2  1253 164E:09B4  1254 164E:09C2
  1255 164E:09C5  1257 164E:09C8  1258 164E:09CC  1259 164E:09CE
  1260 164E:09D8  1261 164E:09DB  1262 164E:09DE  1263 164E:09E1
  1264 164E:09E4  1265 164E:09E6  1266 164E:09E7  1267 164E:09E9
  1268 164E:09F7  1269 164E:09FA  1271 164E:09FD  1272 164E:0A01
  1273 164E:0A03  1274 164E:0A0D  1275 164E:0A10  1276 164E:0A12
  1277 164E:0A14  1278 164E:0A16  1279 164E:0A18  1280 164E:0A1A
  1281 164E:0A1C  1282 164E:0A1F  1283 164E:0A21  1284 164E:0A23
  1285 164E:0A31  1286 164E:0A34  1289 164E:0A37  1290 164E:0A3A
  1291 164E:0A3E  1292 164E:0A40  1293 164E:0A43  1294 164E:0A44
  1295 164E:0A46  1296 164E:0A47  1297 164E:0A49  1301 164E:0A53
  1302 164E:0ACB  1303 164E:0ACC  1304 164E:0ADA  1305 164E:0ADD
  1307 164E:0AE0  1308 164E:0AE2  1309 164E:0AE4  1313 164E:0AEE
  1314 164E:0B66  1315 164E:0B74  1316 164E:0B77  1317 164E:0B7A
  1318 164E:0B7C  1319 164E:0B7F  1320 164E:0B81  1321 164E:0B84
  1322 164E:0B86  1323 164E:0B89  1324 164E:0B8B  1326 164E:0B8D
  1327 164E:0B8F  1328 164E:0B92  1329 164E:0B94  1330 164E:0B95
  1331 164E:0B96  1332 164E:0B99  1333 164E:0B9B  1334 164E:0BA1
  1335 164E:0BA2  1336 164E:0BA3  1337 164E:0BA5  1338 164E:0BA9
  1339 164E:0BAB  1341 164E:0BAE  1342 164E:0BB1  1344 164E:0BB3
  1345 164E:0BB4  1346 164E:0BB5  1347 164E:0BB7  1348 164E:0BB8
  1354 164E:0BBB  1355 164E:0BBD  1356 164E:0BBF  1357 164E:0BC1
  1358 164E:0BC3  1359 164E:0BC5  1360 164E:0BC7  1361 164E:0BCA
  1362 164E:0BCC  1363 164E:0BCE  1364 164E:0BD0  1365 164E:0BDA
  1366 164E:0BDD  1367 164E:0BEB  1372 164E:0BEC  1373 164E:0BEE
  1374 164E:0BF0  1375 164E:0BF2  1376 164E:0BF4  1377 164E:0BF6
  1378 164E:0BF8  1379 164E:0BFA  1380 164E:0BFC  1381 164E:0BFE
  1382 164E:0C00  1383 164E:0C0A  1384 164E:0C0C  1385 164E:0C1A
  1390 164E:0C1B  1391 164E:0C1D  1392 164E:0C1F  1393 164E:0C21
  1394 164E:0C23  1395 164E:0C25  1396 164E:0C27  1397 164E:0C2A
  1398 164E:0C2D  1399 164E:0C2F  1400 164E:0C32  1401 164E:0C34
  1402 164E:0C36  1403 164E:0C39  1404 164E:0C3C  1405 164E:0C3E
  1406 164E:0C40  1407 164E:0C43  1408 164E:0C4D  1409 164E:0C50
  1410 164E:0C52  1411 164E:0C55  1412 164E:0C57  1413 164E:0C59
  1414 164E:0C5C  1415 164E:0C5F  1416 164E:0C6D  1421 164E:0C6E
  1422 164E:0C70  1423 164E:0C72  1424 164E:0C74  1425 164E:0C76
  1426 164E:0C78  1427 164E:0C7A  1428 164E:0C7D  1429 164E:0C80
  1430 164E:0C82  1431 164E:0C85  1432 164E:0C87  1433 164E:0C89
  1434 164E:0C8C  1435 164E:0C8F  1436 164E:0C91  1437 164E:0C94
  1438 164E:0C96  1439 164E:0C98  1440 164E:0C9B  1441 164E:0C9E
  1442 164E:0CA0  1443 164E:0CA3  1444 164E:0CA5  1445 164E:0CA7
  1446 164E:0CAA  1447 164E:0CAD  1448 164E:0CAF  1449 164E:0CB1
  1450 164E:0CB4  1451 164E:0CBE  1452 164E:0CC1  1453 164E:0CC3
  1454 164E:0CC6  1455 164E:0CC8  1456 164E:0CCA  1457 164E:0CCD
  1458 164E:0CD0  1459 164E:0CD2  1460 164E:0CD5  1461 164E:0CD7
  1462 164E:0CD9  1463 164E:0CDC  1464 164E:0CDF  1465 164E:0CE1
  1466 164E:0CE4  1467 164E:0CE6  1468 164E:0CE8  1469 164E:0CEB
  1470 164E:0CEE  1471 164E:0CFC  1476 164E:0CFD  1477 164E:0CFF
  1478 164E:0D01  1479 164E:0D03  1480 164E:0D05  1481 164E:0D07
  1482 164E:0D09  1483 164E:0D0C  1484 164E:0D0F  1485 164E:0D11
  1486 164E:0D14  1487 164E:0D16  1488 164E:0D18  1489 164E:0D1B
  1490 164E:0D1E  1491 164E:0D20  1492 164E:0D23  1493 164E:0D25
  1494 164E:0D27  1495 164E:0D2A  1496 164E:0D2D  1497 164E:0D2F
  1498 164E:0D32  1499 164E:0D34  1500 164E:0D36  1501 164E:0D39
  1502 164E:0D3C  1503 164E:0D3E  1504 164E:0D41  1505 164E:0D43
  1506 164E:0D45  1507 164E:0D48  1508 164E:0D4B  1509 164E:0D4D
  1510 164E:0D50  1511 164E:0D52  1512 164E:0D54  1513 164E:0D57
  1514 164E:0D5A  1515 164E:0D5C  1516 164E:0D5F  1517 164E:0D61
  1518 164E:0D63  1519 164E:0D66  1520 164E:0D69  1521 164E:0D6B
  1522 164E:0D6E  1523 164E:0D70  1524 164E:0D72  1525 164E:0D75
  1526 164E:0D78  1527 164E:0D7A  1528 164E:0D7C  1529 164E:0D7F
  1530 164E:0D89  1531 164E:0D8C  1532 164E:0D8E  1533 164E:0D91
  1534 164E:0D93  1535 164E:0D95  1536 164E:0D98  1537 164E:0D9B
  1538 164E:0D9D  1539 164E:0DA0  1540 164E:0DA2  1541 164E:0DA4
  1542 164E:0DA7  1543 164E:0DAA  1544 164E:0DAC  1545 164E:0DAF
  1546 164E:0DB1  1547 164E:0DB3  1548 164E:0DB6  1549 164E:0DB9
  1550 164E:0DBB  1551 164E:0DBE  1552 164E:0DC0  1553 164E:0DC2
  1554 164E:0DC5  1555 164E:0DC8  1556 164E:0DCA  1557 164E:0DCD
  1558 164E:0DCF  1559 164E:0DD1  1560 164E:0DD4  1561 164E:0DD7
  1562 164E:0DD9  1563 164E:0DDC  1564 164E:0DDE  1565 164E:0DE0
  1566 164E:0DE3  1567 164E:0DE6  1568 164E:0DE8  1569 164E:0DEB
  1570 164E:0DED  1571 164E:0DEF  1572 164E:0DF2  1573 164E:0DF5
  1574 164E:0E03  1578 164E:0E04  1579 164E:0E05  1580 164E:0E06
  1581 164E:0E07  1582 164E:0E08  1583 164E:0E0A  1584 164E:0E0C
  1585 164E:0E0E  1586 164E:0E10  1587 164E:0E13  1588 164E:0E16
  1589 164E:0E19  1590 164E:0E1E  1591 164E:0E21  1592 164E:0E24
  1593 164E:0E27  1594 164E:0E2C  1595 164E:0E2F  1596 164E:0E32
  1597 164E:0E35  1598 164E:0E3A  1599 164E:0E3D  1600 164E:0E40
  1601 164E:0E43  1602 164E:0E48  1603 164E:0E4B  1604 164E:0E4E
  1605 164E:0E51  1606 164E:0E56  1607 164E:0E59  1608 164E:0E5C
  1609 164E:0E5F  1610 164E:0E64  1611 164E:0E67  1612 164E:0E6A
  1613 164E:0E6D  1614 164E:0E72  1615 164E:0E75  1616 164E:0E78
  1617 164E:0E7D  1618 164E:0E80  1619 164E:0E83  1620 164E:0E88
  1621 164E:0E8B  1622 164E:0E8E  1623 164E:0E93  1624 164E:0E95
  1625 164E:0E98  1626 164E:0E99  1627 164E:0E9A  1631 164E:0E9B
  1632 164E:0E9C  1633 164E:0E9D  1634 164E:0E9E  1635 164E:0E9F
  1636 164E:0EA2  1637 164E:0EA4  1638 164E:0EA6  1639 164E:0EA8
  1640 164E:0EAA  1641 164E:0EAD  1642 164E:0EB0  1643 164E:0EB5
  1644 164E:0EB8  1645 164E:0EBB  1646 164E:0EBE  1647 164E:0EC3
  1648 164E:0EC6  1649 164E:0EC9  1650 164E:0ECC  1651 164E:0ED1
  1652 164E:0ED4  1653 164E:0ED7  1654 164E:0EDA  1655 164E:0EDF
  1656 164E:0EE2  1657 164E:0EE5  1658 164E:0EE8  1659 164E:0EED
  1660 164E:0EF0  1661 164E:0EF3  1662 164E:0EF6  1663 164E:0EFB
  1664 164E:0EFE  1665 164E:0F01  1666 164E:0F04  1667 164E:0F09
  1668 164E:0F0B  1669 164E:0F0E  1670 164E:0F0F  1671 164E:0F10
  1695 164E:0F25  1696 164E:0F26  1697 164E:0F28  1698 164E:0F29
  1699 164E:0F2A  1700 164E:0F2B  1701 164E:0F2E  1702 164E:0F31
  1703 164E:0F34  1704 164E:0F37  1705 164E:0F3A  1706 164E:0F3D
  1707 164E:0F40  1708 164E:0F43  1709 164E:0F46  1710 164E:0F49
  1711 164E:0F4C  1712 164E:0F4F  1713 164E:0F51  1714 164E:0F54
  1715 164E:0F56  1716 164E:0F59  1717 164E:0F5D  1718 164E:0F5F
  1719 164E:0F62  1720 164E:0F66  1721 164E:0F68  1722 164E:0F6A
  1723 164E:0F6D  1724 164E:0F6F  1725 164E:0F71  1726 164E:0F73
  1727 164E:0F76  1728 164E:0F78  1729 164E:0F7A  1730 164E:0F7C
  1731 164E:0F7E  1732 164E:0F80  1733 164E:0F82  1734 164E:0F84
  1735 164E:0F86  1736 164E:0F88  1737 164E:0F8A  1738 164E:0F8C
  1739 164E:0F8E  1740 164E:0F90  1741 164E:0F93  1742 164E:0F96
  1743 164E:0F98  1744 164E:0F9A  1745 164E:0F9C  1749 164E:0F9F
  1750 164E:0FA1  1751 164E:0FA3  1752 164E:0FA5  1753 164E:0FA7
  1754 164E:0FA8  1755 164E:0FAB  1756 164E:0FAD  1757 164E:0FAF
  1758 164E:0FB2  1759 164E:0FB3  1760 164E:0FB6  1762 164E:0FB8
  1763 164E:0FB9  1764 164E:0FBA  1765 164E:0FBB  1766 164E:0FBC
  1806 164E:0FBF  1807 164E:0FC0  1808 164E:0FC2  1810 164E:0FC3
  1811 164E:0FC6  1812 164E:0FC9  1813 164E:0FCB  1814 164E:0FCE
  1816 164E:0FCF  1817 164E:0FD2  1818 164E:0FD4  1819 164E:0FD6
  1821 164E:0FD8  1822 164E:0FDB  1823 164E:0FDD  1825 164E:0FE0
  1826 164E:0FE3  1827 164E:0FE6  1828 164E:0FE9  1829 164E:0FEC
  1830 164E:0FEF  1831 164E:0FF2  1832 164E:0FF5  1834 164E:0FF8
  1835 164E:0FFA  1836 164E:0FFC  1837 164E:0FFE  1838 164E:1000
  1839 164E:1002  1840 164E:1005  1841 164E:1007  1842 164E:1009
  1843 164E:100C  1844 164E:100E  1845 164E:1010  1846 164E:1013
  1848 164E:1016  1849 164E:1019  1850 164E:101B  1851 164E:101E
  1852 164E:1020  1853 164E:1022  1854 164E:1025  1855 164E:1027
  1856 164E:1029  1857 164E:102C  1858 164E:102E  1859 164E:1030
  1860 164E:1033  1862 164E:1036  1863 164E:1039  1864 164E:103B
  1865 164E:103E  1866 164E:1040  1867 164E:1042  1868 164E:1045
  1869 164E:1047  1870 164E:1049  1871 164E:104C  1872 164E:104E
  1873 164E:1050  1874 164E:1053  1876 164E:1056  1877 164E:1059
  1878 164E:105B  1879 164E:105E  1880 164E:1060  1881 164E:1063
  1882 164E:1065  1883 164E:1068  1884 164E:106A  1885 164E:106C
  1886 164E:106E  1887 164E:1070  1888 164E:1073  1890 164E:1076
  1891 164E:1079  1892 164E:107A  1893 164E:107C  1895 164E:107F
  1896 164E:1081  1897 164E:1083  1898 164E:1084  1899 164E:1085
  1934 164E:1088  1935 164E:1089  1936 164E:108B  1937 164E:108C
  1938 164E:108F  1939 164E:1093  1940 164E:1096  1942 164E:109B
  1943 164E:109E  1944 164E:10A2  1945 164E:10A6  1946 164E:10AA
  1947 164E:10AE  1948 164E:10B2  1949 164E:10B6  1950 164E:10BA
  1952 164E:10BF  1953 164E:10C3  1954 164E:10C7  1955 164E:10CB
  1956 164E:10CF  1957 164E:10D3  1958 164E:10D7  1959 164E:10DB
  1963 164E:10DF  1964 164E:10E2  1966 164E:10E5  1967 164E:10E7
  1968 164E:10E9  1970 164E:10EB  1973 164E:10F0  1974 164E:10F3
  1975 164E:10F6  1976 164E:10F9  1977 164E:10FC  1978 164E:10FF
  1979 164E:1102  1980 164E:1105  1982 164E:110A  1983 164E:110B
  1984 164E:110D  1986 164E:110F  1987 164E:1112  1988 164E:1115
  1989 164E:1118  1990 164E:111B  1991 164E:111E  1992 164E:1121
  1994 164E:1124  1995 164E:1126  1996 164E:1128  1997 164E:112A
  1999 164E:112D  2000 164E:1130  2001 164E:1131  2002 164E:1132
  2007 164E:1135  2008 164E:1136  2009 164E:1138  2010 164E:1139
  2011 164E:113C  2012 164E:113F  2013 164E:1141  2014 164E:1143
  2016 164E:1145  2017 164E:1146  2018 164E:114B  2019 164E:1150
  2020 164E:1155  2021 164E:115A  2022 164E:115B  2023 164E:115D
  2024 164E:115F  2025 164E:1161  2026 164E:1163  2027 164E:1165
  2028 164E:1167  2029 164E:1169  2030 164E:116C  2031 164E:116E
  2032 164E:1175  2033 164E:117A  2034 164E:117C  2037 164E:117E
  2039 164E:1180  2040 164E:1181  2041 164E:1186  2042 164E:118B
  2043 164E:1190  2044 164E:1195  2045 164E:1197  2047 164E:1198
  2048 164E:119A  2049 164E:119C  2050 164E:119E  2051 164E:119F
  2052 164E:11A0  2063 164E:11A9  2064 164E:11AA  2065 164E:11AC
  2067 164E:11AD  2068 164E:11AF  2069 164E:11B1  2070 164E:11B4
  2071 164E:11BA  2072 164E:11BC  2073 164E:11BE  2074 164E:11C0
  2075 164E:11C2  2076 164E:11C5  2077 164E:11C7  2078 164E:11CB
  2080 164E:11CD  2081 164E:11CE  2082 164E:11CF  2096 164E:11D2
  2097 164E:11D3  2098 164E:11D5  2100 164E:11D6  2102 164E:11DC
  2103 164E:11E0  2105 164E:11E4  2106 164E:11E5  2107 164E:11E6

Line numbers for topb_datastructures(TOPB_DATASTRUCTURES.PAS) segment topb_datastructures

   109 176D:0008   110 176D:008E   112 176D:009B   113 176D:00AA
   114 176D:00B4   115 176D:00BB   116 176D:00C2   117 176D:00C9
   118 176D:00D0   119 176D:00DE   120 176D:00ED   121 176D:00FC
   122 176D:0114   123 176D:0128   124 176D:0137   125 176D:0146
   126 176D:0157   127 176D:015E   128 176D:016D   129 176D:017C
   132 176D:0187   134 176D:0191   135 176D:01A1   136 176D:01B1
   137 176D:01C1   138 176D:01D1   139 176D:01E1   140 176D:01F1
   142 176D:0201   143 176D:020E   147 176D:021B   148 176D:0241
   150 176D:0250   151 176D:0257   152 176D:026B   153 176D:0280
   156 176D:0286   159 176D:02CA   162 176D:030E   165 176D:0352
   168 176D:0396   171 176D:03DA   174 176D:041E   178 176D:0462
   179 176D:0470   189 176D:04FE   231 176D:050A   232 176D:0518
   233 176D:051B   235 176D:0532   237 176D:053B   241 176D:0549
   242 176D:0565   243 176D:056D   244 176D:0589   246 176D:0590
   247 176D:05AA   248 176D:05B1   249 176D:05CB   251 176D:05D2
   252 176D:05E2   253 176D:05E9   254 176D:05F9   255 176D:0600
   256 176D:0605   264 176D:060E   265 176D:0618   266 176D:062C
   268 176D:0630   269 176D:063E   270 176D:0646   271 176D:0658
   274 176D:0684   279 176D:0690   280 176D:069A   281 176D:06A4
   282 176D:06B1   300 176D:06BC   301 176D:06CA   302 176D:06E3
   303 176D:06EA   304 176D:0703   305 176D:070A   306 176D:070F

Line numbers for m6845ctl(M6845CTL.PAS) segment m6845ctl

   251 17DF:0000   252 17DF:0002   253 17DF:0004   254 17DF:0006
   255 17DF:0008   256 17DF:000A   360 17DF:000B   362 17DF:0015
   363 17DF:0020

Program entry point at 0000:5E3F
