/* the file is to contain some system-specific code */
#include "sysup.h"
#include "modern.h"
#include <errno.h>
#include <stdio.h>
#ifdef MSDOS
#	include <dos.h>
#	include <stdlib.h>
#	include <string.h>
#else
	extern char *malloc();
#endif
#ifndef __TURBOC__
#	include <sys/types.h>
#endif
#include <sys/stat.h>
#include "define.h"

#ifdef UNIX
#	ifndef RMKDIR
int bincall(name, args)
char *name, *args;
{
   extern int fork(), execl(), wait();
   char b[24];
   int i;

   if (fork() == 0) {
      (void)execl(strcat(strcpy(b, "/bin/"),     name), name, args, 0);
      (void)execl(strcat(strcpy(b, "/usr/bin/"), name), name, args, 0);
      exit(-1); /* return to parent */
   } else {
      (void)wait(&i);
   }
   return i>>8;
}
#	endif
#endif

#ifdef MSDOS
int mapumode(umode) /* UNIX file mode to DOS attributes */
{
   register mask = 0;
   if (0 == (umode & 00222)) mask |= FA_RDONLY;
   if (0 == (umode & 00555)) mask |= FA_HIDDEN;
   if (0 != (umode & 07000)) mask |= FA_SYSTEM;
   return mask;
}

int mapdattr(int dattr) /* DOS file attributes to UNIX mode */
{
   register mode = dattr & FA_LABEL ? S_IFLNK :
                   dattr & FA_DIREC ? S_IFDIR : S_IFREG;
   if (0 != (dattr & FA_SYSTEM)) mode |= 02000;
   if (0 == (dattr & FA_HIDDEN)) mode |= 00444;
   if (0 == (dattr & FA_RDONLY)) mode |= 00222;
   return mode;
}

static long ftime2unix(register unsigned short *dt)
{
   struct date d; struct time t;
   d.da_year = (dt[1] >> 9) + 1980;
   d.da_mon  = (dt[1] >> 5) & 15;
   d.da_day  =  dt[1] & 31;
   t.ti_hour =  dt[0] >> 11;
   t.ti_min  = (dt[0] >> 5) & 63;
   t.ti_sec  = (dt[0] & 31) << 1;
   t.ti_hund = 0;
   return dostounix(&d, &t);
}

void ffb2stat(struct stat *s, unsigned char *ffbP)
{
   s->st_dev = *ffbP;
   s->st_ino = 0;
   s->st_mode = mapdattr(ffbP[21]);
   s->st_nlink = 1;
   s->st_uid = s->st_gid = 0;
   s->st_rdev = 0;
   s->st_size = *(long*)(ffbP + 26);
   s->st_atime = s->st_mtime = s->st_ctime =
      ftime2unix((unsigned short*)(ffbP + 22));
}

int _acces(char *path, int amode)
{
   register attr = lchmod(path, 0, 0);
   if (attr == -1) return -1;
   return (amode & ~7) ||
      ((amode & 3) && (attr & (FA_HIDDEN+FA_LABEL))) ||
      ((amode & 2) && (attr & (FA_SYSTEM+FA_RDONLY))) ?
         (errno=EACCES, -1) : 0;
}

int hasdrive(register char *path)
{
   register c = LC(path[0]);
   return c<'a' || c>'z' || path[1]!=':' ? 0 : c-('a'-1);
}

int fnoffset(char *path)
/* Calculate an offset to last filename element */
{
   register k;
   register char *p = hasdrive(path) ? path+2 : path;
   for (k=strlen(p); k && p[k-1]!='\\' && p[k-1]!='/';) --k;
   return (int)(p-path) + k;
}

static char *fullname(name)
char *name;
{
   int len, driveno = hasdrive(name);
   char tmp[PATHSIZE];
   register char *p;

   if (driveno) name += 2;

   tmp[len = 0] = '\0';
   if (*name!='\\' && *name!='/') {
      if (0 != lgetcurdir(driveno, &tmp[1])) return NULL;
      tmp[0] = '\\';
      if ((len = strlen(tmp)) > 1) tmp[len++] = '\\';
   }
   if (NULL != (p = malloc(strlen(name) + len + 3))) {
      p[0] = driveno ? 'A'-1 + driveno : dosgetdisk() + 'A';
      p[1] = ':';
      (void)strncpy(p+2, tmp, len);
      (void)strcpy(p+len+2, name);
   }
   return p;
}

#define MAXTRACE (PATHSIZE/sizeof(int))
#define SLASH(c) ((c)=='\\' || (c)=='/')

static void simplify(name)
register char *name;
{
   int trace[MAXTRACE];
   register char *p;
   int i, n;

   for (;;) {
      for (n=i=0; name[i]; i++) {
         p = &name[i];
         if (!SLASH(*p)) continue;
         if (p[1] == '.' && SLASH(p[2])) {
             (void)strcpy(p, p+2);
         } else if (p[1] == '.' && p[2] == '.' && SLASH(p[3]) && n>0) {
             --n;
             (void)strcpy(&name[trace[n]], p+3);
             goto next;
         } else {
            trace[n++] = i;
         }
      }
      break;
next: ;
   }
}

char *realname(name)
char *name;
{
    register char *p = fullname(name);
    if (p) simplify(p+2);
    return p;
}

int isarchive(s, p)
register struct stat *s; register char *p;
{
   register k = FALSE;
   /* The algorithm below is not perfect:
    * name comparison gives no guarantee (consider substed drives).
    * Some day we might want to redefine stat structure and use
    * 64-bit drive and file IDs.
    */
   if (!isfile || sa.st_dev != s->st_dev) return FALSE;
   if (archname && !stricmp(archname+fnoffset(archname), p+fnoffset(p))) {
       /* file names are the same, compare drive:directory */
       register char *a = archname;
       register char *r = realname(p);
       if (r) {
          register c1, c2;
          k = TRUE;
          do {
             c1 = *a++;
             if (c1 >= 'a' && c1 <= 'z') c1 -= 'z'-'Z';
             else if (c1 == '/') c1 = '\\';
             c2 = *r++;
             if (c2 >= 'a' && c2 <= 'z') c2 -= 'z'-'Z';
             else if (c2 == '/') c2 = '\\';
             if (c1 != c2) {
                k = FALSE; break;
             }
          } while (c1 && c2);
       }
   }
   return k;
}

void lfntest() /* initialize lfn_active */
{
   lcwdent_t e; if (0 == lfindfirst(&e, "*", 0x3f)) lfindend(&e);
}
#endif

long mtime(path)
char *path;
{
#ifdef MSDOS
   extern long dostounix();
   unsigned long mtm = lgetmtime(path);
   if (mtm != -1L) return ftime2unix((unsigned short*)&mtm);
#else
   struct stat st;
   if (!stat(path, &st)) return st.st_mtime;
#endif
   return -1L; /* error */
}
