program SSTEP;
{$G+,N+,E-}
var
geax,gedx:longint;
pfid,pvid:byte;
code:integer;

procedure enabless;
var
 recx:longint;
 cnst:longint;
begin
 recx:=$1a0;
 cnst:=65536;
 asm
  DB $66
  mov cx,word ptr [recx]
  DB $0F,$32 {rdmsr}

  DB $66
  or ax,word ptr [cnst]

  DB $0F,$30 {wrmsr}
 end;
end;


procedure writefidvid(reax,redx:longint);
var
 recx:longint;
begin
 recx:=$199;
 asm
  DB $66
  mov ax,word ptr [reax]
  DB $66
  mov dx,word ptr [redx]
  DB $66
  mov cx,word ptr [recx]
  DB $0F,$30 {wrmsr}
 end;
end;

procedure readfidvid(var reax:longint;var redx:longint;pending:boolean);
var
recx:longint;
begin
 if pending then recx:=$199
 else
 recx:=$198;
 asm
 DB $66
 mov cx,word ptr [recx]
 DB $0F,$32 {rdmsr}
 les di,reax
 DB $66
 mov word ptr es:[di],ax
 les di,redx
 DB $66
 mov word ptr es:[di],dx
 end;
end;

function checksupport:boolean;
var support:boolean;
begin
  asm
            mov support,true
            mov ax,0F000h       {386+ detect }
	    push ax
	    popf
	    pushf
	    pop ax
	    and ah,0F0h
	    sti
	    jz @nosupport

            DB $66
            pushf               {cpuid detect}
            DB $66
            pop ax
            DB $66
            mov bx,ax
            DB $66,$0F,$BA,$F8,$15 {btc eax,15h}
            DB $66
            push ax
            DB $66
            popf
            DB $66
            pushf
            DB $66
            pop ax
            DB $66
            cmp ax,bx
            jz @nosupport

            DB $66       {speedstep detect}
            xor ax,ax
            mov ax,1
            DB 0Fh,0A2h  {cpuid}
            test cx,128
            jz @nosupport

            jmp @exit
    @nosupport:
            mov support,false
    @exit:
  end;
 checksupport:=support;
end;



begin
writeln('Speedstep 1.1 by Falcosoft');
writeln('usage: sstep [multiplier] [voltageid] -without parameters shows CPU info');
writeln;
 if not checksupport then
 begin
  writeln('CPU is not supported!');
  exit;
 end;
 enabless;
 if paramcount <> 2 then
 begin
 readfidvid(geax,gedx,true);
 writeln('LastTriedFid: ',(geax shr 8) and $FF,'x');
 writeln('LastTriedVid: ',geax and $FF);

 readfidvid(geax,gedx,false);
 writeln('CurrentFid: ',(geax shr 8) and $FF,'x');
 writeln('CurrentVid: ',geax and $FF);
 writeln('MaxFid: ',(gedx shr 8) and $FF,'x');
 writeln('MaxVid: ',gedx and $FF);
 writeln('MinFid: ',(gedx shr 24) and $FF,'x');
 writeln('MinVid: ',(gedx shr 16) and $FF);
 writeln;
 readln;
end
else
begin

 val(paramstr(1),pfid,code);
 if code<>0 then val(copy(paramstr(1),1,code-1),pfid,code);
 val(paramstr(2),pvid,code);

 gedx:=0;
 geax:=pvid or (pfid shl 8);
 writefidvid(geax,gedx);

 writeln('New settings applied...');
 readfidvid(geax,gedx,true);
 writeln('LastTriedFid: ',(geax shr 8) and $FF,'x');
 writeln('LastTriedVid: ',geax and $FF);

 readfidvid(geax,gedx,false);
 writeln('CurrentFid: ',(geax shr 8) and $FF,'x');
 writeln('CurrentVid: ',geax and $FF);
 end;

end.