#ifndef _PROTOCOL_H
#define _PROTOCOL_H

/* Protocol data prototypes */

struct Packet {
    long length;		/* type + body length */
    unsigned char type;		/* packet type */
    unsigned long crc;		/* CRC */
    unsigned char *whole;	/* pointer to whole packet */
    unsigned char *body;	/* pointer to useful data */
    long maxlen;
};

short TCPConnect(char *);
short SSHConnect(void);

/* request compression from server */
void Request_Compression(int);

#ifdef __TURBOC__
/* free compression memory) */
void Disable_Compression(void);
#endif

/* clean up compression structures */
void Uninit_Compression(void);

/* get a packet with blocking */
void packet_read_block(void);

/* we need the type only */
void packet_read_type(void);

/* expect a packet type */
void packet_read_expect(unsigned char);

/* create header for raw outgoing packet */
void s_wrpkt_start(unsigned int, unsigned int);

/* create outgoing packet */
void s_wrpkt(void);

/* read and convert raw, encrypted packet to readable structure */
void ssh_gotdata(void);

void SendSSHPacket(unsigned char *, unsigned short);

#endif
