/*
 * test application for testing picoTCP's socket capabilities
 */

#include <stdio.h>
#include <stdint.h>
#include <string.h>

#include <picodos.h>
#include <picotcp.h>


int connstate = 0;
int connwrite_ready = 0;

static void cb_wakeup(uint16_t ev, struct pico_socket *sock) {
  if (ev == PICO_SOCK_EV_RD) { /* new data arrived */
  } else if (ev == PICO_SOCK_EV_WR) { /* ready to write */
    connwrite_ready = 1;
  } else if (ev == PICO_SOCK_EV_CONN) { /* connected */
    printf("connected\n");
    connstate = 1;
  } else if (ev == PICO_SOCK_EV_CLOSE) { /* FIN received */
    connstate = -1;
  } else if (ev == PICO_SOCK_EV_FIN) { /* conn closed */
    connstate = -1;
  } else if (ev == PICO_SOCK_EV_ERR) { /* error occured */
    connstate = -1;
  } else { /* some WTF */
    connstate = -1;
  }
}


int main(void) {
  char *req = "GET / HTTP/1.0\r\n\r\n";
  char buff[16];
  struct pico_socket *sock;
  struct pico_device picodev;
  struct pico_ip4 srvaddr;
  int writelen, readlen;

  if (picoinit(&picodev, 0) != 0) {
    printf("picoinit() failure\n");
    picoquit(&picodev);
    return(1);
  }

  sock = pico_socket_open(PICO_PROTO_IPV4, PICO_PROTO_TCP, cb_wakeup);
  if (sock == NULL) {
    printf("pico_socket_open() failure\n");
    picoquit(&picodev);
    return(1);
  }

  pico_string_to_ipv4("185.86.53.5", &srvaddr.addr);

  if (pico_socket_connect(sock, &srvaddr, 0x5000) < 0) {
    printf("pico_socket_connect() failure\n");
    picoquit(&picodev);
    return(1);
  }

  /* wait for connection to be established */
  while (connstate == 0) {
    pico_stack_tick();
  }
  if (connstate < 0) {
    printf("Error: connection failed\n");
    picoquit(&picodev);
    return(1);
  }

  /* wait for the socket to become write-ready */
  while (connwrite_ready == 0) {
    pico_stack_tick();
    if (connstate < 0) {
      printf("Error: connection failed\n");
      picoquit(&picodev);
      return(1);
    }
  }

  /* send request */
  writelen = pico_socket_write(sock, req, strlen(req));
  if (writelen < 0) {
    printf("Error: connection failed\n");
    picoquit(&picodev);
    return(1);
  }

  while (connstate > 0) {
    int x;
    pico_stack_tick();
    /* read data */
    readlen = pico_socket_read(sock, buff, sizeof(buff));
    if (readlen < 0) break;
    for (x = 0; x < readlen; x++) printf("%c", buff[x]);
  }

  printf("\n");

  /* close socket and quit */
  pico_socket_close(sock);

  picoquit(&picodev);
  return(0);
}
