Index: include/pico_config.h
===================================================================
--- include/pico_config.h	(revision 4363)
+++ include/pico_config.h	(working copy)
@@ -196,6 +196,8 @@
 # include "arch/pico_cortex_m.h"
 #elif defined CORTEX_M3
 # include "arch/pico_cortex_m.h"
+#elif defined ARCHDOS
+# include "arch/pico_dos.h"
 #elif defined PIC24
 # include "arch/pico_pic24.h"
 #elif defined MSP430
Index: modules/pico_icmp6.h
===================================================================
--- modules/pico_icmp6.h	(revision 4363)
+++ modules/pico_icmp6.h	(working copy)
@@ -156,7 +156,7 @@
                 struct pico_ip6 target;
                 struct pico_ip6 dest;
             } redirect;
-            PEDANTIC_STRUCT_DEF mld_s { 
+            PEDANTIC_STRUCT_DEF mld_s {
                 uint16_t max_resp_time;
                 uint16_t reserved;
                 struct pico_ip6 mmcast_group;
@@ -164,8 +164,8 @@
                 uint8_t reserverd; // With S and QRV
                 uint8_t QQIC;
                 uint16_t nbr_src;
-                struct pico_ip6 src[0];
-            } mld;          
+                struct pico_ip6 src[1];
+            } mld;
         } info;
     } msg;
 };
Index: modules/pico_mld.h
===================================================================
--- modules/pico_mld.h	(revision 4363)
+++ modules/pico_mld.h	(working copy)
@@ -86,11 +86,11 @@
     uint8_t aux_len;
     uint16_t nbr_src;
     struct pico_ip6 multicast;
-    struct pico_ip6 src[0];
+    struct pico_ip6 src[1];
 };
 
 struct mld_parameters {
-    uint8_t event; 
+    uint8_t event;
     uint8_t state;
     uint8_t general_query;
     uint8_t filter_mode;
Index: modules/pico_socket_udp.c
===================================================================
--- modules/pico_socket_udp.c	(revision 4363)
+++ modules/pico_socket_udp.c	(working copy)
@@ -35,10 +35,11 @@
 
     ip4hdr = (struct pico_ipv4_hdr*)(f->net_hdr);
     p_dst.addr = ip4hdr->dst.addr;
+    #ifdef PICO_SUPPORT_MCAST
     if (pico_ipv4_is_multicast(p_dst.addr) && (pico_socket_mcast_filter(s, (union pico_address *)&ip4hdr->dst, (union pico_address *)&ip4hdr->src) < 0))
         return -1;
+    #endif
 
-
     if ((pico_ipv4_link_get(&ip4hdr->src)) && (PICO_SOCKET_GETOPT(s, PICO_SOCKET_OPT_MULTICAST_LOOP) == 0u)) {
         /* Datagram from ourselves, Loop disabled, discarding. */
         return -1;
@@ -160,7 +161,7 @@
         int retval = pico_socket_udp_deliver_ipv6_mcast(s, f);
         pico_frame_discard(f);
         return retval;
-    } 
+    }
     else if (pico_ipv6_is_unspecified(s->local_addr.ip6.addr) || (pico_ipv6_compare(&s_local, &p_dst) == 0))
     { /* Either local socket is ANY, or matches dst */
         cpy = pico_frame_copy(f);
Index: stack/pico_socket.c
===================================================================
--- stack/pico_socket.c	(revision 4363)
+++ stack/pico_socket.c	(working copy)
@@ -480,7 +480,9 @@
     PICOTCP_MUTEX_LOCK(Mutex);
     pico_tree_delete(&sp->socks, s);
     pico_socket_check_empty_sockport(s, sp);
+    #ifdef PICO_SUPPORT_MCAST
     pico_multicast_delete(s);
+    #endif
     pico_socket_tcp_delete(s);
     s->state = PICO_SOCKET_STATE_CLOSED;
     pico_timer_add((pico_time)10, socket_garbage_collect, s);
@@ -1036,7 +1038,7 @@
     uint16_t hdr_offset = (uint16_t)pico_socket_sendto_transport_offset(s);
     int ret = 0;
     (void)src;
-    
+
     f = pico_socket_frame_alloc(s, (uint16_t)(len + hdr_offset));
     if (!f) {
         pico_err = PICO_ERR_ENOMEM;
