/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using template emitter:
 *      SOM Emitter emitctm: 2.23.1.9
 */

#ifndef SOM_Module_course_Source
#define SOM_Module_course_Source
#endif
#define Course_Class_Source

#include "student.h"
#include "course.ih"

#include <stdio.h>
#include <string.h>

SOM_Scope void  SOMLINK somInit(Course *somSelf)
{
    CourseData *somThis = CourseGetData(somSelf);
    CourseMethodDebug("Course","somInit");

    parent_somInit(somSelf);
    _code[0] = _title[0] = _instructor[0] = '\0';
    _credit = _capacity = _enrollment = 0;
}

/*
 * sets up a new course
 */

SOM_Scope void  SOMLINK setUpCourse(Course *somSelf, char *code,
                                    char *title, char *instructor,
                                    int credit, int capacity)
{
    CourseData *somThis = CourseGetData(somSelf);
    CourseMethodDebug("Course","setUpCourse");

    strcpy(_code, code);
    strcpy(_title, title);
    strcpy(_instructor, instructor);
    _credit = credit;
    _capacity = capacity;
}

/*
 * enrolls a student to the course
 */

SOM_Scope int  SOMLINK addStudent(Course *somSelf, Student *student)
{
    CourseData *somThis = CourseGetData(somSelf);
    CourseMethodDebug("Course","addStudent");

    if (_enrollment >= _capacity)
        return -1;

    _studentList[_enrollment++] = student;
    return 0;
}

/*
 * drops the student from the course
 */

SOM_Scope void  SOMLINK dropStudent(Course *somSelf, char *studentId)
{
    int  i;
    CourseData *somThis = CourseGetData(somSelf);
    CourseMethodDebug("Course","dropStudent");

    for (i = 0; i < _enrollment; i++)
        if (!strcmp(studentId, _getStudentId(_studentList[i]))) {
            _enrollment--;
            for (i; i < _enrollment; i++)
                _studentList[i] = _studentList[i + 1];
            return;
        }
}

/*
 * prints the information about the course and enrolled students
 */

SOM_Scope void  SOMLINK printCourseInfo(Course *somSelf)
{
    int i;
    CourseData *somThis = CourseGetData(somSelf);
    CourseMethodDebug("Course","printCourseInfo");

    printf(" %s %s\n", _code, _title);
    printf(" Instructor Name : %s\n", _instructor);
    printf(" Credit = %d, Capacity = %d, Enrollment = %d\n\n",
        _credit, _capacity, _enrollment);
    printf(" STUDENT LIST:\n\n");
    for (i = 0; i < _enrollment; i++) {
        _printStudentInfo(_studentList[i]);
        printf("\n");
    }
}

