/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  Kitchen furniture interface.
*
****************************************************************************/


#include "box.hpp"

class cupboard : public box {
public:
    enum handle_position_flag {
        MIDDLE = 0,
        LEFT = 1,
        RIGHT = 2,
        TOP = 4,
        BOTTOM = 8 };

private:
    void build( unsigned pos );

public:
    cupboard( float width, float depth, float height, unsigned pos );
    cupboard( cupboard& left_neighbor, unsigned pos );
};

class fridge : public box {
public:
    enum handle_position { LEFT, RIGHT };

private:
    void make_fridge( handle_position pos );

public:
    fridge( float width, float depth, float height, handle_position pos );
};

class table : public box {
private:
    void top_and_four_legs( float leg_width );

public:
    table( float width, float depth, float height, float leg_width );
};

class chair : public box {
public:
    chair( float width, float depth, float height );
};

