/*****************************************************************************
*   SETTINGS.APP - settings program for FreeGEM                              *
*   Copyright 1999, 2005 John Elliott                                        *
*                                                                            *
* This program is free software; you can redistribute it and/or              *
* modify it under the terms of the GNU General Public License                *
* as published by the Free Software Foundation; either version 2             *
* of the License, or (at your option) any later version.                     *
*                                                                            *
* This program is distributed in the hope that it will be useful,            *
* but WITHOUT ANY WARRANTY; without even the implied warranty of             *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
* GNU General Public License for more details.                               *
*                                                                            *
* You should have received a copy of the GNU General Public License          *
* along with this program; if not, write to the Free Software                *
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.*
*                                                                           *
******************************************************************************/


#include "settings.h"
#include <stdio.h>

//WORD round;
#ifndef SEEK_SET
#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2
#endif

MLOCAL WORD ext_out[90];

typedef struct
{
	WORD magic1;	/* = 0 */
	WORD magic2;	/* = 2 */
	WORD count;	/* = 1 */
} WCURSORHEAD;

typedef struct
{
/* Cursor directory */
	BYTE width;
	BYTE height;
	BYTE depth;
	BYTE reserved;
	WORD xhot;
	WORD yhot;
	LONG size;
	LONG offset;
} WCURSORDIR;

typedef struct
{
/* Bitmap info header */
	LONG len;
	LONG w;
	LONG h;
	WORD planes;
	WORD depth;
	LONG compression;
	LONG imgsize;
	LONG xscale;
	LONG yscale;
	LONG clr_used;
	LONG clr_important;
	UBYTE r0, g0, b0, a0;
	UBYTE r1, g1, b1, a1;

} WCURSORINFO;

static WCURSORHEAD head_template = 
{
	0, 2, 1,				/* 6 bytes */
};

static WCURSORDIR dir_template = 
{
	16, 16, 0, 0, 0, 0, 48 + 128, 16 + 6	/* 16 bytes */
};

static WCURSORINFO info_template =
{
	40, 16, 32, 1, 1, 0, 64, 0, 0, 0, 0, 
	0, 0, 0, 0, -1, -1, -1, 0
};





MLOCAL CURSOR cursor[9];
MLOCAL WORD sel_cur;
MLOCAL WORD cur_col;

MLOCAL PPDUBLK pre_ublk[3];

VOID set_clip(WORD clip_flag, GRECT *s_area);
WORD do_clrdrop(LPTREE tr, WORD ob);

void draw_cell(CURSOR *c, GRECT *rcobj, WORD x, WORD y)
{
	GRECT rc;
	WORD style = 0, index = 0;
	UWORD mask;

	rc.g_x = rcobj->g_x;
	rc.g_y = rcobj->g_y;
	rc.g_w = (rcobj->g_w) / 16;
	rc.g_h = (rcobj->g_h) / 16;
	rc.g_x += (x * rc.g_w);
	rc.g_y += (y * rc.g_h);
	mask = 0x8000 >> x;

	if (c->mask[y] & mask)
	{
		if (c->data[y] & mask) style = 1;
		else		       style = 0;
		filled_rect(&rc, c->ci_data, c->ci_mask, style, index);
	}
	else
	{
		style = 2;
		if (c->data[y] & mask) index = 3;
		else		       index = 4;
		filled_rect(&rc, BLACK, WHITE, style, index);
	}
}

void draw_hotspot(CURSOR *c, GRECT *rcobj, WORD x, WORD y)
{
	GRECT rc;
	WORD pt[4];

	rc.g_x = rcobj->g_x;
	rc.g_y = rcobj->g_y;
	rc.g_w = (rcobj->g_w) / 16;
	rc.g_h = (rcobj->g_h) / 16;
	rc.g_x += (x * rc.g_w);
	rc.g_y += (y * rc.g_h);

	vswr_mode(vdi_handle, MD_XOR);
	pt[0] = rc.g_x; 
	pt[1] = rc.g_y;
	pt[2] = rc.g_x + rc.g_w;
	pt[3] = rc.g_y + rc.g_h;
	v_pline(vdi_handle, 2, pt);
	pt[0] = rc.g_x; 
	pt[1] = rc.g_y + rc.g_h;
	pt[2] = rc.g_x + rc.g_w;
	pt[3] = rc.g_y;
	v_pline(vdi_handle, 2, pt);
	vswr_mode(vdi_handle, MD_REPLACE);
}


WORD paint_grid(LPPARM lp)
{
	PARMBLK pb;
	WORD x, y, dx, dy;
	GRECT rc;
	CURSOR *c;

	LBCOPY((LPBYTE)ADDR(&pb), (LPBYTE)lp ,sizeof(PARMBLK));
	c = &cursor[sel_cur];

	dx = pb.pb_w / 16;
	dy = pb.pb_h / 16;
	set_clip(TRUE, (GRECT *) &pb.pb_xc);
	vsl_color(vdi_handle, BLACK);
	vsl_width(vdi_handle, 1);
	vsl_type(vdi_handle, FIS_SOLID);
/*	rc.g_x = pb.pb_x;
	rc.g_y = pb.pb_y;
	rc.g_w = dx;
	rc.g_h = 16 * dy;
	for (x = 1; x < 16; x++)
	{
		draw_rect(&rc);
		rc.g_x += dx;
	}
	rc.g_x = pb.pb_x;
	rc.g_w = 16 * dx;
	rc.g_h = dy;

	for (y = 1; y < 16; y++)
	{
		draw_rect(&rc);
		rc.g_y += dy;
	} */
	for (y = 0; y < 16; y++)
	{
		for (x = 0; x < 16; x++)
		{
			draw_cell(c, (GRECT *)(&pb.pb_x), x, y);
		}
	}
	draw_hotspot(c, (GRECT *)&pb.pb_x, c->xhot, c->yhot);

	vsl_width(vdi_handle, 1);
	vsl_color(vdi_handle, BLACK);
	rc.g_x = pb.pb_x;
	rc.g_y = pb.pb_y;
	rc.g_w = 16 * dx;
	rc.g_h = 16 * dy;
	draw_rect(&rc);
	set_clip(FALSE, (GRECT *)&pb.pb_xc);
	return 0;
}








WORD LSTCPY(LPBYTE d, LPBYTE s);

BYTE 	path[256];

FILE *rsc_open(char *mode)
{
	LPBYTE	gemrsc;
	FILE *fprsc;

	rsrc_gaddr(R_STRING, GEMRSC, (LPVOID *)&gemrsc);
	LSTCPY(path, gemrsc);
	if (shel_find(path))
	{
		fprsc = fopen(path, mode);
		if (fprsc) return fprsc;

		rsrc_alert(1, NORSC);
		return NULL;
	}
	rsrc_gaddr(R_STRING, GSTRSC, (LPVOID *)&gemrsc);
	LSTCPY(path, gemrsc);
	if (shel_find(path))
	{
		fprsc = fopen(path, mode);
		if (fprsc) return fprsc;
	}
	rsrc_alert(1, NORSC);
	return NULL;
}


WORD rw_cursor(CURSOR *c, int count, int write)
{

	FILE *fprsc;
	RSHDR rshdr;
	LONG lbitblk;
	BITBLK blk;
	int n, nc;

	if (!write)
	{
		for (n = 0; n < count; n++)
		{
			memset(&c[n], 0, sizeof(CURSOR));
			c[n].planes = 1;
		}
	}
	fprsc = rsc_open(write ? "r+b" : "rb");
	if (!fprsc) return 0;

	if (fread(&rshdr, 1, sizeof(rshdr), fprsc) != sizeof(rshdr))
	{
		fclose(fprsc);
		rsrc_alert(1, NORSC);
		return 0;
	}
	nc = 0;
	for (n = 0; n < rshdr.rsh_nimages; n++)
	{
		fseek(fprsc, rshdr.rsh_frimg + 4L * n, SEEK_SET);
		if (fread(&lbitblk, 1, sizeof(lbitblk), fprsc) 
				!= sizeof(lbitblk))
		{
			fclose(fprsc);
			rsrc_alert(1, NORSC);
			return 0;
		}
		fseek(fprsc, lbitblk, SEEK_SET);
		if (fread(&blk, 1, sizeof(blk), fprsc) != sizeof(blk))
		{
			fclose(fprsc);
			rsrc_alert(1, NORSC);
			return 0;
		}
		if (blk.bi_wb != 2 || blk.bi_hl != 37) continue;
		fseek(fprsc, (long)blk.bi_pdata, SEEK_SET);
		if (write)
		{
			if (fwrite(&c[nc], 1, sizeof(CURSOR), fprsc) != sizeof(CURSOR))
			{
				fclose(fprsc);
				rsrc_alert(1, NORSC);
				return 0;
			}
		}
		else if (fread(&c[nc], 1, sizeof(CURSOR), fprsc) != sizeof(CURSOR))
		{
			fclose(fprsc);
			rsrc_alert(1, NORSC);
			return 0;
		}
		nc++;
		if (nc >= count) break;
	}
	fclose(fprsc);	
	return nc;
}


MLOCAL UWORD abs(WORD w)
{
	if (w >= 0) return w;
	return -w;
}


VOID load_cur(CURSOR *c)
{
	WCURSORDIR  dir, mdir;
	WCURSORHEAD head;
	WCURSORINFO info, minfo;
	WORD n, delta, mdelta, ddelta;
	WORD mx, my, x, y, wb;
	WORD rgb[3];
	WORD r0, g0, b0;

	FILE *fp = get_file(TRUE, path, "*.CUR", "rb");
	if (!fp) return;

	if ((fread(&head, 1, sizeof(head), fp) < (int)sizeof(head))
	|| head.magic1 != 0 || head.magic2 != 2)
	{
		fclose(fp);
		rsrc_alert(1, NOCUR);
		return;
	}
	mx = -1;
	my = -1;
/* Load the info for each cursor, trying to find the best approximation to
 * 16x16 mono */
	for (n = 0; n < head.count; n++)
	{
		fseek(fp, 6 + 16*n, SEEK_SET);
		if (fread(&dir, 1, sizeof(dir), fp) < (int)sizeof(dir))
		{
			fclose(fp);
			rsrc_alert(1, NOCUR);
			return;
		}
		fseek(fp, dir.offset, SEEK_SET);
		if (fread(&info, 1, sizeof(info), fp) < (int)sizeof(info))
		{
			fclose(fp);
			rsrc_alert(1, NOCUR);
			return;
		}
		if (info.planes != 1 || info.depth != 1) continue;
		if (mx == 16 && my == 16) break;

		delta  = abs(dir.width - mx)  + abs(dir.height - my);
		mdelta = abs(mdir.width - mx) + abs(mdir.height - my);
		if (mx == -1 || (delta < mdelta)) 
		{
			mx = dir.width;
			my = dir.height;
			memcpy(&mdir,  &dir,  sizeof(mdir));	
			memcpy(&minfo, &info, sizeof(minfo));	
		}
	}
	if (mx == -1)	/* Nothing found */
	{
		fclose(fp);
		rsrc_alert(1, NOCUR);
		return;
	}
/* mdir holds the lucky entry */
	fseek(fp, mdir.offset, SEEK_SET);
	if (fread(&info,   1, sizeof(info),    fp) < (int)sizeof(info))
	{
		fclose(fp);
		rsrc_alert(1, NOCUR);
		return;
	}
/* Read masked image */
	wb = ((mdir.width + 31)/32) * 4;
	for (y = 0; y < my; y++)
	{
		for (x = 0; x < wb; x ++)
		{
			WORD ch = fgetc(fp);
			if (x == 0 && y < 16)
			{
				c->data[15-y] = 256 * ch;
			}
			if (x == 1 && y < 16)
			{
				c->data[15-y] |= ch;
			}	
		}
	}
	for (y = 0; y < my; y++)
	{
		for (x = 0; x < wb; x ++)
		{
			WORD ch = fgetc(fp);
			if (x == 0 && y < 16)
			{
				c->mask[15-y] = 256 * ch;
			}
			if (x == 1 && y < 16)
			{
				c->mask[15-y] |= ch;
			}	
		}
	}
	for (y = 0; y < 16; y++)
	{
		c->data[y] ^= c->mask[y];
		c->mask[y] = ~c->mask[y];
	}
	fclose(fp);
	c->xhot = mdir.xhot;
	c->yhot = mdir.yhot;

/* Guess the colours. Do this by finding the closest match in the GEM palette
 * (the size of which we deduce from the count of planes) */
	vq_extnd(vdi_handle, 1, ext_out);
	mdelta = 32767;
	ddelta = 32767;
	if (ext_out[4] > 1)
	{
		for (n = 0; n < (1 << ext_out[4]); n++)
		{
			vq_color(vdi_handle, n, 0, rgb);
			r0 = x_mul_div(rgb[2], 51, 200);
			g0 = x_mul_div(rgb[1], 51, 200);
			b0 = x_mul_div(rgb[0], 51, 200);

			delta = abs(r0 - (0xFF & minfo.r0)) + 
				abs(g0 - (0xFF & minfo.g0)) +
				abs(b0 - (0xFF & minfo.b0));
			if (delta < mdelta)
			{
				c->ci_mask = n;
				mdelta = delta;
			}
			delta = abs(r0 - (0xFF & minfo.r1)) + 
				abs(g0 - (0xFF & minfo.g1)) +
				abs(b0 - (0xFF & minfo.b1));
			if (delta < ddelta)
			{
				c->ci_data = n;
				ddelta = delta;
			}
		}
	}
}


VOID save_cur(CURSOR *c)
{
	WCURSORHEAD head;
	WCURSORDIR  dir; 
	WCURSORINFO info;
	WORD rgb[3];
	WORD n;

	FILE *fp = get_wfile(TRUE, path, "*.CUR", "wb");
	if (!fp) return;

	memcpy(&head, &head_template, sizeof(head));
	memcpy(&dir,  &dir_template,  sizeof(dir));
	memcpy(&info, &info_template, sizeof(info));

	dir.xhot = c->xhot;
	dir.yhot = c->yhot;

	vq_color(vdi_handle, c->ci_mask, 0, rgb);
	info.r0 = x_mul_div(rgb[2], 51, 200); 
	info.g0 = x_mul_div(rgb[1], 51, 200); 
	info.b0 = x_mul_div(rgb[0], 51, 200); 
	vq_color(vdi_handle, c->ci_data, 0, rgb);
	info.r1 = x_mul_div(rgb[2], 51, 200); 
	info.g1 = x_mul_div(rgb[1], 51, 200); 
	info.b1 = x_mul_div(rgb[0], 51, 200); 

	fwrite(&head, 1, sizeof(head), fp);
	fwrite(&dir,  1, sizeof(dir),  fp);
	fwrite(&info, 1, sizeof(info), fp);
	for (n = 15; n >= 0; n--)
	{
		fputc((c->data[n] | ~c->mask[n]) >> 8,   fp);
		fputc((c->data[n] | ~c->mask[n]) & 0xFF, fp);
		fputc(0, fp);
		fputc(0, fp);
	}
	for (n = 15; n >= 0; n--)
	{
		fputc(~c->mask[n] >> 8,   fp);
		fputc(~c->mask[n] & 0xFF, fp);
		fputc(0, fp);
		fputc(0, fp);
	}
	fclose(fp);
}


VOID set_cursors(LPTREE tr, WORD o)
{
	LPTREE  tree;
	GRECT	or;
	WORD	xdial, ydial, wdial, hdial, exitobj, indial;
	WORD	xo;
	WORD	nc, n;

	clr_vdi_handle(vdi_handle);	
	indial  = 1;
	
	rsrc_gaddr(R_TREE, CURSORS, (LPVOID *)&tree);
	pre_ublk[0].ub_code = paint_grid;
	pre_ublk[1].ub_code = paint_colour;
	pre_ublk[2].ub_code = paint_colour;
	ppd_userdef(tree, CURSEDIT, &pre_ublk[0]);
	ppd_userdef(tree, CHOICE6, &pre_ublk[1]);
	ppd_userdef(tree, CHOICE7, &pre_ublk[2]);

	nc = rw_cursor(cursor, sizeof(cursor)/sizeof(cursor[0]), 0);

	for (n = nc; n < (int)(sizeof(cursor)/sizeof(cursor[0])); n++)
	{
		tree[CURS0 + n].ob_flags &= ~TOUCHEXIT;
		tree[CURS0 + n].ob_state |= DISABLED;
	}
	ob_xywh(tr, o, &or);
	sel_cur = 0;
	cur_col = 0;
	for (n = 1; n <  (int)(sizeof(cursor)/sizeof(cursor[0])); n++)
	{
		tree[CURS0].ob_state &= ~SELECTED;
	}
	tree[CURS0].ob_state |= SELECTED;
	tree[CURSGREY].ob_state |= OUTLINED;
	
	form_center(tree, &xdial, &ydial, &wdial, &hdial);
	form_dial(0, or.g_x, or.g_y, or.g_w, or.g_h, xdial, ydial, wdial, hdial);
	form_dial(1, or.g_x, or.g_y, or.g_w, or.g_h, xdial, ydial, wdial, hdial);

	pre_ublk[1].ub_parm = cursor[sel_cur].ci_mask;
	pre_ublk[2].ub_parm = cursor[sel_cur].ci_data;
	objc_draw(tree, ROOT, MAX_DEPTH, xdial, ydial, wdial, hdial);

	while (indial)
	{
/*
		for (xo = 0; !(tree[xo].ob_flags & LASTOB); xo++)
		{
			if ((tree[xo].ob_type >> 8) == 1)
				objc_draw(tree, xo, 1, xdial, ydial, wdial, hdial);
		}
*/
		exitobj = x_form_do(tree, 0, cur_col, &cursor[sel_cur]) & 0x7FFF;

		switch(exitobj)
		{
			case CURS0:
			case CURS1:
			case CURS2:
			case CURS3:
			case CURS4:
			case CURS5:
			case CURS6:
			case CURS7:
			case CURS8:
				if ((exitobj - CURS0) >= nc) break;
				tree[CURS0 + sel_cur].ob_state &= ~SELECTED;
				sel_cur = exitobj - CURS0;
				tree[CURS0 + sel_cur].ob_state |= SELECTED;
				pre_ublk[1].ub_parm = cursor[sel_cur].ci_mask;
				pre_ublk[2].ub_parm = cursor[sel_cur].ci_data;
				objc_draw(tree, CURSBOX, 
						1, xdial, ydial, wdial, hdial);
				objc_draw(tree, CURSEDIT, 
						1, xdial, ydial, wdial, hdial);
				objc_draw(tree, CURCOLS, 1, 
						xdial, ydial, wdial, hdial);
				break;
			case CURSGREY:
			case CURSHOT:
			case CHOICE6:
			case CHOICE7:
				cur_col = (exitobj == CURSGREY) ? 0 :
					  (exitobj == CHOICE7 ) ? 1 :
					  (exitobj == CHOICE6 ) ? 2 : 
					  (exitobj == CURSHOT ) ? 3 : 4;
				tree[CURSGREY].ob_state &= ~OUTLINED;
				tree[CHOICE7 ].ob_state &= ~OUTLINED;
				tree[CHOICE6 ].ob_state &= ~OUTLINED;
				tree[CURSHOT ].ob_state &= ~OUTLINED;
				tree[exitobj ].ob_state |= OUTLINED;
				objc_draw(tree, CURCOLS, 1, 
						xdial, ydial, wdial, hdial);
				break;


			case DROP6:	
			case DROP7:	tree[CURSEDIT].ob_flags |= HIDETREE;
					xo = do_clrdrop(tree, exitobj);
					tree[CURSEDIT].ob_flags &= ~HIDETREE;
					if (xo >= 1)
					{
						if (exitobj == DROP6)
						
							pre_ublk[1].ub_parm = cursor[sel_cur].ci_mask = xo - 1;
						else	pre_ublk[2].ub_parm = cursor[sel_cur].ci_data = xo - 1;
					}	
					tree[exitobj].ob_state &= ~SELECTED;
					objc_draw(tree, exitobj, 1, xdial, ydial, wdial, hdial);
					objc_draw(tree, CURCOLS, 1, xdial, ydial, wdial, hdial);
					objc_draw(tree, CURSEDIT, 1, xdial, ydial, wdial, hdial);
					break;
						
			case CURSHELP:
					rsrc_alert(1, HELPCURS);
					tree[exitobj].ob_state &= ~SELECTED;
					objc_draw(tree, exitobj, 1, xdial, ydial, wdial, hdial);
					break;
		
			case CURSOKAY:
			case CURSCNCL:
					indial = 0;		
					tree[exitobj].ob_state &= ~SELECTED;
					break;
			case CUREXP:	
					save_cur(&cursor[sel_cur]);	
					tree[exitobj].ob_state &= ~SELECTED;
					objc_draw(tree, ROOT, MAX_DEPTH, xdial, ydial, wdial, hdial);
					break;
			case CURIMP:
					load_cur(&cursor[sel_cur]);
					tree[exitobj].ob_state &= ~SELECTED;
					objc_draw(tree, ROOT, MAX_DEPTH, xdial, ydial, wdial, hdial);
					break;
		} 
		
	}

	if (exitobj == CURSOKAY)
	{
		rw_cursor(cursor, sizeof(cursor)/sizeof(cursor[0]), 1);
	}


	form_dial(2, or.g_x, or.g_y, or.g_w, or.g_h, xdial, ydial, wdial, hdial);
	form_dial(3, or.g_x, or.g_y, or.g_w, or.g_h, xdial, ydial, wdial, hdial);

	
}



