/*

 Nibbles - Copyright (C) 2000 Andrea Fazzi

 This file is part of Nibbles.

 Nibbles is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Nibbles is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Nibbles; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef _LEVEL_H_
#define _LEVEL_H_

#include "Sprite.h"
#include "DblBuf.h"
//---------------------------------------------------------------------------
class BoundRect {

 public:

  int x,y,W,H;

   BoundRect();
   ~BoundRect();

   void Init(int posx,int posy,int w,int h);
   void DrawBound(unsigned char *buf);

   bool Check(int x,int y,int W,int H,char dir);

   bool checked;

};
//---------------------------------------------------------------------------
class FoodRect:public BoundRect {

 public:

  Sprite *GraphData;

  void InitGraph(char *filename);
  void Display(DblBuf *buf);

};
//---------------------------------------------------------------------------
class LevelHeader {

 public:

  LevelHeader();
  ~LevelHeader();

  void Animations(DblBuf *buf);
  void FoodInit();
  void LoadFrom_SCP_File(char *filename);


   int NumBlock,NumFood,StartSize,CurrSize,StartX,StartY;
   int LevelProgr,NumLives;

   char *LevelName;
   BoundRect *Block;
   FoodRect  *Food;
   Sprite *Arts;
   bool WormDeath;

};
//---------------------------------------------------------------------------
#endif




