/*

 Nibbles - Copyright (C) 2000 Andrea Fazzi

 This file is part of Nibbles.

 Nibbles is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Nibbles is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Nibbles; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
//---------------------------------------------------------------------------
#ifndef _VGA_256_
#define _VGA_256_

#define GRAPH256_MODE   0x13
#define TEXT_MODE       0x3

#define FADING_INTRO    0
#define FADING_THE_END  1
#define FADE_TO_RED     2
//---------------------------------------------------------------------------

 /* funzioni di init*/

extern void SetVgaMode(unsigned char mode);
//---------------------------------------------------------------------------
extern unsigned char *GrabScreenPtr();
//---------------------------------------------------------------------------
extern void Release();
//---------------------------------------------------------------------------
extern void WaitForRetrace();
//---------------------------------------------------------------------------
extern void SetPalette(unsigned char *pal);
//---------------------------------------------------------------------------
extern void GetPalette(unsigned char *pal);
//---------------------------------------------------------------------------

 /* funzioni grafiche*/

extern void PutPixel(unsigned char *ptrBuf,int x,int y,unsigned char color);
//---------------------------------------------------------------------------

 /*effetti*/

extern bool  FadingFX(unsigned char *src_pal,unsigned char *dest_pal,
                     char mode);
//---------------------------------------------------------------------------

 /* utilities */

extern void LoadPalette(char *filename,unsigned char *pal);
//---------------------------------------------------------------------------
extern void SavePalToTex(char *filename,unsigned char *pal);
//---------------------------------------------------------------------------
extern void ImgColorInfo(char *filename,unsigned char *img_buf,int size);
//---------------------------------------------------------------------------

#endif





