#include "huff_new.h"
#include "requant.h"

HuffmanTyp HuffHdr[10];
HuffmanTyp HuffSCFI[4];
HuffmanTyp HuffDSCF[16];
HuffmanTyp HuffQ1[2][27];
HuffmanTyp HuffQ2[2][25];
HuffmanTyp HuffQ3[2][ 7];
HuffmanTyp HuffQ4[2][ 9];
HuffmanTyp HuffQ5[2][15];
HuffmanTyp HuffQ6[2][31];
HuffmanTyp HuffQ7[2][63];

HuffmanTyp* HuffQ[2][8] =
{
 {0, HuffQ1[0], HuffQ2[0], HuffQ3[0], HuffQ4[0], HuffQ5[0], HuffQ6[0], HuffQ7[0]},
 {0, HuffQ1[1], HuffQ2[1], HuffQ3[1], HuffQ4[1], HuffQ5[1], HuffQ6[1], HuffQ7[1]},

};

static HuffSrcTyp  HuffSCFI_src [4] = {
    { 2, 3 }, { 1, 1 }, { 3, 3 }, { 0, 2 }
};

static HuffSrcTyp  HuffDSCF_src [16] = {
    { 32, 6 }, {  4, 5 }, { 17, 5 }, { 30, 5 }, { 13, 4 }, {  0, 3 }, {  3, 3 }, {  9, 4 },
    {  5, 3 }, {  2, 3 }, { 14, 4 }, {  3, 4 }, { 31, 5 }, {  5, 5 }, { 33, 6 }, { 12, 4 }
};

static HuffSrcTyp  HuffHdr_src [10] = {
    {  92, 8 }, {  47, 7 }, {  10, 5 }, {   4, 4 }, {   0, 2 },
    {   1, 1 }, {   3, 3 }, {  22, 6 }, { 187, 9 }, { 186, 9 }
};

static HuffSrcTyp  HuffQ1_src [2] [3*3*3] = { {
    { 54, 6 }, {  9, 5 }, { 32, 6 }, {  5, 5 }, { 10, 4 }, {  7, 5 }, { 52, 6 }, {  0, 5 }, { 35, 6 },
    { 10, 5 }, {  6, 4 }, {  4, 5 }, { 11, 4 }, {  7, 3 }, { 12, 4 }, {  3, 5 }, {  7, 4 }, { 11, 5 },
    { 34, 6 }, {  1, 5 }, { 53, 6 }, {  6, 5 }, {  9, 4 }, {  2, 5 }, { 33, 6 }, {  8, 5 }, { 55, 6 }
}, {
    { 103, 8 }, {  62, 7 }, { 225, 9 }, {  55, 7 }, {   3, 4 }, {  52, 7 }, { 101, 8 }, {  60, 7 }, { 227, 9 },
    {  24, 6 }, {   0, 4 }, {  61, 7 }, {   4, 4 }, {   1, 1 }, {   5, 4 }, {  63, 7 }, {   1, 4 }, {  59, 7 },
    { 226, 9 }, {  57, 7 }, { 100, 8 }, {  53, 7 }, {   2, 4 }, {  54, 7 }, { 224, 9 }, {  58, 7 }, { 102, 8 }
} };

static HuffSrcTyp  HuffQ2_src [2] [5*5] = { {
    {  89, 7 }, {  47, 6 }, {  15, 5 }, {   0, 5 }, {  91, 7 },
    {   4, 5 }, {   6, 4 }, {  13, 4 }, {   4, 4 }, {   5, 5 },
    {  20, 5 }, {  12, 4 }, {   4, 3 }, {  15, 4 }, {  14, 5 },
    {   3, 5 }, {   3, 4 }, {  14, 4 }, {   5, 4 }, {   1, 5 },
    {  90, 7 }, {   2, 5 }, {  21, 5 }, {  46, 6 }, {  88, 7 }
}, {
    {  921, 10 }, {  113,  7 }, {   51,  6 }, {  231,  8 }, {  922, 10 },
    {  104,  7 }, {   30,  5 }, {    0,  3 }, {   29,  5 }, {  105,  7 },
    {   50,  6 }, {    1,  3 }, {    2,  2 }, {    3,  3 }, {   49,  6 },
    {  107,  7 }, {   27,  5 }, {    2,  3 }, {   31,  5 }, {  112,  7 },
    {  920, 10 }, {  106,  7 }, {   48,  6 }, {  114,  7 }, {  923, 10 }
} };

static HuffSrcTyp  HuffQ3_src [2] [ 7] = { {
    { 12, 4 }, {  4, 3 }, {  0, 2 }, {  1, 2 }, {  7, 3 }, {  5, 3 }, { 13, 4 }
}, {
    { 4, 5 }, { 3, 4 }, { 2, 2 }, { 3, 2 }, { 1, 2 }, { 0, 3 }, { 5, 5 }
} };

static HuffSrcTyp  HuffQ4_src [2] [ 9] = { {
    { 5, 4 }, { 0, 3 }, { 4, 3 }, { 6, 3 }, { 7, 3 }, { 5, 3 }, { 3, 3 }, { 1, 3 }, { 4, 4 }
}, {
    {  9, 5 }, { 12, 4 }, {  3, 3 }, {  0, 2 }, {  2, 2 }, {  7, 3 }, { 13, 4 }, {  5, 4 }, {  8, 5 }
} };

static HuffSrcTyp  HuffQ5_src [2] [15] = { {
    { 57, 6 }, { 23, 5 }, {  8, 4 }, { 10, 4 }, { 13, 4 }, {  0, 3 }, {  2, 3 }, {  3, 3 },
    {  1, 3 }, { 15, 4 }, { 12, 4 }, {  9, 4 }, { 29, 5 }, { 22, 5 }, { 56, 6 }
}, {
    { 229, 8 }, {  56, 6 }, {   7, 5 }, {   2, 4 }, {   0, 3 }, {   3, 3 }, {   5, 3 }, {   6, 3 },
    {   4, 3 }, {   2, 3 }, {  15, 4 }, {  29, 5 }, {   6, 5 }, { 115, 7 }, { 228, 8 },
} };

static HuffSrcTyp  HuffQ6_src [2] [31] = { {
    {  65, 7 }, {   6, 6 }, {  44, 6 }, {  45, 6 }, {  59, 6 }, {  13, 5 }, {  17, 5 }, {  19, 5 },
    {  23, 5 }, {  21, 5 }, {  26, 5 }, {  30, 5 }, {   0, 4 }, {   2, 4 }, {   5, 4 }, {   7, 4 },
    {   3, 4 }, {   4, 4 }, {  31, 5 }, {  28, 5 }, {  25, 5 }, {  27, 5 }, {  24, 5 }, {  20, 5 },
    {  18, 5 }, {  12, 5 }, {   2, 5 }, {  58, 6 }, {  33, 6 }, {   7, 6 }, {  64, 7 },
}, {
    { 6472, 13 }, { 6474, 13 }, {  808, 10 }, {  405,  9 }, {  203,  8 }, {  102,  7 }, {   49,  6 }, {    9,  5 },
    {   15,  5 }, {   31,  5 }, {    2,  4 }, {    6,  4 }, {    8,  4 }, {   11,  4 }, {   13,  4 }, {    0,  3 },
    {   14,  4 }, {   10,  4 }, {    9,  4 }, {    5,  4 }, {    3,  4 }, {   30,  5 }, {   14,  5 }, {    8,  5 },
    {   48,  6 }, {  103,  7 }, {  201,  8 }, {  200,  8 }, { 1619, 11 }, { 6473, 13 }, { 6475, 13 },
} };

static HuffSrcTyp  HuffQ7_src [2] [63] = { {
    { 103, 8 },    // 0.3338   01100111
    { 153, 8 },    // 0.3766   10011001
    { 181, 8 },    // 0.4715   10110101
    { 233, 8 },    // 0.5528   11101001
    {  64, 7 },    // 0.6677    1000000
    {  65, 7 },    // 0.7041    1000001
    {  77, 7 },    // 0.7733    1001101
    {  81, 7 },    // 0.8296    1010001
    {  91, 7 },    // 0.9295    1011011
    { 113, 7 },    // 1.0814    1110001
    { 112, 7 },    // 1.0807    1110000
    {  24, 6 },    // 1.2748     011000
    {  29, 6 },    // 1.3390     011101
    {  35, 6 },    // 1.4224     100011
    {  37, 6 },    // 1.5201     100101
    {  41, 6 },    // 1.6642     101001
    {  44, 6 },    // 1.7292     101100
    {  46, 6 },    // 1.8647     101110
    {  51, 6 },    // 2.0473     110011
    {  49, 6 },    // 2.0152     110001
    {  54, 6 },    // 2.1315     110110
    {  55, 6 },    // 2.1358     110111
    {  57, 6 },    // 2.1700     111001
    {  60, 6 },    // 2.2449     111100
    {   0, 5 },    // 2.3063      00000
    {   2, 5 },    // 2.3854      00010
    {  10, 5 },    // 2.5481      01010
    {   5, 5 },    // 2.4867      00101
    {   9, 5 },    // 2.5352      01001
    {   6, 5 },    // 2.5074      00110
    {  13, 5 },    // 2.5745      01101
    {   7, 5 },    // 2.5195      00111
    {  11, 5 },    // 2.5502      01011
    {  15, 5 },    // 2.6251      01111
    {   8, 5 },    // 2.5260      01000
    {   4, 5 },    // 2.4418      00100
    {   3, 5 },    // 2.3983      00011
    {   1, 5 },    // 2.3697      00001
    {  63, 6 },    // 2.3041     111111
    {  62, 6 },    // 2.2656     111110
    {  61, 6 },    // 2.2549     111101
    {  53, 6 },    // 2.1151     110101
    {  59, 6 },    // 2.2042     111011
    {  52, 6 },    // 2.0837     110100
    {  48, 6 },    // 1.9446     110000
    {  47, 6 },    // 1.9189     101111
    {  43, 6 },    // 1.7177     101011
    {  42, 6 },    // 1.7035     101010
    {  39, 6 },    // 1.5287     100111
    {  36, 6 },    // 1.4559     100100
    {  33, 6 },    // 1.4117     100001
    {  28, 6 },    // 1.2776     011100
    { 117, 7 },    // 1.1107    1110101
    { 101, 7 },    // 1.0636    1100101
    { 100, 7 },    // 0.9751    1100100
    {  80, 7 },    // 0.8132    1010000
    {  69, 7 },    // 0.7091    1000101
    {  68, 7 },    // 0.7084    1000100
    {  50, 7 },    // 0.6277    0110010
    { 232, 8 },    // 0.5386   11101000
    { 180, 8 },    // 0.4408   10110100
    { 152, 8 },    // 0.3759   10011000
    { 102, 8 },    // 0.3160   01100110
}, {
    { 14244, 14 },    // 0.0059   11011110100100
    { 14253, 14 },    // 0.0098   11011110101101
    { 14246, 14 },    // 0.0078   11011110100110
    { 14254, 14 },    // 0.0111   11011110101110
    {  3562, 12 },    // 0.0320     110111101010
    {   752, 10 },    // 0.0920       1011110000
    {   753, 10 },    // 0.1057       1011110001
    {   160,  9 },    // 0.1403        010100000
    {   162,  9 },    // 0.1579        010100010
    {   444,  9 },    // 0.2486        110111100
    {   122,  8 },    // 0.3772         01111010
    {   223,  8 },    // 0.5710         11011111
    {    60,  7 },    // 0.6858          0111100
    {    73,  7 },    // 0.8033          1001001
    {   110,  7 },    // 0.9827          1101110
    {    14,  6 },    // 1.2601           001110
    {    24,  6 },    // 1.3194           011000
    {    25,  6 },    // 1.3938           011001
    {    34,  6 },    // 1.5693           100010
    {    37,  6 },    // 1.7846           100101
    {    54,  6 },    // 2.0078           110110
    {     3,  5 },    // 2.2975            00011
    {     9,  5 },    // 2.5631            01001
    {    11,  5 },    // 2.7021            01011
    {    16,  5 },    // 3.1465            10000
    {    19,  5 },    // 3.4244            10011
    {    21,  5 },    // 3.5921            10101
    {    24,  5 },    // 3.7938            11000
    {    26,  5 },    // 3.9595            11010
    {    29,  5 },    // 4.1546            11101
    {    31,  5 },    // 4.2623            11111
    {     2,  4 },    // 4.5180             0010
    {     0,  4 },    // 4.3151             0000
    {    30,  5 },    // 4.2538            11110
    {    28,  5 },    // 4.1422            11100
    {    25,  5 },    // 3.9145            11001
    {    22,  5 },    // 3.6691            10110
    {    20,  5 },    // 3.4955            10100
    {    14,  5 },    // 2.9155            01110
    {    13,  5 },    // 2.7921            01101
    {     8,  5 },    // 2.5553            01000
    {     6,  5 },    // 2.3093            00110
    {     2,  5 },    // 2.1200            00010
    {    46,  6 },    // 1.8134           101110
    {    35,  6 },    // 1.5824           100011
    {    31,  6 },    // 1.4701           011111
    {    21,  6 },    // 1.3187           010101
    {    15,  6 },    // 1.2776           001111
    {    95,  7 },    // 0.9664          1011111
    {    72,  7 },    // 0.7922          1001000
    {    41,  7 },    // 0.6838          0101001
    {   189,  8 },    // 0.5024         10111101
    {   123,  8 },    // 0.3830         01111011
    {   377,  9 },    // 0.2232        101111001
    {   161,  9 },    // 0.1566        010100001
    {   891, 10 },    // 0.1383       1101111011
    {   327, 10 },    // 0.0900       0101000111
    {   326, 10 },    // 0.0790       0101000110
    {  3560, 12 },    // 0.0254     110111101000
    { 14255, 14 },    // 0.0117   11011110101111
    { 14247, 14 },    // 0.0085   11011110100111
    { 14252, 14 },    // 0.0085   11011110101100
    { 14245, 14 },    // 0.0065   11011110100101
} };

static void  Make_HuffTable ( HuffmanTyp* dst, HuffSrcTyp* src, unsigned int len )
{
    unsigned int i;

    for ( i = 0; i < len; i++,src++,dst++ ) {
	dst->Code   = src->Code  ;
	dst->Length = src->Length;
    }
}

#define MAKE_HUFF(d,s)     Make_HuffTable   ( (d), (s), sizeof(s)/sizeof(*(s)) )

static void  Huffman_Encoder_SV7 ( void )
{
 MAKE_HUFF( HuffSCFI, HuffSCFI_src );

 MAKE_HUFF( HuffDSCF, HuffDSCF_src );

 MAKE_HUFF( HuffHdr, HuffHdr_src );

 MAKE_HUFF( HuffQ1[0], HuffQ1_src[0] );          // less shaped, book 0
 MAKE_HUFF( HuffQ1[1], HuffQ1_src[1] );          // more shaped, book 1

 MAKE_HUFF( HuffQ2[0], HuffQ2_src[0] );          // less shaped, book 0
 MAKE_HUFF( HuffQ2[1], HuffQ2_src[1] );          // more shaped, book 1

 MAKE_HUFF( HuffQ3[0], HuffQ3_src[0] );          // less shaped, book 0
 MAKE_HUFF( HuffQ3[1], HuffQ3_src[1] );          // more shaped, book 1

 MAKE_HUFF( HuffQ4[0], HuffQ4_src[0] );          // less shaped, book 0
 MAKE_HUFF( HuffQ4[1], HuffQ4_src[1] );          // more shaped, book 1

 MAKE_HUFF( HuffQ5[0], HuffQ5_src[0] );          // less shaped, book 0
 MAKE_HUFF( HuffQ5[1], HuffQ5_src[1] );          // more shaped, book 1

 MAKE_HUFF( HuffQ6[0], HuffQ6_src[0] );          // less shaped, book 0
 MAKE_HUFF( HuffQ6[1], HuffQ6_src[1] );          // more shaped, book 1

 MAKE_HUFF( HuffQ7[0], HuffQ7_src[0] );          // less shaped, book 0
 MAKE_HUFF( HuffQ7[1], HuffQ7_src[1] );          // more shaped, book 1
}

static void Resort_HuffTables(unsigned int elements, HuffmanTyp *Table,int offset)
{
 unsigned int c[LARGEST_TABLE];
 unsigned int v[LARGEST_TABLE];
 unsigned int l[LARGEST_TABLE];
 unsigned int i;
 int sorted=0;

 for (i=0; i<elements; ++i){
  Table[i].Value = i;
  c[i] = Table[i].Code<<(32-Table[i].Length);
  v[i] = Table[i].Value;
  l[i] = Table[i].Length;
 }
	
 //bubble sort
 while (!sorted){
  sorted = 1;
  for (i=1; i<elements; ++i){
   if (c[i]>c[i-1]){
    unsigned int tmp;
    tmp = v[i]; v[i] = v[i-1]; v[i-1] = tmp;
    tmp = c[i]; c[i] = c[i-1]; c[i-1] = tmp;
    tmp = l[i];	l[i] = l[i-1]; l[i-1] = tmp;
    sorted = 0;
   }
  }
 }
 for (i=0; i<elements; ++i){
  Table[i].Code =   c[i];
  Table[i].Length = l[i];
  Table[i].Value =  v[i] - offset;
 }
}

void mpcdec_Huffman_Decoder_SV7_init(void)
{
 Huffman_Encoder_SV7 ();
 Resort_HuffTables(10, &HuffHdr[0]   , 5);
 Resort_HuffTables( 4, &HuffSCFI[0]  , 0);
 Resort_HuffTables(16, &HuffDSCF[0]  , 7);
 Resort_HuffTables(27, &HuffQ1[0][0] , 0);
 Resort_HuffTables(27, &HuffQ1[1][0] , 0);
 Resort_HuffTables(25, &HuffQ2[0][0] , 0);
 Resort_HuffTables(25, &HuffQ2[1][0] , 0);
 Resort_HuffTables( 7, &HuffQ3[0][0] , mpcdec_D(3));
 Resort_HuffTables( 7, &HuffQ3[1][0] , mpcdec_D(3));
 Resort_HuffTables( 9, &HuffQ4[0][0] , mpcdec_D(4));
 Resort_HuffTables( 9, &HuffQ4[1][0] , mpcdec_D(4));
 Resort_HuffTables(15, &HuffQ5[0][0] , mpcdec_D(5));
 Resort_HuffTables(15, &HuffQ5[1][0] , mpcdec_D(5));
 Resort_HuffTables(31, &HuffQ6[0][0] , mpcdec_D(6));
 Resort_HuffTables(31, &HuffQ6[1][0] , mpcdec_D(6));
 Resort_HuffTables(63, &HuffQ7[0][0] , mpcdec_D(7));
 Resort_HuffTables(63, &HuffQ7[1][0] , mpcdec_D(7));
}
