/*      vbios.c                              08.03.95       */
/*!
/  --------------------------------------------------------------
/  Copyright (C) 1993: Michael Braun
/                      Kaetinger Muehlenweg 103 A
/                      D-28816 Stuhr
/  --------------------------------------------------------------
/
/     video bios functions
/     (extract from: Allen Holub, "c fuer kenner")
/                                                                             
*/

/****************************************************************
*                                                               *
*  BENUTZTE UNTERPROGRAMME (C LIBRARY)                          *
*                                                               *
****************************************************************/

#include "config.h"
#if (ACT_OP_SYSTEM == MS_DOS)

#include <stdio.h>
#include <dos.h>
#include <malloc.h>
#include "vbios.h"


/****************************************************************
*                                                               *
*  BENUTZTE UNTERPROGRAMME / GLOBALE VARIABLEN                  *
*                                                               *
****************************************************************/

static union REGS Regs;
static struct SREGS SRegs;

#pragma pack(1)

struct VGA_STATIC_FUNCTIONALITY
{ 
  unsigned char info_bytes[16];
};

union VGA_STATE
{
  struct VGA_state_info
  {
    struct VGA_STATIC_FUNCTIONALITY far * const VGA_static_functionality;
    unsigned char CRT_mode;
    unsigned int  CRT_cols;
    unsigned int  CRT_len;
    unsigned int  CRT_start;
    unsigned char cursors[2][8];
    unsigned char cursor_start;
    unsigned char cursor_stop;
    unsigned char CRT_page;
    unsigned int  CRTC_port;
    unsigned char CRT_mode_set;
    unsigned char CRT_palette;
    unsigned char CRT_rows;
    unsigned int  CRT_points;
    unsigned char active_displ_combine;
    unsigned char inactive_displ_combine;
    unsigned int  num_colors;
    unsigned char num_pages;
    unsigned char raster_lines;
  }
   data;
  char fill[64];
};

#pragma pack()


/****************************************************************
*                                                               *
*  ENDE DER DEKLARATIONEN                                       *
*                                                               *
****************************************************************/


/*-------------------------------------------------------------*/

int vb_getpage (void)
{
/* liefert die nummer der momentan aktiven Anzeigeseite */

   Regs.h.ah = GET_VMODE;
   int86 (VIDEO_INT, &Regs, &Regs);

   return (int) Regs.h.bh;
}  /* vb_getpage */

/*-------------------------------------------------------------*/

void vb_setcur (int posn)
{
/* Set Cursor to position (LSB = x=column, MSB = y=row) */

   Regs.h.bh = (unsigned char) vb_getpage ();
   Regs.x.dx = posn;
   Regs.h.ah = SET_POSN;
   int86 (VIDEO_INT, &Regs, &Regs);

   return;
}

/*-------------------------------------------------------------*/

void vb_ctoxy (int x, int y)
{
/* set cursor to x/y (column/row) */

   vb_setcur ((y << 8) | (x & 0xff));

   return;
}

/*-------------------------------------------------------------*/

int vb_getvmode (void)
{ 
  /* returns actual video mode */

   Regs.h.ah = GET_VMODE;
   int86 (VIDEO_INT, &Regs, &Regs);

   return ((int) Regs.h.al);
}

/*-------------------------------------------------------------*/

int vb_setvmode (int mode)
{ 
  /* sets new video mode */

   Regs.h.ah = SET_VMODE;
   Regs.h.al = (unsigned char) mode;
   int86 (VIDEO_INT, &Regs, &Regs);

   return vb_getvmode ();  /* for control, if set was o.k. */
}

/*-------------------------------------------------------------*/

int vb_getvsize (int* cols, int* lines)
{ 
  /* returns video screen dimensions */
  static union VGA_STATE vga_state;
  static void _far * fp = &vga_state;


   Regs.h.ah = GET_VSTATE;
   Regs.h.al = 0;
   Regs.x.bx = 0;
   Regs.x.di = FP_OFF(fp);
   SRegs.es  = FP_SEG(fp);
   int86x (VIDEO_INT, &Regs, &Regs, &SRegs);

   if (Regs.h.al == GET_VSTATE)
   {
     *cols = vga_state.data.CRT_cols;
     *lines = vga_state.data.CRT_rows;
     return 1;
   }
   else
   {
     *cols  = INIT_COLUMNS;
     *lines = INIT_ROWS;
     return 0;
   }
}

/*-------------------------------------------------------------*/

static void * vcontext;

void vb_savecontext (void)
{
  if (!vcontext) /* only once */
  {
    Regs.h.ah = SAVE_VSTATE;
    Regs.h.al = 0;   /* Get size buffer size */
    Regs.x.cx = 0x7; /* Hardware, BIOS and DAC states */
  
    int86 (VIDEO_INT, &Regs, &Regs);
  
    if (Regs.h.al == SAVE_VSTATE)
    {
      vcontext = malloc ((size_t)Regs.x.bx*64);

      Regs.h.ah = SAVE_VSTATE;
      Regs.h.al = 1;   /* Save requested states */
      Regs.x.cx = 0x7; /* Hardware, BIOS and DAC states */
      Regs.x.bx = FP_OFF(vcontext);
      SRegs.es  = FP_SEG(vcontext);
      int86x (VIDEO_INT, &Regs, &Regs, &SRegs);
    }
  }
}


void vb_restorecontext (void)
{
  if (vcontext)
  {
    Regs.h.ah = SAVE_VSTATE;
    Regs.h.al = 2;   /* Restore requested states */
    Regs.x.cx = 0x7; /* Hardware, BIOS and DAC states */
    Regs.x.bx = FP_OFF(vcontext);
    SRegs.es  = FP_SEG(vcontext);
    int86x (VIDEO_INT, &Regs, &Regs, &SRegs);

    free (vcontext);
    vcontext = NULL;
  }
}

/*-------------------------------------------------------------*/

void vb_setvlines (int lines)
{ 
  /* sets video screen dimensions */

  switch (lines)
  {
    case 50:
      vb_setvmode (3);  /* character generator functions in mode 3 */
      Regs.h.al = LOAD_8x8;
      break;

    case 28:
      vb_setvmode (3);  /* character generator functions in mode 3 */
      Regs.h.al = LOAD_8x14;
      break;

    default:
      vb_setvmode (3);  /* character generator functions in mode 3 */
      Regs.h.al = LOAD_8x16;
      break;
  }
  Regs.h.ah = VIDEO_CHAR;
  Regs.h.bl = 0;  
  int86 (VIDEO_INT, &Regs, &Regs);
}

/*-------------------------------------------------------------*/

void vb_switch_lines (void)
{
  static int resolution;

  switch (resolution)
  {
    case 0: 
      vb_setvlines (28); 
      resolution++;
      break;
      
    case 1: 
      vb_setvlines (50); 
      resolution++;
      break;

    case 2: 
      vb_setvlines (25); 
      resolution = 0;
      break;
  }
}

/*-------------------------------------------------------------*/

#elif (ACT_OP_SYSTEM == WIN_32)

int vb_getvsize (int* cols, int* lines)
{ 
  /* returns video screen dimensions */
    *cols  = INIT_COLUMNS;
    *lines = INIT_ROWS;
    return 0;
}


/*-------------------------------------------------------------*/

/* -FF-  */

#else

static int dummy (void)
{
   ;  /* leer-anweisung fuer os-9 c-compiler */
}

#endif


/* Modification History */
/* 19.12.92 - file erzeugt */
/* 21.12.92 - vb_getvmode (), vb_setvmode () */
/* 22.01.95 - vb_getvsize (), ... */
/* 08.03.95 - INIT_ROWS, INIT_COLUMNS */
