-- stream.e - Data stream encryption/decryption in CFB mode
-- Created for use with the Block Cipher Library, version 1.0
-- Copyright (C) 2000  Davi Tassinari de Figueiredo
--
-- This program is distributed under the terms of the GNU General
-- Public License. Please read the documentation for more information.
--
-- You can get the latest version of this program from my Euphoria page:
-- http://www16.brinkster.com/davitf/

include enc_algs.e



atom ubiv       -- used bytes in vector
sequence vector



global procedure init_stream (atom algorithm, sequence key,sequence iv)

    -- Sets the key and the initialization vector
    init_encrypt (algorithm, key)
    vector = enc_block(iv)
    ubiv=0

end procedure


global function encrypt_data(sequence data)
    -- This function encrypts the given data in CFB mode,
    -- using the previously encrypted data.

    atom enc_bytes
    enc_bytes=0

    -- If all of the buffer has been used, encrypt it again
    if ubiv= block_size then vector=enc_block(vector) ubiv=0 end if

    -- Is the length of the data to be encrypted smaller than
    -- the remaining bytes in the buffer?

    if ubiv+length(data)<= block_size then
	-- It is, so let's do everything at once
	data=xor_bits(vector[ubiv+1..ubiv+length(data)],data)
	vector[ubiv+1..ubiv+length(data)]=data
	ubiv=ubiv+length(data)
	return data
    end if

    -- Use the remaining bytes in the buffer

    vector[ubiv+1.. block_size]=xor_bits(vector[ubiv+1.. block_size],data[1.. block_size-ubiv])

    data[1.. block_size-ubiv]=vector[ubiv+1.. block_size]
    enc_bytes= block_size-ubiv

    vector=enc_block(vector) ubiv=0


    -- Encrypt whole blocks

    for pos=enc_bytes+1 to length(data)- block_size by  block_size do

	vector=xor_bits(data[enc_bytes+1..enc_bytes+ block_size],vector)
	data[enc_bytes+1..enc_bytes+ block_size]=vector
	vector=enc_block(vector)
	enc_bytes=enc_bytes+ block_size

    end for


    -- Encrypt the remaining bytes (not an entire block)

    ubiv=length(data)-enc_bytes
    vector[1..ubiv]=xor_bits(vector[1..ubiv],data[enc_bytes+1..length(data)])
    data[enc_bytes+1..length(data)]=vector[1..ubiv]


    return data

end function


global function decrypt_data(sequence data)
    -- This function decrypts the given data in CFB mode,
    -- using the previously decrypted data.


    sequence vector1

    atom enc_bytes
    enc_bytes=0

    -- If all of the buffer has been used, encrypt it again
    if ubiv= block_size then vector=enc_block(vector) ubiv=0 end if

    -- Is the length of the data to be decrypted smaller than
    -- the remaining bytes in the buffer?

    if ubiv+length(data)<=block_size then
	-- It is, so let's do everything at once
	vector1=vector[ubiv+1..ubiv+length(data)]
	vector[ubiv+1..ubiv+length(data)]=data
	data=xor_bits(vector1,data)
	ubiv=ubiv+length(data)
	return data
    end if

    -- Use the remaining bytes in the buffer

    vector1=data[1..block_size-ubiv]
    data[1..block_size-ubiv]=xor_bits(vector[ubiv+1..block_size],vector1)
    vector[ubiv+1..block_size]=vector1

    enc_bytes=block_size-ubiv

    vector=enc_block(vector) ubiv=0


    -- Decrypt whole blocks

    for pos=enc_bytes+1 to length(data)-block_size by block_size do

	vector1=data[enc_bytes+1..enc_bytes+block_size]
	data[enc_bytes+1..enc_bytes+block_size]=xor_bits(vector,vector1)
	vector=vector1
	vector=enc_block(vector)
	enc_bytes=enc_bytes+block_size

    end for


    -- Decrypt the remaining bytes (not an entire block)

    ubiv=length(data)-enc_bytes
    vector1=data[enc_bytes+1..length(data)]
    data[enc_bytes+1..length(data)]=xor_bits(vector[1..ubiv],vector1)
    vector[1..ubiv]=vector1


    return data

end function

global function get_stream_status ()
    return { enc_alg, ubiv, vector, get_enc_status() }
end function

global procedure set_stream_status (sequence status)
    enc_alg = status [1]
    ubiv = status [2]
    vector = status [3]
    set_enc_status (status [4])
end procedure


global procedure clean_stream_status ()
    clean_enc_status()
    ubiv = 0
    vector = {}
end procedure

