-- m_en.e - User interface messages  - HIP 2.1
-- Copyright (C) 2002  Davi Tassinari de Figueiredo
--
-- This program is distributed under the terms of the GNU General
-- Public License. Please read the documentation for more information.
--
-- This file contains messages and other texts for HIP. They are in a
-- single file to make it easier to translate the program into other
-- languages. If you want, translate the messages in this file into
-- your language and send it to me, so I can distribute it along with HIP.
--
-- When translating, please remember that the "%s" symbols in the messages
-- will be replaced by a file name or other text when they are shown, the
-- the "%d" symbols will become numbers and the "%x" ones will become
-- hexadecimal numbers. Do not change the order of the symbols inside
-- each message.
--
-- If your language uses special characters, use the Windows character set
-- for writing them. msg.e will convert them to the appropriate set.
--
-- Please try to keep line-by-line correspondence with the English
-- language file; this will make comparisons and mantainance much easier.

global constant

	HIP_VERSION = "2.1",
	program_id = "Hide In Picture "&HIP_VERSION&" - (C) 2002 Davi Figueiredo",

	-- when translating, replace by something like
	-- "Translated by ?????????? - ?????@????.???\n"
	translation = ""

-- Replace these by the keys the user should press to answer
-- Yes or No to a question. These keys should be uppercase.
global constant yes_key = 'Y', no_key = 'N'


global constant

-- Used only in command-line version

error_abortedbyuser = "Aborted by user",
error_colornotfound = "Color not found in palette",
error_filenameneeded = "A file name must be specified for retrieving this file",
error_mustbergb = "Transparent color must be a RGB triplet for 24-bit pictures",

status_opening_bmp = "Opening %s",
status_initializing = "Initializing procedure",
status_saving_bmp = "Saving %s",
status_done = "Operation completed successfully.",

info_filecanbehidden = "File can be hidden in picture",
info_filename = "File name: %s",
info_nofilename = "File name not stored",
info_filesize = "File size: %d bytes",
info_crcpresent = "Data checksum present",
info_crcnotpresent = "Data checksum not present",
info_algorithmused = "Encryption algorithm: %s",
info_nothingtodo = "Nothing to do",

prompt_enterpassword   = "Enter password  : ",
prompt_confirmpassword = "Confirm password: ",
prompt_overwritepicture = "Really overwrite %s",    -- this is a question (a '?' will be added by the program)
prompt_overwrite = "%s already exists, overwrite",    -- this is a question (a '?' will be added by the program)

help = program_id & '\n' & translation &
       "\n"&
       "To hide:     hip h source_image input_file [destination_image] [options]\n"&
       "To retrieve: hip r source_image [output_file] [options]\n"&
       "To erase:    hip e source_image [destination_image] [options]\n"&
       "\n"&
       "Options:     fXXXXXX        - file name to write in image\n"&
       "             pXXXXXX        - password to use\n"&
       "             tHH or tHHHHHH - transparent color index or RGB value\n"&
       "             eX             - use the specified encryption algorithm:\n"&
       "                              %s\n"&
       "             iX             - use specified image format for output file:\n"&
       "                              %s\n"&
--     "           * c              - write the CRC-32 of the data\n"&
       "             C              - do not write the CRC-32 of the data\n"&
--     "           * h              - hide the password characters when typing\n"&
       "             H              - do not hide the password characters when typing\n"&
--     "           * b              - create BMP file\n"&
--     "             g              - create GIF file (default if extension is GIF)\n"&
       "             v              - view file information only (do not save)\n" &
       "             q              - quiet mode (show only necessary messages)\n"&
       "             y              - answer 'yes' to all confirmation questions\n"&
       "           * = default options\n"&
       "\n"&
       "           Please read the documentation for more detailed information.\n",
--      12345678901234567890123456789012345678901234567890123456789012345678901234567890
--               1         2         3         4         5         6         7         8
--                                         Make sure no lines are longer than this ---^

-- Used in both command-line and GUI versions

error_invalidbmp = "%s is not a valid file",
error_corrupted = "%s is corrupted",
error_filesystemerror = "Filesystem error while reading %s",
error_unabletoopen = "Unable to open %s",
error_unsupportedbmp = "%s contains unsupported features",
error_unknown = "Unknown error in %s: %d",
error_outofmemory = "Not enough memory",
error_filetoobig = "File is too big to be hidden in picture",
error_unsupported = "File was hidden with a newer version of HIP",
error_nohiddenfile = "No hidden file found",
error_hiddencorrupted = "Hidden data is corrupted",
error_differentpasswords = "Passwords are not the same",
error_unsupportedbpp = "Cannot save a %d-bit picture as a %s file",

status_hiding = "Hiding ",
status_retrieving = "Retrieving ",
status_writing_in_picture = "Writing ",
status_reading_from_picture = "Reading ",

-- Used only in GUI version

ErrorWin_title = "HIP error",

MainWin_title = "HIP "&HIP_VERSION,
FileMenu_title = "&File",
FileOpen_title = "&Open picture...",
FileExit_title = "E&xit",

HelpMenu_title = "&Help",
HelpManual_title = "User &manual",
HelpAbout_title = "A&bout...",

HideWin_title = "Hide - Options",
RetrieveWin_title = "Retrieve - Options",
EraseWin_title = "Erase - Options",

EnterPwd_title = "Enter password:",
ConfirmPwd_title = "Confirm password:",
FileName_title = "File name:",
Encryption_title = "Encryption algorithm:",
WriteCRC_title = "Write CRC",
EraseUsingPwd_title = "Erase data hidden with password",
VerifyPassword_title = "Verify password before erasing",

ColorWin_title = "Select transparent color",
CW_info_notransparent = "No transparent color",
CW_transparent_text = "Transparent color",

PCW_index_text = "Color index:",
PCW_index_hint = "Color index",
PCW_info_text = "Index: %d (#%x)   -   Red:%d Green:%d Blue:%d",

RCW_red_text = "Red: %d",
RCW_red_text_none = "Red",
RCW_green_text = "Green: %d",
RCW_green_text_none = "Green",
RCW_blue_text = "Blue: %d",
RCW_blue_text_none = "Blue",

RCW_info_text = "Transparent color: #%02x%02x%02x",

OK_title = "OK",
Cancel_title = "Cancel",

ProgressWin_title = "Working...",

OpenPicture_hint = "Open picture",
Cancel_hint = "Cancel operation",
Hide_hint = "Hide file in picture",
Retrieve_hint = "Retrieve file from picture",
SavePicture_hint = "Save picture",
SavePictureAs_hint = "Save picture as",

AllFiles_title = "All files (*.*)",
FilterFiles_title = "%s pictures (*.%s)",

NoTransparent_info = "None",
PictureInfo_text = "File: %s\nDimensions: %d x %d\nBits per pixel: %d\n"&
		   "Transparent color: %s\n\nMaximum capacity: %d bytes",
PictureInfo_title = "Bitmap information",

Child_title = "%s - "&MainWin_title,
ImageMenu_title = "&Image",
ImageHide_title = "&Hide file...",
ImageRetrieve_title = "&Retrieve file...",
ImageErase_title = "&Erase file...",
ImageSave_title = "&Save picture",
ImageSaveAs_title = "Save picture &as...",
ImageClose_title = "&Close picture",
ImageTransparent_title = "&Transparent color...",
ImageInformation_title = "Picture &information...",

ViewMenu_title = "&View",
ViewFitWindow_title = "&Fit window to image",

ZoomMenu_title = "Zoom",

SavePicture_text = "%s\nhas been modified, save it before closing?",
SavePicture_title = "Question",

FitToWindow_text = "Fit to window",

About_text = "Hide In Picture - version "&HIP_VERSION&"\n" &
	     "Copyright (C) 2002  Davi Figueiredo\n" &
	     translation&
	     "\n"&
	     "This program has been created using:\n"&
	     "Euphoria by RDS\n"&
	     "Win32Lib by David Cuny, Derek Parnell and others\n"&
	     "\n"&
	     "This program is distributed under the terms of the\n"&
	     "GNU General Public License.\n"&
	     "\n"&
	     "Visit http://hide-in-picture.sf.net/ for the newest versions and news.",

About_title = "About HIP",


dummy=0     -- just to keep the comma after the last constant

