/*
 * EW Snake - Versione 0.5
 * Copyright (C) 2001 di Federico Marverti (yfede)
 *
 * Questo programma e` distribuito secondo i termini della Licenza
 * Pubblica Generica GNU (GNU GPL: GNU General Public License).
 * Per maggiori informazioni e riguardo leggere il file README.TXT
 * allegato alla distribuzione del presente codice sorgente.
 */

/* --- Inizio di main.c --- */

#include "defs.h"
#include <allegro.h>
#include <stdio.h>
#include <stdlib.h>             /* Per srand e rand */
#include <time.h>               /* Per time */

extern void load_config( struct st_config *cfg );   /* Legge la configurazione da file o default */
extern int save_config( struct st_config *cfg );    /* Salva la configurazione corrente su file */
extern void reset_colors( struct st_config *cfg );  /* Reimposta i colori */
extern void reset_screen( void );   /* Cancella lo schermo e colora lo sfondo */
extern void main_menu( struct st_config *cfg ); /* Visualizza il menu principale */
extern int set_gfx( struct st_config *cfg );    /* Imposta il video e disegna le bitmap */
extern void unset_gfx( struct st_config *cfg ); /* Distrugge le bitmap */

/* Indicazioni per la riduzione delle dimensioni dell'eseguibile */
BEGIN_COLOR_DEPTH_LIST
    COLOR_DEPTH_8
END_COLOR_DEPTH_LIST

BEGIN_DIGI_DRIVER_LIST
END_DIGI_DRIVER_LIST

BEGIN_MIDI_DRIVER_LIST
END_MIDI_DRIVER_LIST

BEGIN_JOYSTICK_DRIVER_LIST
END_JOYSTICK_DRIVER_LIST

int main( void )
{
    struct st_config cfg;       /* Dati di configurazione */

    allegro_init();             /* Inizializza la libreria allegro */
    check_cpu();                /* Controlla i dati relativi alla CPU */
    install_timer();            /* Installa il timer */
    install_keyboard();         /* Installa la routine per la tastiera */
    install_mouse();            /* Installa il driver del mouse */

    load_config( &cfg );        /* Legge la configurazione */

    if( set_gfx( &cfg ) != R_OK )   /* Imposta la modalita` video in base ai dati contenuti in cfg */
    {
        printf( "Impossibile impostare la risoluzione richiesta\n" );
        return R_ERR;
    }

    srand( time( NULL ) );      /* Imposta il seme dei numeri casuali */

    reset_colors( &cfg );       /* Reimposta i colori */
    reset_screen();             /* Cancella lo schermo */

    main_menu( &cfg );          /* Visualizza il menu principale */

    save_config( &cfg );        /* Salva la configurazione corrente su file */
    
    unset_gfx( &cfg );          /* Distrugge le bitmap utilizzate */

    return R_OK;
}
/* --- Fine di main.c --- */