/*
 * EW Snake - Versione 0.5
 * Copyright (C) 2001 di Federico Marverti (yfede)
 *
 * Questo programma e` distribuito secondo i termini della Licenza
 * Pubblica Generica GNU (GNU GPL: GNU General Public License).
 * Per maggiori informazioni e riguardo leggere il file README.TXT
 * allegato alla distribuzione del presente codice sorgente.
 */

/* --- Inizio di defs.h --- */

#include <allegro.h>

#ifndef _EWSNAKE_DEFS_H_
#define _EWSNAKE_DEFS_H_

#define P_WRITER "EW Software"
#define P_NAME "Snake"
#define P_VERSION "0.5"
#define P_DATE "2001-01-05"

#define MAX_BODY 600            /* Numero massimo di blocchi di cui puo` essere costituito il serpente */
#define HCELLS 32               /* Numero di celle orizzontali */
#define VCELLS 24               /* Num di celle verticali */
#define FIX_DELAY 40            /* Attesa fissa (millisecondi) */
#define LEV_DELAY 11            /* Attesa da aggiungere per ogni livello inferiore a quello massimo */
#define MAX_LEVEL 9             /* Livello massimo giocabile */
#define OUTOFSCREEN (-1)        /* Coordinata fuori dallo schermo */
#define CONFIG_NAME "EWSNAKE.05"    /* Nome del file di configurazione */
#define NO_FOCUS (-1)           /* Indica di non focalizzare alcun elemento della dialog */

#define CL_TRANSPARENT 0        /* Indici per i colori nella palette corrente */
#define CL_BACKGROUND 1         /* Colore di sfondo */
#define CL_SNAKE 2              /* Colore del serpente */
#define CL_GOAL 3               /* Colore dell'obiettivo */
#define CL_WALL 4               /* Colore del muro */
#define CL_GUI 5                /* Colore delle GUI */
#define CL_TEXT 6               /* Colore del testo */
#define CL_OLD 7                /* Colore di test usato nella gui di scelta dei colori */
#define CL_NEW 8                /* Colore di test usato nella gui di scelta dei colori */
#define CL_MOUSE 255            /* Colore del cursore del mouse */

#define D_UP 1                  /* Costanti per la direzione */
#define D_DOWN 2
#define D_RIGHT 3
#define D_LEFT 4
#define D_UNDEF 5

#define R_OK 1                  /* Valori di ritorno */
#define R_ERR 0

#define DE_COLOR_DEPTH 8        /* Valori di default */
#define DE_RESX 640             /* Risoluzione di default */
#define DE_RESY 480
#define DE_DIRECTION D_RIGHT    /* Direzione di partenza */
#define DE_SIZE 4               /* Dimensione iniziale del serpente */
#define DE_STARTX 16            /* Posizione iniziale della testa del serpente */
#define DE_STARTY 10
#define DE_C_BACKGROUNDR 0      /* Componenti del colore di sfondo */
#define DE_C_BACKGROUNDG 0 
#define DE_C_BACKGROUNDB 40
#define DE_C_SNAKER 40          /* Componenti del colore del serpente */
#define DE_C_SNAKEG 40
#define DE_C_SNAKEB 63
#define DE_C_GOALR 0            /* Componenti del colore dell'obiettivo */
#define DE_C_GOALG 63
#define DE_C_GOALB 0
#define DE_C_WALLR 63           /* Componenti del colore del muro */
#define DE_C_WALLG 63
#define DE_C_WALLB 0
#define DE_C_GUIR 63            /* Componenti del colore delle GUI */
#define DE_C_GUIG 63
#define DE_C_GUIB 0
#define DE_C_TEXTR 0            /* Componenti del colore del testo */
#define DE_C_TEXTG 63
#define DE_C_TEXTB 0
#define DE_C_MOUSER 63          /* Componenti del colore del cursore del mouse */
#define DE_C_MOUSEG 63
#define DE_C_MOUSEB 63
#define DE_RECORD 0             /* Valore di default per il record */
#define DE_LEVEL 5              /* Livello di default */
#define DE_GROW 2               /* Crescita di default */
#define DE_FONTH 8              /* Altezza e larghezza di default del font */
#define DE_FONTW 8
#define DE_CELLSIZE 10          /* Dimensione di default delle celle */

#define W_WALL 1                /* Valori per le celle dei muri */
#define W_EMPTY 0

#define KEY_NONE (-1)           /* Scancode arbitrario per indicare che non e` stato premuto alcun tasto */

#define ST_NORMAL 0             /* Stati del serpente */
#define ST_GOAL 1               /* Ha preso l'obiettivo */
#define ST_WALL 2               /* Ha preso il muro */
#define ST_SNAKE 3              /* Ha preso se stesso */

struct st_game                  /* Dati riguardanti il gioco (evitando dettagli grafici e hardware) */
{
    int direction;              /* Direzione corrente del serpente */
    int size;                   /* Dimensione (in blocchi) del serpente */
    int x[MAX_BODY];            /* Array delle ascisse dei blocchi del serpente */
    int y[MAX_BODY];            /* Array delle ordinate dei blocchi del serpente */
    int goal_x, goal_y;         /* Coordinate dell'obiettivo */
    int wall[HCELLS][VCELLS];   /* Array contenente i dati per i muri */
    int score;                  /* Punteggio ottenuto */
    int to_grow;                /* Dimensione di cui deve cresecere ancora il serpente */
};

struct st_config                /* Struttura per la configurazione */
{
    int resx, resy;             /* Risoluzione x e y dello schermo */
    int cellsize;               /* Dimensione di una cella del serpente */
    int record;                 /* Record ottenuto */
    int level;                  /* Livello di gioco */
    RGB c_background;           /* Componenti RGB del colore di sfondo */
    RGB c_snake;                /* Componenti RGB del colore del serpente */
    RGB c_goal;                 /* Componenti RGB del colore dell'obiettivo */
    RGB c_wall;                 /* Componenti RGB del colore del muro */
    RGB c_gui;                  /* Componenti RGB del colore delle GUI */
    RGB c_text;                 /* Componenti RGB del colore del testo */
    RGB c_mouse;                /* Componenti RGB del colore del mouse */
    RGB c_new;                  /* Colore nuovo, utilizzato per la scelta dei colori */
    BITMAP *bm_snake;           /* Puntatore alla bitmap da usare per i blocchi del serpente */
    BITMAP *bm_goal;            /* Puntatore alla bitmap da usare per l'obiettvo */
    BITMAP *bm_empty;           /* Puntatore alla bitmap con il solo colore di sfondo */
    BITMAP *bm_wall;            /* Puntatore alla bitmap del muro */
};

#endif
/* --- Fine di defs.h --- */