#include <dpmi.h>

// Gets the mouse position and button status.
// Usage: get_mouse_pos(&x_pos, &y_pos, &button)
// The information will be put into the variables.
void get_mouse_pos(short *x_pos, short *y_pos, short *mouse_button) {
  __dpmi_regs regs;
  regs.x.ax = 0x03;
  __dpmi_int(0x33, &regs);
  *x_pos = regs.x.cx >> 1;
  *y_pos = regs.x.dx;
  *mouse_button = regs.x.bx;
}

// Sets the mouse position to x_pos, y_pos.
void set_mouse_pos(short x_pos, short y_pos) {
  __dpmi_regs regs;
  regs.x.ax = 0x04;
  regs.x.cx = x_pos << 1;
  regs.x.dx = y_pos;
  __dpmi_int(0x33, &regs);
}
