;-------------------------------------------------------------------------------
; Wissensbasis fuer das Go-Programm                       Begonnen am 18.3.1994
; Joachim Pimiskern
;-------------------------------------------------------------------------------

(!outmsg "Wissensbasis wird geladen")
;(setq fp nil)

; Alle Symbole erst einmal bekannt machen
(setq !patterns             nil)
(setq Muster-Feinde         nil)
(setq Muster-Eckzuege       nil)
(setq Muster-Randzuege      nil)
(setq Muster-Basiszuege     nil)
(setq Muster-Shimaris       nil)
(setq Muster-Ecktripel      nil)
(setq Muster-lokal-optimal  nil)
(setq Muster-Vorschlaege    nil)
(setq Muster-Kontextbezogen nil)
(setq Muster-Abdichten      nil)
(setq Muster-Fest-Verbinden nil)
(setq Muster-Verbinden      nil)
(setq Muster-Formzug        nil)
(setq Muster-Schneiden      nil)
(setq Muster-Schnitt-drohen nil)
(setq Muster-Fluchtsprung   nil)
(setq Muster-Invasion-verhindern nil)
(setq Muster-Hane           nil)
(setq Muster-DreiVier       nil)
(setq Muster-Lebensvorhand  nil)

(setq Schwache-Gruppen      nil)
(setq Ziele                 nil)
(setq Regeln                nil)
(setq Versuche              nil)
(setq Treppen               nil)
(setq Strategische-Werte    nil)
(setq Spielerkette          -1)


(defun zugvorschlag (x)
   (if (!sinnvoll x)
       (progn
          (!zugvorschlag x)
          (setq *endeflag* t)
       )
   )
)



(defun outmsg (s)
   (!outmsg s)
;   (if (filep fp)
;       (print s fp)
;   )
)



(defun zv (x)
   (let ((result 0))
         (if (!legal x 1)
             (progn
                (!pushboard)
                (!set-stone x 1)
                (setq result (!zval))
                (!popboard)
             )
         )
    (+ result 361)
   )
)


(defun treppendroher (zug feind)
   (let (result)
         (if (!legal zug 1)
             (progn
                (!pushboard)
                (!set-stone zug 1)
                (setq result (!shicho feind))
                (!popboard)
             )
         )
    result
   )
)




(defun garbage-collection ()
  (if (< (maxavail) 2000000)
      (progn
         (outmsg "Garbage Collection")
         (gc)
         (outmsg "")
      )
  )
)


;-------------------------------------------------------------------------------
; Mittels dieser Routine denkt das Go-Programm
;-------------------------------------------------------------------------------
(defun nachdenken ()
;   (setq fp (openo "log.txt"))
   (setq !patterns nil)
   (setq Muster-Feinde         nil)
   (setq Muster-Eckzuege       nil)
   (setq Muster-Randzuege      nil)
   (setq Muster-Basiszuege     nil)
   (setq Muster-Shimaris       nil)
   (setq Muster-Ecktripel      nil)
   (setq Muster-lokal-optimal  nil)
   (setq Muster-Vorschlaege    nil)
   (setq Muster-Kontextbezogen nil)
   (setq Muster-abdichten      nil)
   (setq Muster-fest-verbinden nil)
   (setq Muster-verbinden      nil)
   (setq Muster-Formzug        nil)
   (setq Muster-Schneiden      nil)
   (setq Muster-Schnitt-drohen nil)
   (setq Muster-Fluchtsprung   nil)
   (setq Muster-Invasion-verhindern nil)
   (setq Muster-Hane           nil)
   (setq Muster-DreiVier       nil)
   (setq Muster-Lebensvorhand  nil)


   (garbage-collection)
   (outmsg "Mustererkennung")
   (!pattern-matching)
   (!berechne-gebiet)
   (garbage-collection)
   (outmsg "Musterverarbeitung")
   (bearbeite-patterns)
   (garbage-collection)



   (outmsg "Bestimmung schwacher Ketten")

;  (setq Schwache-Gruppen      (!weak-groups))
   (setq Schwache-Gruppen nil)

   (setq Staerken nil)
   (dolist (x (!ketten) nil)
      (garbage-collection)
      (let (temp)
         (setq temp (staerke x))
         (setq Staerken (cons (list x temp) Staerken))
         (if (eql temp 'schwach)
             (setq Schwache-Gruppen (cons x Schwache-Gruppen))
         )
         (if (eql temp 'sehr-schwach)
             (setq Schwache-Gruppen (cons x Schwache-Gruppen))
         )
         (if (eql 1 (length (!liberties x)))
             (setq Schwache-Gruppen (cons x Schwache-Gruppen))
         )
      )
   )


   (setq Ziele                 nil)
   (setq Regeln                nil)
   (setq Versuche              nil)
   (setq Treppen               nil)
   (setq Strategische-Werte    nil)


   (outmsg "Treppenanalyse")
   (treppenanalyse)
   (strategiewerte)

   ;--- Start mit der allerersten Regel ---
   (Regel-0)
   (setq StartZeit (time))



   (garbage-collection)

   (setq save-ziele (copy ziele))

   (setq *endeflag* nil)
   (ausfuehrversuch)





   (gc)
   (sound 600)
   (delay 300)
   (nosound)
;   (close fp)
;   (!show "log.txt")
)




;-------------------------------------------------------------------------------
; Alle Symbole einer Liste bestimmen
;-------------------------------------------------------------------------------
(defun symbole (l bisher)
   (let (result)
      (dolist (x ziele nil)
         (setq result (cons (caar x) result))
      )
    result
   )
)



;-------------------------------------------------------------------------------
; Die Feinde einer Kette zaehlen. Annahme: MUSTER-FEINDE ist bereits besetzt
;-------------------------------------------------------------------------------
(defun count-of-enemies (x)
   (let ((result 0))
      (dolist (y Muster-Feinde result)
         (if (eql x (car y))
             (setq result (1+ result))
         )
      )
   )
)



;-------------------------------------------------------------------------------
; Alle momentan in Frage kommenden Ziele bewerten
;-------------------------------------------------------------------------------
;(defun sortiere-ziele (Restzeit)
;   (if (> Restzeit 0)
;       (let ((startzeit (time)))
;           (dolist (x regeln nil)
;              (eval (list x))
;           )
;           (sortiere-ziele (- Restzeit (- (time) startzeit)))
;       )
;   )
;)






;-------------------------------------------------------------------------------
; Eine Liste von Zugvorschlaegen filtern, dass Feld an d. Stelle legal ist
;-------------------------------------------------------------------------------
(defun check-empty (l)
  (outmsg "Check-Empty")
  (let (temp)
     (dolist (x l nil)
        (garbage-collection)
        (if (!sinnvoll x)
            (setq temp (cons x temp))
        )
     )
   temp
  )
)



;-------------------------------------------------------------------------------
; Die Liste der erkannten Muster !patterns bearbeiten
;-------------------------------------------------------------------------------
(defun bearbeite-patterns ()
   (dolist (x !patterns nil)
;     (garbage-collection)
      (let ((temp (aref Muster-aktionen (car x))))
         (dolist (y temp nil)
;(if (eql (car y) '$kontextbezogen)
;    (progn
;       (print (list (append y (cdr x)) x))
;       (print muster-kontextbezogen)
;    )
;)
            (eval (append y (cdr x)))
         )
      )
   )
)







;-------------------------------------------------------------------------------
; Fuer alle Ketten mit 2 Freiheiten Treppenanalyse durchfuehren
;-------------------------------------------------------------------------------
(defun treppenanalyse ()
   (outmsg "Treppenanalyse")
   (dolist (x (!ketten) nil)
      (garbage-collection)
      (if (and (not (eql (!color x) 0)) (eql (length (!liberties x)) 2))
          (let ((temp (!shicho x)))
               (garbage-collection)
               (if temp
                   (setq Treppen (cons (list x (list temp)) Treppen))
               )
               (garbage-collection)
          )
      )
   )
)







(outmsg "Loading FLAVORS.LSP")
(load 'flavors)
(outmsg "Loading FUNMERGS.LSP")
(load 'funmergs)
(outmsg "Loading PATTERN.LSP")
(load 'pattern)
(outmsg "Loading MUSTER.LSP")
(load 'muster)
(outmsg "Loading RULES.LSP")
(load 'rules)
(outmsg "Loading ZIELE.LSP")
(load 'ziele)
(outmsg "Loading KLASSEN.LSP")
(load 'klassen)
(outmsg "Loading PP.LSP")
(load 'pp)


;-------------------------------------------------------------------------------
; Ziele sind Listen, bestehend aus Paaren Funktionsaufruf-Wert
; Beispiel: Ziele = (((angreifen 5) 100) ((staerken 182) 101))
;-------------------------------------------------------------------------------
(setq ziele nil)


;-------------------------------------------------------------------------------
; Ein Ziel wurde schon ausprobiert, wenn es in der Liste VERSUCHE ist
;-------------------------------------------------------------------------------
(defun Schon-versucht (x)
   (let (result)
      (dolist (y versuche result)
         (if (equal x y)
             (setq result t)
         )
      )
   )
)



;-------------------------------------------------------------------------------
; Ein Ziel (eine Liste) einplanen
;-------------------------------------------------------------------------------
(defun ziel-einplanen (ziel wert)
   (if (not (schon-versucht ziel))
       (setq ziele (cons (list ziel wert) ziele))
   )
)





(defun Regelauswertung (Regel Prdikat1 Argument1 Prdikat2 Argument2)
   (let (result)
      (outmsg (symbol-name regel))
      (setq result (eval (list Regel
                               (list 'quote Prdikat1)
                               (list 'quote Argument1)
                               (list 'quote Prdikat2)
                               (list 'quote Argument2))))
;  (print result fp)
      (if (not result)
          (progn
              (setq result (eval (list Regel
                                       (list 'quote Prdikat2)
                                       (list 'quote Argument2)
                                       (list 'quote Prdikat1)
                                       (list 'quote Argument1))))
              (if result
                  (setq result (* result -1))
              )
          )
      )
    result
   )
)


(defun GetPriority (Bewertet1 Bewertet2)
   (let (ZuBeachtendeRegeln Ergebnis)
      (setq ZuBeachtendeRegeln (append (cadr (assoc (caar Bewertet1)
                                                    AufrufWnsche
                                             )
                                       )
                                       (cadr (assoc (caar Bewertet2)
                                                    AufrufWnsche
                                             )
                                       )
                               )
      )
      (while (and ZuBeachtendeRegeln (not Ergebnis))
         (setq Ergebnis (Regelauswertung (car   ZuBeachtendeRegeln)
                                         (caar  Bewertet1)
                                         (cadar Bewertet1)
                                         (caar  Bewertet2)
                                         (cadar Bewertet2)
                        )
         )
         (setq ZuBeachtendeRegeln (cdr ZuBeachtendeRegeln))
      )
      (cond (ergebnis ergebnis)
            ((eql (cadr Bewertet1) (cadr Bewertet2)) 0)
            ((>   (cadr Bewertet1) (cadr Bewertet2)) 1)
            (t -1)
      )
   )
)




;-------------------------------------------------------------------------------
; Suchen des Zieles mit dem groessten Prioritaetswert
;-------------------------------------------------------------------------------
(defun Max-Ziel ()
   (let (bisher h)
      (setq bisher (car ziele))
      (dolist (x (cdr ziele) bisher)
         (setq h (GetPriority Bisher x))
         (if (eql h -1)
             (setq bisher x)
         )
      )
   )
)






















;-------------------------------------------------------------------------------
; Eine Art Member-Funktion fuer Ziele-Liste
;-------------------------------------------------------------------------------
(defun finde (ziel liste)
   (cond ((null liste) nil)
         ((equal ziel (caar liste)) liste)
         (t (finde ziel (cdr liste)))
   )
)

;-------------------------------------------------------------------------------
; Sicherstellen, dass ein bestimmtes Ziel eingeplant ist
;-------------------------------------------------------------------------------
(defun verify-goal (g)
   (let (found)
      (dolist (x ziele nil)
         (if (equal (car x) g)
             (setq found t)
         )
      )
      (if (not found)
          (ziel-einplanen g 0)
      )
   )
)


;-------------------------------------------------------------------------------
; Von der Ziele-Liste ein Ziel entfernen
;-------------------------------------------------------------------------------
(defun entferne-ziel (ziel-mit-wert)
   (let (result)
      (setq ziele
            (dolist (x ziele result)
               (if (not (equal x ziel-mit-wert))
                   (setq result (cons x result))
               )
            )
      )
   )
   (garbage-collection)
)


;-------------------------------------------------------------------------------
; Die Werte aller Ziele e. wenig verfaelschen, um Nichtdeterminismus zu erzeugen
;-------------------------------------------------------------------------------
(defun mische-ziele ()
   (dolist (x ziele nil)
      (let (wert)
         (setq wert (cadr x))
         (setq wert (+ 0.5 wert))
         (setq wert (- wert (random)))
         (rplaca (cdr x) wert)
      )
   )
)

;-------------------------------------------------------------------------------
; Ein bisschen Nichtdeterminismus: eine kleine Zufallszahl
;-------------------------------------------------------------------------------
(defun Zufall (x)
   (- (+ x (* 0.1 (random))) 0.05)
)


(defun maximaler-zielwert ()
   (let ((result 0))
      (dolist (x ziele result)
         (if (> (cadr x) result)
             (setq result (cadr x))
         )
      )
   )
)





;-------------------------------------------------------------------------------
; Versuchen, das Ziel mit dem groessten Wert auszufuehren.
;-------------------------------------------------------------------------------
(defun ausfuehrversuch ()
   (while (and ziele (not *endeflag*))
      (if ziele
          (let (temp tempZiel)
             (setq temp              (max-ziel))
             (setq tempZiel          (car temp))
;            (setq globaler-zielwert (cadr temp))
             (setq globaler-zielwert (maximaler-zielwert))

;            (outmsg (symbol-name (car tempZiel)))
             (let (xxx)
                (setq xxx '(nil))
                (princ tempZiel xxx)
                (outmsg (read-line xxx))
             )

             ;--- Den Ausfuehrversuch aufzeichnen ---
;            (outmsg (show-as-string (list tempZiel)))
;            (delay 1000)
             (if Versuche
                 (rplacd (last Versuche) (list tempZiel))
                 (setq Versuche (list tempZiel))
             )

             (entferne-ziel temp)

             ;--- Der eigentliche Ausfuehrversuch ---
             (eval tempZiel)
          )
      )
   )
)




;-------------------------------------------------------------------------------
; Je nach Flag einen Ausdruck drucken oder auch nicht
;-------------------------------------------------------------------------------
(defun druck (flag ausdruck)
   (if (not flag)
       (print ausdruck)
       ausdruck
   )
)



;-------------------------------------------------------------------------------
; Abfragen, welche Funktion ein bestimmter Zug hat.
; Die Frage beschraenkt sich auf Zuege, die von der Mustererkennung
; vorgeschlagen wurden.
;-------------------------------------------------------------------------------
(defun which (x &optional noprint)
   (let (result)
        (dolist (y muster-abdichten nil)
           (if (eql (cadr y) x)
               (setq result (druck noprint (list 'abdichten (car y) (cadr y))))
           )
        )
        (dolist (y muster-formzug nil)
           (if (eql (cadr y) x)
               (setq result (druck noprint (list 'formzug (car y) (cadr y))))
           )
        )
        (dolist (y muster-lebensvorhand nil)
           (if (eql (cadr y) x)
               (setq result (druck noprint (list 'lebensvorhand (car y) (cadr y))))
           )
        )
        (dolist (y muster-fluchtsprung nil)
           (if (eql (cadr y) x)
               (setq result (druck noprint (list 'fluchtsprung (car y) (cadr y))))
           )
        )
        (dolist (y muster-verbinden nil)
           (if (eql (cadr y) x)
               (setq result (druck noprint (list 'verbinden (car y) (cadr y))))
           )
        )
        (dolist (y muster-fest-verbinden nil)
           (if (eql (cadr y) x)
               (setq result (druck noprint (list 'fest-verbinden (car y) (cadr y))))
           )
        )
        (dolist (y muster-schneiden nil)
           (if (eql (cadr y) x)
               (setq result (druck noprint (list 'schneiden (car y) (cadr y))))
           )
        )
        (dolist (y muster-schnitt-drohen nil)
           (if (eql (cadr y) x)
               (setq result (druck noprint (list 'schnitt-drohen (car y) (cadr y))))
           )
        )
        (dolist (y muster-hane nil)
           (if (eql (cadr y) x)
               (setq result (druck noprint (list 'hane (car y) (cadr y))))
           )
        )
        (dolist (y muster-kontextbezogen nil)
           (if (eql (car y) x)
               (setq result (druck noprint (list 'kontextbezogen (car y) (cadr y))))
           )
        )
    result
   )
)





;-------------------------------------------------------------------------------
; Die taktischen Werte aller Ketten berechnen: Steine * 2 + Freiheiten
;-------------------------------------------------------------------------------
(defun taktikwerte ()
   (garbage-collection)
   (outmsg "Taktische Werte werden bestimmt")
   (let (temp)
      (dolist (x (!ketten) nil)
        (setq temp (cons (list x (+ (* 2 (length (!territory x)))
                                    (length (!liberties x))
                                 )
                         )
                         temp
                   )
        )
      )
      temp
   )


;  (let ((result nil)
;        (wz (!whiteconnected))
;        (sz (!blackconnected)))
;     (dolist (x (!ketten) nil)
;       (setq result (cons (list x (+ (* 2 (length (!territory x)))
;                                     (if (eql (!color x) 1)
;                                         (length (!connected x sz))
;                                         (length (!connected x wz))
;                                     )
;                                  )
;                          )
;                          Result
;                    )
;       )
;     )
;     result
;  )
)


;------------------------------------------------------------------------------
;  Die strategischen Werte aller Gruppen berechnen. Praeziser gesagt, es wird
;  berechnet, wie gross der Wert eines Angriff auf eine bestimmte Gruppe bzw.
;  wie gross der Wert der Verteidigung einer bestimmten Gruppe ist. Sichere
;  Gruppen haben den strategischen Wert 0.
; -----------------------------------------------------------------------------
(defun strategiewerte ()
   (garbage-collection)
   (outmsg "Bestimmung der strategischen Werte aller Gruppen")
   (let ((ergebnis1 nil) (tw (taktikwerte)))
     (garbage-collection)
     (dolist (tempS Schwache-Gruppen nil)
        (let ((summe (cadr (assoc tempS tw))))
           (dolist (tempS2 muster-feinde nil)
              (if (eql (car tempS2) tempS)
                 (if (member (cadr tempS2) Schwache-Gruppen)
                     (setq summe (+ summe (cadr (assoc (cadr tempS2) tw))))
                 )
              )
           )
           (setq ergebnis1 (cons (list tempS summe) ergebnis1))
        )
     )
     (setq strategische-werte ergebnis1)
     ergebnis1
   )
)




















;-------------------------------------------------------------------------------
; Musik-Experimente
;-------------------------------------------------------------------------------


(defun expt (x y)
  (exp (* y (ln x)))
)

(setq faktor (expt 2 (/ 1.0 12)))


(defun frequenz (stufe)
  (* 440.0 (expt faktor stufe))
)


;
;(dotimes (x 24 (nosound))
;   (sound (frequenz x))
;   (delay 100)
;)

(outmsg "")



