;-------------------------------------------------------------------------------
; Mein eigenes Flavors-System (Joachim Pimiskern). 27/28.10.1994
;-------------------------------------------------------------------------------
;
;   Ein Objekt ist eine Liste:
;
;       (object [(<Eltern-Objekte>)]
;               [(<Instanz-Variablen>)]
;               [(<abweichende Instanz-Methoden>)]
;       )
;   Einfachstes Objekt ist (object nil nil nil)
;
;-------------------------------------------------------------------------------
;   (get-value <Objekt> <Variable>)
;   holt den Wert einer Objekt-Variablen
;-------------------------------------------------------------------------------
;   (set-value <Objekt> <Variable> <Wert>)
;   setzt den Wert einer Objekt-Variablen
;-------------------------------------------------------------------------------
;   (send <Objekt> <Methode> <Arg1> <Arg2> ...)
;   Objekt-Methode aufrufen mit Argument1, Argument2 ...
;-------------------------------------------------------------------------------
;   (make-instance <Elter1> <Elter2> ...)
;   Ein Objekt ableiten
;-------------------------------------------------------------------------------
;   (objectp <X>)
;   Ist <X> ein Objekt ?
;-------------------------------------------------------------------------------
;   (defmethod <Objekt> <Methode> <Formale Parameter> ...)
;   fgt neue Prozeduren ein
;-------------------------------------------------------------------------------
;   (defvar <Objekt> <Variable> [Wert])
;   fgt neue Variable hinzu
;-------------------------------------------------------------------------------





;-------------------------------------------------------------------------------
; Test, ob ein Objekt vorliegt
;-------------------------------------------------------------------------------
(defun objectp (x)
   (and (consp x)
        (eql (car x) 'object)
        (listp (cadr  x))
        (listp (caddr x))
        (listp (cadddr x))
   )
)



;-------------------------------------------------------------------------------
; Vollstaendige Variablenliste (Paare von Symbolen/Werten) eines Objektes
; holen. Hierbei werden auch Variablen von Eltern geholt.
;-------------------------------------------------------------------------------
(defun get-var-binding (objekt bisher)
   (if (not (objectp objekt))
       bisher
;   else
       (let ((result bisher) temp)
         ;--- Lokale Variablen-Liste durchgehen ---
         (dolist (x (caddr objekt) nil)
            (setq temp (assoc (car x) result))
            (if (not temp)
                (setq result (cons x result))
            )
         )
         ;--- Eltern-Objekte durchsuchen ---
         (dolist (x (cadr objekt) nil)
            (if (boundp x)
                (setq result (get-var-binding (eval x) result))
            )
         )

         result
       )
   )
)


;-------------------------------------------------------------------------------
; Den Wert einer Variablen eines Objektes holen
;-------------------------------------------------------------------------------
(defmacro get-value (objekt variable)
   `(progn
        (cadr (assoc ',variable (caddr ,objekt)))
    )
)

;-------------------------------------------------------------------------------
; Den Wert einer Objektvariablen setzen
;-------------------------------------------------------------------------------
(defmacro set-value (objekt variable wert)
   `(progn
        (car (rplaca (cdr (assoc ',variable (caddr ,objekt))) ,wert))
    )
)


;-------------------------------------------------------------------------------
; Folgende beiden Funktionen dienen dazu, eine Objektmethode zu suchen
;-------------------------------------------------------------------------------
(defun find-method-by-list (objektliste methode)
   (let (temp)
        (cond ((null objektliste) nil)
              ((setq temp (find-method (eval (car objektliste)) methode)) temp)
              (t (find-method-by-list (cdr objektliste) methode))
        )
   )
)


(defun find-method (objekt methode)
   (let (temp)
      (setq temp (assoc methode (cadddr objekt)))
      (if temp
          temp
          (progn
              (dolist (x (cadr objekt) nil)
              )
              (find-method-by-list (cadr objekt) methode)
          )
      )
   )
)





;-------------------------------------------------------------------------------
; Eine Objekt-Methode aufrufen bzw. eine Nachricht verschicken
;-------------------------------------------------------------------------------
(defmacro send (objekt methode &rest argumente)
   `(let (temp code)
       (setq code (cadr (find-method ,objekt ',methode)))
       ;--- Bindungsumgebung fuer SELF erzeugen ---
       (setq temp (list 'let (list (list 'self (list 'quote ,objekt)))
                       (list 'apply
                             (list 'quote code)
                             (list 'mapcar ''eval (list 'quote ',argumente))
                       )
                 )
       )
        (eval temp)
    )
)



;-------------------------------------------------------------------------------
; Eine Menge von Objekten zu einer Instanz ableiten, wobei von den Variablen
; eine private Kopie angelegt wird. Eine Instanz wird individuell durch seine
; persoenliche Variablenauspraegung. Sollte einmal der Wunsch auftauchen,
; aus Sparsamkeitsgruenden Variablenwerte ableiten zu koennen, so moege man
; entsprechende Methoden schreiben und per Send ansprechen
;-------------------------------------------------------------------------------
(defmacro make-instance (&rest eltern)
   `(let (temp)
         (setq temp (list 'object ',eltern nil nil))
         (rplaca (cddr temp) (get-var-binding temp nil))
         (copy temp)
    )
)





;-------------------------------------------------------------------------------
; Eine neue Objektmethode definieren
;-------------------------------------------------------------------------------
(defmacro defmethod (objekt methode Parameterliste &rest Rumpf)
   `(let (methodenliste fundort lambda-ausdruck)
      ; Nachschauen, ob Methode gleichen Namens schon bekannt ist
      (setq methodenliste (cadddr ,objekt))
      (dolist (laeufer methodenliste nil)
         (if (eql (car laeufer) ',methode)
             (setq fundort laeufer)
         )
      )

      (setq lambda-ausdruck (cons 'lambda
                                  (cons ',Parameterliste ',Rumpf)
                             )
      )

      (if (null fundort)
          (rplaca (cdddr ,objekt)
                  (cons (list ',methode lambda-ausdruck)
                        methodenliste
                  )
          )
          ;else
          (rplaca (cdr fundort) lambda-ausdruck)
      )
    )
)




;-------------------------------------------------------------------------------
; Sicherstellen, dass ein Objekt eine bestimmte Variable besitzt
;-------------------------------------------------------------------------------
(defmacro defvar (objekt variable &optional wert)
   `(let (found oldvars)
      (setq found (assoc ',variable (caddr ,objekt)))
      (if found
          (rplaca (cdr found) ,wert)
          ;else
          (progn
             (setq oldvars (caddr ,objekt))
             (rplaca (cddr ,objekt) (cons (list ',variable ,wert) oldvars))
          )
      )
    )
)


;-------------------------------------------------------------------------------

(defun is-a-hilfe1 (l b)
   (cond ((null l) nil)
         ((is-a-hilfe2 (eval (car l)) b) t)
         (t (is-a-hilfe1 (cdr l) b))
   )
)

(defun is-a-hilfe2 (a b)
   (cond ((or (not (objectp a)) (not (objectp (eval b)))) nil)
         ((member b (cadr a)) t)
         (t (is-a-hilfe1 (cadr a) b))
   )
)

;-------------------------------------------------------------------------------
; Ist a ein b ?
; Fuer Zyklen gilt, dass fuer alle Objekte A im Zyklus gilt: (is-a A A).
;-------------------------------------------------------------------------------
(defmacro is-a (a b)
  `(progn
       (is-a-hilfe2 ,a ',b)
   )
)


;-------------------------------------------------------------------------------
; Ein elementares Objekt:
;-------------------------------------------------------------------------------
(setq ding '(object () () ()))
(setq self '(object () () ()))
