/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 dying.sc
 Contains a public script instance to handle when the ego dies.
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script DYING_SCRIPT)
/******************************************************************************/
(use "main")
(use "controls")
(use "dcicon")
(use "cycle")
(use "obj")
(use "sciAudio")
(local
   snd
)
/******************************************************************************/
(instance public DyingScript of Script
	(properties
	    seconds 3	// Customization by Gumby, see below...
	)
	(method (changeState newState)
		(var mbResult, message)
		= state newState
		(if(== state 0)
			ProgramControl()
			(send gTheMusic:fade())
			(send gRoom:setScript(0))
			Load(rsSOUND 2)
			//= seconds 3              // Customization by Gumby, use script object 'seconds' property, defaulted to 3.  Allows us to 
			                           // call the dyingScript and specify the number of seconds before the death screen opens
		)(else
  			(if(== state 1)
  				/*
  				(send gTheSoundFX:stop())
  				(send gTheMusic:
  					number(2)
  					loop(1)
  					priority(-1)
  					play()
  				)
  				*/
  				= snd aud
			    (send snd:
		           command("play")
		           fileName("speech\\ho-ho-ho.sciAudio")
		           volume("50")
		           loopCount("0")
		           init()
		        )
		        
      
                // The following lines give a typical Sierra style
                // message box telling the player that they have died.
                // You can customize it to your liking.

  				(if(<> NULL caller)
  					Load(rsVIEW caller)
  					(deadIcon:view(caller))
  				)(else
  					Load(rsVIEW DYING_SCRIPT)
  					(deadIcon:view(DYING_SCRIPT))
  				)
  				(if(<> NULL register)
  					= message register
  				)(else
  					= message "You are dead."
  				)

  				(if(Print(
  					message
  					#font gDeadFont
  					#icon deadIcon
  					#button "Keep On Muddling" 0
  					#button "Order A Hintbook" 1
  				))
  					Print(977 0) /* Order a hint book? Who do you think I am? Sierra On-Line? Naw, I'm just a measly computer programmer that made this game in his basement! */
  				)

  				(while(1)
  					= mbResult Print(
  						"Remember:\nsave early, save often!"
  						#title "Gumby advises:"
  						#font gDeadFont
  						#button "Restore"  1
  						#button "Restart"  2
  						#button "  Quit  " 3
  					)
  					(switch(mbResult)
  						(case 1
  							(if(<> (send gGame:restore()) -1) 
  								return
  							)
		    			)
		    			(case 2
  							(send gGame:restart())
  							return
		    			)
		    			(case 3
		    				= gQuitGame TRUE
		    				return
		    			)
		    		)
		    	)
  			)
  		)
	)
)
/******************************************************************************/
(instance deadIcon of DCIcon
	(properties)
	(method (init)
		(super:init())
		(if(== gRoomNumberExit 540)
			= cycler (End:new())
			(send cycler:init(self))
		)
	)
)
/******************************************************************************/
// sciAudio
(instance aud of sciAudio
   (properties)
   (method (init)
      (super:init())
   )
)