/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17;

import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SVNRemoteStatusEditor17
extends SVNStatusEditor17
implements ISVNEditor,
ISvnObjectReceiver<SvnStatus> {
    private boolean myIsRootOpen;
    private SvnStatus myAnchorStatus;
    private DirectoryInfo myDirectoryInfo;
    private FileInfo myFileInfo;
    private File myAnchorAbsPath;
    private String myTargetBaseName;
    private File myTargetAbsPath;
    private boolean myIsMarkingDeleted;
    private boolean myIsCheckWorkingCopy;

    public SVNRemoteStatusEditor17(File anchorAbsPath, String targetBaseName, SVNWCContext wcContext, ISVNOptions options, boolean includeIgnored, boolean reportAll, SVNDepth depth, boolean checkWorkingCopy, ISvnObjectReceiver<SvnStatus> realHandler) throws SVNException {
        super(SVNFileUtil.createFilePath(anchorAbsPath, targetBaseName), wcContext, options, includeIgnored, reportAll, depth, realHandler);
        this.myAnchorStatus = SVNRemoteStatusEditor17.internalStatus(wcContext, anchorAbsPath, checkWorkingCopy);
        this.myIsCheckWorkingCopy = checkWorkingCopy;
        this.myAnchorAbsPath = anchorAbsPath;
        this.myTargetBaseName = targetBaseName;
        this.myTargetAbsPath = SVNFileUtil.createFilePath(anchorAbsPath, targetBaseName);
        this.collectExternals(this.myTargetAbsPath);
    }

    @Override
    public void openRoot(long revision) throws SVNException {
        this.myIsRootOpen = true;
        this.myDirectoryInfo = new DirectoryInfo(null, null);
    }

    @Override
    public void deleteEntry(String path, long revision) throws SVNException {
        File local_abspath = SVNFileUtil.createFilePath(this.myAnchorAbsPath, path);
        this.tweakStatusHash(this.myDirectoryInfo, new DirectoryInfo(path, this.myDirectoryInfo), local_abspath, SVNStatusType.STATUS_DELETED, SVNStatusType.STATUS_NONE, SVNStatusType.STATUS_NONE, SVNRevision.create(revision), null);
        if (this.myDirectoryInfo.parent != null && this.myTargetBaseName == null) {
            this.tweakStatusHash(this.myDirectoryInfo.parent, this.myDirectoryInfo, this.myDirectoryInfo.localAbsPath, SVNStatusType.STATUS_MODIFIED, SVNStatusType.STATUS_MODIFIED, SVNStatusType.STATUS_NONE, null, null);
        }
    }

    private void tweakStatusHash(DirectoryInfo dirInfo, DirectoryInfo childDir, File localAbsPath, SVNStatusType reposNodeStatus, SVNStatusType reposTextStatus, SVNStatusType reposPropStatus, SVNRevision deletedRev, SVNLock reposLock) throws SVNException {
        TreeMap<File, SvnStatus> statushash = dirInfo.statii;
        SvnStatus statstruct = (SvnStatus)statushash.get(localAbsPath);
        if (statstruct == null) {
            if (reposNodeStatus != SVNStatusType.STATUS_ADDED) {
                return;
            }
            statstruct = SVNRemoteStatusEditor17.internalStatus(this.myWCContext, localAbsPath, this.myIsCheckWorkingCopy);
            if (statstruct.getNodeStatus() == SVNStatusType.STATUS_UNVERSIONED || statstruct.getNodeStatus() == SVNStatusType.STATUS_NONE) {
                statstruct.setWorkingCopyFormat(this.myAnchorStatus.getWorkingCopyFormat());
            }
            statstruct.setRepositoryLock(reposLock);
            statushash.put(localAbsPath, statstruct);
        }
        if (reposNodeStatus == SVNStatusType.STATUS_ADDED && statstruct.getRepositoryNodeStatus() == SVNStatusType.STATUS_DELETED) {
            reposNodeStatus = SVNStatusType.STATUS_REPLACED;
        }
        if (reposNodeStatus != null) {
            statstruct.setRepositoryNodeStatus(reposNodeStatus);
        }
        if (reposTextStatus != null) {
            statstruct.setRepositoryTextStatus(reposTextStatus);
        }
        if (reposPropStatus != null) {
            statstruct.setRepositoryPropertiesStatus(reposPropStatus);
        }
        statstruct.setRepositoryRootUrl(this.myRepositoryRoot);
        statstruct.setRepositoryRelativePath(childDir.computeRepositoryRelativePath());
        if (statstruct.getRepositoryNodeStatus() == SVNStatusType.STATUS_DELETED) {
            statstruct.setRepositoryKind(statstruct.getKind());
            if (deletedRev == null || !deletedRev.isValid()) {
                statstruct.setRepositoryChangedRevision(dirInfo.ood_changed_rev);
            } else {
                statstruct.setRepositoryChangedRevision(deletedRev.getNumber());
            }
        } else {
            statstruct.setRepositoryKind(childDir.ood_kind);
            statstruct.setRepositoryChangedRevision(childDir.ood_changed_rev);
            statstruct.setRepositoryChangedDate(childDir.ood_changed_date);
            if (childDir.ood_changed_author != null) {
                statstruct.setRepositoryChangedAuthor(childDir.ood_changed_author);
            }
        }
    }

    @Override
    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myDirectoryInfo = new DirectoryInfo(path, this.myDirectoryInfo);
        this.myDirectoryInfo.added = true;
        this.myDirectoryInfo.parent.text_changed = true;
    }

    @Override
    public void openDir(String path, long revision) throws SVNException {
        this.myDirectoryInfo = new DirectoryInfo(path, this.myDirectoryInfo);
    }

    @Override
    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        if (!name.startsWith("svn:entry:") && !name.startsWith("svn:wc:")) {
            this.myDirectoryInfo.prop_changed = true;
        }
        if (value != null) {
            if ("svn:entry:committed-rev".equals(name)) {
                try {
                    this.myDirectoryInfo.ood_changed_rev = Long.parseLong(value.getString());
                }
                catch (NumberFormatException nfe) {
                    this.myDirectoryInfo.ood_changed_rev = -1L;
                }
            } else if ("svn:entry:last-author".equals(name)) {
                this.myDirectoryInfo.ood_changed_author = value.getString();
            } else if ("svn:entry:committed-date".equals(name)) {
                this.myDirectoryInfo.ood_changed_date = SVNDate.parseDate(value.getString());
            }
        }
    }

    @Override
    public void closeDir() throws SVNException {
        DirectoryInfo db = this.myDirectoryInfo;
        DirectoryInfo pb = db.parent;
        if (db.added || db.prop_changed || db.text_changed || db.ood_changed_rev != -1L) {
            SVNStatusType repos_prop_status;
            SVNStatusType repos_text_status;
            SVNStatusType repos_node_status;
            if (db.added) {
                repos_node_status = SVNStatusType.STATUS_ADDED;
                repos_text_status = SVNStatusType.STATUS_ADDED;
                repos_prop_status = db.prop_changed ? SVNStatusType.STATUS_ADDED : SVNStatusType.STATUS_NONE;
            } else {
                repos_node_status = db.text_changed || db.prop_changed ? SVNStatusType.STATUS_MODIFIED : SVNStatusType.STATUS_NONE;
                repos_text_status = db.text_changed ? SVNStatusType.STATUS_MODIFIED : SVNStatusType.STATUS_NONE;
                SVNStatusType sVNStatusType = repos_prop_status = db.prop_changed ? SVNStatusType.STATUS_MODIFIED : SVNStatusType.STATUS_NONE;
            }
            if (pb != null) {
                this.tweakStatusHash(pb, db, db.localAbsPath, repos_node_status, repos_text_status, repos_prop_status, null, null);
            } else {
                this.myAnchorStatus.setRepositoryNodeStatus(repos_node_status);
                this.myAnchorStatus.setRepositoryPropertiesStatus(repos_prop_status);
                this.myAnchorStatus.setRepositoryTextStatus(repos_text_status);
                if (db.ood_changed_rev != this.myAnchorStatus.getRevision()) {
                    this.myAnchorStatus.setRepositoryChangedRevision(db.ood_changed_rev);
                    this.myAnchorStatus.setRepositoryChangedDate(db.ood_changed_date);
                    this.myAnchorStatus.setRepositoryKind(db.ood_kind);
                    this.myAnchorStatus.setRepositoryChangedAuthor(db.ood_changed_author);
                }
            }
        }
        if (pb != null && !db.excluded) {
            ISVNWCDb.WCDbRepositoryInfo dirReposInfo;
            boolean was_deleted = false;
            SvnStatus dir_status = pb.statii.get(db.localAbsPath);
            if (dir_status != null && (dir_status.getRepositoryNodeStatus() == SVNStatusType.STATUS_DELETED || dir_status.getRepositoryNodeStatus() == SVNStatusType.STATUS_REPLACED)) {
                was_deleted = true;
            }
            if ((dirReposInfo = new ISVNWCDb.WCDbRepositoryInfo()) != null && dir_status != null) {
                dirReposInfo.rootUrl = dir_status.getRepositoryRootUrl();
                dirReposInfo.relPath = SVNFileUtil.createFilePath(dir_status.getRepositoryRelativePath());
                dirReposInfo.uuid = dir_status.getRepositoryUuid();
            }
            this.handleStatii(dirReposInfo, db.statii, was_deleted, db.depth);
            if (dir_status != null && this.isSendableStatus(dir_status)) {
                this.getDefaultHandler().receive(SvnTarget.fromFile(dir_status.getPath()), dir_status);
            }
            pb.statii.remove(db.localAbsPath);
        } else if (pb == null) {
            if (this.myTargetBaseName != null && !"".equals(this.myTargetBaseName)) {
                SvnStatus tgt_status = db.statii.get(this.myTargetAbsPath);
                if (tgt_status != null) {
                    if (tgt_status.isVersioned() && tgt_status.getKind() == SVNNodeKind.DIR) {
                        this.getDirStatus(this.myTargetAbsPath, null, true, null, null, null, null, this.getDepth(), this.isReportAll(), this.isNoIgnore(), this.getDefaultHandler());
                    }
                    if (this.isSendableStatus(tgt_status)) {
                        this.getDefaultHandler().receive(SvnTarget.fromFile(tgt_status.getPath()), tgt_status);
                    }
                }
            } else {
                ISVNWCDb.WCDbRepositoryInfo dirReposInfo = new ISVNWCDb.WCDbRepositoryInfo();
                if (dirReposInfo != null) {
                    dirReposInfo.rootUrl = this.myAnchorStatus.getRepositoryRootUrl();
                    dirReposInfo.relPath = SVNFileUtil.createFilePath(this.myAnchorStatus.getRepositoryRelativePath());
                    dirReposInfo.uuid = this.myAnchorStatus.getRepositoryUuid();
                }
                this.handleStatii(dirReposInfo, db.statii, false, this.getDepth());
                if (this.isSendableStatus(this.myAnchorStatus)) {
                    this.getDefaultHandler().receive(SvnTarget.fromFile(this.myAnchorStatus.getPath()), this.myAnchorStatus);
                }
                this.myAnchorStatus = null;
            }
        }
        this.myDirectoryInfo = this.myDirectoryInfo.parent;
    }

    private boolean isSendableStatus(SvnStatus status) {
        if (status.getRepositoryNodeStatus() != SVNStatusType.STATUS_NONE) {
            return true;
        }
        if (status.getRepositoryLock() != null) {
            return true;
        }
        if (status.getNodeStatus() == SVNStatusType.STATUS_IGNORED && !this.isNoIgnore()) {
            return false;
        }
        if (this.isReportAll()) {
            return true;
        }
        if (status.getNodeStatus() == SVNStatusType.STATUS_UNVERSIONED) {
            return true;
        }
        if (status.getNodeStatus() != SVNStatusType.STATUS_NONE && status.getNodeStatus() != SVNStatusType.STATUS_NORMAL) {
            return true;
        }
        if (status.isConflicted()) {
            return true;
        }
        if (status.isSwitched()) {
            return true;
        }
        if (status.isVersioned() && status.getLock() != null) {
            return true;
        }
        return status.getChangelist() != null;
    }

    private void handleStatii(ISVNWCDb.WCDbRepositoryInfo reposInfo, Map<File, SvnStatus> statii, boolean dirWasDeleted, SVNDepth depth) throws SVNException {
        ISvnObjectReceiver<SvnStatus> handler = dirWasDeleted ? this : this.getDefaultHandler();
        for (File localAbsPath : statii.keySet()) {
            SvnStatus status = statii.get(localAbsPath);
            if (status.getKind() == SVNNodeKind.DIR && (depth == SVNDepth.UNKNOWN || depth == SVNDepth.INFINITY)) {
                this.getDirStatus(localAbsPath, null, true, reposInfo, null, null, this.myGlobalIgnores, depth, this.isReportAll(), this.isNoIgnore(), handler);
            }
            if (dirWasDeleted) {
                status.setRepositoryNodeStatus(SVNStatusType.STATUS_DELETED);
            }
            if (!this.isSendableStatus(status)) continue;
            this.getDefaultHandler().receive(SvnTarget.fromFile(localAbsPath), status);
        }
    }

    @Override
    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myFileInfo = new FileInfo(this.myDirectoryInfo, path, true);
        this.myFileInfo.added = true;
        this.myDirectoryInfo.text_changed = true;
    }

    @Override
    public void openFile(String path, long revision) throws SVNException {
        this.myFileInfo = new FileInfo(this.myDirectoryInfo, path, false);
    }

    @Override
    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        this.myFileInfo.text_changed = true;
        this.myFileInfo.baseChecksum = baseChecksum;
    }

    @Override
    public void changeFileProperty(String path, String propertyName, SVNPropertyValue propertyValue) throws SVNException {
        if (!propertyName.startsWith("svn:entry:") && !propertyName.startsWith("svn:wc:")) {
            this.myFileInfo.prop_changed = true;
        }
        if (propertyValue != null) {
            if ("svn:entry:committed-rev".equals(propertyName)) {
                try {
                    this.myFileInfo.ood_changed_rev = Long.parseLong(propertyValue.getString());
                }
                catch (NumberFormatException nfe) {
                    this.myFileInfo.ood_changed_rev = -1L;
                }
            } else if ("svn:entry:committed-date".equals(propertyName)) {
                this.myFileInfo.ood_changed_date = SVNDate.parseDate(propertyValue.getString());
            } else if ("svn:entry:last-author".equals(propertyName)) {
                this.myFileInfo.ood_changed_author = propertyValue.getString();
            }
        }
    }

    @Override
    public void closeFile(String path, String textChecksum) throws SVNException {
        SVNStatusType repos_prop_status;
        SVNStatusType repos_text_status;
        SVNStatusType repos_node_status;
        SVNLock repos_lock = null;
        if (this.myFileInfo.baseChecksum != null && textChecksum != null) {
            boolean bl = this.myFileInfo.text_changed = !this.myFileInfo.baseChecksum.equals(textChecksum);
        }
        if (!(this.myFileInfo.added || this.myFileInfo.prop_changed || this.myFileInfo.text_changed)) {
            return;
        }
        if (this.myFileInfo.added) {
            File dir_repos_relpath;
            repos_node_status = SVNStatusType.STATUS_ADDED;
            repos_text_status = SVNStatusType.STATUS_ADDED;
            SVNStatusType sVNStatusType = repos_prop_status = this.myFileInfo.prop_changed ? SVNStatusType.STATUS_ADDED : SVNStatusType.STATUS_NONE;
            if (this.myRepositoryLocks != null && (dir_repos_relpath = this.findDirReposRelpath(this.myFileInfo.parent)) != null) {
                File repos_relpath = SVNFileUtil.createFilePath(dir_repos_relpath, this.myFileInfo.name);
                String reposRelPathWithDirectSlashes = repos_relpath.toString().replace(File.separatorChar, '/');
                repos_lock = (SVNLock)this.myRepositoryLocks.get(SVNEncodingUtil.uriDecode("/" + reposRelPathWithDirectSlashes));
            }
        } else {
            repos_node_status = this.myFileInfo.text_changed || this.myFileInfo.prop_changed ? SVNStatusType.STATUS_MODIFIED : SVNStatusType.STATUS_NONE;
            repos_text_status = this.myFileInfo.text_changed ? SVNStatusType.STATUS_MODIFIED : SVNStatusType.STATUS_NONE;
            repos_prop_status = this.myFileInfo.prop_changed ? SVNStatusType.STATUS_MODIFIED : SVNStatusType.STATUS_NONE;
        }
        this.tweakStatusHash(this.myFileInfo, this.myFileInfo.localAbsPath, repos_node_status, repos_text_status, repos_prop_status, -1L, repos_lock);
    }

    private void tweakStatusHash(FileInfo fileInfo, File localAbsPath, SVNStatusType reposNodeStatus, SVNStatusType reposTextStatus, SVNStatusType reposPropStatus, long revnum, SVNLock reposLock) throws SVNException {
        TreeMap<File, SvnStatus> statushash = fileInfo.parent.statii;
        SvnStatus statstruct = (SvnStatus)statushash.get(localAbsPath);
        if (statstruct == null) {
            if (reposNodeStatus != SVNStatusType.STATUS_ADDED) {
                return;
            }
            statstruct = SVNRemoteStatusEditor17.internalStatus(this.myWCContext, localAbsPath, this.myIsCheckWorkingCopy);
            statstruct.setRepositoryLock(reposLock);
            if (statstruct.getNodeStatus() == SVNStatusType.STATUS_UNVERSIONED || statstruct.getNodeStatus() == SVNStatusType.STATUS_NONE) {
                statstruct.setWorkingCopyFormat(this.myAnchorStatus.getWorkingCopyFormat());
            }
            statushash.put(localAbsPath, statstruct);
        }
        if (reposNodeStatus == SVNStatusType.STATUS_ADDED && statstruct.getRepositoryNodeStatus() == SVNStatusType.STATUS_DELETED) {
            reposNodeStatus = SVNStatusType.STATUS_REPLACED;
        }
        if (reposNodeStatus != null) {
            statstruct.setRepositoryNodeStatus(reposNodeStatus);
        }
        if (reposTextStatus != null) {
            statstruct.setRepositoryTextStatus(reposTextStatus);
        }
        if (reposPropStatus != null) {
            statstruct.setRepositoryPropertiesStatus(reposPropStatus);
        }
        statstruct.setRepositoryChangedRevision(fileInfo.ood_changed_rev);
        statstruct.setRepositoryChangedDate(fileInfo.ood_changed_date);
        statstruct.setRepositoryKind(fileInfo.ood_kind);
        statstruct.setRepositoryRootUrl(this.myRepositoryRoot);
        statstruct.setRepositoryRelativePath(fileInfo.computeRepositoryRelativePath());
        if (fileInfo.ood_changed_author != null) {
            statstruct.setRepositoryChangedAuthor(fileInfo.ood_changed_author);
        }
    }

    private File findDirReposRelpath(DirectoryInfo dirinfo) {
        if (dirinfo.name == null) {
            return SVNFileUtil.createFilePath(this.myAnchorStatus.getRepositoryRelativePath());
        }
        DirectoryInfo parent = dirinfo.parent;
        SvnStatus status = parent.statii.get(dirinfo.localAbsPath);
        if (status != null) {
            return SVNFileUtil.createFilePath(status.getRepositoryRelativePath());
        }
        File repos_relpath = this.findDirReposRelpath(parent);
        if (repos_relpath != null) {
            return SVNFileUtil.createFilePath(repos_relpath, dirinfo.name);
        }
        return null;
    }

    @Override
    public void abortEdit() throws SVNException {
    }

    @Override
    public void absentDir(String path) throws SVNException {
    }

    @Override
    public void absentFile(String path) throws SVNException {
    }

    @Override
    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        if (diffWindow != SVNDiffWindow.EMPTY) {
            this.myFileInfo.text_changed = true;
        }
        return null;
    }

    @Override
    public void textDeltaEnd(String path) throws SVNException {
    }

    @Override
    public void receive(SvnTarget target, SvnStatus status) throws SVNException {
        if (this.myIsMarkingDeleted) {
            status.setRepositoryNodeStatus(SVNStatusType.STATUS_DELETED);
        }
        this.getDefaultHandler().receive(target, status);
    }

    @Override
    public SVNCommitInfo closeEdit() throws SVNException {
        if (!this.myIsRootOpen) {
            super.closeEdit();
        }
        return new SVNCommitInfo(this.getTargetRevision(), null, null);
    }

    private class DirectoryInfo
    implements ISvnObjectReceiver<SvnStatus> {
        private File localAbsPath;
        private String name;
        private DirectoryInfo parent;
        private TreeMap<File, SvnStatus> statii;
        private long ood_changed_rev;
        private SVNDate ood_changed_date;
        private SVNNodeKind ood_kind;
        private String ood_changed_author;
        private boolean excluded;
        private SVNDepth depth;
        private boolean added;
        private boolean prop_changed;
        private boolean text_changed;
        private String repositoryRelativePath;

        public DirectoryInfo(String path, DirectoryInfo parent) throws SVNException {
            assert (path != null || parent == null);
            File local_abspath = parent != null ? SVNFileUtil.createFilePath(SVNRemoteStatusEditor17.this.myAnchorAbsPath, path) : SVNRemoteStatusEditor17.this.myAnchorAbsPath;
            this.localAbsPath = local_abspath;
            this.name = path != null ? SVNPathUtil.tail(path) : null;
            this.parent = parent;
            this.statii = new TreeMap();
            this.ood_changed_rev = -1L;
            this.ood_changed_date = null;
            this.ood_kind = SVNNodeKind.DIR;
            this.ood_changed_author = null;
            if (parent != null) {
                if (parent.excluded) {
                    this.excluded = true;
                } else if (parent.depth == SVNDepth.IMMEDIATES) {
                    this.depth = SVNDepth.EMPTY;
                } else if (parent.depth == SVNDepth.FILES || parent.depth == SVNDepth.EMPTY) {
                    this.excluded = true;
                } else {
                    this.depth = parent.depth == SVNDepth.UNKNOWN ? SVNDepth.UNKNOWN : SVNDepth.INFINITY;
                }
            } else {
                this.depth = SVNRemoteStatusEditor17.this.getDepth();
            }
            SvnStatus status_in_parent = parent != null ? parent.statii.get(this.localAbsPath) : SVNRemoteStatusEditor17.this.myAnchorStatus;
            if (!(status_in_parent == null || status_in_parent.getNodeStatus() == SVNStatusType.STATUS_UNVERSIONED || status_in_parent.getNodeStatus() == SVNStatusType.STATUS_EXTERNAL || status_in_parent.getNodeStatus() == SVNStatusType.STATUS_IGNORED || status_in_parent.getKind() != SVNNodeKind.DIR || this.excluded || this.depth != SVNDepth.UNKNOWN && this.depth != SVNDepth.INFINITY && this.depth != SVNDepth.FILES && this.depth != SVNDepth.IMMEDIATES)) {
                Collection ignores = SVNRemoteStatusEditor17.this.myGlobalIgnores;
                ISVNWCDb.WCDbRepositoryInfo parentReposInfo = new ISVNWCDb.WCDbRepositoryInfo();
                parentReposInfo.rootUrl = status_in_parent.getRepositoryRootUrl();
                parentReposInfo.uuid = status_in_parent.getRepositoryUuid();
                SVNRemoteStatusEditor17.this.getDirStatus(local_abspath, null, true, parentReposInfo, null, null, ignores, this.depth == SVNDepth.FILES ? SVNDepth.FILES : SVNDepth.IMMEDIATES, true, true, this);
                SvnStatus this_dir_status = this.statii.get(this.localAbsPath);
                if (this_dir_status != null && this_dir_status.isVersioned() && (this.depth == SVNDepth.UNKNOWN || this.depth.compareTo(status_in_parent.getDepth()) > 0)) {
                    this.depth = this_dir_status.getDepth();
                }
            }
        }

        @Override
        public void receive(SvnTarget target, SvnStatus status) throws SVNException {
            if (status != null) {
                this.statii.put(status.getPath(), status);
            }
        }

        private String computeRepositoryRelativePath() throws SVNException {
            if (this.repositoryRelativePath != null) {
                return this.repositoryRelativePath;
            }
            if (this.name == null) {
                return SVNRemoteStatusEditor17.this.myAnchorStatus.getRepositoryRelativePath();
            }
            SvnStatus status = this.parent.statii.get(this.localAbsPath);
            if (status != null && status.getRepositoryRelativePath() != null) {
                this.repositoryRelativePath = status.getRepositoryRelativePath();
                return status.getRepositoryRelativePath();
            }
            String url = this.parent.computeRepositoryRelativePath();
            if (url != null) {
                this.repositoryRelativePath = url = SVNPathUtil.append(url, this.name);
            }
            return this.repositoryRelativePath;
        }
    }

    public class FileInfo {
        private File localAbsPath;
        private String name;
        private DirectoryInfo parent;
        private long ood_changed_rev;
        private SVNDate ood_changed_date;
        private SVNNodeKind ood_kind;
        private String ood_changed_author;
        private boolean added;
        private boolean text_changed;
        private boolean prop_changed;
        private String baseChecksum;

        public FileInfo(DirectoryInfo parent, String path, boolean added) {
            this.localAbsPath = SVNFileUtil.createFilePath(SVNRemoteStatusEditor17.this.myAnchorAbsPath, path);
            this.name = SVNFileUtil.getFileName(this.localAbsPath);
            this.parent = parent;
            this.ood_changed_rev = -1L;
            this.ood_changed_date = null;
            this.ood_kind = SVNNodeKind.FILE;
            this.ood_changed_author = null;
        }

        private String computeRepositoryRelativePath() throws SVNException {
            return SVNPathUtil.append(this.parent.computeRepositoryRelativePath(), this.name);
        }
    }
}

