/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.FSClosestCopy;
import org.tmatesoft.svn.core.internal.io.fs.FSEntry;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChange;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.io.fs.PathInfo;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class FSUpdateContext {
    private File myReportFile;
    private String myTarget;
    private OutputStream myReportOS;
    private FSFile myReportIS;
    private ISVNEditor myEditor;
    private long myTargetRevision;
    private SVNDepth myDepth;
    private PathInfo myCurrentPathInfo;
    private boolean ignoreAncestry;
    private boolean sendTextDeltas;
    private String myTargetPath;
    private boolean isSwitch;
    private boolean mySendCopyFromArgs;
    private FSRoot myTargetRoot;
    private LinkedList myRootsCache;
    private FSFS myFSFS;
    private FSRepository myRepository;
    private SVNDeltaGenerator myDeltaGenerator;
    private SVNDeltaCombiner myDeltaCombiner;

    public FSUpdateContext(FSRepository repository, FSFS owner, long revision, File reportFile, String target, String targetPath, boolean isSwitch, SVNDepth depth, boolean ignoreAncestry, boolean textDeltas, boolean sendCopyFromArgs, ISVNEditor editor) {
        this.myRepository = repository;
        this.myFSFS = owner;
        this.myTargetRevision = revision;
        this.myReportFile = reportFile;
        this.myTarget = target;
        this.myEditor = editor;
        this.myDepth = depth;
        this.ignoreAncestry = ignoreAncestry;
        this.sendTextDeltas = textDeltas;
        this.myTargetPath = targetPath;
        this.isSwitch = isSwitch;
        this.mySendCopyFromArgs = sendCopyFromArgs;
    }

    public void reset(FSRepository repository, FSFS owner, long revision, File reportFile, String target, String targetPath, boolean isSwitch, SVNDepth depth, boolean ignoreAncestry, boolean textDeltas, boolean sendCopyFrom, ISVNEditor editor) throws SVNException {
        this.dispose();
        this.myRepository = repository;
        this.myFSFS = owner;
        this.myTargetRevision = revision;
        this.myReportFile = reportFile;
        this.myTarget = target;
        this.myEditor = editor;
        this.myDepth = depth;
        this.ignoreAncestry = ignoreAncestry;
        this.sendTextDeltas = textDeltas;
        this.myTargetPath = targetPath;
        this.isSwitch = isSwitch;
        this.mySendCopyFromArgs = sendCopyFrom;
    }

    public void setTargetRoot(FSRoot root) {
        this.myTargetRoot = root;
    }

    public OutputStream getReportFileForWriting() throws SVNException {
        if (this.myReportOS == null) {
            this.myReportOS = SVNFileUtil.openFileForWriting(this.myReportFile);
        }
        return this.myReportOS;
    }

    private boolean isIgnoreAncestry() {
        return this.ignoreAncestry;
    }

    private boolean isSwitch() {
        return this.isSwitch;
    }

    private boolean isSendTextDeltas() {
        return this.sendTextDeltas;
    }

    private String getReportTarget() {
        return this.myTarget;
    }

    private String getReportTargetPath() {
        return this.myTargetPath;
    }

    public void dispose() throws SVNException {
        SVNFileUtil.closeFile(this.myReportOS);
        this.myReportOS = null;
        if (this.myReportIS != null) {
            this.myReportIS.close();
            this.myReportIS = null;
        }
        if (this.myReportFile != null) {
            SVNFileUtil.deleteFile(this.myReportFile);
            this.myReportFile = null;
        }
        if (this.myDeltaCombiner != null) {
            this.myDeltaCombiner.reset();
        }
        this.myTargetRoot = null;
        this.myRootsCache = null;
    }

    private ISVNEditor getEditor() {
        return this.myEditor;
    }

    private long getTargetRevision() {
        return this.myTargetRevision;
    }

    private PathInfo getNextPathInfo() throws IOException, SVNException {
        if (this.myReportIS == null) {
            this.myReportIS = new FSFile(this.myReportFile);
        }
        this.myCurrentPathInfo = this.myReportIS.readPathInfoFromReportFile();
        return this.myCurrentPathInfo;
    }

    private PathInfo getCurrentPathInfo() {
        return this.myCurrentPathInfo;
    }

    private FSRoot getTargetRoot() throws SVNException {
        if (this.myTargetRoot == null) {
            this.myTargetRoot = this.myFSFS.createRevisionRoot(this.myTargetRevision);
        }
        return this.myTargetRoot;
    }

    private LinkedList getRootsCache() {
        if (this.myRootsCache == null) {
            this.myRootsCache = new LinkedList();
        }
        return this.myRootsCache;
    }

    private FSRevisionRoot getSourceRoot(long revision) throws SVNException {
        int i;
        LinkedList cache = this.getRootsCache();
        FSRevisionRoot root = null;
        for (i = 0; i < cache.size() && i < 10; ++i) {
            root = (FSRevisionRoot)this.myRootsCache.get(i);
            if (root.getRevision() == revision) {
                if (i == 0) break;
                this.myRootsCache.remove(i);
                this.myRootsCache.addFirst(root);
                break;
            }
            root = null;
        }
        if (root == null) {
            if (i == 10) {
                this.myRootsCache.removeLast();
            }
            root = this.myFSFS.createRevisionRoot(revision);
            this.myRootsCache.addFirst(root);
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drive() throws SVNException {
        SVNErrorMessage err;
        SVNErrorMessage err2;
        OutputStream reportOS = this.getReportFileForWriting();
        try {
            reportOS.write(45);
        }
        catch (IOException ioe) {
            err2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err2, ioe, SVNLogType.FSFS);
        }
        finally {
            SVNFileUtil.closeFile(reportOS);
            this.myReportOS = null;
        }
        PathInfo info = null;
        try {
            info = this.getNextPathInfo();
        }
        catch (IOException ioe) {
            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err3, ioe, SVNLogType.FSFS);
        }
        if (info == null || !info.getPath().equals(this.getReportTarget()) || info.getLinkPath() != null || FSRepository.isInvalidRevision(info.getRevision())) {
            err2 = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_REVISION_REPORT, "Invalid report for top level of working copy");
            SVNErrorManager.error(err2, SVNLogType.FSFS);
        }
        long sourceRevision = info.getRevision();
        PathInfo lookahead = null;
        try {
            lookahead = this.getNextPathInfo();
        }
        catch (IOException ioe) {
            err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
        }
        if (lookahead != null && lookahead.getPath().equals(this.getReportTarget())) {
            if ("".equals(this.getReportTarget())) {
                SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_REVISION_REPORT, "Two top-level reports with no target");
                SVNErrorManager.error(err4, SVNLogType.FSFS);
            }
            if (lookahead.getRevision() < 0L) {
                lookahead.myDepth = info.getDepth();
            }
            info = lookahead;
            try {
                this.getNextPathInfo();
            }
            catch (IOException ioe) {
                err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
                SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
            }
        }
        String fullTargetPath = this.getReportTargetPath();
        String fullSourcePath = this.myRepository != null ? SVNPathUtil.getAbsolutePath(SVNPathUtil.append(this.myRepository.getRepositoryPath(""), this.getReportTarget())) : SVNPathUtil.getAbsolutePath(this.getReportTarget());
        FSEntry targetEntry = this.fakeDirEntry(fullTargetPath, this.getTargetRoot());
        FSRevisionRoot srcRoot = this.getSourceRoot(sourceRevision);
        FSEntry sourceEntry = this.fakeDirEntry(fullSourcePath, srcRoot);
        if (FSRepository.isValidRevision(info.getRevision()) && info.getLinkPath() == null && sourceEntry == null) {
            fullSourcePath = null;
        }
        if ("".equals(this.getReportTarget()) && targetEntry == null) {
            SVNErrorMessage err5 = SVNErrorMessage.create(SVNErrorCode.FS_PATH_SYNTAX, "Target path ''{0}'' does not exist", (Object)this.getReportTargetPath());
            SVNErrorManager.error(err5, SVNLogType.FSFS);
        } else if ("".equals(this.getReportTarget()) && (sourceEntry == null || sourceEntry.getType() != SVNNodeKind.DIR || targetEntry.getType() != SVNNodeKind.DIR)) {
            SVNErrorMessage err6 = SVNErrorMessage.create(SVNErrorCode.FS_PATH_SYNTAX, "Cannot replace a directory from within");
            SVNErrorManager.error(err6, SVNLogType.FSFS);
        }
        if (this.myDeltaGenerator == null) {
            this.myDeltaGenerator = new SVNDeltaGenerator();
        }
        if (this.myDeltaCombiner == null) {
            this.myDeltaCombiner = new SVNDeltaCombiner();
        }
        this.getEditor().targetRevision(this.getTargetRevision());
        this.getEditor().openRoot(sourceRevision);
        if ("".equals(this.getReportTarget())) {
            this.diffDirs(sourceRevision, fullSourcePath, fullTargetPath, "", info.isStartEmpty(), info.getDepth(), this.myDepth);
        } else {
            this.updateEntry(sourceRevision, fullSourcePath, sourceEntry, fullTargetPath, targetEntry, this.getReportTarget(), info, info.getDepth(), this.myDepth);
        }
        this.getEditor().closeDir();
        this.getEditor().closeEdit();
    }

    private void diffDirs(long sourceRevision, String sourcePath, String targetPath, String editPath, boolean startEmpty, SVNDepth wcDepth, SVNDepth requestedDepth) throws SVNException {
        this.diffProplists(sourceRevision, startEmpty ? null : sourcePath, editPath, targetPath, null, true);
        SVNHashMap sourceEntries = null;
        if (requestedDepth.compareTo(SVNDepth.EMPTY) > 0 || requestedDepth == SVNDepth.UNKNOWN) {
            FSEntry srcEntry;
            String entryEditPath;
            Object[] nextInfo;
            String entryName;
            if (sourcePath != null && !startEmpty) {
                FSRevisionRoot sourceRoot = this.getSourceRoot(sourceRevision);
                FSRevisionNode sourceNode = sourceRoot.getRevisionNode(sourcePath);
                sourceEntries = new SVNHashMap(sourceNode.getDirEntries(this.myFSFS));
            }
            FSRevisionNode targetNode = this.getTargetRoot().getRevisionNode(targetPath);
            SVNHashMap targetEntries = new SVNHashMap(targetNode.getDirEntries(this.myFSFS));
            while ((entryName = (String)(nextInfo = this.fetchPathInfo(editPath))[0]) != null) {
                FSEntry sourceEntry;
                PathInfo pathInfo = (PathInfo)nextInfo[1];
                if (pathInfo != null && FSRepository.isInvalidRevision(pathInfo.getRevision()) && pathInfo.getDepth() != SVNDepth.EXCLUDE) {
                    if (sourceEntries == null) continue;
                    sourceEntries.remove(entryName);
                    continue;
                }
                entryEditPath = SVNPathUtil.append(editPath, entryName);
                String entryTargetPath = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(targetPath, entryName));
                FSEntry targetEntry = (FSEntry)targetEntries.get(entryName);
                String entrySourcePath = sourcePath != null ? SVNPathUtil.getAbsolutePath(SVNPathUtil.append(sourcePath, entryName)) : null;
                FSEntry fSEntry = sourceEntry = sourceEntries != null ? (FSEntry)sourceEntries.get(entryName) : null;
                if (!(pathInfo != null && pathInfo.getDepth() == SVNDepth.EXCLUDE || requestedDepth == SVNDepth.FILES && (targetEntry != null && targetEntry.getType() == SVNNodeKind.DIR || sourceEntry != null && sourceEntry.getType() == SVNNodeKind.DIR))) {
                    this.updateEntry(sourceRevision, entrySourcePath, sourceEntry, entryTargetPath, targetEntry, entryEditPath, pathInfo, pathInfo != null ? pathInfo.getDepth() : this.getDepthBelow(wcDepth), this.getDepthBelow(requestedDepth));
                }
                targetEntries.remove(entryName);
                if (sourceEntries == null || pathInfo != null && pathInfo.getDepth() == SVNDepth.EXCLUDE && targetEntry == null) continue;
                sourceEntries.remove(entryName);
            }
            if (sourceEntries != null) {
                FSEntry[] srcEntries = new ArrayList(sourceEntries.values()).toArray(new FSEntry[sourceEntries.size()]);
                for (int i = 0; i < srcEntries.length; ++i) {
                    srcEntry = srcEntries[i];
                    if (targetEntries.get(srcEntry.getName()) != null || srcEntry.getType() == SVNNodeKind.FILE && wcDepth.compareTo(SVNDepth.FILES) < 0 || srcEntry.getType() == SVNNodeKind.DIR && (wcDepth.compareTo(SVNDepth.IMMEDIATES) < 0 || requestedDepth == SVNDepth.FILES)) continue;
                    entryEditPath = SVNPathUtil.append(editPath, srcEntry.getName());
                    long deletedRev = this.getDeletedRevision(SVNPathUtil.append(targetPath, srcEntry.getName()), sourceRevision, this.getTargetRevision());
                    this.getEditor().deleteEntry(entryEditPath, deletedRev);
                }
            }
            for (FSEntry tgtEntry : targetEntries.values()) {
                srcEntry = null;
                String entrySourcePath = null;
                if (!this.isDepthUpgrade(wcDepth, requestedDepth, tgtEntry.getType())) {
                    if (tgtEntry.getType() == SVNNodeKind.FILE && requestedDepth == SVNDepth.UNKNOWN && wcDepth.compareTo(SVNDepth.FILES) < 0 || tgtEntry.getType() == SVNNodeKind.DIR && (wcDepth.compareTo(SVNDepth.IMMEDIATES) < 0 || requestedDepth == SVNDepth.FILES)) continue;
                    srcEntry = sourceEntries != null ? (FSEntry)sourceEntries.get(tgtEntry.getName()) : null;
                    entrySourcePath = srcEntry != null ? SVNPathUtil.getAbsolutePath(SVNPathUtil.append(sourcePath, tgtEntry.getName())) : null;
                }
                String entryEditPath2 = SVNPathUtil.append(editPath, tgtEntry.getName());
                String entryTargetPath = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(targetPath, tgtEntry.getName()));
                this.updateEntry(sourceRevision, entrySourcePath, srcEntry, entryTargetPath, tgtEntry, entryEditPath2, null, this.getDepthBelow(wcDepth), this.getDepthBelow(requestedDepth));
            }
        }
    }

    private boolean isDepthUpgrade(SVNDepth wcDepth, SVNDepth requestedDepth, SVNNodeKind kind) {
        if (requestedDepth == SVNDepth.UNKNOWN || wcDepth == SVNDepth.IMMEDIATES) {
            return false;
        }
        int compareResult = requestedDepth.compareTo(wcDepth);
        if (compareResult <= 0) {
            return false;
        }
        if (kind == SVNNodeKind.FILE && wcDepth == SVNDepth.FILES) {
            return false;
        }
        return kind != SVNNodeKind.DIR || wcDepth != SVNDepth.EMPTY || requestedDepth != SVNDepth.FILES;
    }

    private void diffFiles(long sourceRevision, String sourcePath, String targetPath, String editPath, String lockToken) throws SVNException {
        this.diffProplists(sourceRevision, sourcePath, editPath, targetPath, lockToken, false);
        String sourceHexDigest = null;
        FSRevisionRoot sourceRoot = null;
        if (sourcePath != null) {
            sourceRoot = this.getSourceRoot(sourceRevision);
            boolean changed = false;
            changed = this.isIgnoreAncestry() ? FSRepositoryUtil.checkFilesDifferent(sourceRoot, sourcePath, this.getTargetRoot(), targetPath, this.myDeltaCombiner) : FSRepositoryUtil.areFileContentsChanged(sourceRoot, sourcePath, this.getTargetRoot(), targetPath);
            if (!changed) {
                return;
            }
            FSRevisionNode sourceNode = sourceRoot.getRevisionNode(sourcePath);
            sourceHexDigest = sourceNode.getFileMD5Checksum();
        }
        FSRepositoryUtil.sendTextDelta(this.getEditor(), editPath, sourcePath, sourceHexDigest, sourceRoot, targetPath, this.getTargetRoot(), this.isSendTextDeltas(), this.myDeltaCombiner, this.myDeltaGenerator, this.myFSFS);
    }

    private void updateEntry(long sourceRevision, String sourcePath, FSEntry sourceEntry, String targetPath, FSEntry targetEntry, String editPath, PathInfo pathInfo, SVNDepth wcDepth, SVNDepth requestedDepth) throws SVNException {
        if (pathInfo != null && pathInfo.getLinkPath() != null && !this.isSwitch()) {
            targetPath = pathInfo.getLinkPath();
            targetEntry = this.fakeDirEntry(targetPath, this.getTargetRoot());
        }
        if (pathInfo != null && FSRepository.isInvalidRevision(pathInfo.getRevision())) {
            sourcePath = null;
            sourceEntry = null;
        } else if (pathInfo != null && sourcePath != null) {
            sourcePath = pathInfo.getLinkPath() != null ? pathInfo.getLinkPath() : sourcePath;
            sourceRevision = pathInfo.getRevision();
            FSRevisionRoot srcRoot = this.getSourceRoot(sourceRevision);
            sourceEntry = this.fakeDirEntry(sourcePath, srcRoot);
        }
        if (sourcePath != null && sourceEntry == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Working copy path ''{0}'' does not exist in repository", (Object)editPath);
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        boolean related = false;
        if (sourceEntry != null && targetEntry != null && sourceEntry.getType() == targetEntry.getType()) {
            int distance = sourceEntry.getId().compareTo(targetEntry.getId());
            if (!(distance != 0 || PathInfo.isRelevant(this.getCurrentPathInfo(), editPath) || requestedDepth.compareTo(wcDepth) > 0 && targetEntry.getType() != SVNNodeKind.FILE)) {
                if (pathInfo == null) {
                    return;
                }
                if (!pathInfo.isStartEmpty()) {
                    if (pathInfo.getLockToken() == null) {
                        return;
                    }
                    SVNLock exitsingLock = this.myFSFS.getLock(targetPath, false, false);
                    if (exitsingLock != null && exitsingLock.getID().equals(pathInfo.getLockToken())) {
                        return;
                    }
                }
            }
            boolean bl = related = distance != -1 || this.isIgnoreAncestry();
        }
        if (sourceEntry != null && !related) {
            SVNNodeKind kind;
            long deletedRev = this.getDeletedRevision(targetPath, sourceRevision, this.getTargetRevision());
            if (!SVNRevision.isValidRevisionNumber(deletedRev) && (kind = this.getTargetRoot().checkNodeKind(targetPath)) != SVNNodeKind.NONE) {
                deletedRev = this.getTargetRevision() - 1L;
            }
            this.getEditor().deleteEntry(editPath, deletedRev);
            sourcePath = null;
        }
        if (targetEntry == null) {
            this.skipPathInfo(editPath);
            return;
        }
        if (targetEntry.getType() == SVNNodeKind.DIR) {
            if (related) {
                this.getEditor().openDir(editPath, sourceRevision);
            } else {
                this.getEditor().addDir(editPath, null, -1L);
            }
            this.diffDirs(sourceRevision, sourcePath, targetPath, editPath, pathInfo != null ? pathInfo.isStartEmpty() : false, wcDepth, requestedDepth);
            this.getEditor().closeDir();
        } else {
            if (related) {
                this.getEditor().openFile(editPath, sourceRevision);
                this.diffFiles(sourceRevision, sourcePath, targetPath, editPath, pathInfo != null ? pathInfo.getLockToken() : null);
            } else {
                SVNLocationEntry copyFromFile = this.addFileSmartly(editPath, targetPath);
                String copyFromPath = copyFromFile.getPath();
                long copyFromRevision = copyFromFile.getRevision();
                if (copyFromPath == null) {
                    this.diffFiles(sourceRevision, sourcePath, targetPath, editPath, pathInfo != null ? pathInfo.getLockToken() : null);
                } else {
                    this.diffFiles(copyFromRevision, copyFromPath, targetPath, editPath, pathInfo != null ? pathInfo.getLockToken() : null);
                }
            }
            FSRevisionNode targetNode = this.getTargetRoot().getRevisionNode(targetPath);
            String targetHexDigest = targetNode.getFileMD5Checksum();
            this.getEditor().closeFile(editPath, targetHexDigest);
        }
    }

    private long getDeletedRevision(String targetPath, long sourceRevision, long targetRevision) throws SVNException {
        if (this.isTransactionTarget()) {
            return this.getTargetRevision();
        }
        return this.myFSFS.getDeletedRevision(targetPath, sourceRevision, targetRevision);
    }

    private boolean isTransactionTarget() throws SVNException {
        return this.getTargetRoot() instanceof FSTransactionRoot;
    }

    private SVNLocationEntry addFileSmartly(String editPath, String originalPath) throws SVNException {
        String copyFromPath = null;
        long copyFromRevision = -1L;
        if (this.mySendCopyFromArgs) {
            FSTransactionRoot txn;
            FSPathChange change;
            if (!this.isTransactionTarget()) {
                FSClosestCopy closestCopy = ((FSRevisionRoot)this.getTargetRoot()).getClosestCopy(originalPath);
                if (closestCopy != null) {
                    FSRevisionRoot closestCopyRoot = closestCopy.getRevisionRoot();
                    String closestCopyPath = closestCopy.getPath();
                    if (originalPath.equals(closestCopyPath)) {
                        FSRevisionNode closestCopyFromNode = closestCopyRoot.getRevisionNode(closestCopyPath);
                        copyFromPath = closestCopyFromNode.getCopyFromPath();
                        copyFromRevision = closestCopyFromNode.getCopyFromRevision();
                    }
                }
            } else if (this.isTransactionTarget() && (change = (FSPathChange)(txn = (FSTransactionRoot)this.getTargetRoot()).getChangedPaths().get(originalPath)) != null) {
                copyFromPath = change.getCopyPath();
                copyFromRevision = change.getCopyRevision();
            }
        }
        this.myEditor.addFile(editPath, copyFromPath, copyFromRevision);
        return new SVNLocationEntry(copyFromRevision, copyFromPath);
    }

    private Map computeMetaProperties(long revision) throws SVNException {
        SVNHashMap metaProperties = new SVNHashMap();
        if (FSRepository.isValidRevision(revision)) {
            SVNProperties entryProps = this.myFSFS.compoundMetaProperties(revision);
            metaProperties.put("svn:entry:committed-rev", entryProps.getSVNPropertyValue("svn:entry:committed-rev"));
            metaProperties.put("svn:entry:committed-date", entryProps.getSVNPropertyValue("svn:entry:committed-date"));
            metaProperties.put("svn:entry:last-author", entryProps.getSVNPropertyValue("svn:entry:last-author"));
            metaProperties.put("svn:entry:uuid", entryProps.getSVNPropertyValue("svn:entry:uuid"));
        } else if (!FSRepository.isValidRevision(revision) && this.isTransactionTarget()) {
            FSTransactionRoot txnRoot = (FSTransactionRoot)this.getTargetRoot();
            SVNProperties txnProperties = this.myFSFS.getTransactionProperties(txnRoot.getTxnID());
            metaProperties.put("svn:entry:committed-rev", SVNPropertyValue.create(Long.toString(this.getTargetRevision())));
            metaProperties.put("svn:entry:committed-date", txnProperties.getSVNPropertyValue("svn:date"));
            metaProperties.put("svn:entry:last-author", txnProperties.getSVNPropertyValue("svn:author"));
            metaProperties.put("svn:entry:uuid", SVNPropertyValue.create(this.myFSFS.getUUID()));
        } else {
            metaProperties = null;
        }
        return metaProperties;
    }

    private void diffProplists(long sourceRevision, String sourcePath, String editPath, String targetPath, String lockToken, boolean isDir) throws SVNException {
        SVNLock lock;
        FSRevisionNode targetNode = this.getTargetRoot().getRevisionNode(targetPath);
        long createdRevision = targetNode.getCreatedRevision();
        Map metaProperties = this.computeMetaProperties(createdRevision);
        if (metaProperties != null) {
            SVNPropertyValue uuid;
            SVNPropertyValue lastAuthor;
            SVNPropertyValue committedRevision = (SVNPropertyValue)metaProperties.get("svn:entry:committed-rev");
            this.changeProperty(editPath, "svn:entry:committed-rev", committedRevision, isDir);
            SVNPropertyValue committedDate = (SVNPropertyValue)metaProperties.get("svn:entry:committed-date");
            if (committedDate != null || sourcePath != null) {
                this.changeProperty(editPath, "svn:entry:committed-date", committedDate, isDir);
            }
            if ((lastAuthor = (SVNPropertyValue)metaProperties.get("svn:entry:last-author")) != null || sourcePath != null) {
                this.changeProperty(editPath, "svn:entry:last-author", lastAuthor, isDir);
            }
            if ((uuid = (SVNPropertyValue)metaProperties.get("svn:entry:uuid")) != null || sourcePath != null) {
                this.changeProperty(editPath, "svn:entry:uuid", uuid, isDir);
            }
        }
        if (!(lockToken == null || (lock = this.myFSFS.getLockHelper(targetPath, false)) != null && lockToken.equals(lock.getID()))) {
            this.changeProperty(editPath, "svn:entry:lock-token", null, isDir);
        }
        SVNProperties sourceProps = null;
        if (sourcePath != null) {
            boolean propsChanged;
            FSRevisionRoot sourceRoot = this.getSourceRoot(sourceRevision);
            FSRevisionNode sourceNode = sourceRoot.getRevisionNode(sourcePath);
            boolean bl = propsChanged = !FSRepositoryUtil.arePropertiesEqual(sourceNode, targetNode);
            if (!propsChanged) {
                return;
            }
            sourceProps = sourceNode.getProperties(this.myFSFS);
        } else {
            sourceProps = new SVNProperties();
        }
        SVNProperties targetProps = targetNode.getProperties(this.myFSFS);
        SVNProperties propsDiffs = FSRepositoryUtil.getPropsDiffs(sourceProps, targetProps);
        Object[] names = propsDiffs.nameSet().toArray();
        for (int i = 0; i < names.length; ++i) {
            String propName = (String)names[i];
            this.changeProperty(editPath, propName, propsDiffs.getSVNPropertyValue(propName), isDir);
        }
    }

    private SVNDepth getDepthBelow(SVNDepth depth) {
        return depth == SVNDepth.IMMEDIATES ? SVNDepth.EMPTY : depth;
    }

    private Object[] fetchPathInfo(String prefix) throws SVNException {
        Object[] result = new Object[2];
        PathInfo pathInfo = this.getCurrentPathInfo();
        if (!PathInfo.isRelevant(pathInfo, prefix)) {
            result[0] = null;
            result[1] = null;
        } else {
            String relPath;
            String string = relPath = "".equals(prefix) ? pathInfo.getPath() : pathInfo.getPath().substring(prefix.length() + 1);
            if (relPath.indexOf(47) != -1) {
                result[0] = relPath.substring(0, relPath.indexOf(47));
                result[1] = null;
            } else {
                result[0] = relPath;
                result[1] = pathInfo;
                try {
                    this.getNextPathInfo();
                }
                catch (IOException ioe) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
                    SVNErrorManager.error(err, SVNLogType.FSFS);
                }
            }
        }
        return result;
    }

    private void changeProperty(String path, String name, SVNPropertyValue value, boolean isDir) throws SVNException {
        if (isDir) {
            this.getEditor().changeDirProperty(name, value);
        } else {
            this.getEditor().changeFileProperty(path, name, value);
        }
    }

    private FSEntry fakeDirEntry(String reposPath, FSRoot root) throws SVNException {
        if (root.checkNodeKind(reposPath) == SVNNodeKind.NONE) {
            return null;
        }
        FSRevisionNode node = root.getRevisionNode(reposPath);
        FSEntry dirEntry = new FSEntry(node.getId(), node.getType(), SVNPathUtil.tail(node.getCreatedPath()));
        return dirEntry;
    }

    private void skipPathInfo(String prefix) throws SVNException {
        while (PathInfo.isRelevant(this.getCurrentPathInfo(), prefix)) {
            try {
                this.getNextPathInfo();
            }
            catch (IOException ioe) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
        }
    }

    private void writeSingleString(String s, OutputStream out) throws IOException {
        if (s != null) {
            byte[] b = s.getBytes("UTF-8");
            out.write(43);
            out.write(String.valueOf(b.length).getBytes("UTF-8"));
            out.write(58);
            out.write(b);
        } else {
            out.write(45);
        }
    }

    public void writePathInfoToReportFile(String path, String linkPath, String lockToken, long revision, boolean startEmpty, SVNDepth depth) throws SVNException {
        if (depth == null || depth == SVNDepth.UNKNOWN) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_ARGS, "Unsupported report depth ''{0}''", (Object)(depth != null ? depth.getName() : "null"));
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        String anchorRelativePath = SVNPathUtil.append(this.getReportTarget(), path);
        String revisionRep = FSRepository.isValidRevision(revision) ? "+" + String.valueOf(revision) + ":" : "-";
        Object depthRep = "-";
        if (depth == SVNDepth.EXCLUDE || depth == SVNDepth.EMPTY || depth == SVNDepth.FILES || depth == SVNDepth.IMMEDIATES) {
            depthRep = "+" + this.getDepthLetter(depth);
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writeSingleString(anchorRelativePath, baos);
            this.writeSingleString(linkPath, baos);
            baos.write(revisionRep.getBytes("UTF-8"));
            baos.write(((String)depthRep).getBytes("UTF-8"));
            baos.write(startEmpty ? 43 : 45);
            this.writeSingleString(lockToken, baos);
            OutputStream reportOS = this.getReportFileForWriting();
            reportOS.write(baos.toByteArray());
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
        }
    }

    public String getDepthLetter(SVNDepth depth) throws SVNException {
        if (depth == SVNDepth.EXCLUDE) {
            return "X";
        }
        if (depth == SVNDepth.EMPTY) {
            return "E";
        }
        if (depth == SVNDepth.FILES) {
            return "F";
        }
        if (depth == SVNDepth.IMMEDIATES) {
            return "M";
        }
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_ARGS, "Unsupported report depth ''{0}''", (Object)SVNDepth.asString(depth));
        SVNErrorManager.error(err, SVNLogType.FSFS);
        return null;
    }
}

