/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.cli.svn.SVNShowRevisionType;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnLogMergeInfo;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnRevisionRange;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNMergeInfoCommand
extends SVNCommand
implements ISVNLogEntryHandler {
    public SVNMergeInfoCommand() {
        super("mergeinfo", null);
    }

    @Override
    protected Collection<SVNOption> createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.REVISION);
        options.add(SVNOption.SHOW_REVS);
        options.add(SVNOption.RECURSIVE);
        options.add(SVNOption.DEPTH);
        return options;
    }

    @Override
    public boolean acceptsRevisionRange() {
        return true;
    }

    @Override
    public void run() throws SVNException {
        SVNRevision srcEndRevision;
        List revisionRanges;
        SVNPath source;
        SVNRevision srcPegRevision;
        SVNErrorMessage err;
        List<String> targets = this.getSVNEnvironment().combineTargets(null, true);
        if (targets.size() < 1) {
            err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Not enough arguments given");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        if (targets.size() > 2) {
            err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Too many arguments given");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        if ((srcPegRevision = (source = new SVNPath(targets.get(0), true)).getPegRevision()) == SVNRevision.UNDEFINED) {
            srcPegRevision = SVNRevision.HEAD;
        }
        SVNPath target = null;
        SVNRevision tgtPegRevision = null;
        if (targets.size() == 2) {
            target = new SVNPath(targets.get(1), true);
            tgtPegRevision = target.getPegRevision();
        } else {
            target = new SVNPath("");
            tgtPegRevision = SVNRevision.UNDEFINED;
        }
        if (tgtPegRevision == SVNRevision.UNDEFINED) {
            tgtPegRevision = target.isURL() ? SVNRevision.HEAD : SVNRevision.BASE;
        }
        SVNRevision srcStartRevision = (revisionRanges = this.getSVNEnvironment().getRevisionRanges()).size() == 0 ? SVNRevision.UNDEFINED : ((SVNRevisionRange)revisionRanges.get(0)).getStartRevision();
        SVNRevision sVNRevision = srcEndRevision = revisionRanges.size() == 0 ? SVNRevision.UNDEFINED : ((SVNRevisionRange)revisionRanges.get(revisionRanges.size() - 1)).getEndRevision();
        if (srcEndRevision == SVNRevision.UNDEFINED) {
            srcEndRevision = srcStartRevision;
        }
        if (this.getSVNEnvironment().getShowRevisionType() == SVNShowRevisionType.MERGED || this.getSVNEnvironment().getShowRevisionType() == SVNShowRevisionType.ELIGIBLE) {
            SVNDiffClient client = this.getSVNEnvironment().getClientManager().getDiffClient();
            SVNNotifyPrinter printer = new SVNNotifyPrinter(this.getSVNEnvironment());
            client.setEventHandler(printer);
            SvnOperationFactory of = client.getOperationsFactory();
            SVNDepth depth = this.getSVNEnvironment().getDepth();
            if (depth == SVNDepth.UNKNOWN) {
                depth = SVNDepth.EMPTY;
            }
            SvnLogMergeInfo logMergeInfo = of.createLogMergeInfo();
            logMergeInfo.addRevisionRange(SvnRevisionRange.create(srcStartRevision, srcEndRevision));
            logMergeInfo.setDepth(depth);
            logMergeInfo.setDiscoverChangedPaths(true);
            logMergeInfo.setRevisionProperties(null);
            logMergeInfo.setReceiver(new ISvnObjectReceiver<SVNLogEntry>(){

                @Override
                public void receive(SvnTarget target, SVNLogEntry object) throws SVNException {
                    SVNMergeInfoCommand.this.handleLogEntry(object);
                }
            });
            logMergeInfo.setFindMerged(this.getSVNEnvironment().getShowRevisionType() == SVNShowRevisionType.MERGED);
            if (target.isURL()) {
                logMergeInfo.setSingleTarget(SvnTarget.fromURL(target.getURL(), tgtPegRevision));
            } else {
                logMergeInfo.setSingleTarget(SvnTarget.fromFile(target.getFile(), tgtPegRevision));
            }
            if (source.isURL()) {
                logMergeInfo.setSource(SvnTarget.fromURL(source.getURL(), srcPegRevision));
            } else {
                logMergeInfo.setSource(SvnTarget.fromFile(source.getFile(), srcPegRevision));
            }
            logMergeInfo.run();
        } else {
            SVNErrorMessage errorMessage;
            if (srcStartRevision != SVNRevision.UNDEFINED || srcEndRevision != SVNRevision.UNDEFINED) {
                errorMessage = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "--revision (-r) option valid only with --show-revs option");
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
            if (this.getSVNEnvironment().getDepth() != SVNDepth.UNKNOWN) {
                errorMessage = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Depth specification options valid only with --show-revs option");
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
            errorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Mergeinfo summary functionality is not yet implemented");
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
    }

    @Override
    public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
        String message = logEntry.isNonInheritable() ? MessageFormat.format("r{0}*", String.valueOf(logEntry.getRevision())) : MessageFormat.format("r{0}", String.valueOf(logEntry.getRevision()));
        this.getSVNEnvironment().getOut().println(message);
    }
}

