/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCleanupCommand
extends SVNCommand {
    public SVNCleanupCommand() {
        super("cleanup", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.DIFF3_CMD);
        options.add(SVNOption.REMOVE_UNVERSIONED);
        options.add(SVNOption.REMOVE_IGNORED);
        options.add(SVNOption.INCLUDE_EXTERNALS);
        return options;
    }

    @Override
    public void run() throws SVNException {
        List<String> targets = this.getSVNEnvironment().combineTargets(this.getSVNEnvironment().getTargets(), true);
        if (targets.isEmpty()) {
            targets.add("");
        }
        SVNWCClient client = this.getSVNEnvironment().getClientManager().getWCClient();
        SVNNotifyPrinter eventHandler = new SVNNotifyPrinter(this.getSVNEnvironment());
        client.setEventHandler(eventHandler);
        boolean removeUnversioned = this.getSVNEnvironment().isRemoveUnversioned();
        boolean removeIgnored = this.getSVNEnvironment().isRemoveIgnored();
        boolean includeExternals = this.getSVNEnvironment().isIncludeExternals();
        for (String targetName : targets) {
            SVNPath target = new SVNPath(targetName);
            eventHandler.checkCancelled();
            if (removeUnversioned || removeIgnored) {
                try {
                    client.doCleanup(target.getFile(), false, false, false, removeUnversioned, removeIgnored, includeExternals);
                    continue;
                }
                catch (SVNException e) {
                    SVNErrorMessage errorMessage;
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LOCKED) {
                        errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Working copy locked; if no other Subversion client is currently using the working copy, try running 'svn cleanup' without the --remove-unversioned and --remove-ignored options first.", (Object)e);
                        SVNErrorManager.error(errorMessage, SVNLogType.WC);
                        continue;
                    }
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_WORKING_COPY) {
                        errorMessage = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Cannot remove unversioned or ignored items from something that is not a working copy", (Object)e);
                        SVNErrorManager.error(errorMessage, SVNLogType.WC);
                        continue;
                    }
                    throw e;
                }
            }
            try {
                client.doCleanup(target.getFile(), true, true, true, false, false, includeExternals);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LOCKED) {
                    File workingCopyRoot = null;
                    try {
                        workingCopyRoot = SVNWCUtil.getWorkingCopyRoot(target.getFile(), true);
                    }
                    catch (SVNException second) {
                        SVNErrorManager.error(e.getErrorMessage(), second.getErrorMessage(), e, SVNLogType.WC);
                    }
                    SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Working copy locked; try running 'svn cleanup' on the root of the working copy (''{0}'') instead.", new Object[]{workingCopyRoot}, e);
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                    continue;
                }
                throw e;
            }
        }
    }
}

