/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import net.schmizz.sshj.common.Base64;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.userauth.keyprovider.BaseFileKeyProvider;
import net.schmizz.sshj.userauth.keyprovider.FileKeyProvider;
import net.schmizz.sshj.userauth.password.PasswordUtils;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.params.Argon2Parameters;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.util.encoders.Hex;

public class PuTTYKeyFile
extends BaseFileKeyProvider {
    private Integer keyFileVersion;
    private byte[] privateKey;
    private byte[] publicKey;
    private byte[] verifyHmac;
    private Map<String, String> payload = new HashMap<String, String>();
    private final Map<String, String> headers = new HashMap<String, String>();

    @Override
    public KeyType getType() throws IOException {
        String headerName = String.format("PuTTY-User-Key-File-%d", this.keyFileVersion);
        return KeyType.fromString(this.headers.get(headerName));
    }

    public boolean isEncrypted() throws IOException {
        String encryption = this.headers.get("Encryption");
        if ("none".equals(encryption)) {
            return false;
        }
        if ("aes256-cbc".equals(encryption)) {
            return true;
        }
        throw new IOException(String.format("Unsupported encryption: %s", encryption));
    }

    @Override
    protected KeyPair readKeyPair() throws IOException {
        String ecdsaCurve;
        this.parseKeyPair();
        Buffer.PlainBuffer publicKeyReader = new Buffer.PlainBuffer(this.publicKey);
        Buffer.PlainBuffer privateKeyReader = new Buffer.PlainBuffer(this.privateKey);
        KeyType keyType = this.getType();
        publicKeyReader.readBytes();
        if (KeyType.RSA.equals((Object)keyType)) {
            KeyFactory factory;
            BigInteger e = publicKeyReader.readMPInt();
            BigInteger n = publicKeyReader.readMPInt();
            BigInteger d = privateKeyReader.readMPInt();
            try {
                factory = KeyFactory.getInstance("RSA");
            }
            catch (NoSuchAlgorithmException s) {
                throw new IOException(s.getMessage(), s);
            }
            try {
                return new KeyPair(factory.generatePublic(new RSAPublicKeySpec(n, e)), factory.generatePrivate(new RSAPrivateKeySpec(n, d)));
            }
            catch (InvalidKeySpecException i) {
                throw new IOException(i.getMessage(), i);
            }
        }
        if (KeyType.DSA.equals((Object)keyType)) {
            KeyFactory factory;
            BigInteger p = publicKeyReader.readMPInt();
            BigInteger q = publicKeyReader.readMPInt();
            BigInteger g = publicKeyReader.readMPInt();
            BigInteger y = publicKeyReader.readMPInt();
            BigInteger x = privateKeyReader.readMPInt();
            try {
                factory = KeyFactory.getInstance("DSA");
            }
            catch (NoSuchAlgorithmException s) {
                throw new IOException(s.getMessage(), s);
            }
            try {
                return new KeyPair(factory.generatePublic(new DSAPublicKeySpec(y, p, q, g)), factory.generatePrivate(new DSAPrivateKeySpec(x, p, q, g)));
            }
            catch (InvalidKeySpecException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        if (KeyType.ED25519.equals((Object)keyType)) {
            EdDSANamedCurveSpec ed25519 = EdDSANamedCurveTable.getByName((String)"Ed25519");
            EdDSAPublicKeySpec publicSpec = new EdDSAPublicKeySpec(publicKeyReader.readBytes(), (EdDSAParameterSpec)ed25519);
            EdDSAPrivateKeySpec privateSpec = new EdDSAPrivateKeySpec(privateKeyReader.readBytes(), (EdDSAParameterSpec)ed25519);
            return new KeyPair((PublicKey)new EdDSAPublicKey(publicSpec), (PrivateKey)new EdDSAPrivateKey(privateSpec));
        }
        switch (keyType) {
            case ECDSA256: {
                ecdsaCurve = "P-256";
                break;
            }
            case ECDSA384: {
                ecdsaCurve = "P-384";
                break;
            }
            case ECDSA521: {
                ecdsaCurve = "P-521";
                break;
            }
            default: {
                ecdsaCurve = null;
            }
        }
        if (ecdsaCurve != null) {
            BigInteger s = new BigInteger(1, privateKeyReader.readBytes());
            X9ECParameters ecParams = NISTNamedCurves.getByName((String)ecdsaCurve);
            ECNamedCurveSpec ecCurveSpec = new ECNamedCurveSpec(ecdsaCurve, ecParams.getCurve(), ecParams.getG(), ecParams.getN());
            ECPrivateKeySpec pks = new ECPrivateKeySpec(s, (ECParameterSpec)ecCurveSpec);
            try {
                PrivateKey privateKey = SecurityUtils.getKeyFactory("ECDSA").generatePrivate(pks);
                return new KeyPair(keyType.readPubKeyFromBuffer(publicKeyReader), privateKey);
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        throw new IOException(String.format("Unknown key type %s", new Object[]{this.getType()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseKeyPair() throws IOException {
        this.keyFileVersion = null;
        try (BufferedReader r = new BufferedReader(this.resource.getReader());){
            String line;
            String headerName = null;
            while ((line = r.readLine()) != null) {
                int idx = line.indexOf(": ");
                if (idx > 0) {
                    headerName = line.substring(0, idx);
                    this.headers.put(headerName, line.substring(idx + 2));
                    if (!headerName.startsWith("PuTTY-User-Key-File-")) continue;
                    this.keyFileVersion = Integer.parseInt(headerName.substring(20));
                    continue;
                }
                Object s = this.payload.get(headerName);
                s = s == null ? line : (String)s + line;
                this.payload.put(headerName, (String)s);
            }
        }
        if (this.keyFileVersion == null) {
            throw new IOException("Invalid key file format: missing \"PuTTY-User-Key-File-?\" entry");
        }
        this.publicKey = Base64.decode(this.payload.get("Public-Lines"));
        if (this.isEncrypted()) {
            char[] passphrase = this.pwdf != null ? this.pwdf.reqPassword(this.resource) : "".toCharArray();
            try {
                this.privateKey = this.decrypt(Base64.decode(this.payload.get("Private-Lines")), passphrase);
                Mac mac = this.keyFileVersion <= 2 ? this.prepareVerifyMacV2(passphrase) : this.prepareVerifyMacV3();
                this.verify(mac);
            }
            finally {
                PasswordUtils.blankOut(passphrase);
            }
        } else {
            this.privateKey = Base64.decode(this.payload.get("Private-Lines"));
        }
    }

    private void initCipher(char[] passphrase, Cipher cipher) throws IOException, InvalidAlgorithmParameterException, InvalidKeyException {
        String kdfAlgorithm = this.headers.get("Key-Derivation");
        if (kdfAlgorithm != null) {
            byte[] keyData = this.argon2(kdfAlgorithm = kdfAlgorithm.toLowerCase(), passphrase);
            if (keyData == null) {
                throw new IOException(String.format("Unsupported key derivation function: %s", kdfAlgorithm));
            }
            byte[] key = new byte[32];
            byte[] iv = new byte[16];
            byte[] tag = new byte[32];
            System.arraycopy(keyData, 0, key, 0, 32);
            System.arraycopy(keyData, 32, iv, 0, 16);
            System.arraycopy(keyData, 48, tag, 0, 32);
            cipher.init(2, (Key)new SecretKeySpec(key, "AES"), new IvParameterSpec(iv));
            this.verifyHmac = tag;
            return;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] encodedPassphrase = PasswordUtils.toByteArray(passphrase);
            digest.update(new byte[]{0, 0, 0, 0});
            digest.update(encodedPassphrase);
            byte[] key1 = digest.digest();
            digest.update(new byte[]{0, 0, 0, 1});
            digest.update(encodedPassphrase);
            byte[] key2 = digest.digest();
            Arrays.fill(encodedPassphrase, (byte)0);
            byte[] expanded = new byte[32];
            System.arraycopy(key1, 0, expanded, 0, 20);
            System.arraycopy(key2, 0, expanded, 20, 12);
            cipher.init(2, (Key)new SecretKeySpec(expanded, 0, 32, "AES"), new IvParameterSpec(new byte[16]));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private byte[] argon2(String algorithm, char[] passphrase) throws IOException {
        int type;
        if ("argon2i".equals(algorithm)) {
            type = 1;
        } else if ("argon2d".equals(algorithm)) {
            type = 0;
        } else if ("argon2id".equals(algorithm)) {
            type = 2;
        } else {
            return null;
        }
        byte[] salt = Hex.decode((String)this.headers.get("Argon2-Salt"));
        int iterations = Integer.parseInt(this.headers.get("Argon2-Passes"));
        int memory = Integer.parseInt(this.headers.get("Argon2-Memory"));
        int parallelism = Integer.parseInt(this.headers.get("Argon2-Parallelism"));
        Argon2Parameters a2p = new Argon2Parameters.Builder(type).withVersion(19).withIterations(iterations).withMemoryAsKB(memory).withParallelism(parallelism).withSalt(salt).build();
        Argon2BytesGenerator generator = new Argon2BytesGenerator();
        generator.init(a2p);
        byte[] output = new byte[80];
        int bytes = generator.generateBytes(passphrase, output);
        if (bytes != output.length) {
            throw new IOException("Failed to generate key via Argon2");
        }
        return output;
    }

    private void verify(Mac mac) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(256);
        DataOutputStream data = new DataOutputStream(out);
        String keyType = this.getType().toString();
        data.writeInt(keyType.length());
        data.writeBytes(keyType);
        data.writeInt(this.headers.get("Encryption").length());
        data.writeBytes(this.headers.get("Encryption"));
        data.writeInt(this.headers.get("Comment").length());
        data.writeBytes(this.headers.get("Comment"));
        data.writeInt(this.publicKey.length);
        data.write(this.publicKey);
        data.writeInt(this.privateKey.length);
        data.write(this.privateKey);
        String encoded = Hex.toHexString((byte[])mac.doFinal(out.toByteArray()));
        String reference = this.headers.get("Private-MAC");
        if (!encoded.equals(reference)) {
            throw new IOException("Invalid passphrase");
        }
    }

    private Mac prepareVerifyMacV2(char[] passphrase) throws IOException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update("putty-private-key-file-mac-key".getBytes());
            if (passphrase != null) {
                byte[] encodedPassphrase = PasswordUtils.toByteArray(passphrase);
                digest.update(encodedPassphrase);
                Arrays.fill(encodedPassphrase, (byte)0);
            }
            byte[] key = digest.digest();
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(key, 0, 20, mac.getAlgorithm()));
            return mac;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private Mac prepareVerifyMacV3() throws IOException {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(this.verifyHmac, 0, 32, mac.getAlgorithm()));
            return mac;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private byte[] decrypt(byte[] privateKey, char[] passphrase) throws IOException {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            this.initCipher(passphrase, cipher);
            return cipher.doFinal(privateKey);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public int getKeyFileVersion() {
        return this.keyFileVersion;
    }

    public static class Factory
    implements Factory.Named<FileKeyProvider> {
        @Override
        public FileKeyProvider create() {
            return new PuTTYKeyFile();
        }

        @Override
        public String getName() {
            return "PuTTY";
        }
    }
}

