/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import net.schmizz.concurrent.Promise;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.PacketType;
import net.schmizz.sshj.sftp.RemoteResource;
import net.schmizz.sshj.sftp.Request;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPEngine;
import net.schmizz.sshj.sftp.SFTPException;

public class RemoteFile
extends RemoteResource {
    public RemoteFile(SFTPEngine requester, String path, byte[] handle) {
        super(requester, path, handle);
    }

    public FileAttributes fetchAttributes() throws IOException {
        return this.requester.request(this.newRequest(PacketType.FSTAT)).retrieve(this.requester.getTimeoutMs(), TimeUnit.MILLISECONDS).ensurePacketTypeIs(PacketType.ATTRS).readFileAttributes();
    }

    public long length() throws IOException {
        return this.fetchAttributes().getSize();
    }

    public void setLength(long len) throws IOException {
        this.setAttributes(new FileAttributes.Builder().withSize(len).build());
    }

    public int read(long fileOffset, byte[] to, int offset, int len) throws IOException {
        Response res = this.asyncRead(fileOffset, len).retrieve(this.requester.getTimeoutMs(), TimeUnit.MILLISECONDS);
        return this.checkReadResponse(res, to, offset);
    }

    protected Promise<Response, SFTPException> asyncRead(long fileOffset, int len) throws IOException {
        return this.requester.request((Request)((Request)this.newRequest(PacketType.READ).putUInt64(fileOffset)).putUInt32(len));
    }

    protected int checkReadResponse(Response res, byte[] to, int offset) throws Buffer.BufferException, SFTPException {
        switch (res.getType()) {
            case DATA: {
                int recvLen = res.readUInt32AsInt();
                System.arraycopy(res.array(), res.rpos(), to, offset, recvLen);
                return recvLen;
            }
            case STATUS: {
                res.ensureStatusIs(Response.StatusCode.EOF);
                return -1;
            }
        }
        throw new SFTPException("Unexpected packet: " + res.getType());
    }

    public void write(long fileOffset, byte[] data, int off, int len) throws IOException {
        this.checkWriteResponse(this.asyncWrite(fileOffset, data, off, len));
    }

    protected Promise<Response, SFTPException> asyncWrite(long fileOffset, byte[] data, int off, int len) throws IOException {
        return this.requester.request((Request)((Request)this.newRequest(PacketType.WRITE).putUInt64(fileOffset)).putString(data, off, len));
    }

    private void checkWriteResponse(Promise<Response, SFTPException> responsePromise) throws SFTPException {
        responsePromise.retrieve(this.requester.getTimeoutMs(), TimeUnit.MILLISECONDS).ensureStatusPacketIsOK();
    }

    public void setAttributes(FileAttributes attrs) throws IOException {
        this.requester.request((Request)this.newRequest(PacketType.FSETSTAT).putFileAttributes(attrs)).retrieve(this.requester.getTimeoutMs(), TimeUnit.MILLISECONDS).ensureStatusPacketIsOK();
    }

    public int getOutgoingPacketOverhead() {
        return 9 + this.handle.length + 8 + 4 + 4;
    }

    public class ReadAheadRemoteFileInputStream
    extends InputStream {
        private final byte[] b = new byte[1];
        private final int maxUnconfirmedReads;
        private final long readAheadLimit;
        private final Deque<UnconfirmedRead> unconfirmedReads = new ArrayDeque<UnconfirmedRead>();
        private long currentOffset;
        private int maxReadLength = Integer.MAX_VALUE;
        private boolean eof;
        private ByteArrayInputStream pending = new ByteArrayInputStream(new byte[0]);

        public ReadAheadRemoteFileInputStream(int maxUnconfirmedReads) {
            this(maxUnconfirmedReads, 0L, -1L);
        }

        public ReadAheadRemoteFileInputStream(int maxUnconfirmedReads, long fileOffset, long readAheadLimit) {
            assert (0 <= maxUnconfirmedReads);
            assert (0L <= fileOffset);
            this.maxUnconfirmedReads = maxUnconfirmedReads;
            this.currentOffset = fileOffset;
            this.readAheadLimit = readAheadLimit > 0L ? fileOffset + readAheadLimit : Long.MAX_VALUE;
        }

        private boolean retrieveUnconfirmedRead(boolean blocking) throws IOException {
            UnconfirmedRead unconfirmedRead = this.unconfirmedReads.peek();
            if (unconfirmedRead == null || !blocking && !unconfirmedRead.getPromise().isDelivered()) {
                return false;
            }
            this.unconfirmedReads.remove(unconfirmedRead);
            Response res = unconfirmedRead.promise.retrieve(RemoteFile.this.requester.getTimeoutMs(), TimeUnit.MILLISECONDS);
            switch (res.getType()) {
                case DATA: {
                    int recvLen = res.readUInt32AsInt();
                    if (unconfirmedRead.offset != this.currentOffset) break;
                    this.currentOffset += (long)recvLen;
                    this.pending = new ByteArrayInputStream(res.array(), res.rpos(), recvLen);
                    if (recvLen >= unconfirmedRead.length) break;
                    this.maxReadLength = recvLen;
                    this.unconfirmedReads.clear();
                    break;
                }
                case STATUS: {
                    res.ensureStatusIs(Response.StatusCode.EOF);
                    this.eof = true;
                    break;
                }
                default: {
                    throw new SFTPException("Unexpected packet: " + res.getType());
                }
            }
            return true;
        }

        @Override
        public int read() throws IOException {
            return this.read(this.b, 0, 1) == -1 ? -1 : this.b[0] & 0xFF;
        }

        @Override
        public int read(byte[] into, int off, int len) throws IOException {
            while (!this.eof && this.pending.available() <= 0) {
                long requestOffset;
                if (this.unconfirmedReads.isEmpty()) {
                    requestOffset = this.currentOffset;
                } else {
                    UnconfirmedRead lastRequest = this.unconfirmedReads.getLast();
                    requestOffset = lastRequest.offset + (long)lastRequest.length;
                }
                while (this.unconfirmedReads.size() <= this.maxUnconfirmedReads) {
                    long remaining;
                    int reqLen = Math.min(Math.max(1024, len), this.maxReadLength);
                    if (this.readAheadLimit > requestOffset && (long)reqLen > (remaining = this.readAheadLimit - requestOffset)) {
                        reqLen = (int)remaining;
                    }
                    this.unconfirmedReads.add(new UnconfirmedRead(requestOffset, reqLen));
                    if ((requestOffset += (long)reqLen) < this.readAheadLimit) continue;
                    break;
                }
                if (this.retrieveUnconfirmedRead(true)) continue;
                throw new IllegalStateException("Could not retrieve data for pending read request");
            }
            return this.pending.read(into, off, len);
        }

        @Override
        public int available() throws IOException {
            boolean lastRead = true;
            while (!this.eof && this.pending.available() <= 0 && lastRead) {
                lastRead = this.retrieveUnconfirmedRead(false);
            }
            return this.pending.available();
        }

        private class UnconfirmedRead {
            private final long offset;
            private final Promise<Response, SFTPException> promise;
            private final int length;

            private UnconfirmedRead(long offset, int length, Promise<Response, SFTPException> promise) {
                this.offset = offset;
                this.length = length;
                this.promise = promise;
            }

            UnconfirmedRead(long offset, int length) throws IOException {
                this(offset, length, readAheadRemoteFileInputStream.RemoteFile.this.asyncRead(offset, length));
            }

            public long getOffset() {
                return this.offset;
            }

            public Promise<Response, SFTPException> getPromise() {
                return this.promise;
            }

            public int getLength() {
                return this.length;
            }
        }
    }

    public class RemoteFileInputStream
    extends InputStream {
        private final byte[] b = new byte[1];
        private long fileOffset;
        private long markPos;
        private long readLimit;

        public RemoteFileInputStream() {
            this(0L);
        }

        public RemoteFileInputStream(long fileOffset) {
            this.fileOffset = fileOffset;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readLimit) {
            this.readLimit = readLimit;
            this.markPos = this.fileOffset;
        }

        @Override
        public void reset() throws IOException {
            this.fileOffset = this.markPos;
        }

        @Override
        public long skip(long n) throws IOException {
            long fileLength = RemoteFile.this.length();
            Long previousFileOffset = this.fileOffset;
            this.fileOffset = Math.min(this.fileOffset + n, fileLength);
            return this.fileOffset - previousFileOffset;
        }

        @Override
        public int read() throws IOException {
            return this.read(this.b, 0, 1) == -1 ? -1 : this.b[0] & 0xFF;
        }

        @Override
        public int read(byte[] into, int off, int len) throws IOException {
            int read = RemoteFile.this.read(this.fileOffset, into, off, len);
            if (read != -1) {
                this.fileOffset += (long)read;
                if (this.markPos != 0L && (long)read > this.readLimit) {
                    this.markPos = 0L;
                }
            }
            return read;
        }
    }

    public class RemoteFileOutputStream
    extends OutputStream {
        private final byte[] b = new byte[1];
        private final int maxUnconfirmedWrites;
        private final Queue<Promise<Response, SFTPException>> unconfirmedWrites;
        private long fileOffset;

        public RemoteFileOutputStream() {
            this(0L);
        }

        public RemoteFileOutputStream(long startingOffset) {
            this(startingOffset, 0);
        }

        public RemoteFileOutputStream(long startingOffset, int maxUnconfirmedWrites) {
            this.fileOffset = startingOffset;
            this.maxUnconfirmedWrites = maxUnconfirmedWrites;
            this.unconfirmedWrites = new LinkedList<Promise<Response, SFTPException>>();
        }

        @Override
        public void write(int w) throws IOException {
            this.b[0] = (byte)w;
            this.write(this.b, 0, 1);
        }

        @Override
        public void write(byte[] buf, int off, int len) throws IOException {
            if (this.unconfirmedWrites.size() > this.maxUnconfirmedWrites) {
                RemoteFile.this.checkWriteResponse(this.unconfirmedWrites.remove());
            }
            this.unconfirmedWrites.add(RemoteFile.this.asyncWrite(this.fileOffset, buf, off, len));
            this.fileOffset += (long)len;
        }

        @Override
        public void flush() throws IOException {
            while (!this.unconfirmedWrites.isEmpty()) {
                RemoteFile.this.checkWriteResponse(this.unconfirmedWrites.remove());
            }
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }
    }
}

