/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class DateTime
extends Composite {
    int day;
    int month;
    int year;
    int hours;
    int minutes;
    int seconds;
    long textEntryHandle;
    long spinButtonHandle;
    long containerHandle;
    long calendarHandle;
    Calendar calendar;
    Button down;
    FieldPosition currentField;
    StringBuilder typeBuffer = new StringBuilder();
    int typeBufferPos = -1;
    boolean firstTime = true;
    private DateFormat dateFormat;
    Color fg;
    Color bg;
    boolean hasFocus;
    int savedYear;
    int savedMonth;
    int savedDay;
    Shell popupShell;
    DateTime popupCalendar;
    Listener popupListener;
    Listener popupFilter;
    Point prefferedSize;
    Locale locale;
    Listener mouseEventListener;
    static final String DEFAULT_SHORT_DATE_FORMAT = "dd/MM/yy";
    static final String DEFAULT_MEDIUM_DATE_FORMAT = "d-MMM-yyyy";
    static final String DEFAULT_LONG_DATE_FORMAT = "MMMM d, yyyy";
    static final String DEFAULT_SHORT_TIME_FORMAT = "h:mm a";
    static final String DEFAULT_MEDIUM_TIME_FORMAT = "h:mm:ss a";
    static final String DEFAULT_LONG_TIME_FORMAT = "h:mm:ss z a";
    static final int MIN_YEAR = 1752;
    static final int MAX_YEAR = 9999;
    static final int SPACE_FOR_CURSOR = 1;
    private int mdYear;
    private int mdMonth;

    public DateTime(Composite parent, int style) {
        super(parent, DateTime.checkStyle(style));
        if (this.isDate() || this.isTime()) {
            this.createText();
        }
        if (this.isCalendar()) {
            GTK.gtk_calendar_mark_day(this.calendarHandle, Calendar.getInstance().get(5));
        }
        if (this.isDateWithDropDownButton()) {
            this.createDropDownButton();
            this.createPopupShell(-1, -1, -1);
            this.addListener(11, event -> this.setDropDownButtonSize());
        }
        this.initAccessible();
        if (this.isDateWithDropDownButton()) {
            Point size = this.computeSizeInPixels(-1, -1);
            this.setBoundsInPixels(0, 0, size.x, size.y);
        }
    }

    void createText() {
        String property = System.getProperty("swt.datetime.locale");
        this.locale = property == null || property.isEmpty() ? Locale.getDefault() : Locale.forLanguageTag(property);
        this.dateFormat = this.getFormat(this.locale, this.style);
        this.dateFormat.setLenient(false);
        this.calendar = Calendar.getInstance(this.locale);
        this.updateControl();
        this.selectField(this.updateField(this.currentField));
    }

    DateFormat getFormat(Locale locale, int style) {
        int dfStyle = (style & 0x10000000) != 0 ? 1 : ((style & 0x8000) != 0 ? 3 : 2);
        if (this.isDate()) {
            return DateFormat.getDateInstance(dfStyle, locale);
        }
        if (this.isTime()) {
            return DateFormat.getTimeInstance(dfStyle, locale);
        }
        throw new IllegalStateException("can only be called for date or time widgets!");
    }

    static int checkStyle(int style) {
        style &= 0xFFFFFCFF;
        if (((style = DateTime.checkBits(style, 32, 128, 1024, 0, 0, 0)) & 0x20) == 0) {
            style &= 0xFFFFFFFB;
        }
        return DateTime.checkBits(style, 65536, 32768, 0x10000000, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    Point computeMaxTextSize(int wHint, int hHint, boolean changed) {
        String formatPattern;
        String currentText = this.getFormattedString();
        switch (formatPattern = this.getComputeSizeString(this.style)) {
            case "d-MMM-yyyy": {
                String longDateText = currentText.replaceFirst("\\d{1,2}", "00");
                this.setText(longDateText);
                break;
            }
            case "MMMM d, yyyy": {
                Set<String> months = this.calendar.getDisplayNames(2, 2, this.locale).keySet();
                String longestMonth = Collections.max(months, (s1, s2) -> s1.length() - s2.length());
                String doubleDigitDate = currentText.replaceFirst("\\d{1,2}", "00");
                String longText = doubleDigitDate.replaceFirst("[^\\s]+", longestMonth);
                this.setText(longText);
                break;
            }
            case "h:mm a": 
            case "h:mm:ss a": 
            case "h:mm:ss z a": {
                String longTimeText = currentText.replaceFirst("\\d{1,2}", "00");
                this.setText(longTimeText);
                break;
            }
        }
        Point textSize = this.computeNativeSize(GTK.GTK4 ? this.spinButtonHandle : this.textEntryHandle, wHint, hHint, changed);
        this.updateControl();
        return textSize;
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (!changed && (this.isDate() || this.isTime()) && this.prefferedSize != null) {
            width = wHint != -1 ? wHint : this.prefferedSize.x;
            height = hHint != -1 ? hHint : this.prefferedSize.y;
            return new Point(width, height);
        }
        if (wHint == -1 || hHint == -1) {
            if (this.isCalendar()) {
                Point size = this.computeNativeSize(this.containerHandle, wHint, hHint, changed);
                width = size.x;
                height = size.y;
            } else {
                Point textSize = this.computeMaxTextSize(wHint, hHint, changed);
                Rectangle trim = this.computeTrimInPixels(0, 0, textSize.x, textSize.y);
                if (this.isDateWithDropDownButton()) {
                    Point buttonSize = this.down.computeSizeInPixels(-1, -1, changed);
                    width = trim.width + buttonSize.x;
                    height = Math.max(trim.height, buttonSize.y);
                } else if (this.isDate() || this.isTime()) {
                    width = trim.width;
                    height = trim.height;
                }
            }
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int borderWidth = this.getBorderWidthInPixels();
        if (this.prefferedSize == null && this.isDateWithDropDownButton()) {
            this.prefferedSize = new Point(width + 2 * borderWidth, height + 2 * borderWidth);
            return this.prefferedSize;
        }
        return new Point(width + 2 * borderWidth, height + 2 * borderWidth);
    }

    @Override
    Rectangle computeTrimInPixels(int x, int y, int width, int height) {
        if (this.isCalendar()) {
            return super.computeTrimInPixels(x, y, width, height);
        }
        this.checkWidget();
        Rectangle trim = super.computeTrimInPixels(x, y, width, height);
        int xborder = 0;
        int yborder = 0;
        GtkBorder tmp = new GtkBorder();
        long context = GTK.gtk_widget_get_style_context(GTK.GTK4 ? this.spinButtonHandle : this.textEntryHandle);
        int state_flag = GTK.GTK_VERSION < OS.VERSION(3, 18, 0) ? 0 : GTK.gtk_widget_get_state_flags(this.textEntryHandle);
        this.gtk_style_context_get_padding(context, state_flag, tmp);
        trim.x -= tmp.left;
        trim.y -= tmp.top;
        trim.width += tmp.left + tmp.right;
        trim.height += tmp.top + tmp.bottom;
        if ((this.style & 0x800) != 0) {
            int state = GTK.GTK_VERSION < OS.VERSION(3, 18, 0) ? 0 : GTK.gtk_widget_get_state_flags(this.textEntryHandle);
            this.gtk_style_context_get_border(context, state, tmp);
            trim.x -= tmp.left;
            trim.y -= tmp.top;
            trim.width += tmp.left + tmp.right;
            trim.height += tmp.top + tmp.bottom;
        }
        trim.x -= xborder;
        trim.y -= yborder;
        trim.width += 2 * xborder;
        trim.height += 2 * yborder;
        ++trim.width;
        return new Rectangle(trim.x, trim.y, trim.width, trim.height);
    }

    @Override
    void createHandle(int index) {
        this.createHandle();
    }

    void createHandle() {
        if (this.isCalendar()) {
            this.state |= 8;
            this.createHandleForFixed();
            this.createHandleForCalendar();
        } else {
            this.createHandleForFixed();
            if (this.isDateWithDropDownButton()) {
                this.createHandleForDateWithDropDown();
            } else {
                this.createHandleForDateTime();
            }
            GTK.gtk_editable_set_editable(this.textEntryHandle, (this.style & 8) == 0);
            if (GTK.GTK_VERSION <= OS.VERSION(3, 20, 0)) {
                GTK.gtk_entry_set_has_frame(this.textEntryHandle, (this.style & 0x800) != 0);
            }
        }
    }

    private void createHandleForFixed() {
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        this.gtk_widget_set_has_surface_or_window(this.fixedHandle, true);
    }

    private void createHandleForCalendar() {
        this.calendarHandle = GTK.gtk_calendar_new();
        if (this.calendarHandle == 0L) {
            this.error(2);
        }
        this.handle = this.calendarHandle;
        this.containerHandle = this.calendarHandle;
        GTK.gtk_container_add(this.fixedHandle, this.calendarHandle);
        int flags = 3;
        if (this.showWeekNumbers()) {
            flags |= 8;
        }
        GTK.gtk_calendar_set_display_options(this.calendarHandle, flags);
        GTK.gtk_widget_show(this.calendarHandle);
    }

    private void createHandleForDateWithDropDown() {
        this.containerHandle = this.gtk_box_new(0, false, 0);
        if (this.containerHandle == 0L) {
            this.error(2);
        }
        GTK.gtk_container_add(this.fixedHandle, this.containerHandle);
        this.textEntryHandle = GTK.gtk_entry_new();
        if (this.textEntryHandle == 0L) {
            this.error(2);
        }
        GTK.gtk_container_add(this.containerHandle, this.textEntryHandle);
        GTK.gtk_widget_show(this.containerHandle);
        GTK.gtk_widget_show(this.textEntryHandle);
        this.handle = this.containerHandle;
        if (this.handle == 0L) {
            this.error(2);
        }
        this.setFontDescription(this.defaultFont().handle);
    }

    private void createHandleForDateTime() {
        long adjusment = GTK.gtk_adjustment_new(0.0, -9999.0, 9999.0, 1.0, 0.0, 0.0);
        if (GTK.GTK4) {
            long textHandle;
            this.spinButtonHandle = GTK.gtk_spin_button_new(adjusment, 1.0, 0);
            long boxHandle = GTK.gtk_widget_get_first_child(this.spinButtonHandle);
            this.textEntryHandle = textHandle = GTK.gtk_widget_get_first_child(boxHandle);
            this.handle = this.spinButtonHandle;
            this.containerHandle = this.spinButtonHandle;
        } else {
            this.handle = this.textEntryHandle = GTK.gtk_spin_button_new(adjusment, 1.0, 0);
            this.containerHandle = this.textEntryHandle;
        }
        if (this.textEntryHandle == 0L) {
            this.error(2);
        }
        GTK.gtk_spin_button_set_numeric(GTK.GTK4 ? this.spinButtonHandle : this.textEntryHandle, false);
        GTK.gtk_container_add(this.fixedHandle, GTK.GTK4 ? this.spinButtonHandle : this.textEntryHandle);
        GTK.gtk_spin_button_set_wrap(GTK.GTK4 ? this.spinButtonHandle : this.textEntryHandle, (this.style & 0x40) != 0);
    }

    void createDropDownButton() {
        this.down = new Button(this, 1028);
        GTK.gtk_widget_set_can_focus(this.down.handle, false);
        this.down.addListener(13, event -> {
            this.setFocus();
            this.dropDownCalendar(!this.isDropped());
        });
        this.popupListener = event -> {
            if (event.widget == this.popupShell) {
                this.popupShellEvent(event);
                return;
            }
            if (event.widget == this.popupCalendar) {
                this.popupCalendarEvent(event);
                return;
            }
            if (event.widget == this) {
                this.onDispose(event);
                return;
            }
            if (event.widget == this.getShell()) {
                this.getDisplay().asyncExec(() -> {
                    if (this.isDisposed()) {
                        return;
                    }
                    this.handleFocus(16);
                });
            }
        };
        this.popupFilter = event -> {
            Shell shell = ((Control)event.widget).getShell();
            if (shell == this.getShell()) {
                this.handleFocus(16);
            }
        };
    }

    void createPopupShell(int year, int month, int day) {
        int i;
        this.popupShell = new Shell(this.getShell(), 16392);
        int popupStyle = 1024;
        if (this.showWeekNumbers()) {
            popupStyle |= 0x4000;
        }
        this.popupCalendar = new DateTime(this.popupShell, popupStyle);
        if (this.font != null) {
            this.popupCalendar.setFont(this.font);
        }
        if (this.fg != null) {
            this.popupCalendar.setForeground(this.fg);
        }
        if (this.bg != null) {
            this.popupCalendar.setBackground(this.bg);
        }
        this.mouseEventListener = event -> {
            Control c;
            if (event.widget instanceof Control && (c = (Control)event.widget) != this.down && c.getShell() != this.popupShell) {
                this.dropDownCalendar(false);
            }
        };
        int[] listeners = new int[]{21, 4};
        for (i = 0; i < listeners.length; ++i) {
            this.popupShell.addListener(listeners[i], this.popupListener);
        }
        listeners = new int[]{3, 4, 13, 31, 1, 2, 15, 16, 12};
        for (i = 0; i < listeners.length; ++i) {
            this.popupCalendar.addListener(listeners[i], this.popupListener);
        }
        this.addListener(12, this.popupListener);
        if (year != -1) {
            this.popupCalendar.setDate(year, month, day);
        }
    }

    @Override
    void setFontDescription(long font) {
        if (this.isDateWithDropDownButton()) {
            this.prefferedSize = null;
            this.setFontDescription(this.textEntryHandle, font);
        }
        super.setFontDescription(font);
    }

    @Override
    boolean checkSubwindow() {
        return false;
    }

    @Override
    void createWidget(int index) {
        super.createWidget(index);
        if (this.isCalendar()) {
            this.getDate();
        }
    }

    void onDispose(Event event) {
        if (this.popupShell != null && !this.popupShell.isDisposed()) {
            this.popupCalendar.removeListener(12, this.popupListener);
            this.popupShell.dispose();
        }
        Shell shell = this.getShell();
        shell.removeListener(27, this.popupListener);
        Display display = this.getDisplay();
        display.removeFilter(15, this.popupFilter);
        this.popupShell = null;
        this.popupCalendar = null;
        this.down = null;
    }

    void dropDownCalendar(boolean drop) {
        if (drop == this.isDropped()) {
            return;
        }
        if (!drop) {
            this.hideDropDownCalendar();
            return;
        }
        this.setCurrentDate();
        if (this.getShell() != this.popupShell.getParent()) {
            this.recreateCalendar();
        }
        Point containerBounds = this.getSizeInPixels();
        Point calendarSize = this.popupCalendar.computeSizeInPixels(-1, -1, false);
        this.popupCalendar.setBoundsInPixels(1, 1, Math.max(containerBounds.x - 2, calendarSize.x), calendarSize.y);
        this.popupCalendar.setDate(this.savedYear, this.savedMonth, this.savedDay);
        this.focusDayOnPopupCalendar();
        Display display = this.getDisplay();
        Rectangle coordsRelativeToScreen = display.mapInPixels(this.getParent(), null, this.getBoundsInPixels());
        Rectangle displayRect = DPIUtil.autoScaleUp(this.getMonitor().getClientArea());
        this.showPopupShell(containerBounds, calendarSize, coordsRelativeToScreen, displayRect);
        display.addFilter(3, this.mouseEventListener);
    }

    private void showPopupShell(Point containerBounds, Point calendarSize, Rectangle coordsRelativeToScreen, Rectangle displayRect) {
        int width = Math.max(containerBounds.x, calendarSize.x + 2);
        int height = calendarSize.y + 2;
        int y = this.calculateCalendarYpos(containerBounds, coordsRelativeToScreen, height, displayRect);
        int x = this.calculateCalendarXpos(calendarSize, coordsRelativeToScreen, displayRect, width);
        this.popupShell.setBoundsInPixels(x, y, width, height);
        this.popupShell.setVisible(true);
        if (this.isFocusControl()) {
            this.popupCalendar.setFocus();
        }
    }

    private int calculateCalendarYpos(Point containerBounds, Rectangle coordsRelativeToScreen, int height, Rectangle displayRect) {
        int dateEntryHeight = this.computeNativeSize((long)this.containerHandle, (int)-1, (int)-1, (boolean)false).y;
        int y = coordsRelativeToScreen.y + containerBounds.y / 2 + dateEntryHeight / 2;
        if (y + height > displayRect.y + displayRect.height) {
            y -= height + dateEntryHeight;
        }
        return y;
    }

    private int calculateCalendarXpos(Point calendarSize, Rectangle coordsRelativeToScreen, Rectangle displayRect, int width) {
        Integer x = coordsRelativeToScreen.x;
        if (x + width > displayRect.x + displayRect.width) {
            x = displayRect.x + displayRect.width - calendarSize.x;
        }
        return x;
    }

    private void focusDayOnPopupCalendar() {
        int currentYear = Calendar.getInstance().get(1);
        int currentMonth = Calendar.getInstance().get(2);
        if (this.savedYear == currentYear && this.savedMonth == currentMonth) {
            int currentDay = Calendar.getInstance().get(5);
            GTK.gtk_calendar_mark_day(this.popupCalendar.handle, currentDay);
        }
    }

    private void setCurrentDate() {
        this.savedYear = this.getYear();
        this.savedMonth = this.getMonth();
        this.savedDay = this.getDay();
    }

    private void recreateCalendar() {
        int year = this.popupCalendar.getYear();
        int month = this.popupCalendar.getMonth();
        int day = this.popupCalendar.getDay();
        this.popupCalendar.removeListener(12, this.popupListener);
        this.popupShell.dispose();
        this.popupShell = null;
        this.popupCalendar = null;
        this.createPopupShell(year, month, day);
    }

    private void hideDropDownCalendar() {
        this.popupShell.setVisible(false);
        GTK.gtk_calendar_clear_marks(this.popupCalendar.handle);
        this.display.removeFilter(3, this.mouseEventListener);
    }

    String getComputeSizeString(int style) {
        if ((style & 0x20) != 0) {
            return (style & 0x8000) != 0 ? DEFAULT_SHORT_DATE_FORMAT : ((style & 0x10000000) != 0 ? DEFAULT_LONG_DATE_FORMAT : DEFAULT_MEDIUM_DATE_FORMAT);
        }
        return (style & 0x8000) != 0 ? DEFAULT_SHORT_TIME_FORMAT : ((style & 0x10000000) != 0 ? DEFAULT_LONG_TIME_FORMAT : DEFAULT_MEDIUM_TIME_FORMAT);
    }

    String getFormattedString() {
        return this.dateFormat.format(this.calendar.getTime());
    }

    void getDate() {
        int[] y = new int[1];
        int[] m = new int[1];
        int[] d = new int[1];
        GTK.gtk_calendar_get_date(this.calendarHandle, y, m, d);
        this.year = y[0];
        this.month = m[0];
        this.day = d[0];
    }

    public int getDay() {
        this.checkWidget();
        if (this.isCalendar()) {
            this.getDate();
            return this.day;
        }
        return this.calendar.get(5);
    }

    public int getHours() {
        this.checkWidget();
        if (this.isCalendar()) {
            return this.hours;
        }
        return this.calendar.get(11);
    }

    public int getMinutes() {
        this.checkWidget();
        if (this.isCalendar()) {
            return this.minutes;
        }
        return this.calendar.get(12);
    }

    public int getMonth() {
        this.checkWidget();
        if (this.isCalendar()) {
            this.getDate();
            return this.month;
        }
        return this.calendar.get(2);
    }

    @Override
    String getNameText() {
        if (this.calendar == null) {
            return "";
        }
        if (this.isTime()) {
            return this.getHours() + ":" + this.getMinutes() + ":" + this.getSeconds();
        }
        return this.getMonth() + 1 + "/" + this.getDay() + "/" + this.getYear();
    }

    public int getSeconds() {
        this.checkWidget();
        if (this.isCalendar()) {
            return this.seconds;
        }
        return this.calendar.get(13);
    }

    String getSpokenText() {
        if (this.isTime()) {
            return DateFormat.getTimeInstance(0).format(this.calendar.getTime());
        }
        if (this.isDate()) {
            return DateFormat.getDateInstance(0).format(this.calendar.getTime());
        }
        Calendar cal = Calendar.getInstance();
        this.getDate();
        cal.set(this.year, this.month, this.day);
        return DateFormat.getDateInstance(0).format(cal.getTime());
    }

    public int getYear() {
        this.checkWidget();
        if (this.isCalendar()) {
            this.getDate();
            return this.year;
        }
        return this.calendar.get(1);
    }

    @Override
    long gtk_day_selected(long widget) {
        this.sendSelectionEvent();
        return 0L;
    }

    @Override
    long gtk_day_selected_double_click(long widget) {
        this.sendSelectionEvent(14);
        return 0L;
    }

    @Override
    long gtk_month_changed(long widget) {
        this.sendSelectionEvent();
        return 0L;
    }

    @Override
    long eventHandle() {
        return this.dateTimeHandle();
    }

    @Override
    long focusHandle() {
        return this.dateTimeHandle();
    }

    @Override
    long fontHandle() {
        return this.dateTimeHandle();
    }

    private long dateTimeHandle() {
        if (this.isCalendar() && this.calendarHandle != 0L) {
            return this.calendarHandle;
        }
        if (this.isDate() || this.isTime()) {
            if (GTK.GTK4) {
                if (this.spinButtonHandle != 0L) {
                    return this.spinButtonHandle;
                }
            } else if (this.textEntryHandle != 0L) {
                return this.textEntryHandle;
            }
            return super.focusHandle();
        }
        return super.focusHandle();
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if (this.isCalendar()) {
            this.hookEventsForCalendar();
        } else {
            int eventMask = 772;
            GTK.gtk_widget_add_events(this.textEntryHandle, eventMask);
            if ((this.style & 4) == 0) {
                this.hookEventsForDateTimeSpinner();
            }
            if (OS.G_OBJECT_TYPE(this.textEntryHandle) == GTK.GTK_TYPE_MENU()) {
                this.hookEventsForMenu();
            }
        }
    }

    private final void hookEventsForCalendar() {
        OS.g_signal_connect_closure(this.calendarHandle, OS.day_selected, this.display.getClosure(61), false);
        OS.g_signal_connect_closure(this.calendarHandle, OS.day_selected_double_click, this.display.getClosure(66), false);
        OS.g_signal_connect_closure(this.calendarHandle, OS.month_changed, this.display.getClosure(62), false);
    }

    private final void hookEventsForDateTimeSpinner() {
        OS.g_signal_connect_closure(this.textEntryHandle, OS.output, this.display.getClosure(36), true);
        if (GTK.GTK4) {
            long keyController = GTK.gtk_event_controller_key_new();
            GTK.gtk_widget_add_controller(this.textEntryHandle, keyController);
            GTK.gtk_event_controller_set_propagation_phase(keyController, 3);
            long focusAddress = this.display.focusCallback.getAddress();
            OS.g_signal_connect(keyController, OS.focus_in, focusAddress, 86L);
        } else {
            OS.g_signal_connect_closure(this.textEntryHandle, OS.focus_in_event, this.display.getClosure(21), true);
        }
    }

    private final void hookEventsForMenu() {
        OS.g_signal_connect_closure(this.down.handle, OS.selection_done, this.display.getClosure(68), true);
    }

    void incrementField(int amount) {
        if (this.currentField != null) {
            int field = DateTime.getCalendarField(this.currentField);
            if (field == 10 && this.hasAmPm()) {
                int max = this.calendar.getMaximum(10);
                int min = this.calendar.getMinimum(10);
                int value = this.calendar.get(10);
                if (value == max && amount == 1 || value == min && amount == -1) {
                    this.calendar.roll(9, amount);
                }
            }
            if (field > -1) {
                this.calendar.roll(field, amount);
                this.updateControl();
                this.selectField(this.updateField(this.currentField));
            }
        }
    }

    private boolean hasAmPm() {
        AttributedCharacterIterator iterator = this.dateFormat.formatToCharacterIterator(this.calendar.getTime());
        while (iterator.current() != '\uffff') {
            for (AttributedCharacterIterator.Attribute attribute : iterator.getAttributes().keySet()) {
                if (!DateFormat.Field.AM_PM.equals(attribute)) continue;
                return true;
            }
            iterator.setIndex(iterator.getRunLimit());
        }
        return false;
    }

    boolean isDropped() {
        return this.popupShell.getVisible();
    }

    private boolean isCalendar() {
        return (this.style & 0x400) != 0;
    }

    private boolean isDateWithDropDownButton() {
        return (this.style & 4) != 0 && (this.style & 0x20) != 0;
    }

    private boolean isDate() {
        return (this.style & 0x20) != 0;
    }

    private boolean isTime() {
        return (this.style & 0x80) != 0;
    }

    private boolean isReadOnly() {
        return (this.style & 8) != 0;
    }

    private boolean showWeekNumbers() {
        return (this.style & 0x4000) != 0;
    }

    void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            @Override
            public void getName(AccessibleEvent e) {
                e.result = DateTime.this.getSpokenText();
            }

            @Override
            public void getHelp(AccessibleEvent e) {
                e.result = DateTime.this.getToolTipText();
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            @Override
            public void getChildAtPoint(AccessibleControlEvent e) {
                e.childID = -1;
            }

            @Override
            public void getLocation(AccessibleControlEvent e) {
                Rectangle rect = DateTime.this.display.map((Control)DateTime.this.getParent(), null, DateTime.this.getBounds());
                e.x = rect.x;
                e.y = rect.y;
                e.width = rect.width;
                e.height = rect.height;
            }

            @Override
            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            @Override
            public void getRole(AccessibleControlEvent e) {
                e.detail = DateTime.this.isCalendar() ? 41 : 42;
            }

            @Override
            public void getState(AccessibleControlEvent e) {
                e.detail = 0x100000;
                if (DateTime.this.hasFocus()) {
                    e.detail |= 4;
                }
            }

            @Override
            public void getSelection(AccessibleControlEvent e) {
                if (DateTime.this.hasFocus()) {
                    e.childID = -1;
                }
            }

            @Override
            public void getFocus(AccessibleControlEvent e) {
                if (DateTime.this.hasFocus()) {
                    e.childID = -1;
                }
            }
        });
    }

    boolean isValidTime(int fieldName, int value) {
        Calendar validCalendar = this.isCalendar() ? Calendar.getInstance() : this.calendar;
        int min = validCalendar.getActualMinimum(fieldName);
        int max = validCalendar.getActualMaximum(fieldName);
        return value >= min && value <= max;
    }

    boolean isValidDate(int year, int month, int day) {
        if (year < 1752 || year > 9999) {
            return false;
        }
        Calendar valid = Calendar.getInstance();
        valid.set(year, month, day);
        return valid.get(1) == year && valid.get(2) == month && valid.get(5) == day;
    }

    void popupCalendarEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.popupShell == null || this.popupShell.isDisposed() || this.isDisposed() || this.getShell() == this.popupShell.getParent()) break;
                int year = this.popupCalendar.getYear();
                int month = this.popupCalendar.getMonth();
                int day = this.popupCalendar.getDay();
                this.popupShell = null;
                this.popupCalendar = null;
                this.createPopupShell(year, month, day);
                break;
            }
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 3: {
                if (event.button != 1) {
                    return;
                }
                this.mdYear = this.getYear();
                this.mdMonth = this.getMonth();
                break;
            }
            case 4: {
                if (event.button != 1) {
                    return;
                }
                if (this.mdYear != this.getYear() || this.mdMonth != this.getMonth()) break;
                this.dropDownCalendar(false);
                break;
            }
            case 13: {
                int year = this.popupCalendar.getYear();
                int month = this.popupCalendar.getMonth();
                int day = this.popupCalendar.getDay();
                this.setDate(year, month, day);
                Event e = new Event();
                e.time = event.time;
                e.stateMask = event.stateMask;
                e.doit = event.doit;
                this.notifyListeners(13, e);
                event.doit = e.doit;
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                        break;
                    }
                    case 8: 
                    case 16: {
                        event.detail = 0;
                        if (event.doit) {
                            this.dropDownCalendar(false);
                        }
                        return;
                    }
                    case 256: 
                    case 512: {
                        return;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.character = event.character;
                e.keyCode = event.keyCode;
                this.notifyListeners(31, e);
                event.doit = e.doit;
                event.detail = e.detail;
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                break;
            }
            case 1: {
                if (event.character == '\u001b') {
                    this.popupCalendar.setDate(this.savedYear, this.savedMonth, this.savedDay);
                    this.setDate(this.savedYear, this.savedMonth, this.savedDay);
                    this.dropDownCalendar(false);
                }
                if (event.keyCode == 13 || (event.stateMask & 0x10000) != 0 && (event.keyCode == 0x1000001 || event.keyCode == 0x1000002)) {
                    this.dropDownCalendar(false);
                }
                if (event.keyCode == 32) {
                    this.dropDownCalendar(false);
                }
                if (this.isDisposed()) break;
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(1, e);
                break;
            }
        }
    }

    void handleFocus(int type) {
        if (this.isDisposed()) {
            return;
        }
        switch (type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.selectAll();
                this.hasFocus = true;
                Shell shell = this.getShell();
                shell.removeListener(27, this.popupListener);
                shell.addListener(27, this.popupListener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.popupFilter);
                Event e = new Event();
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this.down || focusControl == this.popupCalendar) {
                    return;
                }
                this.hasFocus = false;
                Shell shell = this.getShell();
                shell.removeListener(27, this.popupListener);
                Display display = this.getDisplay();
                display.removeFilter(3, this.mouseEventListener);
                Event e = new Event();
                this.notifyListeners(16, e);
                break;
            }
        }
    }

    void popupShellEvent(Event event) {
        switch (event.type) {
            case 21: {
                event.doit = false;
                this.dropDownCalendar(false);
                break;
            }
            case 4: {
                this.dropDownCalendar(false);
            }
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void selectField(DateFormat.Field field) {
        AttributedCharacterIterator iterator = this.dateFormat.formatToCharacterIterator(this.calendar.getTime());
        while (iterator.current() != '\uffff') {
            for (AttributedCharacterIterator.Attribute attribute : iterator.getAttributes().keySet()) {
                if (!attribute.equals(field)) continue;
                this.selectField(DateTime.getFieldPosition(field, iterator));
                return;
            }
            iterator.setIndex(iterator.getRunLimit());
        }
    }

    void selectField(FieldPosition fieldPosition) {
        boolean sameField = DateTime.isSameField(fieldPosition, this.currentField);
        if (sameField) {
            if (this.typeBufferPos > -1) {
                this.typeBufferPos = 0;
            }
        } else {
            this.typeBufferPos = -1;
            this.commitData();
            fieldPosition = this.updateField(fieldPosition);
        }
        Point pt = this.getSelection();
        int start = fieldPosition.getBeginIndex();
        int end = fieldPosition.getEndIndex();
        if (sameField && start == pt.x && end == pt.y) {
            return;
        }
        this.currentField = fieldPosition;
        this.display.syncExec(() -> {
            if (this.textEntryHandle != 0L) {
                String value = this.getText(this.getText(), start, end - 1);
                int s = value.lastIndexOf(32);
                s = s == -1 ? start : start + s + 1;
                this.setSelection(s, end);
            }
        });
        this.sendSelectionEvent(13);
    }

    void sendSelectionEvent() {
        int[] y = new int[1];
        int[] m = new int[1];
        int[] d = new int[1];
        GTK.gtk_calendar_get_date(this.calendarHandle, y, m, d);
        if (d[0] != this.day || m[0] != this.month || y[0] != this.year) {
            this.year = y[0];
            this.month = m[0];
            this.day = d[0];
            if (this.year == Calendar.getInstance().get(1) && this.month == Calendar.getInstance().get(2)) {
                GTK.gtk_calendar_mark_day(this.calendarHandle, Calendar.getInstance().get(5));
            } else {
                GTK.gtk_calendar_clear_marks(this.calendarHandle);
            }
            this.sendSelectionEvent(13);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.bg = color;
        if (this.popupCalendar != null) {
            this.popupCalendar.setBackground(color);
        }
    }

    @Override
    void setBackgroundGdkRGBA(GdkRGBA rgba) {
        super.setBackgroundGdkRGBA(rgba);
        if (this.calendarHandle != 0L) {
            this.setBackgroundGdkRGBA(this.calendarHandle, rgba);
        }
        super.setBackgroundGdkRGBA(rgba);
    }

    @Override
    void setBackgroundGdkRGBA(long context, long handle, GdkRGBA rgba) {
        String css;
        String name = GTK.GTK_VERSION >= OS.VERSION(3, 20, 0) ? this.display.gtk_widget_class_get_css_name(handle) : this.display.gtk_widget_get_name(handle);
        this.cssBackground = css = name + " {background: " + this.display.gtk_rgba_to_css_string(rgba) + ";}\n" + name + ":selected {background: " + this.display.gtk_rgba_to_css_string(this.display.COLOR_LIST_SELECTION_RGBA) + ";}";
        String finalCss = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
        this.gtk_css_provider_load_from_css(context, finalCss);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.isDateWithDropDownButton()) {
            this.down.setEnabled(enabled);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.font = font;
        if (this.popupCalendar != null) {
            this.popupCalendar.setFont(font);
        }
        this.redraw();
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA rgba) {
        this.setForegroundGdkRGBA(this.containerHandle, rgba);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.fg = color;
        if (this.popupCalendar != null) {
            this.popupCalendar.setForeground(color);
        }
    }

    void setFieldOfInternalDataStructure(FieldPosition field, int value) {
        int calendarField = DateTime.getCalendarField(field);
        if (this.calendar.get(calendarField) == value) {
            return;
        }
        if (calendarField == 9 && this.hasAmPm()) {
            this.calendar.roll(11, 12);
        }
        this.calendar.set(calendarField, value);
        if (this.calendar.get(calendarField) != value) {
            this.calendar.set(calendarField, value);
        }
        this.sendSelectionEvent(13);
    }

    public void setDate(int year, int month, int day) {
        this.checkWidget();
        if (!this.isValidDate(year, month, day)) {
            return;
        }
        if (this.isCalendar()) {
            this.year = year;
            this.month = month;
            this.day = day;
            GTK.gtk_calendar_select_month(this.calendarHandle, month, year);
            GTK.gtk_calendar_select_day(this.calendarHandle, day);
        } else {
            this.calendar.set(year, month, day);
            this.updateControl();
        }
    }

    public void setDay(int day) {
        this.checkWidget();
        if (!this.isValidDate(this.getYear(), this.getMonth(), day)) {
            return;
        }
        if (this.isCalendar()) {
            this.day = day;
            GTK.gtk_calendar_select_day(this.calendarHandle, day);
        } else {
            this.calendar.set(5, day);
            this.updateControl();
        }
    }

    public void setHours(int hours) {
        this.checkWidget();
        if (!this.isValidTime(11, hours)) {
            return;
        }
        if (this.isCalendar()) {
            this.hours = hours;
        } else {
            this.calendar.set(11, hours);
            this.updateControl();
        }
    }

    @Override
    public void setMenu(Menu menu) {
        super.setMenu(menu);
        if (this.down != null) {
            this.down.setMenu(menu);
        }
    }

    public void setMinutes(int minutes) {
        this.checkWidget();
        if (!this.isValidTime(12, minutes)) {
            return;
        }
        if (this.isCalendar()) {
            this.minutes = minutes;
        } else {
            this.calendar.set(12, minutes);
            this.updateControl();
        }
    }

    public void setMonth(int month) {
        this.checkWidget();
        if (!this.isValidDate(this.getYear(), month, this.getDay())) {
            return;
        }
        if (this.isCalendar()) {
            this.month = month;
            GTK.gtk_calendar_select_month(this.calendarHandle, month, this.year);
        } else {
            this.calendar.set(2, month);
            this.updateControl();
        }
    }

    public void setSeconds(int seconds) {
        this.checkWidget();
        if (!this.isValidTime(13, seconds)) {
            return;
        }
        if (this.isCalendar()) {
            this.seconds = seconds;
        } else {
            this.calendar.set(13, seconds);
            this.updateControl();
        }
    }

    public void setTime(int hours, int minutes, int seconds) {
        this.checkWidget();
        if (!this.isValidTime(11, hours)) {
            return;
        }
        if (!this.isValidTime(12, minutes)) {
            return;
        }
        if (!this.isValidTime(13, seconds)) {
            return;
        }
        if (this.isCalendar()) {
            this.hours = hours;
            this.minutes = minutes;
            this.seconds = seconds;
        } else {
            this.calendar.set(11, hours);
            this.calendar.set(12, minutes);
            this.calendar.set(13, seconds);
            this.updateControl();
        }
    }

    public void setYear(int year) {
        this.checkWidget();
        if (!this.isValidDate(year, this.getMonth(), this.getDay())) {
            return;
        }
        if (this.isCalendar()) {
            this.year = year;
            GTK.gtk_calendar_select_month(this.calendarHandle, this.month, year);
        } else {
            this.calendar.set(1, year);
            this.updateControl();
        }
    }

    @Override
    void setBoundsInPixels(int x, int y, int width, int height) {
        int calendarPrefferedVerticalSize;
        if (this.isDateWithDropDownButton()) {
            long sizingHandle = GTK.GTK4 ? this.spinButtonHandle : this.textEntryHandle;
            GtkRequisition requisition = new GtkRequisition();
            GTK.gtk_widget_get_preferred_size(sizingHandle, null, requisition);
            int oldHeight = requisition.height;
            int newWidth = width - (this.down.getSizeInPixels().x + this.getGtkBorderPadding().right);
            GTK.gtk_widget_set_size_request(sizingHandle, newWidth >= 0 ? newWidth : 0, oldHeight);
        }
        int fixedGtkVersion = OS.VERSION(3, 14, 2);
        if (this.isCalendar() && GTK.GTK_VERSION < fixedGtkVersion && height > (calendarPrefferedVerticalSize = this.computeSizeInPixels((int)-1, (int)-1, (boolean)true).y)) {
            height = calendarPrefferedVerticalSize;
        }
        super.setBoundsInPixels(x, y, width, height);
    }

    private void setDropDownButtonSize() {
        int dateEntryHeight;
        Rectangle rect = this.getClientAreaInPixels();
        int parentWidth = rect.width;
        int parentHeight = rect.height;
        Point buttonSize = this.down.computeSizeInPixels(-1, parentHeight);
        int newHeight = dateEntryHeight = this.computeNativeSize((long)(GTK.GTK4 ? this.spinButtonHandle : this.textEntryHandle), (int)-1, (int)-1, (boolean)false).y;
        int newXpos = parentWidth - buttonSize.x - this.getGtkBorderPadding().left - this.getGtkBorderPadding().right;
        int newYPos = parentHeight / 2 - dateEntryHeight / 2;
        this.down.setBoundsInPixels(newXpos, newYPos, buttonSize.x, newHeight);
    }

    GtkBorder getGtkBorderPadding() {
        GtkBorder gtkBorderPadding = new GtkBorder();
        long contextHandle = GTK.GTK4 ? this.spinButtonHandle : this.textEntryHandle;
        long context = GTK.gtk_widget_get_style_context(contextHandle);
        int state_flag = GTK.GTK_VERSION < OS.VERSION(3, 18, 0) ? 0 : GTK.gtk_widget_get_state_flags(contextHandle);
        this.gtk_style_context_get_padding(context, state_flag, gtkBorderPadding);
        return gtkBorderPadding;
    }

    boolean onNumberKeyInput(int key) {
        if (this.currentField == null) {
            return false;
        }
        int fieldName = DateTime.getCalendarField(this.currentField);
        StringBuilder prefix = new StringBuilder();
        StringBuilder current = new StringBuilder();
        StringBuilder suffix = new StringBuilder();
        AttributedCharacterIterator iterator = this.dateFormat.formatToCharacterIterator(this.calendar.getTime());
        char c = iterator.first();
        do {
            if (DateTime.isSameField(this.currentField, DateTime.getFieldPosition(iterator))) {
                current.append(c);
                continue;
            }
            if (current.length() == 0) {
                prefix.append(c);
                continue;
            }
            suffix.append(c);
        } while ((c = iterator.next()) != '\uffff');
        if (this.typeBufferPos < 0) {
            this.typeBuffer.setLength(0);
            this.typeBuffer.append((CharSequence)current);
            this.typeBufferPos = 0;
        }
        if (key == 65288) {
            if (this.typeBufferPos > 0 && this.typeBufferPos <= this.typeBuffer.length()) {
                this.typeBuffer.deleteCharAt(this.typeBufferPos - 1);
                --this.typeBufferPos;
            }
        } else if (key == 65535) {
            if (this.typeBufferPos >= 0 && this.typeBufferPos < this.typeBuffer.length()) {
                this.typeBuffer.deleteCharAt(this.typeBufferPos);
            }
        } else {
            char newText = this.keyToString(key);
            if ((this.style & 0x80) != 0 && fieldName != 9 && !Character.isDigit(newText)) {
                return false;
            }
            if (!Character.isAlphabetic(newText) && !Character.isDigit(newText)) {
                return false;
            }
            if (fieldName == 9 && this.dateFormat instanceof SimpleDateFormat) {
                String[] amPmStrings = ((SimpleDateFormat)this.dateFormat).getDateFormatSymbols().getAmPmStrings();
                if (amPmStrings[0].charAt(0) == newText) {
                    this.setTextField(this.currentField, 0);
                    return false;
                }
                if (amPmStrings[1].charAt(0) == newText) {
                    this.setTextField(this.currentField, 1);
                    return false;
                }
            }
            if (this.typeBufferPos < this.typeBuffer.length()) {
                this.typeBuffer.replace(this.typeBufferPos, this.typeBufferPos + 1, Character.toString(newText));
            } else {
                this.typeBuffer.append(newText);
            }
            ++this.typeBufferPos;
        }
        StringBuilder newText = new StringBuilder(prefix);
        newText.append((CharSequence)this.typeBuffer);
        newText.append((CharSequence)suffix);
        this.setText(newText.toString());
        this.setSelection(prefix.length() + this.typeBufferPos, prefix.length() + this.typeBuffer.length());
        this.currentField.setBeginIndex(prefix.length());
        this.currentField.setEndIndex(prefix.length() + this.typeBuffer.length());
        if (!this.isCalendar()) {
            try {
                Date date = this.dateFormat.parse(this.getText());
                this.calendar.setTime(date);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return false;
    }

    private char keyToString(int key) {
        if (key >= 65456 && key <= 65465) {
            key -= 65408;
        }
        return (char)GDK.gdk_keyval_to_unicode(key);
    }

    void updateControl() {
        if ((this.isDate() || this.isTime()) && this.textEntryHandle != 0L) {
            this.setText(this.getFormattedString());
        }
        this.redraw();
    }

    @Override
    void register() {
        super.register();
        if (this.handle != 0L && this.display.getWidget(this.handle) == null) {
            this.display.addWidget(this.handle, this);
        }
        if (this.containerHandle != 0L && this.containerHandle != this.handle) {
            this.display.addWidget(this.containerHandle, this);
        }
        if (this.textEntryHandle != 0L && this.textEntryHandle != this.containerHandle) {
            this.display.addWidget(this.textEntryHandle, this);
        }
    }

    @Override
    GdkRGBA defaultBackground() {
        return this.display.getSystemColor((int)25).handle;
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.handle != 0L && this.display.getWidget(this.handle) != null) {
            this.display.removeWidget(this.handle);
        }
        if (this.containerHandle != 0L && this.containerHandle != this.handle) {
            this.display.removeWidget(this.containerHandle);
        }
        if (this.textEntryHandle != 0L && this.textEntryHandle != this.containerHandle) {
            this.display.removeWidget(this.textEntryHandle);
        }
    }

    int getArrow(long widget) {
        this.updateControl();
        int adj_value = (int)GTK.gtk_adjustment_get_value(GTK.gtk_spin_button_get_adjustment(widget));
        int new_value = 0;
        if (this.isDate()) {
            FieldPosition firstField = this.getNextField(null);
            int firstFieldConstant = DateTime.getCalendarField(firstField);
            new_value = this.calendar.get(DateTime.getCalendarField(firstField));
            if (firstFieldConstant == 2) {
                if ((this.style & 0x8000) != 0) {
                    --adj_value;
                } else if ((this.style & 0x10000) != 0 || (this.style & 0x10000000) != 0) {
                    if (adj_value == 0) {
                        return 0;
                    }
                    return adj_value > 0 ? 0x1000001 : 0x1000002;
                }
            }
        } else if (this.isTime()) {
            new_value = this.getHours();
            if (this.hasAmPm()) {
                if (this.getHours() > 12) {
                    new_value = this.getHours() - 12;
                }
                if (new_value == 0) {
                    new_value = 12;
                }
            }
        }
        if (adj_value == 0 && this.firstTime) {
            return 0;
        }
        this.firstTime = false;
        if (adj_value == new_value) {
            return 0;
        }
        return adj_value > new_value ? 0x1000001 : 0x1000002;
    }

    void setText(String dateTimeText) {
        if (dateTimeText != null) {
            byte[] dateTimeConverted = Converter.wcsToMbcs(dateTimeText, true);
            GTK.gtk_entry_set_width_chars(this.textEntryHandle, dateTimeText.length());
            GTK.gtk_entry_set_text(this.textEntryHandle, dateTimeConverted);
            if (this.popupCalendar != null && this.calendar != null) {
                Date parse;
                try {
                    parse = this.dateFormat.parse(dateTimeText);
                }
                catch (ParseException e) {
                    return;
                }
                Calendar clone = (Calendar)this.calendar.clone();
                clone.setTime(parse);
                try {
                    this.popupCalendar.setDate(clone.get(1), clone.get(2), clone.get(5));
                }
                catch (SWTException e) {
                    if (e.code == 24) {
                        return;
                    }
                    throw e;
                }
            }
        }
    }

    @Override
    long gtk_key_press_event(long widget, long event) {
        if (!this.isReadOnly() && (this.isTime() || this.isDate())) {
            int[] key = new int[1];
            GDK.gdk_event_get_keyval(event, key);
            switch (key[0]) {
                case 65362: 
                case 65431: {
                    this.incrementField(1);
                    this.commitData();
                    break;
                }
                case 65364: 
                case 65433: {
                    this.incrementField(-1);
                    this.commitData();
                    break;
                }
                case 65289: 
                case 65363: 
                case 65432: {
                    this.selectField(this.getNextField(this.currentField));
                    this.sendEvent(31);
                    break;
                }
                case 65361: 
                case 65430: {
                    this.selectField(this.getPreviousField(this.currentField));
                    this.sendEvent(31);
                    break;
                }
                case 65360: 
                case 65429: {
                    if (this.currentField == null) break;
                    this.setTextField(this.currentField, this.calendar.getActualMinimum(DateTime.getCalendarField(this.currentField)));
                    break;
                }
                case 65367: 
                case 65436: {
                    if (this.currentField == null) break;
                    this.setTextField(this.currentField, this.calendar.getActualMaximum(DateTime.getCalendarField(this.currentField)));
                    break;
                }
                default: {
                    this.onNumberKeyInput(key[0]);
                }
            }
        }
        return 1L;
    }

    void commitData() {
        try {
            Date date = this.dateFormat.parse(this.getText());
            this.calendar.setTime(date);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.updateControl();
    }

    Point getSelection() {
        this.checkWidget();
        int[] start = new int[1];
        int[] end = new int[1];
        GTK.gtk_editable_get_selection_bounds(this.textEntryHandle, start, end);
        long ptr = GTK.gtk_entry_get_text(this.textEntryHandle);
        start[0] = (int)OS.g_utf8_offset_to_utf16_offset(ptr, start[0]);
        end[0] = (int)OS.g_utf8_offset_to_utf16_offset(ptr, end[0]);
        Point selection = new Point(start[0], end[0]);
        return selection;
    }

    String getText() {
        this.checkWidget();
        if (this.textEntryHandle != 0L) {
            long str = GTK.gtk_entry_get_text(this.textEntryHandle);
            if (str == 0L) {
                return "";
            }
            int length = C.strlen(str);
            byte[] buffer = new byte[length];
            C.memmove(buffer, str, (long)length);
            return new String(Converter.mbcsToWcs(buffer));
        }
        return "";
    }

    String getText(String str, int start, int end) {
        this.checkWidget();
        if (start > end || 0 > end) {
            return "";
        }
        int length = str.length();
        if (start > (end = Math.min(end, length - 1))) {
            return "";
        }
        start = Math.max(0, start);
        return str.substring(start, end + 1);
    }

    void setSelection(int start, int end) {
        this.checkWidget();
        long ptr = GTK.gtk_entry_get_text(this.textEntryHandle);
        start = (int)OS.g_utf16_offset_to_utf8_offset(ptr, start);
        end = (int)OS.g_utf16_offset_to_utf8_offset(ptr, end);
        GTK.gtk_editable_set_position(this.textEntryHandle, start);
        GTK.gtk_editable_select_region(this.textEntryHandle, start, end);
    }

    void setTextField(FieldPosition field, int value) {
        int validValue = this.validateValueBounds(field, value);
        this.setFieldOfInternalDataStructure(field, validValue);
        this.setFieldOfInternalDataStructure(field, value);
        this.updateControl();
        if (this.currentField != null) {
            this.selectField(this.currentField);
        }
    }

    private int validateValueBounds(FieldPosition field, int value) {
        int calendarField = DateTime.getCalendarField(field);
        int max = this.calendar.getActualMaximum(calendarField);
        int min = this.calendar.getActualMinimum(calendarField);
        if (calendarField == 1) {
            max = 9999;
            min = 1752;
            int currentYear = Calendar.getInstance().get(1);
            int currentCentury = currentYear / 100 * 100;
            if (value < (currentYear + 30) % 100) {
                value += currentCentury;
            } else if (value < 100) {
                value += currentCentury - 100;
            }
        }
        if (value > max) {
            value = min;
        }
        if (value < min) {
            value = max;
        }
        return value;
    }

    @Override
    long gtk_button_release_event(long widget, long event) {
        if (this.isDate() || this.isTime()) {
            int[] eventButton = new int[1];
            GDK.gdk_event_get_button(event, eventButton);
            if (eventButton[0] == 1) {
                this.onTextMouseClick();
            }
        }
        return super.gtk_button_release_event(widget, event);
    }

    @Override
    long gtk_output(long widget) {
        if (this.calendar == null) {
            return 0L;
        }
        int arrowType = this.getArrow(widget);
        switch (arrowType) {
            case 0x1000001: {
                this.commitData();
                this.incrementField(1);
                break;
            }
            case 0x1000002: {
                this.commitData();
                this.incrementField(-1);
            }
        }
        return 1L;
    }

    void replaceCurrentlySelectedTextRegion(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] buffer = Converter.wcsToMbcs(string, false);
        int[] start = new int[1];
        int[] end = new int[1];
        GTK.gtk_editable_get_selection_bounds(this.textEntryHandle, start, end);
        GTK.gtk_editable_delete_selection(this.textEntryHandle);
        GTK.gtk_editable_insert_text(this.textEntryHandle, buffer, buffer.length, start);
        GTK.gtk_editable_set_position(this.textEntryHandle, start[0]);
    }

    void onTextMouseClick() {
        if (this.calendar == null) {
            return;
        }
        int clickPosition = this.getSelection().x;
        AttributedCharacterIterator iterator = this.dateFormat.formatToCharacterIterator(this.calendar.getTime());
        iterator.first();
        int pos = 0;
        do {
            FieldPosition position = DateTime.getFieldPosition(iterator);
            iterator.setIndex(iterator.getRunLimit());
            if (DateTime.isSameField(position, this.currentField)) {
                position = this.currentField;
            }
            int fieldWidth = position.getEndIndex() - position.getBeginIndex();
            if (position.getFieldAttribute() == null || (pos += fieldWidth) < clickPosition) continue;
            FieldPosition selectField = new FieldPosition(position.getFieldAttribute());
            selectField.setBeginIndex(pos - fieldWidth);
            selectField.setEndIndex(pos);
            this.selectField(selectField);
            break;
        } while (iterator.current() != '\uffff');
    }

    String getText(int start, int end) {
        this.checkWidget();
        if (start > end || 0 > end) {
            return "";
        }
        String str = this.getText();
        int length = str.length();
        if (start > (end = Math.min(end, length - 1))) {
            return "";
        }
        start = Math.max(0, start);
        return str.substring(start, end + 1);
    }

    void selectAll() {
        this.checkWidget();
        if (this.textEntryHandle != 0L) {
            GTK.gtk_editable_select_region(this.textEntryHandle, 0, -1);
        }
    }

    void hideDateTime() {
        if (this.isDate() || this.isTime()) {
            GTK.gtk_widget_hide(this.fixedHandle);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.fixedHandle != 0L) {
            this.hideDateTime();
        }
    }

    private FieldPosition updateField(FieldPosition field) {
        AttributedCharacterIterator iterator = this.dateFormat.formatToCharacterIterator(this.calendar.getTime());
        while (iterator.current() != '\uffff') {
            FieldPosition current = DateTime.getFieldPosition(iterator);
            iterator.setIndex(iterator.getRunLimit());
            if (field != null && !DateTime.isSameField(current, field)) continue;
            return current;
        }
        return field;
    }

    private FieldPosition getNextField(FieldPosition field) {
        AttributedCharacterIterator iterator = this.dateFormat.formatToCharacterIterator(this.calendar.getTime());
        FieldPosition first = null;
        boolean found = false;
        while (iterator.current() != '\uffff') {
            FieldPosition current = DateTime.getFieldPosition(iterator);
            iterator.setIndex(iterator.getRunLimit());
            if (current.getFieldAttribute() == null) continue;
            if (found) {
                return current;
            }
            if (first == null) {
                first = current;
            }
            if (!DateTime.isSameField(current, field)) continue;
            found = true;
        }
        return first;
    }

    private FieldPosition getPreviousField(FieldPosition field) {
        AttributedCharacterIterator iterator = this.dateFormat.formatToCharacterIterator(this.calendar.getTime());
        FieldPosition last = null;
        do {
            FieldPosition current;
            if (DateTime.isSameField(current = DateTime.getFieldPosition(iterator), field) && last != null) {
                return last;
            }
            if (current.getFieldAttribute() != null) {
                last = current;
            }
            iterator.setIndex(iterator.getRunLimit());
        } while (iterator.current() != '\uffff');
        return last;
    }

    private static FieldPosition getFieldPosition(AttributedCharacterIterator iterator) {
        Set<AttributedCharacterIterator.Attribute> keySet = iterator.getAttributes().keySet();
        for (AttributedCharacterIterator.Attribute attribute : keySet) {
            if (!(attribute instanceof DateFormat.Field)) continue;
            return DateTime.getFieldPosition((DateFormat.Field)attribute, iterator);
        }
        return DateTime.getFieldPosition(null, iterator);
    }

    private static FieldPosition getFieldPosition(DateFormat.Field field, AttributedCharacterIterator iterator) {
        FieldPosition position = new FieldPosition(field);
        position.setBeginIndex(iterator.getRunStart());
        position.setEndIndex(iterator.getRunLimit());
        return position;
    }

    private static boolean isSameField(FieldPosition p1, FieldPosition p2) {
        if (p1 == p2) {
            return true;
        }
        if (p1 == null || p2 == null) {
            return false;
        }
        if (p1.getFieldAttribute() == null && p2.getFieldAttribute() == null) {
            return p1.equals(p2);
        }
        if (p1.getFieldAttribute() == null) {
            return false;
        }
        return p1.getFieldAttribute().equals(p2.getFieldAttribute());
    }

    private static int getCalendarField(FieldPosition fieldPosition) {
        if (fieldPosition.getFieldAttribute() instanceof DateFormat.Field) {
            return DateTime.getCalendarField((DateFormat.Field)fieldPosition.getFieldAttribute());
        }
        return -1;
    }

    private static int getCalendarField(DateFormat.Field field) {
        if (DateFormat.Field.HOUR1.equals(field)) {
            field = DateFormat.Field.HOUR0;
        } else if (DateFormat.Field.HOUR_OF_DAY1.equals(field)) {
            field = DateFormat.Field.HOUR_OF_DAY0;
        }
        return field.getCalendarField();
    }
}

