/*
 * Decompiled with CFR 0.152.
 */
package settings;

import application.Console;
import application.RecordInputDevice;
import application.RenderQueue;
import application.Settings;
import application.Shutter;
import application.SubtitlesEmbed;
import application.VideoPlayer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.time.Clock;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import library.EXIFTOOL;
import library.FFMPEG;
import library.FFPROBE;
import library.MEDIAINFO;
import library.XPDF;
import settings.Corrections;
import settings.InputAndOutput;
import settings.Transitions;

public class FunctionUtils
extends Shutter {
    public static int completed;
    public static boolean allowsInvalidCharacters;
    public static boolean yesToAll;
    public static boolean noToAll;
    public static File OPAtomFolder;
    public static String silentTrack;
    public static int mergeDuration;
    public static boolean bestBitrateMode;
    public static boolean goodBitrateMode;
    public static boolean autoBitrateMode;
    private static StringBuilder mailFileList;

    static {
        allowsInvalidCharacters = false;
        yesToAll = false;
        noToAll = false;
        silentTrack = "";
        mergeDuration = 0;
        mailFileList = new StringBuilder();
    }

    public static boolean analyze(File file, boolean isRaw) throws InterruptedException {
        btnStart.setEnabled(false);
        String extension = file.toString().substring(file.toString().lastIndexOf("."));
        if (caseGenerateFromDate.isSelected() || comboFonctions.getSelectedItem().toString().equals("JPEG") || comboFonctions.getSelectedItem().toString().equals(language.getProperty("functionPicture"))) {
            EXIFTOOL.run(file.toString());
            do {
                Thread.sleep(100L);
            } while (EXIFTOOL.isRunning);
        }
        if (!(inputDeviceIsRunning || isRaw || extension.toLowerCase().equals(".pdf"))) {
            FFPROBE.FrameData(file.toString());
            do {
                Thread.sleep(100L);
            } while (FFPROBE.isRunning);
            FFMPEG.checkGPUCapabilities(file.toString(), false);
            if (FunctionUtils.analyzeError(file.toString())) {
                return false;
            }
        } else if (extension.toLowerCase().equals(".pdf")) {
            XPDF.info(file.toString());
            do {
                Thread.sleep(100L);
            } while (XPDF.isRunning);
            if (FunctionUtils.analyzeError(file.toString())) {
                return false;
            }
            XPDF.toFFPROBE(file.toString());
            do {
                Thread.sleep(100L);
            } while (XPDF.isRunning);
            if (FunctionUtils.analyzeError(file.toString())) {
                return false;
            }
        }
        if (!isRaw && !extension.toLowerCase().equals(".pdf")) {
            FFPROBE.Data(file.toString());
            do {
                Thread.sleep(100L);
            } while (FFPROBE.isRunning);
            if (FunctionUtils.analyzeError(file.toString())) {
                return false;
            }
            if (FFPROBE.timecode1 == "" || FFPROBE.interlaced == null) {
                MEDIAINFO.run(file.toString(), false);
                do {
                    Thread.sleep(100L);
                } while (MEDIAINFO.isRunning);
                if (FFPROBE.interlaced == null) {
                    FFPROBE.interlaced = "0";
                    FFPROBE.fieldOrder = "0";
                }
            }
        } else if (FFPROBE.interlaced == null) {
            FFPROBE.interlaced = "0";
            FFPROBE.fieldOrder = "0";
        }
        return true;
    }

    public static boolean analyzeError(String file) {
        if (FFMPEG.error) {
            errorList = new StringBuilder(String.valueOf(file) + System.lineSeparator() + FFMPEG.errorLog + System.lineSeparator());
            return true;
        }
        return false;
    }

    public static boolean waitFileCompleted(File file) {
        progressBar1.setIndeterminate(true);
        lblCurrentEncoding.setForeground(Color.LIGHT_GRAY);
        lblCurrentEncoding.setText(file.getName());
        tempsRestant.setVisible(false);
        btnStart.setEnabled(false);
        btnCancel.setEnabled(true);
        comboFonctions.setEnabled(false);
        long fileSize = 0L;
        do {
            fileSize = file.length();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while ((fileSize != file.length() || !FFMPEG.isReadable(file)) && !cancelled && file.exists());
        progressBar1.setIndeterminate(false);
        btnCancel.setEnabled(false);
        if (cancelled) {
            lblCurrentEncoding.setText(language.getProperty("lblEncodageEnCours"));
            btnStart.setEnabled(true);
            comboFonctions.setEnabled(true);
            return false;
        }
        return true;
    }

    public static File setInputFile(File input) {
        if (Shutter.scanIsRunning) {
            input = FunctionUtils.watchFolder();
            if (input == null) {
                return null;
            }
            btnStart.setEnabled(true);
            Shutter.progressBar1.setIndeterminate(false);
        } else if (Settings.btnWaitFileComplete.isSelected() && !FunctionUtils.waitFileCompleted(input)) {
            return null;
        }
        return input;
    }

    public static File watchFolder() {
        progressBar1.setIndeterminate(true);
        lblCurrentEncoding.setText(language.getProperty("waitingFiles"));
        tempsRestant.setVisible(false);
        FunctionUtils.disableAll();
        File actualScanningFile = null;
        do {
            if (actualScanningFile != null) continue;
            int i = 0;
            while (i < liste.getSize()) {
                File dir = new File((String)liste.getElementAt(i));
                btnStart.setEnabled(false);
                File[] fileArray = dir.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    block10: {
                        File file;
                        block11: {
                            file = fileArray[n2];
                            if (file.isDirectory() || file.isHidden() || file.getName().equals("completed") || file.getName().equals("error")) break block10;
                            if (!file.getName().contains(".")) break block11;
                            boolean allowed = true;
                            if (!Settings.btnExclude.isSelected()) break block11;
                            String[] stringArray = Settings.txtExclude.getText().split("\\*");
                            int n3 = stringArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String excludeExt = stringArray[n4];
                                int s = file.toString().lastIndexOf(46);
                                String ext = file.toString().substring(s);
                                if (excludeExt.contains(".") && ext.toLowerCase().equals(excludeExt.replace(",", "").toLowerCase())) {
                                    allowed = false;
                                }
                                ++n4;
                            }
                            if (!allowed) break block10;
                        }
                        actualScanningFile = file;
                        progressBar1.setIndeterminate(true);
                        if (!FunctionUtils.waitFileCompleted(file)) {
                            return null;
                        }
                        if (actualScanningFile != null) {
                            return actualScanningFile;
                        }
                    }
                    ++n2;
                }
                ++i;
            }
        } while (scanIsRunning);
        progressBar1.setIndeterminate(false);
        FunctionUtils.enableAll();
        btnEmptyList.doClick();
        return null;
    }

    public static void moveScannedFiles(File file) {
        File fileToMove;
        File folder = new File(String.valueOf(file.getParent()) + "/completed");
        if (FFMPEG.error || cancelled) {
            folder = new File(String.valueOf(file.getParent()) + "/error");
        }
        if (!folder.exists()) {
            folder.mkdir();
        }
        if ((fileToMove = new File(folder + "/" + file.getName())).exists()) {
            int n = 1;
            String ext = file.getName().substring(file.getName().lastIndexOf("."));
            do {
                fileToMove = new File(folder + "/" + file.getName().replace(ext, "") + "_" + n + ext);
                ++n;
            } while (fileToMove.exists());
        }
        file.renameTo(fileToMove);
    }

    public static String completedFiles(int number) {
        String labelName = number > 1 && number < 1000 ? String.valueOf(number) + " " + Shutter.language.getProperty("filesEnded") : (number <= 1 ? String.valueOf(number) + " " + Shutter.language.getProperty("fileEnded") : String.valueOf(number / 1000) + "k " + Shutter.language.getProperty("filesEnded"));
        return labelName;
    }

    public static void listFilesForFolder(String file, File folder) {
        if (file == null) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                String ext;
                File fileEntry = fileArray[n2];
                if (fileEntry.isFile() && ((ext = fileEntry.toString().substring(fileEntry.toString().lastIndexOf("."))).equals(".log") || ext.equals(".xml") || ext.equals(".mpg") || ext.equals(".meta") || ext.equals(".mkv"))) {
                    File fileToDelete = new File(fileEntry.getAbsolutePath());
                    fileToDelete.delete();
                }
                ++n2;
            }
        } else {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n3 = 0;
            while (n3 < n) {
                File fileEntry = fileArray[n3];
                if (fileEntry.isFile() && fileEntry.getName().contains(file) && fileEntry.getName().contains(".log")) {
                    File fileToDelete = new File(fileEntry.getAbsolutePath());
                    fileToDelete.delete();
                }
                ++n3;
            }
        }
    }

    public static String setConcat(File file, String output) {
        String extension = file.toString().substring(file.toString().lastIndexOf("."));
        File concatFile = new File(String.valueOf(output.replace("\\", "/")) + "/" + file.getName().replace(extension, ".txt"));
        if (VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("removeMode")) && caseInAndOut.isSelected()) {
            block5: {
                try {
                    PrintWriter writer = new PrintWriter(concatFile.toString(), "UTF-8");
                    DecimalFormat formatter = new DecimalFormat("00");
                    DecimalFormat formatFrame = new DecimalFormat("000");
                    int h = Integer.parseInt(VideoPlayer.caseInH.getText());
                    int m = Integer.parseInt(VideoPlayer.caseInM.getText());
                    int s = Integer.parseInt(VideoPlayer.caseInS.getText());
                    int f = (int)((float)Integer.parseInt(VideoPlayer.caseInF.getText()) * (1000.0f / FFPROBE.currentFPS));
                    writer.println("file '" + file + "'");
                    writer.println("outpoint " + formatter.format(h) + ":" + formatter.format(m) + ":" + formatter.format(s) + "." + formatFrame.format(f));
                    h = Integer.parseInt(VideoPlayer.caseOutH.getText());
                    m = Integer.parseInt(VideoPlayer.caseOutM.getText());
                    s = Integer.parseInt(VideoPlayer.caseOutS.getText());
                    f = (int)((float)Integer.parseInt(VideoPlayer.caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS));
                    writer.println("file '" + file + "'");
                    writer.println("inpoint " + formatter.format(h) + ":" + formatter.format(m) + ":" + formatter.format(s) + "." + formatFrame.format(f));
                    InputAndOutput.inPoint = "";
                    InputAndOutput.outPoint = "";
                    writer.close();
                }
                catch (FileNotFoundException | UnsupportedEncodingException e) {
                    FFMPEG.error = true;
                    if (!concatFile.exists()) break block5;
                    concatFile.delete();
                }
            }
            return " -safe 0 -f concat";
        }
        if (grpImageSequence.isVisible() && caseEnableSequence.isSelected()) {
            FunctionUtils.setMerge(file.getName(), extension, output);
            return " -safe 0 -f concat -r " + caseSequenceFPS.getSelectedItem().toString().replace(",", ".");
        }
        if (Settings.btnSetBab.isSelected() || grpImageSequence.isVisible() && caseEnableSequence.isSelected()) {
            FunctionUtils.setMerge(file.getName(), extension, output);
            return " -safe 0 -f concat";
        }
        return "";
    }

    public static void setMerge(String fileName, String extension, String output) {
        block12: {
            File concatFile = new File(String.valueOf(output.replace("\\", "/")) + "/" + fileName.replace(extension, ".txt"));
            try {
                mergeDuration = 0;
                frame.setCursor(Cursor.getPredefinedCursor(3));
                PrintWriter writer = new PrintWriter(concatFile, "UTF-8");
                int i = 0;
                while (i < liste.getSize()) {
                    File file;
                    if (Settings.btnWaitFileComplete.isSelected() && !FunctionUtils.waitFileCompleted(file = new File((String)liste.getElementAt(i)))) break;
                    if (Settings.btnSetBab.isSelected()) {
                        FFPROBE.Data((String)liste.getElementAt(i));
                        do {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (FFPROBE.totalLength == 0 && FFPROBE.isRunning);
                        do {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (FFPROBE.isRunning);
                        mergeDuration += FFPROBE.totalLength;
                        FFPROBE.totalLength = 0;
                    } else if (grpImageSequence.isVisible() && caseEnableSequence.isSelected()) {
                        FFPROBE.currentFPS = 25.0f;
                        mergeDuration = (int)((float)Shutter.liste.getSize() * (1000.0f / Float.parseFloat(caseSequenceFPS.getSelectedItem().toString().replace(",", "."))));
                    }
                    writer.println("file '" + (String)liste.getElementAt(i) + "'");
                    ++i;
                }
                writer.close();
                frame.setCursor(Cursor.getPredefinedCursor(0));
                progressBar1.setMaximum(mergeDuration / 1000);
                FFPROBE.totalLength = mergeDuration;
                FFMPEG.dureeTotale = progressBar1.getMaximum();
            }
            catch (FileNotFoundException | UnsupportedEncodingException e) {
                frame.setCursor(Cursor.getPredefinedCursor(0));
                FFMPEG.error = true;
                if (!concatFile.exists()) break block12;
                concatFile.delete();
            }
        }
    }

    public static String setOutputDestination(String output, File file) {
        if (caseChangeFolder1.isSelected()) {
            String number;
            output = lblDestination1.getText();
            if (caseCreateTree.isSelected()) {
                File pathToFile = null;
                if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                    String[] s = file.getParent().toString().split("/");
                    pathToFile = new File(String.valueOf(lblDestination1.getText()) + file.getParent().toString().replace("/Volumes", "").replace(s[2], ""));
                } else {
                    pathToFile = new File(String.valueOf(lblDestination1.getText()) + file.getParent().toString().substring(2));
                }
                if (!pathToFile.exists()) {
                    pathToFile.mkdirs();
                }
                output = pathToFile.toString();
            } else if (caseCreateOPATOM.isSelected() && lblOPATOM.getText().equals("OP-Atom") && (comboFonctions.getSelectedItem().toString().equals("DNxHD") || comboFonctions.getSelectedItem().toString().equals("DNxHR")) && (number = new File(output).getName()).matches("^[0-9]+$")) {
                if (OPAtomFolder == null) {
                    OPAtomFolder = file.getName().contains(file.getParentFile().getName()) ? new File(file.getParentFile().getParent()) : new File(file.getParent());
                } else if (file.getName().contains(file.getParentFile().getName())) {
                    if (!file.getParentFile().getParent().toString().equals(OPAtomFolder.toString())) {
                        File newFolder;
                        int n = Integer.parseInt(number) + 1;
                        do {
                            newFolder = new File(String.valueOf(new File(output).getParent()) + "/" + n);
                            ++n;
                        } while (newFolder.exists());
                        newFolder.mkdir();
                        lblDestination1.setText(newFolder.toString());
                        output = lblDestination1.getText();
                        OPAtomFolder = new File(file.getParentFile().getParent());
                    }
                } else if (!file.getParent().toString().equals(OPAtomFolder.toString())) {
                    File newFolder;
                    int n = Integer.parseInt(number) + 1;
                    do {
                        newFolder = new File(String.valueOf(new File(output).getParent()) + "/" + n);
                        ++n;
                    } while (newFolder.exists());
                    newFolder.mkdir();
                    lblDestination1.setText(newFolder.toString());
                    output = lblDestination1.getText();
                    OPAtomFolder = new File(file.getParent());
                }
            }
        } else {
            output = file.getParent();
            lblDestination1.setText(output);
        }
        return output;
    }

    public static String getRandomHexString() {
        Random r = new Random();
        StringBuffer sb = new StringBuffer();
        while (sb.length() < 10) {
            sb.append(Integer.toHexString(r.nextInt()));
        }
        return sb.toString().substring(0, 10);
    }

    public static String setLoop(String extension) {
        block21: {
            if (caseEnableSequence.isSelected()) break block21;
            switch (extension) {
                case ".bmp": 
                case ".jpg": 
                case ".png": 
                case ".psd": 
                case ".tga": 
                case ".tif": 
                case ".jpeg": 
                case ".tiff": {
                    return " -loop 1 -t " + Settings.txtImageDuration.getText();
                }
            }
        }
        return "";
    }

    public static int setVideoBitrate() {
        bestBitrateMode = false;
        goodBitrateMode = false;
        autoBitrateMode = false;
        if (debitVideo.getSelectedItem().equals(language.getProperty("lblBest").toLowerCase()) || debitVideo.getSelectedItem().equals(language.getProperty("lblGood").toLowerCase()) || debitVideo.getSelectedItem().equals("auto")) {
            String function = comboFonctions.getSelectedItem().toString();
            Integer compValue = 165888;
            if ("MJPEG".equals(function)) {
                compValue = 16588;
            } else if ("MPEG-1".equals(function)) {
                compValue = 33177;
            } else if ("WMV".equals(function)) {
                compValue = 41472;
            } else if ("MPEG-2".equals(function) || "Xvid".equals(function) || "OGV".equals(function)) {
                compValue = 103680;
            } else if ("H.265".equals(function) || "VP9".equals(function)) {
                compValue = 331776;
            } else if ("AV1".equals(function)) {
                compValue = 414720;
            }
            int pixels = FFPROBE.imageWidth * FFPROBE.imageHeight;
            if (!comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
                String[] i = FFPROBE.imageResolution.split("x");
                String[] o = FFPROBE.imageResolution.split("x");
                if (comboResolution.getSelectedItem().toString().contains("%")) {
                    double value = (double)Integer.parseInt(comboResolution.getSelectedItem().toString().replace("%", "")) / 100.0;
                    o[0] = String.valueOf(Math.round((double)Integer.parseInt(o[0]) * value));
                    o[1] = String.valueOf(Math.round((double)Integer.parseInt(o[1]) * value));
                } else if (comboResolution.getSelectedItem().toString().contains("x")) {
                    o = comboResolution.getSelectedItem().toString().split("x");
                } else if (comboResolution.getSelectedItem().toString().contains(":")) {
                    o = comboResolution.getSelectedItem().toString().replace("auto", "1").split(":");
                    int iw = Integer.parseInt(i[0]);
                    int ih = Integer.parseInt(i[1]);
                    int ow = Integer.parseInt(o[0]);
                    int oh = Integer.parseInt(o[1]);
                    float ir = (float)iw / (float)ih;
                    if (o[0].toString().equals("1")) {
                        o[0] = String.valueOf(Math.round((float)oh * ir));
                    } else {
                        o[1] = String.valueOf(Math.round((float)ow / ir));
                    }
                }
                int ow = Integer.parseInt(o[0]);
                int oh = Integer.parseInt(o[1]);
                pixels = ow * oh;
            }
            float framerate = FFPROBE.currentFPS;
            if (caseConform.isSelected()) {
                framerate = Float.valueOf(comboFPS.getSelectedItem().toString().replace(",", ".")).floatValue();
            }
            int bitDepth = 8;
            if (caseColorspace.isSelected()) {
                if (comboColorspace.getSelectedItem().toString().contains("10bits")) {
                    bitDepth = 10;
                } else if (comboColorspace.getSelectedItem().toString().contains("12bits")) {
                    bitDepth = 12;
                }
            }
            Integer videoBitrate = Math.round((float)pixels * framerate * (float)bitDepth * 2.0f / (float)compValue.intValue());
            if (debitVideo.getSelectedItem().equals(language.getProperty("lblBest").toLowerCase())) {
                bestBitrateMode = true;
                videoBitrate = videoBitrate * 4;
            } else if (debitVideo.getSelectedItem().equals(language.getProperty("lblGood").toLowerCase())) {
                goodBitrateMode = true;
                videoBitrate = videoBitrate * 2;
            } else {
                autoBitrateMode = true;
            }
            return videoBitrate;
        }
        return Integer.parseInt(debitVideo.getSelectedItem().toString());
    }

    public static String setStream() {
        switch (comboFonctions.getSelectedItem().toString()) {
            case "H.264": 
            case "H.265": {
                if (!caseStream.isSelected()) break;
                if (caseLoop.isSelected()) {
                    return " -stream_loop -1 -re";
                }
                return " -re";
            }
        }
        return "";
    }

    public static String setMetadatas() {
        String metadata = " -metadata creation_time=\"" + Clock.systemUTC().instant() + '\"';
        if (casePreserveMetadata.isSelected()) {
            if (FFPROBE.creationTime != "") {
                metadata = " -metadata creation_time=\"" + FFPROBE.creationTime + '\"';
            }
            metadata = String.valueOf(metadata) + " -map_metadata 0 -map_metadata:s:v 0:s:v";
            if (FFPROBE.hasAudio) {
                metadata = String.valueOf(metadata) + " -map_metadata:s:a 0:s:a";
            }
            metadata = String.valueOf(metadata) + " -movflags use_metadata_tags";
        }
        return metadata;
    }

    public static String setMapSubtitles() {
        int i = 0;
        if (VideoPlayer.caseAddWatermark.isSelected()) {
            i = 1;
        }
        String subsMapping = "";
        boolean addSub = false;
        Component[] componentArray = SubtitlesEmbed.frame.getContentPane().getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof JTextField) {
                if (((JTextField)c).getText().equals(language.getProperty("aucun"))) break;
                ++i;
                addSub = true;
            } else if (c instanceof JComboBox && addSub) {
                String[] languages = Locale.getISOLanguages();
                Locale loc = Locale.of(languages[((JComboBox)c).getSelectedIndex()]);
                subsMapping = VideoPlayer.caseAddWatermark.isSelected() ? String.valueOf(subsMapping) + " -map " + i + ":s -metadata:s:s:" + (i - 2) + " language=" + loc.getISO3Language().replace("zho", "chi") : String.valueOf(subsMapping) + " -map " + i + ":s -metadata:s:s:" + (i - 1) + " language=" + loc.getISO3Language().replace("zho", "chi");
                addSub = false;
            }
            ++n2;
        }
        return subsMapping;
    }

    public static String setFilterComplex(String filterComplex, String audio) {
        block29: {
            block30: {
                block28: {
                    float newFPS;
                    if (comboFonctions.getSelectedItem().toString().equals("JPEG") || comboFonctions.getSelectedItem().toString().equals(language.getProperty("functionPicture"))) {
                        if (filterComplex != "") {
                            filterComplex = " -filter_complex \"" + filterComplex + "[out]" + '\"' + " -map " + '\"' + "[out]" + '\"';
                        }
                        return filterComplex;
                    }
                    switch (comboFonctions.getSelectedItem().toString()) {
                        case "VP9": 
                        case "H.264": 
                        case "H.265": {
                            if (!caseAccel.isSelected() || !comboAccel.getSelectedItem().equals("VAAPI")) break;
                            filterComplex = caseColorspace.isSelected() && comboColorspace.getSelectedItem().toString().contains("10bits") ? String.valueOf(filterComplex) + ",format=p010,hwupload" : String.valueOf(filterComplex) + ",format=nv12,hwupload";
                        }
                    }
                    if (caseOPATOM.isSelected()) {
                        audio = "";
                    }
                    if (filterComplex != "") {
                        filterComplex = VideoPlayer.caseAddWatermark.isSelected() || VideoPlayer.caseAddSubtitles.isSelected() && subtitlesBurn ? " -filter_complex \"" + filterComplex + "[out]" : " -filter_complex \"[0:v]" + filterComplex + "[out]";
                        newFPS = Float.parseFloat(comboFPS.getSelectedItem().toString().replace(",", "."));
                        float value = newFPS / FFPROBE.currentFPS;
                        filterComplex = caseConform.isSelected() && (comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySpeed")) || comboConform.getSelectedItem().toString().equals(language.getProperty("conformByReverse"))) && (value < 0.5f || value > 2.0f) ? String.valueOf(filterComplex) + "\" -map \"[out]\"" + audio : (caseConform.isSelected() && comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySlowMotion")) ? String.valueOf(filterComplex) + "\" -map \"[out]\"" + audio : (!(FFPROBE.channels <= 1 || !lblAudioMapping.getText().equals(language.getProperty("stereo")) && !lblAudioMapping.getText().equals(language.getProperty("mono")) || debitAudio.getSelectedItem().toString().equals("0") && !comboAudioCodec.getSelectedItem().equals("FLAC") || FFPROBE.stereo) ? String.valueOf(filterComplex) + audio + " -map " + '\"' + "[out]" + '\"' + " -map " + '\"' + "[a]" + '\"' : (FFPROBE.stereo && lblAudioMapping.getText().equals(language.getProperty("mono")) && (!debitAudio.getSelectedItem().toString().equals("0") || comboAudioCodec.getSelectedItem().equals("FLAC")) && !FFPROBE.surround ? String.valueOf(filterComplex) + audio + " -map " + '\"' + "[out]" + '\"' + " -map " + '\"' + "[a]" + '\"' : (FFPROBE.stereo && lblAudioMapping.getText().equals("Multi") && (!debitAudio.getSelectedItem().toString().equals("0") || comboAudioCodec.getSelectedItem().equals("FLAC")) ? String.valueOf(filterComplex) + audio + " -map " + '\"' + "[out]" + '\"' + " -map " + '\"' + "[a1]" + '\"' + " -map " + '\"' + "[a2]" + '\"' : String.valueOf(filterComplex) + "\" -map \"[out]\"" + audio))));
                    } else {
                        newFPS = Float.parseFloat(comboFPS.getSelectedItem().toString().replace(",", "."));
                        float value = newFPS / FFPROBE.currentFPS;
                        filterComplex = caseConform.isSelected() && (comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySpeed")) || comboConform.getSelectedItem().toString().equals(language.getProperty("conformByReverse"))) && (value < 0.5f || value > 2.0f) ? " -map v:0" + audio : (caseConform.isSelected() && comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySlowMotion")) ? " -map v:0" + audio : (!(FFPROBE.channels <= 1 || !lblAudioMapping.getText().equals(language.getProperty("stereo")) && !lblAudioMapping.getText().equals(language.getProperty("mono")) || debitAudio.getSelectedItem().toString().equals("0") && !comboAudioCodec.getSelectedItem().equals("FLAC") || FFPROBE.stereo) ? String.valueOf(audio) + " -map v:0 -map " + '\"' + "[a]" + '\"' : (FFPROBE.stereo && lblAudioMapping.getText().equals(language.getProperty("mono")) && (!debitAudio.getSelectedItem().toString().equals("0") || comboAudioCodec.getSelectedItem().equals("FLAC")) && !FFPROBE.surround ? String.valueOf(audio) + " -map v:0 -map " + '\"' + "[a]" + '\"' : (FFPROBE.stereo && lblAudioMapping.getText().equals("Multi") && (!debitAudio.getSelectedItem().toString().equals("0") || comboAudioCodec.getSelectedItem().equals("FLAC")) ? String.valueOf(audio) + " -map v:0 -map " + '\"' + "[a1]" + '\"' + " -map " + '\"' + "[a2]" + '\"' : " -map v:0" + audio))));
                    }
                    if (!VideoPlayer.caseAddSubtitles.isSelected() || subtitlesBurn) break block28;
                    filterComplex = comboFilter.getSelectedItem().toString().equals(".mkv") ? String.valueOf(filterComplex) + " -c:s srt" + FunctionUtils.setMapSubtitles() : String.valueOf(filterComplex) + " -c:s mov_text" + FunctionUtils.setMapSubtitles();
                    break block29;
                }
                if (!casePreserveSubs.isSelected()) break block29;
                if (FFPROBE.subtitlesCodec == "" || !FFPROBE.subtitlesCodec.equals("dvb_subtitle")) break block30;
                switch (comboFilter.getSelectedItem().toString()) {
                    case ".ts": 
                    case ".mkv": 
                    case ".mp4": {
                        filterComplex = String.valueOf(filterComplex) + " -c:s dvbsub -map s?";
                        break;
                    }
                    default: {
                        filterComplex = String.valueOf(filterComplex) + " -c:s copy -map s?";
                        break;
                    }
                }
                break block29;
            }
            filterComplex = comboFilter.getSelectedItem().toString().equals(".mkv") ? (FFPROBE.subtitlesCodec != "" && (FFPROBE.subtitlesCodec.equals("hdmv_pgs_subtitle") || FFPROBE.subtitlesCodec.equals("ass")) ? String.valueOf(filterComplex) + " -c:s copy -map s?" : String.valueOf(filterComplex) + " -c:s srt -map s?") : String.valueOf(filterComplex) + " -c:s mov_text -map s?";
        }
        return filterComplex;
    }

    public static String setFilterComplexBroadcastCodecs(String filterComplex, String audio) {
        String mapping = "";
        String transitions = "";
        if (Transitions.setAudioFadeIn(false) != "") {
            transitions = String.valueOf(transitions) + Transitions.setAudioFadeIn(false);
        }
        if (Transitions.setAudioFadeOut(false) != "") {
            if (transitions != "") {
                transitions = String.valueOf(transitions) + ",";
            }
            transitions = String.valueOf(transitions) + Transitions.setAudioFadeOut(false);
        }
        if (Transitions.setAudioSpeed() != "") {
            if (transitions != "") {
                transitions = String.valueOf(transitions) + ",";
            }
            transitions = String.valueOf(transitions) + Transitions.setAudioSpeed();
        }
        if (comboAudioCodec.getSelectedItem().equals(language.getProperty("noAudio"))) {
            mapping = VideoPlayer.caseAddWatermark.isSelected() || VideoPlayer.caseAddSubtitles.isSelected() && subtitlesBurn ? String.valueOf(mapping) + " -filter_complex \"" + filterComplex + "[out]" + '\"' + " -map " + '\"' + "[out]" + '\"' + audio : (filterComplex != "" ? String.valueOf(mapping) + " -filter_complex \"[0:v]" + filterComplex + "[out]" + '\"' + " -map " + '\"' + "[out]" + '\"' + audio : String.valueOf(mapping) + " -map v:0" + audio);
            if (VideoPlayer.caseAddSubtitles.isSelected() && !subtitlesBurn) {
                mapping = String.valueOf(mapping) + " -c:s mov_text" + FunctionUtils.setMapSubtitles();
            }
            return mapping;
        }
        if (!comboAudioCodec.getSelectedItem().equals(language.getProperty("codecCopy"))) {
            int channels = 0;
            Component[] componentArray = grpSetAudio.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (c instanceof JComboBox && !c.getName().equals("comboAudioCodec") && ((JComboBox)c).getSelectedIndex() != 16) {
                    ++channels;
                }
                ++n2;
            }
            int m = 1;
            while (m < channels + 1) {
                if (m <= FFPROBE.channels) {
                    if (inputDeviceIsRunning) {
                        mapping = ((String)liste.getElementAt(0)).equals("Capture.current.screen") && RecordInputDevice.audioDeviceIndex > 0 && RecordInputDevice.overlayAudioDeviceIndex > 0 ? " -map a? -map 2?" : " -map a?";
                    } else if (FFPROBE.channels == 1) {
                        if (transitions != "") {
                            transitions = String.valueOf(transitions) + ",";
                        }
                        mapping = VideoPlayer.caseAddWatermark.isSelected() || VideoPlayer.caseAddSubtitles.isSelected() && subtitlesBurn ? String.valueOf(mapping) + " -filter_complex \"" + filterComplex + "[out];[0:a]" + transitions + "channelsplit[a1][a2]" + '\"' + " -map " + '\"' + "[out]" + '\"' + " -map [a1] -map [a2]" + audio : (filterComplex != "" ? String.valueOf(mapping) + " -filter_complex \"[0:v]" + filterComplex + "[out];[0:a]" + transitions + "channelsplit[a1][a2]" + '\"' + " -map " + '\"' + "[out]" + '\"' + " -map [a1] -map [a2]" + audio : String.valueOf(mapping) + " -map v:0 -filter_complex [0:a]" + transitions + "channelsplit[a1][a2] -map [a1] -map [a2]" + audio);
                        ++m;
                    } else {
                        int i = 1;
                        int map = m;
                        Component[] componentArray2 = grpSetAudio.getComponents();
                        int n3 = componentArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Component c = componentArray2[n4];
                            if (c instanceof JComboBox && !c.getName().equals("comboAudioCodec")) {
                                if (i == m) {
                                    map = ((JComboBox)c).getSelectedIndex() + 1;
                                    break;
                                }
                                ++i;
                            }
                            ++n4;
                        }
                        mapping = String.valueOf(mapping) + " -map 0:" + map;
                    }
                } else {
                    silentTrack = " -f lavfi -i anullsrc=r=" + lbl48k.getText() + ":cl=mono";
                    if (comboFonctions.getSelectedItem().toString().equals("XDCAM HD422")) {
                        silentTrack = String.valueOf(silentTrack) + " -shortest -map_metadata -1";
                    }
                    mapping = VideoPlayer.caseAddWatermark.isSelected() && VideoPlayer.caseAddSubtitles.isSelected() && subtitlesBurn ? String.valueOf(mapping) + " -map 3" : (VideoPlayer.caseAddWatermark.isSelected() || VideoPlayer.caseAddSubtitles.isSelected() && subtitlesBurn ? String.valueOf(mapping) + " -map 2" : String.valueOf(mapping) + " -map 1");
                }
                ++m;
            }
        }
        if (FFPROBE.channels != 1) {
            if (transitions != "") {
                transitions = " -filter:a \"" + transitions + '\"';
            }
            mapping = VideoPlayer.caseAddWatermark.isSelected() || VideoPlayer.caseAddSubtitles.isSelected() && subtitlesBurn ? " -filter_complex \"" + filterComplex + "[out]" + '\"' + " -map " + '\"' + "[out]" + '\"' + transitions + mapping + audio : (filterComplex != "" ? " -filter_complex \"[0:v]" + filterComplex + "[out]" + '\"' + " -map " + '\"' + "[out]" + '\"' + transitions + mapping + audio : " -map v:0" + transitions + mapping + audio);
        }
        if (VideoPlayer.caseAddSubtitles.isSelected() && !subtitlesBurn) {
            mapping = String.valueOf(mapping) + " -c:s mov_text" + FunctionUtils.setMapSubtitles();
        }
        return mapping;
    }

    public static File fileReplacement(String path, String file, String oldExt, String surname, String newExt) {
        int n = 1;
        File fileOut = new File(String.valueOf(path) + "/" + file.replace(oldExt, String.valueOf(surname.substring(0, surname.length() - 1)) + newExt));
        if (file.equals(file.replace(oldExt, String.valueOf(surname.substring(0, surname.length() - 1)) + newExt)) && !caseChangeFolder1.isSelected()) {
            do {
                fileOut = new File(String.valueOf(path) + "/" + file.replace(oldExt, String.valueOf(surname) + n + newExt));
                ++n;
            } while (fileOut.exists());
        } else {
            int q = 0;
            if (!yesToAll && !noToAll) {
                Object[] options = new Object[]{language.getProperty("yes"), language.getProperty("yesToAll"), language.getProperty("no"), language.getProperty("noToAll"), language.getProperty("btnCancel")};
                q = JOptionPane.showOptionDialog(frame, language.getProperty("eraseFile"), String.valueOf(Shutter.language.getProperty("File")) + " " + fileOut.getName() + " " + Shutter.language.getProperty("alreadyExist"), 1, -1, null, options, options[2]);
            }
            if (q == 3) {
                noToAll = true;
            }
            if (q == 1) {
                yesToAll = true;
            }
            if (q == 2 || noToAll) {
                do {
                    fileOut = new File(String.valueOf(path) + "/" + file.replace(oldExt, String.valueOf(surname) + n + newExt));
                    ++n;
                } while (fileOut.exists());
            } else if (q == 4) {
                if (!caseChangeFolder1.isSelected()) {
                    lblDestination1.setText(language.getProperty("sameAsSource"));
                }
                return null;
            }
        }
        return fileOut;
    }

    public static void addFileForMail(String file) {
        String text = Shutter.language.getProperty("isEncoded");
        if (FFMPEG.error) {
            text = Shutter.language.getProperty("notEncoded");
        }
        if (caseChangeFolder3.isSelected()) {
            mailFileList.append(String.valueOf(file) + " " + text + " " + lblDestination1.getText() + " | " + lblDestination2.getText() + " | " + lblDestination3.getText() + System.lineSeparator());
        } else if (caseChangeFolder2.isSelected()) {
            mailFileList.append(String.valueOf(file) + " " + text + " " + lblDestination1.getText() + " | " + lblDestination2.getText() + System.lineSeparator());
        } else {
            mailFileList.append(String.valueOf(file) + " " + text + " " + lblDestination1.getText() + System.lineSeparator());
        }
    }

    public static void sendMail() {
        if (caseSendMail.isSelected() && mailFileList.length() != 0) {
            sendMailIsRunning = true;
            Properties props = new Properties();
            props.put("mail.smtp.auth", "true");
            props.put("mail.smtp.starttls.enable", "true");
            props.put("mail.smtp.host", "auth.smtp.1and1.fr");
            props.put("mail.smtp.port", "587");
            Session session = Session.getInstance(props, new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication("info@shutterencoder.com", "shutterencodermail");
                }
            });
            try {
                try {
                    MimeMessage message = new MimeMessage(session);
                    ((Message)message).setFrom(new InternetAddress("info@shutterencoder.com"));
                    ((Message)message).setRecipients(Message.RecipientType.TO, InternetAddress.parse(textMail.getText()));
                    if (FFMPEG.error) {
                        ((Message)message).setSubject(Shutter.language.getProperty("shutterEncodingError"));
                    } else {
                        ((Message)message).setSubject(Shutter.language.getProperty("shutterEncodingCompleted"));
                    }
                    message.setText(mailFileList.toString());
                    Transport.send(message);
                    Shutter.lblCurrentEncoding.setForeground(Color.LIGHT_GRAY);
                    Shutter.lblCurrentEncoding.setText(Shutter.language.getProperty("mailSuccessful"));
                }
                catch (MessagingException e) {
                    Console.consoleFFMPEG.append(String.valueOf(System.lineSeparator()) + e + System.lineSeparator());
                    Shutter.lblCurrentEncoding.setForeground(Color.RED);
                    Shutter.lblCurrentEncoding.setText(Shutter.language.getProperty("mailFailed"));
                    Shutter.progressBar1.setValue(0);
                    sendMailIsRunning = false;
                    mailFileList.setLength(0);
                }
            }
            finally {
                sendMailIsRunning = false;
                mailFileList.setLength(0);
            }
        } else {
            mailFileList.setLength(0);
        }
    }

    public static void copyFile(File file) {
        FileOutputStream fout;
        FileInputStream fin;
        byte[] b;
        int r;
        long counter;
        long length;
        File fileout;
        File filein;
        if (caseChangeFolder2.isSelected()) {
            btnStart.setEnabled(false);
            grpDestination.setSelectedIndex(1);
            filein = file;
            fileout = new File(String.valueOf(lblDestination2.getText()) + "/" + file.getName());
            try {
                length = filein.length();
                progressBar1.setMaximum((int)length);
                counter = 0L;
                r = 0;
                b = new byte[1024];
                fin = new FileInputStream(filein);
                fout = new FileOutputStream(fileout);
                copyFileIsRunning = true;
                while ((r = fin.read(b)) != -1) {
                    progressBar1.setValue((int)(counter += (long)r));
                    fout.write(b, 0, r);
                    if (cancelled) break;
                }
                fin.close();
                fout.close();
                if (cancelled) {
                    fileout.delete();
                }
            }
            catch (Exception e) {
                copyFileIsRunning = false;
                fileout.delete();
            }
            copyFileIsRunning = false;
            btnStart.setEnabled(true);
        }
        if (caseChangeFolder3.isSelected()) {
            btnStart.setEnabled(false);
            grpDestination.setSelectedIndex(2);
            filein = file;
            fileout = new File(String.valueOf(lblDestination3.getText()) + "/" + file.getName());
            try {
                length = filein.length();
                progressBar1.setMaximum((int)length);
                counter = 0L;
                r = 0;
                b = new byte[1024];
                fin = new FileInputStream(filein);
                fout = new FileOutputStream(fileout);
                copyFileIsRunning = true;
                while ((r = fin.read(b)) != -1) {
                    progressBar1.setValue((int)(counter += (long)r));
                    fout.write(b, 0, r);
                    if (cancelled) break;
                }
                fin.close();
                fout.close();
                if (cancelled) {
                    fileout.delete();
                }
            }
            catch (Exception e) {
                copyFileIsRunning = false;
                fileout.delete();
            }
            copyFileIsRunning = false;
            btnStart.setEnabled(true);
        }
    }

    public static boolean cleanFunction(String fileName, File fileOut, String output) {
        String extension = "";
        if (fileName != null && fileName != "" && fileName.contains(".")) {
            extension = fileName.substring(fileName.lastIndexOf("."));
        }
        if (FFMPEG.error || fileOut.exists() && fileOut.length() == 0L && !caseCreateSequence.isSelected() && !extension.equals(".pdf")) {
            errorList.append(String.valueOf(fileName) + System.lineSeparator() + FFMPEG.errorLog + System.lineSeparator());
            FFMPEG.errorLog.setLength(0);
            try {
                fileOut.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Corrections.vidstab != null) {
            if (Corrections.vidstab.exists()) {
                Corrections.vidstab.delete();
            }
            Corrections.vidstab = null;
        }
        if (Settings.btnSetBab.isSelected() || grpImageSequence.isVisible() && caseEnableSequence.isSelected() || VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("removeMode")) && caseInAndOut.isSelected()) {
            File concatList = new File(String.valueOf(output.replace("\\", "/")) + "/" + fileName.replace(extension, ".txt"));
            if (RenderQueue.frame == null || !RenderQueue.frame.isVisible()) {
                concatList.delete();
            }
        }
        if (cancelled && !caseCreateSequence.isSelected() && !extension.equals(".pdf")) {
            try {
                fileOut.delete();
            }
            catch (Exception concatList) {
                // empty catch block
            }
            return true;
        }
        if (!cancelled && !FFMPEG.error) {
            lblFilesEnded.setText(FunctionUtils.completedFiles(++completed));
        }
        if (caseIncrementTimecode.isSelected()) {
            DecimalFormat formatter = new DecimalFormat("00");
            int timecodeToMs = Integer.parseInt(TCset1.getText()) * 3600000 + Integer.parseInt(TCset2.getText()) * 60000 + Integer.parseInt(TCset3.getText()) * 1000 + Integer.parseInt(TCset4.getText()) * (int)(1000.0f / FFPROBE.currentFPS);
            int millisecondsToTc = timecodeToMs + FFPROBE.totalLength;
            if (caseInAndOut.isSelected()) {
                millisecondsToTc = timecodeToMs + VideoPlayer.durationH * 3600000 + VideoPlayer.durationM * 60000 + VideoPlayer.durationS * 1000 + VideoPlayer.durationF * (int)(1000.0f / FFPROBE.currentFPS);
            }
            if (caseEnableSequence.isSelected()) {
                millisecondsToTc = Shutter.liste.getSize() * (int)(1000.0f / Float.parseFloat(caseSequenceFPS.getSelectedItem().toString()));
            }
            TCset1.setText(formatter.format(millisecondsToTc / 3600000));
            TCset2.setText(formatter.format(millisecondsToTc / 60000 % 60));
            TCset3.setText(formatter.format(millisecondsToTc / 1000 % 60));
            TCset4.setText(formatter.format((int)((float)millisecondsToTc / (1000.0f / FFPROBE.currentFPS) % FFPROBE.currentFPS)));
        }
        if (caseOpenFolderAtEnd1.isSelected() && !cancelled && !FFMPEG.error) {
            try {
                Desktop.getDesktop().open(new File(output));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

