/*
 * Decompiled with CFR 0.152.
 */
package settings;

import application.Shutter;
import application.VideoPlayer;
import java.io.File;
import library.FFMPEG;
import library.FFPROBE;
import library.MKVMERGE;

public class Colorimetry
extends Shutter {
    public static int allR = 0;
    public static int allG = 0;
    public static int allB = 0;
    public static int highR = 0;
    public static int highG = 0;
    public static int highB = 0;
    public static int mediumR = 0;
    public static int mediumG = 0;
    public static int mediumB = 0;
    public static int lowR = 0;
    public static int lowG = 0;
    public static int lowB = 0;
    public static String balanceAll = "";
    public static String balanceHigh = "";
    public static String balanceMedium = "";
    public static String balanceLow = "";
    public static int vibranceValue = 0;
    public static int vibranceR = 0;
    public static int vibranceG = 0;
    public static int vibranceB = 0;

    public static String setColor(String filterComplex) {
        if (grpColorimetry.isVisible() && caseInAndOut.isSelected() && VideoPlayer.caseEnableColorimetry.isSelected() && !Colorimetry.setEQ(true).equals("")) {
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            Colorimetry.setEQ(true);
            filterComplex = String.valueOf(filterComplex) + colorimetryValues;
        }
        return filterComplex;
    }

    public static String setLevels(String filterComplex) {
        if (grpColorimetry.isVisible() && caseLevels.isSelected()) {
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            filterComplex = String.valueOf(filterComplex) + "scale=in_range=" + comboInLevels.getSelectedItem().toString().replace("16-235", "limited").replace("0-255", "full") + ":out_range=" + comboOutLevels.getSelectedItem().toString().replace("16-235", "limited").replace("0-255", "full");
        }
        return filterComplex;
    }

    public static String setColormatrix(String filterComplex) {
        if (grpColorimetry.isVisible() && caseColormatrix.isSelected()) {
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            if (comboInColormatrix.getSelectedItem().equals("HDR")) {
                String pathToLuts;
                if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                    pathToLuts = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                    pathToLuts = pathToLuts.substring(0, pathToLuts.length() - 1);
                    pathToLuts = String.valueOf(pathToLuts.substring(0, pathToLuts.lastIndexOf("/")).replace("%20", "\\ ")) + "/LUTs/HDR-to-SDR.cube";
                } else {
                    pathToLuts = "LUTs/HDR-to-SDR.cube";
                }
                filterComplex = String.valueOf(filterComplex) + "lut3d=file=" + pathToLuts;
            } else {
                filterComplex = String.valueOf(filterComplex) + "colorspace=iall=" + Shutter.comboInColormatrix.getSelectedItem().toString().replace("Rec. ", "bt").replace("601", "601-6-625") + ":all=" + Shutter.comboOutColormatrix.getSelectedItem().toString().replace("Rec. ", "bt").replace("601", "601-6-625");
            }
        }
        return filterComplex;
    }

    public static String setColorspace() {
        if (grpColorimetry.isVisible() && caseColorspace.isSelected()) {
            if (comboColorspace.getSelectedItem().toString().contains("Rec. 709")) {
                return " -color_primaries bt709 -color_trc bt709 -colorspace bt709";
            }
            if (comboColorspace.getSelectedItem().toString().contains("Rec. 2020 PQ")) {
                return " -color_primaries bt2020 -color_trc smpte2084 -colorspace bt2020nc";
            }
            if (comboColorspace.getSelectedItem().toString().contains("Rec. 2020 HLG")) {
                return " -color_primaries bt2020 -color_trc arib-std-b67 -colorspace bt2020nc";
            }
        }
        return "";
    }

    public static String setInputCodec(String extension) {
        if (extension.toLowerCase().equals(".exr")) {
            return " -apply_trc iec61966_2_1";
        }
        if (FFPROBE.videoCodec != null) {
            if (FFPROBE.videoCodec.contains("vp9")) {
                return " -c:v libvpx-vp9";
            }
            if (FFPROBE.videoCodec.contains("vp8")) {
                return " -c:v libvpx";
            }
        }
        return "";
    }

    public static String setLUT(String filterComplex) {
        if (grpColorimetry.isVisible() && caseLUTs.isSelected()) {
            String pathToLuts;
            if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                pathToLuts = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                pathToLuts = pathToLuts.substring(0, pathToLuts.length() - 1);
                pathToLuts = String.valueOf(pathToLuts.substring(0, pathToLuts.lastIndexOf("/")).replace("%20", "\\ ")) + "/LUTs/";
            } else {
                pathToLuts = "LUTs/";
            }
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            filterComplex = String.valueOf(filterComplex) + "lut3d=file=" + pathToLuts + Shutter.comboLUTs.getSelectedItem().toString();
        }
        return filterComplex;
    }

    public static void setHDR(String fileName, File fileOut) throws InterruptedException {
        if (grpColorimetry.isVisible() && caseColorspace.isSelected() && comboColorspace.getSelectedItem().toString().contains("HDR") && !FFMPEG.error) {
            lblCurrentEncoding.setText(fileName);
            File HDRmkv = fileOut;
            File tempHDR = new File(fileOut.toString().replace(comboFilter.getSelectedItem().toString(), "_HDR" + comboFilter.getSelectedItem().toString()));
            fileOut.renameTo(tempHDR);
            fileOut = HDRmkv;
            String PQorHLG = "16";
            if (comboColorspace.getSelectedItem().toString().contains("HLG")) {
                PQorHLG = "18";
            }
            if (!comboHDRvalue.getSelectedItem().toString().equals("auto")) {
                FFPROBE.HDRmax = Integer.parseInt(comboHDRvalue.getSelectedItem().toString().replace(" nits", ""));
            }
            String cmd = " --colour-matrix 0:9 --colour-range 0:1 --colour-transfer-characteristics 0:" + PQorHLG + " --colour-primaries 0:9 --max-luminance 0:" + (int)FFPROBE.HDRmax + " --min-luminance 0:" + FFPROBE.HDRmin + " --chromaticity-coordinates 0:0.68,0.32,0.265,0.690,0.15,0.06 --white-colour-coordinates 0:0.3127,0.3290";
            MKVMERGE.run(String.valueOf(cmd) + " " + '\"' + tempHDR + '\"' + " -o " + '\"' + HDRmkv + '\"');
            do {
                Thread.sleep(100L);
            } while (MKVMERGE.runProcess.isAlive());
            if (!MKVMERGE.error) {
                tempHDR.delete();
            } else {
                FFMPEG.error = true;
            }
        }
    }

    public static String setGrain(String eq) {
        if (VideoPlayer.sliderGrain.getValue() != 0) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            eq = VideoPlayer.sliderGrain.getValue() > 0 ? String.valueOf(eq) + "unsharp=la=" + (float)VideoPlayer.sliderGrain.getValue() / 50.0f : String.valueOf(eq) + "bm3d=sigma=" + (float)(0 - VideoPlayer.sliderGrain.getValue());
        }
        return eq;
    }

    public static String setAngle(String eq) {
        if (VideoPlayer.sliderAngle.getValue() != 0) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            float angle = VideoPlayer.sliderAngle.getValue() > 0 ? (float)((double)((float)VideoPlayer.sliderAngle.getValue() / 10.0f) * Math.PI) / 180.0f : (float)((double)(0.0f - (float)VideoPlayer.sliderAngle.getValue() / 10.0f) * Math.PI) / 180.0f;
            float ratio = (float)FFPROBE.imageWidth / (float)FFPROBE.imageHeight;
            float h = (float)((double)FFPROBE.imageHeight / ((double)ratio * Math.sin(angle) + Math.cos(angle)));
            float w = h * ratio;
            if (ratio < 1.0f) {
                ratio = (float)FFPROBE.imageHeight / (float)FFPROBE.imageWidth;
                w = (float)((double)FFPROBE.imageWidth / ((double)ratio * Math.sin(angle) + Math.cos(angle)));
                h = w * ratio;
            }
            w = 2.0f - (float)FFPROBE.imageWidth / w;
            h = 2.0f - (float)FFPROBE.imageHeight / h;
            eq = comboResolution.getSelectedItem().toString().equals(language.getProperty("source")) ? String.valueOf(eq) + "rotate=" + (float)VideoPlayer.sliderAngle.getValue() / 10.0f + "*PI/180:ow=iw*" + w + ":oh=ih*" + h + ",scale=" + FFPROBE.imageWidth + ":" + FFPROBE.imageHeight : String.valueOf(eq) + "rotate=" + (float)VideoPlayer.sliderAngle.getValue() / 10.0f + "*PI/180:ow=iw*" + w + ":oh=ih*" + h;
        }
        return eq;
    }

    public static String setVignette(String eq) {
        if (VideoPlayer.sliderVignette.getValue() != 0) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            eq = VideoPlayer.sliderVignette.getValue() > 0 ? String.valueOf(eq) + "vignette=PI/" + (float)(100 - VideoPlayer.sliderVignette.getValue()) / 5.0f + ":mode=backward" : String.valueOf(eq) + "vignette=PI/" + (float)(100 + VideoPlayer.sliderVignette.getValue()) / 5.0f;
        }
        return eq;
    }

    public static String setVibrance(String eq) {
        if (vibranceValue != 0) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            eq = String.valueOf(eq) + "vibrance=" + (float)vibranceValue / 50.0f + ":rbal=" + (float)(100 + vibranceR) / 100.0f + ":gbal=" + (float)(100 + vibranceG) / 100.0f + ":bbal=" + (float)(100 + vibranceB) / 100.0f;
        }
        return eq;
    }

    public static String setSaturation(String eq) {
        if (VideoPlayer.sliderSaturation.getValue() != 0) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            eq = String.valueOf(eq) + "eq=saturation=" + (float)(VideoPlayer.sliderSaturation.getValue() + 100) / 100.0f;
        }
        return eq;
    }

    public static String setBalance(String eq) {
        float r = (float)VideoPlayer.sliderRED.getValue() / 400.0f;
        float g = (float)VideoPlayer.sliderGREEN.getValue() / 400.0f;
        float b = (float)VideoPlayer.sliderBLUE.getValue() / 400.0f;
        if (VideoPlayer.comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setAll"))) {
            balanceAll = "rs=" + r + ":gs=" + g + ":bs=" + b + ":rm=" + r + ":gm=" + g + ":bm=" + b + ":rh=" + r + ":gh=" + g + ":bh=" + b;
        }
        if (VideoPlayer.comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setLow"))) {
            balanceLow = "rs=" + r + ":gs=" + g + ":bs=" + b;
        } else if (VideoPlayer.comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setMedium"))) {
            balanceMedium = "rm=" + r + ":gm=" + g + ":bm=" + b;
        } else if (VideoPlayer.comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setHigh"))) {
            balanceHigh = "rh=" + r + ":gh=" + g + ":bh=" + b;
        }
        if (balanceAll != "" && !balanceAll.equals("rs=0.0:gs=0.0:bs=0.0:rm=0.0:gm=0.0:bm=0.0:rh=0.0:gh=0.0:bh=0.0")) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            eq = String.valueOf(eq) + "colorbalance=" + balanceAll;
        }
        if (balanceLow != "" || balanceMedium != "" || balanceHigh != "") {
            eq = balanceAll != "" && !balanceAll.equals("rs=0.0:gs=0.0:bs=0.0:rm=0.0:gm=0.0:bm=0.0:rh=0.0:gh=0.0:bh=0.0") ? String.valueOf(eq) + ",colorbalance=" : (eq != "" ? String.valueOf(eq) + ",colorbalance=" : "colorbalance=");
            if (balanceLow == "") {
                balanceLow = "rs=0:gs=0:bs=0";
            }
            if (balanceMedium == "") {
                balanceMedium = "rm=0:gm=0:bm=0";
            }
            if (balanceHigh == "") {
                balanceHigh = "rh=0:gh=0:bh=0";
            }
            eq = String.valueOf(eq) + balanceLow + ":" + balanceMedium + ":" + balanceHigh;
        }
        return eq;
    }

    public static String setContrast(String eq) {
        if (VideoPlayer.sliderContrast.getValue() != 0) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            eq = String.valueOf(eq) + "eq=contrast=" + (1.0f + (float)VideoPlayer.sliderContrast.getValue() / 100.0f);
        }
        return eq;
    }

    public static String setWB(String eq) {
        if (VideoPlayer.sliderBalance.getValue() != 6500) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            eq = String.valueOf(eq) + "colortemperature=" + (13000 - VideoPlayer.sliderBalance.getValue());
        }
        return eq;
    }

    public static String setHUE(String eq) {
        if (VideoPlayer.sliderHUE.getValue() != 0) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            eq = String.valueOf(eq) + "hue=h=" + (0 - VideoPlayer.sliderHUE.getValue());
        }
        return eq;
    }

    public static String setWhite(String eq) {
        if (VideoPlayer.sliderWhite.getValue() != 0) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            if (VideoPlayer.sliderWhite.getValue() > 0) {
                float value = 1.0f - (float)VideoPlayer.sliderWhite.getValue() / 200.0f;
                eq = String.valueOf(eq) + "colorlevels=rimax=" + value + ":gimax=" + value + ":bimax=" + value;
            } else {
                float value = 1.0f + (float)VideoPlayer.sliderWhite.getValue() / 200.0f;
                eq = String.valueOf(eq) + "colorlevels=romax=" + value + ":gomax=" + value + ":bomax=" + value;
            }
        }
        return eq;
    }

    public static String setBlack(String eq) {
        if (VideoPlayer.sliderBlack.getValue() != 0) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            if (VideoPlayer.sliderBlack.getValue() > 0) {
                float value = (float)VideoPlayer.sliderBlack.getValue() / 200.0f;
                eq = String.valueOf(eq) + "colorlevels=romin=" + value + ":gomin=" + value + ":bomin=" + value;
            } else {
                float value = 0.0f - (float)VideoPlayer.sliderBlack.getValue() / 200.0f;
                eq = String.valueOf(eq) + "colorlevels=rimin=" + value + ":gimin=" + value + ":bimin=" + value;
            }
        }
        return eq;
    }

    public static String setShadows(String eq) {
        if (VideoPlayer.sliderShadows.getValue() != 0) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            eq = VideoPlayer.sliderShadows.getValue() > 0 ? String.valueOf(eq) + "curves=master='0/0 0.25/" + (0.25f - (0.0f - (float)VideoPlayer.sliderShadows.getValue() / 500.0f)) + " 0.5/0.5 0.75/0.75 0.875/0.875 1/1'" : String.valueOf(eq) + "curves=master='0/0 " + (0.25f - (float)VideoPlayer.sliderShadows.getValue() / 500.0f) + "/0.25 0.5/0.5 0.625/0.625 0.75/0.75 0.875/0.875 1/1" + "'";
        }
        return eq;
    }

    public static String setMediums(String eq) {
        if (VideoPlayer.sliderMediums.getValue() != 0) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            eq = VideoPlayer.sliderMediums.getValue() > 0 ? String.valueOf(eq) + "curves=master='0/0 " + (0.5 - (double)((float)VideoPlayer.sliderMediums.getValue() / 400.0f)) + "/" + (0.5 + (double)((float)VideoPlayer.sliderMediums.getValue() / 400.0f)) + " 1/1" + "'" : String.valueOf(eq) + "curves=master='0/0 " + (0.5 + (double)(0.0f - (float)VideoPlayer.sliderMediums.getValue() / 400.0f)) + "/" + (0.5 - (double)(0.0f - (float)VideoPlayer.sliderMediums.getValue() / 400.0f)) + " 1/1" + "'";
        }
        return eq;
    }

    public static String setHighlights(String eq) {
        if (VideoPlayer.sliderHighlights.getValue() != 0) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            eq = VideoPlayer.sliderHighlights.getValue() > 0 ? String.valueOf(eq) + "curves=master='0/0 0.125/0.125 0.25/0.25 0.375/0.375 0.5/0.5 " + (0.75f - (float)VideoPlayer.sliderHighlights.getValue() / 500.0f) + "/0.75 1/1" + "'" : String.valueOf(eq) + "curves=master='0/0 0.125/0.125 0.25/0.25 0.375/0.375 0.5/0.5 0.75/" + (0.75f - (0.0f - (float)VideoPlayer.sliderHighlights.getValue() / 500.0f)) + " 1/1'";
        }
        return eq;
    }

    public static String setExposure(String eq) {
        if (VideoPlayer.sliderExposure.getValue() != 0) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            eq = String.valueOf(eq) + "exposure=" + (float)VideoPlayer.sliderExposure.getValue() / 100.0f * 3.0f;
        }
        return eq;
    }

    public static String setGamma(String eq) {
        if (VideoPlayer.sliderGamma.getValue() != 0) {
            if (eq != "") {
                eq = String.valueOf(eq) + ",";
            }
            eq = String.valueOf(eq) + "eq=gamma=" + (1.0f + (float)VideoPlayer.sliderGamma.getValue() / 100.0f);
        }
        return eq;
    }

    public static String setEQ(boolean finalEQ) {
        String eq = "";
        eq = Colorimetry.setHighlights(eq);
        eq = Colorimetry.setMediums(eq);
        eq = Colorimetry.setShadows(eq);
        eq = Colorimetry.setExposure(eq);
        eq = Colorimetry.setGamma(eq);
        eq = Colorimetry.setContrast(eq);
        eq = Colorimetry.setWhite(eq);
        eq = Colorimetry.setBlack(eq);
        eq = Colorimetry.setWB(eq);
        eq = Colorimetry.setHUE(eq);
        eq = Colorimetry.setBalance(eq);
        eq = Colorimetry.setSaturation(eq);
        eq = Colorimetry.setVibrance(eq);
        eq = Colorimetry.setGrain(eq);
        eq = Colorimetry.setAngle(eq);
        eq = Colorimetry.setVignette(eq);
        Shutter.colorimetryValues = eq.replace("\"", "'");
        return eq;
    }
}

