/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Shutter;
import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.RoundRectangle2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class Update {
    public static JDialog frame;
    private static final JProgressBar progressBar;
    private final JLabel lblNewVersion = new JLabel(Shutter.language.getProperty("lblNewVersion"));
    private static JPanel topPanel;
    private static JLabel quit;
    private static boolean cancelled;
    private static int MousePositionY;

    static {
        progressBar = new JProgressBar();
        cancelled = false;
    }

    private Update() {
        frame = new JDialog();
        frame.setFont(new Font(Shutter.montserratFont, 0, 12));
        frame.setResizable(false);
        frame.setModal(false);
        frame.setAlwaysOnTop(true);
        frame.setDefaultCloseOperation(2);
        frame.setSize(346, 59);
        frame.getContentPane().setBackground(new Color(45, 45, 45));
        frame.setTitle(Shutter.language.getProperty("frameUpdate"));
        frame.setForeground(Color.WHITE);
        frame.getContentPane().setLayout(null);
        if (!frame.isUndecorated()) {
            frame.setUndecorated(true);
            frame.setShape(new RoundRectangle2D.Double(0.0, 0.0, frame.getWidth() + 15, frame.getHeight(), 15.0, 15.0));
            frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
        }
        this.content();
        GraphicsConfiguration config = Shutter.frame.getGraphicsConfiguration();
        GraphicsDevice myScreen = config.getDevice();
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] allScreens = env.getScreenDevices();
        int screenIndex = -1;
        int i = 0;
        while (i < allScreens.length) {
            if (allScreens[i].equals(myScreen)) {
                screenIndex = i;
                break;
            }
            ++i;
        }
        if (System.getProperty("os.name").contains("Windows")) {
            frame.setLocation(allScreens[screenIndex].getDefaultConfiguration().getBounds().x + allScreens[screenIndex].getDefaultConfiguration().getBounds().width - Update.frame.getSize().width, allScreens[screenIndex].getDefaultConfiguration().getBounds().height - 99);
        } else {
            frame.setLocation(allScreens[screenIndex].getDefaultConfiguration().getBounds().x + allScreens[screenIndex].getDisplayMode().getWidth() - Update.frame.getSize().width, allScreens[screenIndex].getDisplayMode().getHeight() - 99);
        }
        frame.setVisible(true);
    }

    private void content() {
        topPanel = new JPanel();
        topPanel.setLayout(null);
        topPanel.setBackground(new Color(45, 45, 45));
        quit = new JLabel(new FlatSVGIcon("contents/quit.svg", 15, 15));
        quit.setHorizontalAlignment(0);
        quit.setBounds(Update.frame.getSize().width - 20, 3, 15, 15);
        topPanel.add(quit);
        topPanel.setBounds(0, 0, 346, 59);
        quit.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                quit.setIcon(new FlatSVGIcon("contents/quit_pressed.svg", 15, 15));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    cancelled = true;
                    frame.dispose();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                quit.setIcon(new FlatSVGIcon("contents/quit_hover.svg", 15, 15));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                quit.setIcon(new FlatSVGIcon("contents/quit.svg", 15, 15));
                this.accept = false;
            }
        });
        progressBar.setBounds(6, 29, 334, 23);
        topPanel.add(progressBar);
        this.lblNewVersion.setFont(new Font(Shutter.montserratFont, 0, 12));
        this.lblNewVersion.setBounds(6, 11, 295, 16);
        topPanel.add(this.lblNewVersion);
        topPanel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent down) {
            }

            @Override
            public void mousePressed(MouseEvent down) {
                MousePositionY = down.getPoint().y;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        topPanel.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                frame.setLocation(Update.frame.getLocation().x, MouseInfo.getPointerInfo().getLocation().y - MousePositionY);
            }

            @Override
            public void mouseMoved(MouseEvent arg0) {
            }
        });
        frame.getContentPane().add(topPanel);
    }

    public static void newVersion() {
        cancelled = false;
        try {
            JLabel news = new JLabel(Shutter.language.getProperty("wantToDownload"));
            try {
                Document changelog = Jsoup.connect("https://www.shutterencoder.com/changelog.txt").get();
                changelog.outputSettings().prettyPrint(false);
                String[] versions = changelog.select("body").toString().split("Version");
                news = new JLabel("<html>Version" + versions[1].replace(System.lineSeparator(), "<br>") + Shutter.language.getProperty("wantToDownload") + "</html>");
            }
            catch (Exception changelog) {
                // empty catch block
            }
            Document doc = Jsoup.connect("https://www.shutterencoder.com").get();
            for (Element file : doc.select("a")) {
                int newVersion;
                String[] s2;
                if (System.getProperty("os.name").contains("Windows")) {
                    try {
                        if (file.attr("href").contains("Shutter Encoder (PC Version")) {
                            s2 = file.attr("href").substring(file.attr("href").lastIndexOf(" ") + 1).split("\\)");
                            newVersion = Integer.parseInt(s2[0].replace(".", ""));
                            if (newVersion <= Integer.parseInt(Shutter.actualVersion.replace(".", ""))) continue;
                            int q = JOptionPane.showConfirmDialog(Shutter.frame, news, String.valueOf(Shutter.language.getProperty("updateAvailable")) + " (v" + s2[0] + ")", 0, 3);
                            if (q == 0) {
                                Update.runProcess(file.attr("href"));
                                new Update();
                            }
                        } else {
                            if (!file.attr("href").contains("Windows 64bits.") || (newVersion = Integer.parseInt((s2 = file.attr("href").split(" "))[2].replace(".", ""))) <= Integer.parseInt(Shutter.actualVersion.replace(".", ""))) continue;
                            int q = JOptionPane.showConfirmDialog(Shutter.frame, news, String.valueOf(Shutter.language.getProperty("updateAvailable")) + " (v" + s2[2] + ")", 0, 3);
                            if (q == 0) {
                                Update.runProcess(file.attr("href"));
                                new Update();
                            }
                        }
                        break;
                    }
                    catch (Exception s2) {
                        continue;
                    }
                }
                if (System.getProperty("os.name").contains("Mac")) {
                    try {
                        if (Shutter.arch.equals("x86_64")) {
                            if (file.attr("href").contains("Shutter Encoder (MAC Version")) {
                                s2 = file.attr("href").substring(file.attr("href").lastIndexOf(" ") + 1).split("\\)");
                                newVersion = Integer.parseInt(s2[0].replace(".", ""));
                                if (newVersion <= Integer.parseInt(Shutter.actualVersion.replace(".", ""))) continue;
                                int q = JOptionPane.showConfirmDialog(Shutter.frame, news, String.valueOf(Shutter.language.getProperty("updateAvailable")) + " (v" + s2[0] + ")", 0, 3);
                                if (q == 0) {
                                    Update.runProcess(file.attr("href"));
                                    new Update();
                                }
                            } else {
                                if (!file.attr("href").contains("Mac 64bits.") || (newVersion = Integer.parseInt((s2 = file.attr("href").split(" "))[2].replace(".", ""))) <= Integer.parseInt(Shutter.actualVersion.replace(".", ""))) continue;
                                int q = JOptionPane.showConfirmDialog(Shutter.frame, news, String.valueOf(Shutter.language.getProperty("updateAvailable")) + " (v" + s2[2] + ")", 0, 3);
                                if (q == 0) {
                                    Update.runProcess(file.attr("href"));
                                    new Update();
                                }
                            }
                        } else {
                            if (!file.attr("href").contains("Apple Silicon.") || (newVersion = Integer.parseInt((s2 = file.attr("href").split(" "))[2].replace(".", ""))) <= Integer.parseInt(Shutter.actualVersion.replace(".", ""))) continue;
                            int q = JOptionPane.showConfirmDialog(Shutter.frame, news, String.valueOf(Shutter.language.getProperty("updateAvailable")) + " (v" + s2[2] + ")", 0, 3);
                            if (q == 0) {
                                Update.runProcess(file.attr("href"));
                                new Update();
                            }
                        }
                        break;
                    }
                    catch (Exception s3) {
                        continue;
                    }
                }
                try {
                    if (file.attr("href").contains("Shutter Encoder (Linux Version")) {
                        s2 = file.attr("href").substring(file.attr("href").lastIndexOf(" ") + 1).split("\\)");
                        newVersion = Integer.parseInt(s2[0].replace(".", ""));
                        if (newVersion <= Integer.parseInt(Shutter.actualVersion.replace(".", ""))) continue;
                        int q = JOptionPane.showConfirmDialog(Shutter.frame, news, String.valueOf(Shutter.language.getProperty("updateAvailable")) + " (v" + s2[0] + ")", 0, 3);
                        if (q == 0) {
                            Desktop.getDesktop().browse(new URI("https://www.shutterencoder.com/en/#downloads"));
                        }
                    } else if (file.attr("href").contains("Linux 64bits.deb") && new File("/usr/lib/Shutter Encoder").exists()) {
                        s2 = file.attr("href").split(" ");
                        newVersion = Integer.parseInt(s2[2].replace(".", ""));
                        if (newVersion <= Integer.parseInt(Shutter.actualVersion.replace(".", ""))) continue;
                        int q = JOptionPane.showConfirmDialog(Shutter.frame, news, String.valueOf(Shutter.language.getProperty("updateAvailable")) + " (v" + s2[2] + ")", 0, 3);
                        if (q == 0) {
                            Update.runProcess(file.attr("href"));
                            new Update();
                        }
                    } else {
                        if (!file.attr("href").contains("Linux 64bits.AppImage") || (newVersion = Integer.parseInt((s2 = file.attr("href").split(" "))[2].replace(".", ""))) <= Integer.parseInt(Shutter.actualVersion.replace(".", ""))) continue;
                        int q = JOptionPane.showConfirmDialog(Shutter.frame, news, String.valueOf(Shutter.language.getProperty("updateAvailable")) + " (v" + s2[2] + ")", 0, 3);
                        if (q == 0) {
                            Update.runProcess(file.attr("href"));
                            new Update();
                        }
                    }
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void runProcess(final String newVersion) {
        Thread download = new Thread(new Runnable(){

            @Override
            public void run() {
                File appPath = new File(String.valueOf(System.getProperty("user.home")) + "/Downloads/" + newVersion);
                if (!new File(String.valueOf(System.getProperty("user.home")) + "/Downloads").exists()) {
                    appPath = new File(String.valueOf(System.getProperty("user.home")) + "/Desktop/" + newVersion);
                }
                Update.HTTPDownload("https://www.shutterencoder.com/" + newVersion, appPath.toString());
                if (!cancelled) {
                    int q = JOptionPane.showConfirmDialog(Shutter.frame, Shutter.language.getProperty("installNewVersion"), Shutter.language.getProperty("downloadEnded"), 0, 3);
                    if (q == 0) {
                        try {
                            Desktop.getDesktop().open(appPath);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        System.exit(0);
                    } else {
                        JOptionPane.showMessageDialog(Shutter.frame, String.valueOf('\"') + appPath.toString() + '\"', Shutter.language.getProperty("downloadEnded"), 1);
                        frame.dispose();
                    }
                } else {
                    JOptionPane.showMessageDialog(Shutter.frame, Shutter.language.getProperty("downloadStopped"), Shutter.language.getProperty("downloadCancelled"), 0);
                    if (appPath.exists()) {
                        appPath.delete();
                    }
                    frame.dispose();
                }
            }
        });
        download.start();
    }

    private static void HTTPDownload(String adresse, String destination) {
        OutputStream out = null;
        URLConnection conn = null;
        InputStream in = null;
        try {
            try {
                int numRead;
                URL url = new URL(adresse);
                out = new BufferedOutputStream(new FileOutputStream(destination));
                conn = url.openConnection();
                in = conn.getInputStream();
                byte[] buffer = new byte[1024];
                progressBar.setMaximum(conn.getContentLength());
                long numWritten = 0L;
                while ((numRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, numRead);
                    progressBar.setValue((int)(numWritten += (long)numRead));
                    if (!cancelled) continue;
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(Shutter.frame, Shutter.language.getProperty("downloadFailed"), Shutter.language.getProperty("downloadError"), 0);
                try {
                    File toDelete = new File(destination);
                    toDelete.delete();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

