/*
 * Decompiled with CFR 0.152.
 */
package ballbreaker;

import ballbreaker.Bullet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pad {
    private int dx;
    private int x = 220;
    private int y = 435;
    private int width = 60;
    private int height = 6;
    private ArrayList bulletList = new ArrayList();
    private boolean bulletPower = false;

    public void move() {
        this.x += this.dx;
        if (this.x < 1) {
            this.x = 1;
        } else if (this.x > 500 - this.width) {
            this.x = 500 - this.width;
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setX(int newX) {
        this.x = newX;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int newWidth) {
        this.width = newWidth;
    }

    public int getHeight() {
        return this.height;
    }

    public ArrayList getBullets() {
        return this.bulletList;
    }

    public boolean getBulletPower() {
        return this.bulletPower;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public ArrayList<Bullet> getBulletList() {
        return this.bulletList;
    }

    public void changePad(String newType) {
        if (newType.equals("makeBig")) {
            this.width = 90;
            this.bulletPower = false;
        }
        if (newType.equals("makeSmall")) {
            this.width = 30;
            this.bulletPower = false;
        }
        if (newType.equals("makeGun")) {
            this.width = 60;
            this.bulletPower = true;
        }
    }

    public void draw(Graphics g) {
        if (!this.bulletPower) {
            g.setColor(Color.black);
            g.fillRect(this.x, this.y, this.width, this.height);
        } else {
            g.setColor(Color.black);
            g.fillRect(this.x + this.width / 3 - 3, this.y - this.height / 2, this.width / 2, this.height / 2);
            g.fillRect(this.x + this.width / 2, this.y - this.height / 2 - 4, 3, 4);
            g.fillRect(this.x, this.y, this.width, this.height);
        }
    }

    public void resetPad() {
        this.x = 220;
        this.y = 435;
        this.width = 60;
        this.bulletPower = false;
        this.bulletList.clear();
    }

    public void keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (key == 32 && this.bulletPower) {
            this.fire();
        }
        if (key == 37) {
            this.dx = -2;
        }
        if (key == 39) {
            this.dx = 2;
        }
    }

    public void fire() {
        if (this.bulletList.size() < 3) {
            Bullet b = new Bullet(this.x + this.width / 2, this.y - 3);
            this.bulletList.add(b);
        }
    }

    public void keyReleased(KeyEvent e) {
        int key = e.getKeyCode();
        if (key == 37) {
            this.dx = 0;
        }
        if (key == 39) {
            this.dx = 0;
        }
    }
}

