"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.processOptions = void 0;
const icon_1 = require("./icon");
const userAgent_1 = require("./userAgent");
const name_1 = require("./name");
const OPTION_POSTPROCESSORS = [
    { namespace: 'nativefier', option: 'userAgent', processor: userAgent_1.userAgent },
    { namespace: 'packager', option: 'icon', processor: icon_1.icon },
    { namespace: 'packager', option: 'name', processor: name_1.name },
];
async function processOptions(options) {
    const processedOptions = await Promise.all(OPTION_POSTPROCESSORS.map(async ({ namespace, option, processor }) => {
        const result = await processor(options);
        return {
            namespace,
            option,
            result,
        };
    }));
    for (const { namespace, option, result } of processedOptions) {
        if (result &&
            namespace in options &&
            options[namespace] &&
            option in options[namespace]) {
            // @ts-expect-error We're fiddling with objects at the string key level, which TS doesn't support well.
            options[namespace][option] = result;
        }
    }
    return options;
}
exports.processOptions = processOptions;
//# sourceMappingURL=fields.js.map