/*
 * This file is part of libbluray
 * Copyright (C) 2012  libbluray
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 */

package jail.java.awt;

import jail.java.awt.image.BufferedImage;
import java.util.Locale;

import impl.java.awt.FontMetricsProxy;
import jail.java.awt.Graphics2D;
import jail.java.awt.GraphicsDevice;
import jail.java.awt.GraphicsEnvironment;

class BDGraphicsEnvironment extends GraphicsEnvironment {
    private BDGraphicsDevice graphicsDevice;

    public BDGraphicsEnvironment() {
        graphicsDevice = new BDGraphicsDevice(this);
    }

    public GraphicsDevice[] getScreenDevices() {
        return new GraphicsDevice[] { graphicsDevice };
    }

    public GraphicsDevice getDefaultScreenDevice() {
        return graphicsDevice;
    }

    public String[] getAvailableFontFamilyNames() {
        return FontMetricsProxy.getFontList();
    }

    public String[] getAvailableFontFamilyNames(Locale l) {
        return FontMetricsProxy.getFontList();
    }

    public Graphics2D createGraphics(BufferedImage img) {
        return img.createGraphics();
    }

}
