/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2023 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package impl.org.bluray.system;

import blues.Log;

public class RegisterAccessImpl {

    private int[] gpr = new int[MAX_GPR];
    private int[] psr = new int[MAX_PSR];

    private RegisterAccessImpl() {
    }

    public static RegisterAccessImpl getInstance() {
        return instance;
    }

    public int getGPR(int num) {
        if (num < 0 || (num >= MAX_GPR))
            throw new IllegalArgumentException("Invalid GPR");

        Log.log(2, Log.LOG_GPR, "getGPR(", Integer.toString(num), ")=0x", Integer.toHexString(gpr[num]), " ",
                Integer.toString(gpr[num]));

        return gpr[num];
    }

    public int getPSR(int num) {
        if (num < 0 || (num >= MAX_PSR))
            throw new IllegalArgumentException("Invalid PSR");

        Log.log(2, Log.LOG_PSR, "getPSR(", Integer.toString(num), ")=0x", Integer.toHexString(psr[num]), " ",
                Integer.toString(psr[num]));

        return psr[num];
    }

    public void setGPR(int num, int value) {
        if (num < 0 || (num >= MAX_GPR))
            throw new IllegalArgumentException("Invalid GPR");

        Log.log(2, Log.LOG_GPR, "setGPR(", Integer.toString(num), ")=0x", Integer.toHexString(value), " ",
                Integer.toString(value));

        gpr[num] = value;
    }

    public void setPSR(int num, int value) {
        if (num < 0 || (num >= MAX_PSR))
            throw new IllegalArgumentException("Invalid PSR");

        Log.log(2, Log.LOG_PSR, "setPSR(", Integer.toString(num), ")=0x", Integer.toHexString(value), " ",
                Integer.toString(value));

        psr[num] = value;
    }

    public void setPSR(int num, int value,int psr_value_mask) {
        if (num < 0 || (num >= MAX_PSR))
            throw new IllegalArgumentException("Invalid PSR");

        Log.log(2, Log.LOG_PSR, "setPSR(", Integer.toString(num), ",",Integer.toHexString(psr_value_mask),")=0x", Integer.toHexString(value), " ",
                Integer.toString(value));

        synchronized(this) {
            int newValue = value;
            newValue &= (psr_value_mask^0xffffffff);
            newValue |= (value & psr_value_mask);
            psr[num] = newValue;
        }
    }


    public int[] rawGPR() {
        return gpr;
    }

    public int[] rawPSR() {
        return psr;
    }

    private static final int MAX_GPR = 4096;
    private static final int MAX_PSR = 128;

    private static final RegisterAccessImpl instance = new RegisterAccessImpl();
}
