/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * Copyright (c) 2019 Amlogic, Inc. All rights reserved.
 */

#ifndef __T3_CLKC_H
#define __T3_CLKC_H

/*
 * CLKID index values
 */
#define CLKID_SYS_PLL_DCO		0
#define CLKID_SYS_PLL			1
#define CLKID_SYS1_PLL_DCO		2
#define CLKID_SYS1_PLL			3
#define CLKID_FIXED_PLL_DCO		4
#define CLKID_FIXED_PLL			5
#define CLKID_FCLK_DIV2_DIV		6
#define CLKID_FCLK_DIV2			7
#define CLKID_FCLK_DIV3_DIV		8
#define CLKID_FCLK_DIV3			9
#define CLKID_FCLK_DIV4_DIV		10
#define CLKID_FCLK_DIV4			11
#define CLKID_FCLK_DIV5_DIV		12
#define CLKID_FCLK_DIV5			13
#define CLKID_FCLK_DIV7_DIV		14
#define CLKID_FCLK_DIV7			15
#define CLKID_FCLK_DIV2P5_DIV		16
#define CLKID_FCLK_DIV2P5		17
#define CLKID_GP0_PLL_DCO		18
#define CLKID_GP0_PLL			19
#define CLKID_GP1_PLL_DCO		20
#define CLKID_GP1_PLL			21
#define CLKID_CPU_DYN_CLK		22
#define CLKID_CPU_CLK			23
#define CLKID_HIFI_PLL_DCO		24
#define CLKID_HIFI_PLL			25
#define CLKID_PCIE_PLL_DCO		26
#define CLKID_PCIE_PLL_DCO_DIV2		27
#define CLKID_PCIE_PLL_OD		28
#define CLKID_PCIE_PLL			29
#define CLKID_PCIE_HCSL			30
#define CLKID_MPLL_50M_DIV		31
#define CLKID_MPLL_50M			32
#define CLKID_MPLL_PREDIV		33
#define CLKID_MPLL0_DIV			34
#define CLKID_MPLL0			35
#define CLKID_MPLL1_DIV			36
#define CLKID_MPLL1			37
#define CLKID_MPLL2_DIV			38
#define CLKID_MPLL2			39
#define CLKID_MPLL3_DIV			40
#define CLKID_MPLL3			41
#define CLKID_MCLK_PLL_DCO		42
#define CLKID_MCLK_0_PRE_OD		43
#define CLKID_MCLK_0_PLL		44
#define CLKID_MCLK_0_SEL		45
#define CLKID_MCLK_0_DIV2		46
#define CLKID_MCLK_0_DIV_EN		47
#define CLKID_MCLK_0			48
#define CLKID_MCLK_1_PRE_OD		49
#define CLKID_MCLK_1_PLL		50
#define CLKID_MCLK_1_SEL		51
#define CLKID_MCLK_1_DIV2		52
#define CLKID_MCLK_1_DIV_EN		53
#define CLKID_MCLK_1			54
#define CLKID_MCLK_2_PRE_OD		55
#define CLKID_MCLK_2_PLL		56
#define CLKID_MCLK_2_SEL		57
#define CLKID_MCLK_2_DIV2		58
#define CLKID_MCLK_2_DIV_EN		59
#define CLKID_MCLK_2			60
#define CLKID_MCLK_3_PRE_OD		61
#define CLKID_MCLK_3_PLL		62
#define CLKID_MCLK_3_SEL		63
#define CLKID_MCLK_3_DIV2		64
#define CLKID_MCLK_3_DIV_EN		65
#define CLKID_MCLK_3			66
#define CLKID_MCLK_4_PRE_OD		67
#define CLKID_MCLK_4_PLL		68
#define CLKID_MCLK_4_SEL		69
#define CLKID_MCLK_4_DIV2		70
#define CLKID_MCLK_4_DIV_EN		71
#define CLKID_MCLK_4			72
#define CLKID_A76_DYN_CLK		73
#define CLKID_A76_CLK			74
#define CLKID_DSU_DYN_CLK		75
#define CLKID_DSU_CLK			76
#define CLKID_DSU_FINAL_CLK		77
#define CLKID_CPU6_CLK			78
#define CLKID_CPU7_CLK			79
#define CLKID_GP2_PLL_DCO		80
#define CLKID_GP2_PLL			81
#define CLKID_NNA_PLL_DCO		82
#define CLKID_NNA_PLL			83
#define CLKID_M4_PLL_DCO		84
#define CLKID_M4_PLL			85
#define CLKID_FDLE_PLL_DCO		86
#define CLKID_FDLE_PLL			87
#define CLKID_MCLK_0_PLL_DIV_EN		88
#define CLKID_MCLK_1_PLL_DIV_EN		89
#define CLKID_MCLK_2_PLL_DIV_EN		90
#define CLKID_MCLK_3_PLL_DIV_EN		91
#define CLKID_MCLK_4_PLL_DIV_EN		92
#define CLKID_BASE			93

#define CLKID_RTC_32K_CLKIN		(CLKID_BASE + 0)
#define CLKID_RTC_32K_DIV		(CLKID_BASE + 1)
#define CLKID_RTC_32K_XATL		(CLKID_BASE + 2)
#define CLKID_RTC_32K_SEL		(CLKID_BASE + 3)
#define CLKID_RTC_CLK			(CLKID_BASE + 4)
#define CLKID_SYS_CLK_1_SEL		(CLKID_BASE + 5)
#define CLKID_SYS_CLK_1_DIV		(CLKID_BASE + 6)
#define CLKID_SYS_CLK_1			(CLKID_BASE + 7)
#define CLKID_SYS_CLK_0_SEL		(CLKID_BASE + 8)
#define CLKID_SYS_CLK_0_DIV		(CLKID_BASE + 9)
#define CLKID_SYS_CLK_0			(CLKID_BASE + 10)
#define CLKID_SYS_CLK			(CLKID_BASE + 11)
#define CLKID_DSPA_0_SEL		(CLKID_BASE + 20)
#define CLKID_DSPA_0_DIV		(CLKID_BASE + 21)
#define CLKID_DSPA_0			(CLKID_BASE + 22)
#define CLKID_DSPA_1_SEL		(CLKID_BASE + 23)
#define CLKID_DSPA_1_DIV		(CLKID_BASE + 24)
#define CLKID_DSPA_1			(CLKID_BASE + 25)
#define CLKID_DSPA			(CLKID_BASE + 26)
#define CLKID_DSPB_0_SEL		(CLKID_BASE + 27)
#define CLKID_DSPB_0_DIV		(CLKID_BASE + 28)
#define CLKID_DSPB_0			(CLKID_BASE + 29)
#define CLKID_DSPB_1_SEL		(CLKID_BASE + 30)
#define CLKID_DSPB_1_DIV		(CLKID_BASE + 31)
#define CLKID_DSPB_1			(CLKID_BASE + 32)
#define CLKID_DSPB			(CLKID_BASE + 33)
#define CLKID_24M_CLK_GATE		(CLKID_BASE + 34)
#define CLKID_24M_DIV2			(CLKID_BASE + 35)
#define CLKID_12M_CLK			(CLKID_BASE + 36)
#define CLKID_25M_CLK_DIV		(CLKID_BASE + 37)
#define CLKID_25M_CLK			(CLKID_BASE + 38)

#define PERI_BASE			(CLKID_BASE + 39)
#define CLKID_SD_EMMC_C_CLK_SEL		(PERI_BASE + 0)
#define CLKID_SD_EMMC_C_CLK_DIV		(PERI_BASE + 1)
#define CLKID_SD_EMMC_C_CLK		(PERI_BASE + 2)
#define CLKID_SD_EMMC_A_CLK_SEL		(PERI_BASE + 3)
#define CLKID_SD_EMMC_A_CLK_DIV		(PERI_BASE + 4)
#define CLKID_SD_EMMC_A_CLK		(PERI_BASE + 5)
#define CLKID_SD_EMMC_B_CLK_SEL		(PERI_BASE + 6)
#define CLKID_SD_EMMC_B_CLK_DIV		(PERI_BASE + 7)
#define CLKID_SD_EMMC_B_CLK		(PERI_BASE + 8)
#define CLKID_SPICC0_SEL		(PERI_BASE + 9)
#define CLKID_SPICC0_DIV		(PERI_BASE + 10)
#define CLKID_SPICC0			(PERI_BASE + 11)
#define CLKID_SPICC1_SEL		(PERI_BASE + 12)
#define CLKID_SPICC1_DIV		(PERI_BASE + 13)
#define CLKID_SPICC1			(PERI_BASE + 14)
#define CLKID_SPICC2_SEL		(PERI_BASE + 15)
#define CLKID_SPICC2_DIV		(PERI_BASE + 16)
#define CLKID_SPICC2			(PERI_BASE + 17)
#define CLKID_SPICC3_SEL		(PERI_BASE + 18)
#define CLKID_SPICC3_DIV		(PERI_BASE + 19)
#define CLKID_SPICC3			(PERI_BASE + 20)
#define CLKID_SPICC4_SEL		(PERI_BASE + 21)
#define CLKID_SPICC4_DIV		(PERI_BASE + 22)
#define CLKID_SPICC4			(PERI_BASE + 23)
#define CLKID_SPICC5_SEL		(PERI_BASE + 24)
#define CLKID_SPICC5_DIV		(PERI_BASE + 25)
#define CLKID_SPICC5			(PERI_BASE + 26)
#define CLKID_PWM_A_SEL			(PERI_BASE + 27)
#define CLKID_PWM_A_DIV			(PERI_BASE + 28)
#define CLKID_PWM_A			(PERI_BASE + 29)
#define CLKID_PWM_B_SEL			(PERI_BASE + 30)
#define CLKID_PWM_B_DIV			(PERI_BASE + 31)
#define CLKID_PWM_B			(PERI_BASE + 32)
#define CLKID_PWM_C_SEL			(PERI_BASE + 33)
#define CLKID_PWM_C_DIV			(PERI_BASE + 34)
#define CLKID_PWM_C			(PERI_BASE + 35)
#define CLKID_PWM_D_SEL			(PERI_BASE + 36)
#define CLKID_PWM_D_DIV			(PERI_BASE + 37)
#define CLKID_PWM_D			(PERI_BASE + 38)
#define CLKID_PWM_E_SEL			(PERI_BASE + 39)
#define CLKID_PWM_E_DIV			(PERI_BASE + 40)
#define CLKID_PWM_E			(PERI_BASE + 41)
#define CLKID_PWM_F_SEL			(PERI_BASE + 42)
#define CLKID_PWM_F_DIV			(PERI_BASE + 43)
#define CLKID_PWM_F			(PERI_BASE + 44)
#define CLKID_PWM_G_SEL			(PERI_BASE + 45)
#define CLKID_PWM_G_DIV			(PERI_BASE + 46)
#define CLKID_PWM_G			(PERI_BASE + 47)
#define CLKID_PWM_H_SEL			(PERI_BASE + 48)
#define CLKID_PWM_H_DIV			(PERI_BASE + 49)
#define CLKID_PWM_H			(PERI_BASE + 50)
#define CLKID_PWM_I_SEL			(PERI_BASE + 51)
#define CLKID_PWM_I_DIV			(PERI_BASE + 52)
#define CLKID_PWM_I			(PERI_BASE + 53)
#define CLKID_PWM_J_SEL			(PERI_BASE + 54)
#define CLKID_PWM_J_DIV			(PERI_BASE + 55)
#define CLKID_PWM_J			(PERI_BASE + 56)
#define CLKID_SARADC_SEL		(PERI_BASE + 57)
#define CLKID_SARADC_DIV		(PERI_BASE + 58)
#define CLKID_SARADC			(PERI_BASE + 59)
#define CLKID_GEN_SEL			(PERI_BASE + 60)
#define CLKID_GEN_DIV			(PERI_BASE + 61)
#define CLKID_GEN			(PERI_BASE + 62)
#define CLKID_ETH_RMII_SEL		(PERI_BASE + 63)
#define CLKID_ETH_RMII_DIV		(PERI_BASE + 64)
#define CLKID_ETH_RMII			(PERI_BASE + 65)
#define CLKID_ETH_DIV8			(PERI_BASE + 66)
#define CLKID_ETH_125M			(PERI_BASE + 67)
#define CLKID_TS_CLK_DIV		(PERI_BASE + 68)
#define CLKID_TS_CLK			(PERI_BASE + 69)
#define CLKID_USB_250M_SEL		(PERI_BASE + 70)
#define CLKID_USB_250M_DIV		(PERI_BASE + 71)
#define CLKID_USB_250M			(PERI_BASE + 72)
#define CLKID_PCIE_400M_SEL		(PERI_BASE + 73)
#define CLKID_PCIE_400M_DIV		(PERI_BASE + 74)
#define CLKID_PCIE_400M			(PERI_BASE + 75)
#define CLKID_PCIE_CLK_SEL		(PERI_BASE + 76)
#define CLKID_PCIE_CLK_DIV		(PERI_BASE + 77)
#define CLKID_PCIE_CLK			(PERI_BASE + 78)
#define CLKID_PCIE_TL_CLK_SEL		(PERI_BASE + 79)
#define CLKID_PCIE_TL_CLK_DIV		(PERI_BASE + 80)
#define CLKID_PCIE_TL_CLK		(PERI_BASE + 81)

#define MEDIA_BASE			(PERI_BASE + 82)
#define CLKID_VAPB_0_SEL		(MEDIA_BASE + 1)
#define CLKID_VAPB_0_DIV		(MEDIA_BASE + 2)
#define CLKID_VAPB_0			(MEDIA_BASE + 3)
#define CLKID_GE2D_SEL			(MEDIA_BASE + 4)
#define CLKID_GE2D_DIV			(MEDIA_BASE + 5)
#define CLKID_GE2D			(MEDIA_BASE + 6)
#define CLKID_NNA0_SEL			(MEDIA_BASE + 9)
#define CLKID_NNA0_DIV			(MEDIA_BASE + 10)
#define CLKID_NNA0			(MEDIA_BASE + 11)
#define CLKID_NNA1_SEL			(MEDIA_BASE + 12)
#define CLKID_NNA1_DIV			(MEDIA_BASE + 13)
#define CLKID_NNA1			(MEDIA_BASE + 14)
#define CLKID_NNA2_SEL			(MEDIA_BASE + 15)
#define CLKID_NNA2_DIV			(MEDIA_BASE + 16)
#define CLKID_NNA2			(MEDIA_BASE + 17)
#define CLKID_NNA3_SEL			(MEDIA_BASE + 18)
#define CLKID_NNA3_DIV			(MEDIA_BASE + 19)
#define CLKID_NNA3			(MEDIA_BASE + 20)
#define CLKID_NNA4_SEL			(MEDIA_BASE + 21)
#define CLKID_NNA4_DIV			(MEDIA_BASE + 22)
#define CLKID_NNA4			(MEDIA_BASE + 23)
#define CLKID_NNA5_SEL			(MEDIA_BASE + 24)
#define CLKID_NNA5_DIV			(MEDIA_BASE + 25)
#define CLKID_NNA5			(MEDIA_BASE + 26)
#define CLKID_ISP0_SEL			(MEDIA_BASE + 27)
#define CLKID_ISP0_DIV			(MEDIA_BASE + 28)
#define CLKID_ISP0			(MEDIA_BASE + 29)
#define CLKID_ISP1_SEL			(MEDIA_BASE + 30)
#define CLKID_ISP1_DIV			(MEDIA_BASE + 31)
#define CLKID_ISP1			(MEDIA_BASE + 32)
#define CLKID_ISP2_SEL			(MEDIA_BASE + 33)
#define CLKID_ISP2_DIV			(MEDIA_BASE + 34)
#define CLKID_ISP2			(MEDIA_BASE + 35)
#define CLKID_ISP3_SEL			(MEDIA_BASE + 36)
#define CLKID_ISP3_DIV			(MEDIA_BASE + 37)
#define CLKID_ISP3			(MEDIA_BASE + 38)
#define CLKID_ISP4_SEL			(MEDIA_BASE + 39)
#define CLKID_ISP4_DIV			(MEDIA_BASE + 40)
#define CLKID_ISP4			(MEDIA_BASE + 41)
#define CLKID_CSIPHY0_SEL		(MEDIA_BASE + 42)
#define CLKID_CSIPHY0_DIV		(MEDIA_BASE + 43)
#define CLKID_CSIPHY0			(MEDIA_BASE + 44)
#define CLKID_CSIPHY1_SEL		(MEDIA_BASE + 45)
#define CLKID_CSIPHY1_DIV		(MEDIA_BASE + 46)
#define CLKID_CSIPHY1			(MEDIA_BASE + 47)
#define CLKID_CSIPHY2_SEL		(MEDIA_BASE + 48)
#define CLKID_CSIPHY2_DIV		(MEDIA_BASE + 49)
#define CLKID_CSIPHY2			(MEDIA_BASE + 50)
#define CLKID_CSIPHY3_SEL		(MEDIA_BASE + 51)
#define CLKID_CSIPHY3_DIV		(MEDIA_BASE + 52)
#define CLKID_CSIPHY3			(MEDIA_BASE + 53)
#define CLKID_CSIPHY4_SEL		(MEDIA_BASE + 54)
#define CLKID_CSIPHY4_DIV		(MEDIA_BASE + 55)
#define CLKID_CSIPHY4			(MEDIA_BASE + 56)
#define CLKID_MOPA_SEL			(MEDIA_BASE + 57)
#define CLKID_MOPA_DIV			(MEDIA_BASE + 58)
#define CLKID_MOPA			(MEDIA_BASE + 59)
#define CLKID_MOPB_SEL			(MEDIA_BASE + 60)
#define CLKID_MOPB_DIV			(MEDIA_BASE + 61)
#define CLKID_MOPB			(MEDIA_BASE + 62)
#define CLKID_DEPA_SEL			(MEDIA_BASE + 63)
#define CLKID_DEPA_DIV			(MEDIA_BASE + 64)
#define CLKID_DEPA			(MEDIA_BASE + 65)
#define CLKID_DEPB_SEL			(MEDIA_BASE + 66)
#define CLKID_DEPB_DIV			(MEDIA_BASE + 67)
#define CLKID_DEPB			(MEDIA_BASE + 68)
#define CLKID_VFE_SEL			(MEDIA_BASE + 69)
#define CLKID_VFE_DIV			(MEDIA_BASE + 70)
#define CLKID_VFE			(MEDIA_BASE + 71)
#define CLKID_DEWARPA_SEL		(MEDIA_BASE + 72)
#define CLKID_DEWARPA_DIV		(MEDIA_BASE + 73)
#define CLKID_DEWARPA			(MEDIA_BASE + 74)
#define CLKID_DEWARPB_SEL		(MEDIA_BASE + 75)
#define CLKID_DEWARPB_DIV		(MEDIA_BASE + 76)
#define CLKID_DEWARPB			(MEDIA_BASE + 77)
#define CLKID_DEWARPC_SEL		(MEDIA_BASE + 78)
#define CLKID_DEWARPC_DIV		(MEDIA_BASE + 79)
#define CLKID_DEWARPC			(MEDIA_BASE + 80)
#define CLKID_M4_CLK_0_SEL		(MEDIA_BASE + 81)
#define CLKID_M4_CLK_0_DIV		(MEDIA_BASE + 82)
#define CLKID_M4_CLK_0			(MEDIA_BASE + 83)
#define CLKID_M4_CLK_1_SEL		(MEDIA_BASE + 84)
#define CLKID_M4_CLK_1_DIV		(MEDIA_BASE + 85)
#define CLKID_M4_CLK_1			(MEDIA_BASE + 86)
#define CLKID_M4_CLK			(MEDIA_BASE + 87)

#define SYS_BASE			(MEDIA_BASE + 88)
#define CLKID_SYS_CLK_DDR		(SYS_BASE + 0)
#define CLKID_SYS_CLK_ETHPHY		(SYS_BASE + 1)
#define CLKID_SYS_CLK_M4		(SYS_BASE + 2)
#define CLKID_SYS_CLK_GLB		(SYS_BASE + 3)
#define CLKID_SYS_CLK_AOCPU		(SYS_BASE + 4)
#define CLKID_SYS_CLK_AUCPU		(SYS_BASE + 5)
#define CLKID_SYS_CLK_DEWARPC		(SYS_BASE + 6)
#define CLKID_SYS_CLK_DEWARPB		(SYS_BASE + 7)
#define CLKID_SYS_CLK_DEWARPA		(SYS_BASE + 8)
#define CLKID_SYS_CLK_AMPIPE_NAND	(SYS_BASE + 9)
#define CLKID_SYS_CLK_AMPIPE_ETH	(SYS_BASE + 10)
#define CLKID_SYS_CLK_AM2AXI0		(SYS_BASE + 11)
#define CLKID_SYS_CLK_AM2AXI1		(SYS_BASE + 12)
#define CLKID_SYS_CLK_AM2AXI2		(SYS_BASE + 13)
#define CLKID_SYS_CLK_SD_EMMC_A		(SYS_BASE + 14)
#define CLKID_SYS_CLK_SD_EMMC_C		(SYS_BASE + 15)
#define CLKID_SYS_CLK_SPIFC		(SYS_BASE + 16)
#define CLKID_SYS_CLK_MSR_CLK		(SYS_BASE + 17)
/*REG1*/
#define CLKID_SYS_CLK_AUDIO		(SYS_BASE + 18)
#define CLKID_SYS_CLK_ETH		(SYS_BASE + 19)
#define CLKID_SYS_CLK_UART_A		(SYS_BASE + 20)
#define CLKID_SYS_CLK_UART_B		(SYS_BASE + 21)
#define CLKID_SYS_CLK_UART_C		(SYS_BASE + 22)
#define CLKID_SYS_CLK_UART_D		(SYS_BASE + 23)
#define CLKID_SYS_CLK_UART_E		(SYS_BASE + 24)
#define CLKID_SYS_CLK_UART_F		(SYS_BASE + 25)
#define CLKID_SYS_CLK_AIFIFO		(SYS_BASE + 26)
#define CLKID_SYS_CLK_SPICC2		(SYS_BASE + 27)
#define CLKID_SYS_CLK_SPICC3		(SYS_BASE + 28)
#define CLKID_SYS_CLK_SPICC4		(SYS_BASE + 29)
#define CLKID_SYS_CLK_TS_A76		(SYS_BASE + 30)
#define CLKID_SYS_CLK_TS_A55		(SYS_BASE + 31)
#define CLKID_SYS_CLK_SPICC5		(SYS_BASE + 32)
#define CLKID_SYS_CLK_TS_DDR_0		(SYS_BASE + 33)
#define CLKID_SYS_CLK_TS_DDR_1		(SYS_BASE + 34)
#define CLKID_SYS_CLK_G2D		(SYS_BASE + 35)
#define CLKID_SYS_CLK_SPICC0		(SYS_BASE + 36)
#define CLKID_SYS_CLK_SPICC1		(SYS_BASE + 37)
#define CLKID_SYS_CLK_PCIE		(SYS_BASE + 38)
#define CLKID_SYS_CLK_PCIEPHY		(SYS_BASE + 39)
#define CLKID_SYS_CLK_USB		(SYS_BASE + 40)
#define CLKID_SYS_CLK_PCIE_PHY0		(SYS_BASE + 41)
#define CLKID_SYS_CLK_PCIE_PHY1		(SYS_BASE + 42)
#define CLKID_SYS_CLK_PCIE_PHY2		(SYS_BASE + 43)
#define CLKID_SYS_CLK_I2C_M_A		(SYS_BASE + 44)
#define CLKID_SYS_CLK_I2C_M_B		(SYS_BASE + 45)
/*CLKCTRL_SYS_CLK_EN0_REG2*/
#define CLKID_SYS_CLK_I2C_M_C		(SYS_BASE + 46)
#define CLKID_SYS_CLK_I2C_M_D		(SYS_BASE + 47)
#define CLKID_SYS_CLK_I2C_M_E		(SYS_BASE + 48)
#define CLKID_SYS_CLK_I2C_M_F		(SYS_BASE + 49)
#define CLKID_SYS_CLK_I2C_M_G		(SYS_BASE + 50)
#define CLKID_SYS_CLK_I2C_M_H		(SYS_BASE + 51)
#define CLKID_SYS_CLK_I2C_M_I		(SYS_BASE + 52)
#define CLKID_SYS_CLK_I2C_M_J		(SYS_BASE + 53)
#define CLKID_SYS_CLK_I2C_S_A		(SYS_BASE + 54)
#define CLKID_SYS_CLK_I2C_M_K		(SYS_BASE + 55)
#define CLKID_SYS_CLK_MMC_PCLK		(SYS_BASE + 56)
#define CLKID_SYS_CLK_ISP_PCLK		(SYS_BASE + 57)
#define CLKID_SYS_CLK_RSA		(SYS_BASE + 58)
#define CLKID_SYS_CLK_PCLK_SYS_CPU_APB	(SYS_BASE + 59)
#define CLKID_SYS_CLK_DSPA		(SYS_BASE + 60)
#define CLKID_SYS_CLK_DSPB		(SYS_BASE + 61)
#define CLKID_SYS_CLK_SAR_ADC		(SYS_BASE + 62)
#define CLKID_SYS_CLK_GIC		(SYS_BASE + 63)
/*CLKCTRL_SYS_CLK_EN0_REG3*/
#define CLKID_SYS_CLK_TS_NNA		(SYS_BASE + 64)
#define CLKID_SYS_CLK_PWM_AB		(SYS_BASE + 65)
#define CLKID_SYS_CLK_PWM_CD		(SYS_BASE + 66)
#define CLKID_SYS_CLK_PWM_EF		(SYS_BASE + 67)
#define CLKID_SYS_CLK_PWM_GH		(SYS_BASE + 68)
#define CLKID_SYS_CLK_PWM_IJ		(SYS_BASE + 69)
#define CLKID_SYS_CLK_DEPA		(SYS_BASE + 70)
#define CLKID_SYS_CLK_DEPB		(SYS_BASE + 71)
#define CLKID_SYS_CLK_MOPA		(SYS_BASE + 72)
#define CLKID_SYS_CLK_MOPB		(SYS_BASE + 73)
#define CLKID_SYS_CLK_VFE		(SYS_BASE + 74)
#define CLKID_SYS_CLK_I2C_S_B		(SYS_BASE + 75)
#define CLKID_SYS_CLK_I2C_S_C		(SYS_BASE + 76)
#define CLKID_SYS_CLK_I2C_S_D		(SYS_BASE + 77)
#define CLKID_SYS_CLK_I2C_S_E		(SYS_BASE + 78)
#define CLKID_SYS_CLK_I2C_S_F		(SYS_BASE + 79)
#define CLKID_SYS_CLK_I2C_S_G		(SYS_BASE + 80)
#define CLKID_SYS_CLK_I2C_S_H		(SYS_BASE + 81)
#define CLKID_SYS_CLK_I2C_S_I		(SYS_BASE + 82)
#define CLKID_SYS_CLK_I2C_S_J		(SYS_BASE + 83)
#define CLKID_SYS_CLK_I2C_S_K		(SYS_BASE + 84)
#define NR_CLKS				(SYS_BASE + 85)

#endif /* __T3_CLKC_H */
