/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors;

import java.util.ArrayList;
import java.util.List;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.PropertiesEditorPlugin;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors.PropertiesPartitionScanner;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.listener.IPropertiesDocumentListener;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.property.PropertyUtil;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.resources.Messages;
import jp.gr.java_conf.ussiy.app.propedit.util.EncodeChanger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;

public class PropertiesDocumentProvider
extends FileDocumentProvider {
    private static final String EXTENSION_POINT = "jp.gr.java_conf.ussiy.app.propedit.listeners";

    protected List computePropertiesDocumentListeners() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_POINT);
        IExtension[] extensions = extensionPoint.getExtensions();
        ArrayList<Object> results = new ArrayList<Object>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                try {
                    Object listener = elements[j].createExecutableExtension("class");
                    if (listener instanceof IPropertiesDocumentListener) {
                        results.add(listener);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
        return results;
    }

    protected IDocument createDocument(Object element) throws CoreException {
        IPropertiesDocumentListener listener;
        IDocument document = super.createDocument(element);
        List listeners = this.computePropertiesDocumentListeners();
        int i = 0;
        while (i < listeners.size()) {
            listener = (IPropertiesDocumentListener)listeners.get(i);
            try {
                listener.beforeConvertAtLoadingDocument(document, element);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        if (document != null) {
            try {
                document.set(EncodeChanger.unicodeEsc2Unicode(document.get()));
            }
            catch (Exception e) {
                Status status = new Status(4, PropertiesEditorPlugin.PLUGIN_ID, 0, e.getMessage(), (Throwable)e);
                ILog log = PropertiesEditorPlugin.getDefault().getLog();
                log.log((IStatus)status);
                ErrorDialog.openError(null, (String)Messages.getString("eclipse.propertieseditor.convert.error"), (String)Messages.getString("eclipse.propertieseditor.property.get.settings.error"), (IStatus)status);
            }
            i = 0;
            while (i < listeners.size()) {
                listener = (IPropertiesDocumentListener)listeners.get(i);
                try {
                    listener.afterConvertAtLoadingDocument(document, element);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new PropertiesPartitionScanner(), new String[]{"__dftl_partition_content_type", "__properties_comment", "__properties_separator", "__properties_value"});
            partitioner.connect(document);
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
        return document;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (element instanceof IFileEditorInput) {
            String uniEscStr;
            List listeners;
            block16: {
                ILog log;
                Status status;
                IFileEditorInput input = (IFileEditorInput)element;
                IProject project = input.getFile().getProject();
                listeners = this.computePropertiesDocumentListeners();
                int i = 0;
                while (i < listeners.size()) {
                    IPropertiesDocumentListener listener = (IPropertiesDocumentListener)listeners.get(i);
                    try {
                        listener.beforeUnicodeConvertAtSavingDocument(monitor, element, document, overwrite);
                    }
                    catch (Exception e) {
                        status = new Status(4, PropertiesEditorPlugin.PLUGIN_ID, 0, e.getMessage(), (Throwable)e);
                        log = PropertiesEditorPlugin.getDefault().getLog();
                        log.log((IStatus)status);
                    }
                    ++i;
                }
                uniEscStr = null;
                String charcase = PropertyUtil.getCharCase(project, PropertiesEditorPlugin.getDefault().getPreferenceStore().getString("convertCharCase"));
                if (PropertyUtil.getNotAllConvert(project, PropertiesEditorPlugin.getDefault().getPreferenceStore().getBoolean("notConvert"))) {
                    uniEscStr = document.get();
                } else if (PropertyUtil.getNotConvertComment(project, PropertiesEditorPlugin.getDefault().getPreferenceStore().getBoolean("notConvertComment"))) {
                    try {
                        if (Messages.getString("eclipse.propertieseditor.preference.convert.char.uppercase").equals(charcase)) {
                            uniEscStr = EncodeChanger.unicode2UnicodeEscWithoutComment(document.get(), 1);
                            break block16;
                        }
                        uniEscStr = EncodeChanger.unicode2UnicodeEscWithoutComment(document.get(), 0);
                    }
                    catch (Exception e) {
                        status = new Status(4, PropertiesEditorPlugin.PLUGIN_ID, 0, e.getMessage(), (Throwable)e);
                        log = PropertiesEditorPlugin.getDefault().getLog();
                        log.log((IStatus)status);
                        ErrorDialog.openError(null, (String)Messages.getString("eclipse.propertieseditor.convert.error"), (String)Messages.getString("eclipse.propertieseditor.property.get.settings.error"), (IStatus)status);
                    }
                } else {
                    try {
                        uniEscStr = Messages.getString("eclipse.propertieseditor.preference.convert.char.uppercase").equals(charcase) ? EncodeChanger.unicode2UnicodeEsc(document.get(), 1) : EncodeChanger.unicode2UnicodeEsc(document.get(), 0);
                    }
                    catch (Exception e) {
                        status = new Status(4, PropertiesEditorPlugin.PLUGIN_ID, 0, e.getMessage(), (Throwable)e);
                        log = PropertiesEditorPlugin.getDefault().getLog();
                        log.log((IStatus)status);
                        ErrorDialog.openError(null, (String)Messages.getString("eclipse.propertieseditor.convert.error"), (String)Messages.getString("eclipse.propertieseditor.property.get.settings.error"), (IStatus)status);
                    }
                }
            }
            document = new Document(uniEscStr);
            int i = 0;
            while (i < listeners.size()) {
                IPropertiesDocumentListener listener = (IPropertiesDocumentListener)listeners.get(i);
                try {
                    listener.afterUnicodeConvertAtSavingDocument(monitor, element, document, overwrite);
                }
                catch (Exception e) {
                    Status status = new Status(4, PropertiesEditorPlugin.PLUGIN_ID, 0, e.getMessage(), (Throwable)e);
                    ILog log = PropertiesEditorPlugin.getDefault().getLog();
                    log.log((IStatus)status);
                }
                ++i;
            }
        }
        super.doSaveDocument(monitor, element, document, overwrite);
    }
}

