/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors;

import java.net.MalformedURLException;
import java.net.URL;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.PropertiesEditorPlugin;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors.ColorManager;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors.PropertiesEditor;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.property.PropertyUtil;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.resources.Messages;
import jp.gr.java_conf.ussiy.app.propedit.util.EncodeChanger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.MultiPageEditorPart;

public class MultiPagePropertiesEditor
extends MultiPageEditorPart
implements IGotoMarker {
    private PropertiesEditor editor;
    private StyledText text;

    void createPage0() {
        URL url = PropertiesEditorPlugin.getDefault().getBundle().getEntry("/");
        String path = "icons/editPage.gif";
        ImageDescriptor descriptor = null;
        try {
            descriptor = ImageDescriptor.createFromURL((URL)new URL(url, path));
        }
        catch (MalformedURLException malformedURLException) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        Image image = descriptor.createImage();
        try {
            this.editor = new PropertiesEditor();
            int index = this.addPage((IEditorPart)this.editor, this.getEditorInput());
            this.setPageText(index, Messages.getString("eclipse.tabname.edit"));
            this.setPartName(this.editor.getTitle());
            this.setPageImage(index, image);
            IPreferenceStore pStore = PropertiesEditorPlugin.getDefault().getPreferenceStore();
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)pStore, (String)"backgroundColor");
            Color color = new ColorManager().getColor(rgb);
            this.editor.setBackground(color);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    void createPage1() {
        URL url = PropertiesEditorPlugin.getDefault().getBundle().getEntry("/");
        String path = "icons/previewPage.gif";
        ImageDescriptor descriptor = null;
        try {
            descriptor = ImageDescriptor.createFromURL((URL)new URL(url, path));
        }
        catch (MalformedURLException malformedURLException) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        Image image = descriptor.createImage();
        Composite composite = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        this.text = new StyledText(composite, 768);
        this.text.setEditable(false);
        Display display = Display.getCurrent();
        RGB rgb = new RGB(240, 240, 240);
        Color color = new Color((Device)display, rgb);
        this.text.setBackground(color);
        int index = this.addPage((Control)composite);
        this.setPageText(index, Messages.getString("eclipse.tabname.preview"));
        this.setPageImage(index, image);
    }

    protected void createPages() {
        this.createPage0();
        this.createPage1();
        IPreferenceStore apiStore = PropertiesEditorPlugin.getDefault().getPreferenceStore();
        Composite container = this.getContainer();
        if (container != null && container instanceof CTabFolder) {
            apiStore.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if ("SHOW_TRADITIONAL_STYLE_TABS".equals(event.getProperty())) {
                        MultiPagePropertiesEditor.this.setTabStyle();
                    }
                }
            });
            CTabFolder tabFolder = (CTabFolder)this.getContainer();
            Display display = Display.getCurrent();
            Color titleForeColor = display.getSystemColor(30);
            Color titleBackColor1 = display.getSystemColor(31);
            Color titleBackColor2 = display.getSystemColor(32);
            tabFolder.setSelectionForeground(titleForeColor);
            tabFolder.setSelectionBackground(new Color[]{titleBackColor1, titleBackColor2}, new int[]{100}, true);
            this.setTabStyle();
        }
    }

    protected void setTabStyle() {
        IPreferenceStore apiStore = PropertiesEditorPlugin.getDefault().getPreferenceStore();
        boolean simple = apiStore.getBoolean("SHOW_TRADITIONAL_STYLE_TABS");
        Composite container = this.getContainer();
        if (container != null && container instanceof CTabFolder) {
            CTabFolder tabFolder = (CTabFolder)this.getContainer();
            tabFolder.setSimple(simple);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.getEditor(0).doSave(monitor);
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(0);
        editor.doSaveAs();
        this.setPageText(0, editor.getTitle());
        this.setInput(editor.getEditorInput());
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void pageChange(int newPageIndex) {
        block5: {
            super.pageChange(newPageIndex);
            String editorText = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).get();
            IProject project = ((IFileEditorInput)this.editor.getEditorInput()).getFile().getProject();
            if (PropertyUtil.getNotConvertComment(project, PropertiesEditorPlugin.getDefault().getPreferenceStore().getBoolean("notConvertComment"))) {
                String charcase = PropertyUtil.getCharCase(project, PropertiesEditorPlugin.getDefault().getPreferenceStore().getString("convertCharCase"));
                try {
                    if (Messages.getString("eclipse.propertieseditor.preference.convert.char.uppercase").equals(charcase)) {
                        this.text.setText(EncodeChanger.unicode2UnicodeEscWithoutComment(editorText, 1));
                        break block5;
                    }
                    this.text.setText(EncodeChanger.unicode2UnicodeEscWithoutComment(editorText, 0));
                }
                catch (Exception e) {
                    Status status = new Status(4, PropertiesEditorPlugin.PLUGIN_ID, 0, e.getMessage(), (Throwable)e);
                    ILog log = PropertiesEditorPlugin.getDefault().getLog();
                    log.log((IStatus)status);
                    ErrorDialog.openError(null, (String)Messages.getString("eclipse.propertieseditor.convert.error"), (String)Messages.getString("eclipse.propertieseditor.property.get.settings.error"), (IStatus)status);
                }
            } else {
                this.text.setText(EncodeChanger.unicode2UnicodeEsc(editorText));
            }
        }
    }

    public PropertiesEditor getEditor() {
        return this.editor;
    }

    public Object getAdapter(Class adapter) {
        return this.getEditor().getAdapter(adapter);
    }

    public void dispose() {
        this.editor.dispose();
        this.text.dispose();
        super.dispose();
    }
}

