#!/bin/sh

rm -f {edict2,edict2.utf8.*}
wget -N http://ftp.monash.edu/pub/nihongo/edict2.gz
gzip -dk edict2.gz

cp edict.hits edict.hits_bak

ruby ../src/convert-euc-to-utf8.rb edict2
ruby modify-edict.rb edict2.utf8

ruby ../src/get-yomigana-hyouki.rb edict2.utf8.modedict
ruby ../src/remove-duplicates.rb edict2.utf8.modedict.pairs

cat ../src/dictionary_oss/dictionary*.txt.mozc ../*/*.hits edict2.utf8.modedict.pairs.remdup > allwords
ruby ../src/apply-previous-hits.rb allwords

split -d -l $(expr $(grep '' allwords.new | wc -l) / 3 + 1) allwords.new allwords.new

ruby ../src/get-jawiki-hits.rb allwords.new00 &
ruby ../src/get-jawiki-hits.rb allwords.new01 &
ruby ../src/get-jawiki-hits.rb allwords.new02 &
wait

cat allwords.exist allwords.new*.hits > edict.hits

rm -f {edict2,edict2.utf8.*}
rm allwords*
