/*
 * Copyright (c) 2003-2007 Rony Shapiro <ronys@users.sourceforge.net>.
 * All rights reserved. Use of the code is allowed under the
 * Artistic License terms, as specified in the LICENSE file
 * distributed with this code, or available from
 * http://www.opensource.org/licenses/artistic-license.php
 */
// ExportTextXDlg.cpp : implementation file
//

#include "stdafx.h"
#include "passwordsafe.h"
#include "ExportTextXDlg.h"
#include "corelib/ItemData.h"
#include "ThisMfcApp.h"
#include <bitset>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CExportTextXDlg dialog


CExportTextXDlg::CExportTextXDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CExportTextXDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CExportTextXDlg)
	m_export_group_title = 1;
	m_export_user = 1;
	m_export_notes = 1;
	m_export_password = 1;
	m_export_ctime = 1;
	m_export_pmtime = 1;
	m_export_atime = 1;
	m_export_ltime = 1;
	m_export_rmtime = 1;
	m_export_url = 1;
	m_export_autotype = 1;
	m_export_pwhist = 1;
	m_export_subgroup = 0;
	m_export_subgroup_name = _T("*");
	m_export_subgroup_case = 0;
	m_subgroup_object = -1;
	m_subgroup_function = -1;

	//}}AFX_DATA_INIT
}


BOOL CExportTextXDlg::OnInitDialog()
{
	 CDialog::OnInitDialog();
	 m_bsExport.set();  // note: impossible to set them all even via the advanced dialog

	int index;
	CString cs_text;

	CComboBox *cboSubgroupFunction = (CComboBox *)GetDlgItem(IDC_EXPORTX_SUBGROUP_FUNCTION);
	if(cboSubgroupFunction->GetCount() == 0) {
		cs_text.LoadString(IDS_EQUALS);
		index = cboSubgroupFunction->AddString(cs_text);
		cboSubgroupFunction->SetItemData(index, CItemData::SGF_EQUALS);
		cs_text.LoadString(IDS_DOESNOTEQUAL);
		index = cboSubgroupFunction->AddString(cs_text);
		cboSubgroupFunction->SetItemData(index, CItemData::SGF_NOTEQUAL);
		cs_text.LoadString(IDS_BEGINSWITH);
		index = cboSubgroupFunction->AddString(cs_text);
		cboSubgroupFunction->SetItemData(index, CItemData::SGF_BEGINS);
		cs_text.LoadString(IDS_DOESNOTBEGINSWITH);
		index = cboSubgroupFunction->AddString(cs_text);
		cboSubgroupFunction->SetItemData(index, CItemData::SGF_NOTBEGIN);
		cs_text.LoadString(IDS_ENDSWITH);
		index = cboSubgroupFunction->AddString(cs_text);
		cboSubgroupFunction->SetItemData(index, CItemData::SGF_ENDS);
		cs_text.LoadString(IDS_DOESNOTENDWITH);
		index = cboSubgroupFunction->AddString(cs_text);
		cboSubgroupFunction->SetItemData(index, CItemData::SGF_NOTEND);
		cs_text.LoadString(IDS_CONTAINS);
		index = cboSubgroupFunction->AddString(cs_text);
		cboSubgroupFunction->SetItemData(index, CItemData::SGF_CONTAINS);
		cs_text.LoadString(IDS_DOESNOTCONTAIN);
		index = cboSubgroupFunction->AddString(cs_text);
		cboSubgroupFunction->SetItemData(index, CItemData::SGF_NOTCONTAIN);
	}
	cboSubgroupFunction->SetCurSel(0);

	CComboBox *cboSubgroupObject = (CComboBox *)GetDlgItem(IDC_EXPORTX_SUBGROUP_OBJECT);
	if(cboSubgroupObject->GetCount() == 0) {
		cs_text.LoadString(IDS_GROUP);
		index = cboSubgroupObject->AddString(cs_text);
		cboSubgroupObject->SetItemData(index, CItemData::SGO_GROUP);
		cs_text.LoadString(IDS_TITLE);
		index = cboSubgroupObject->AddString(cs_text);
		cboSubgroupObject->SetItemData(index, CItemData::SGO_TITLE);
		cs_text.LoadString(IDS_USERNAME);
		index = cboSubgroupObject->AddString(cs_text);
		cboSubgroupObject->SetItemData(index, CItemData::SGO_USER);
		cs_text.LoadString(IDS_GROUPTITLE);
		index = cboSubgroupObject->AddString(cs_text);
		cboSubgroupObject->SetItemData(index, CItemData::SGO_GROUPTITLE);
		cs_text.LoadString(IDS_URL);
		index = cboSubgroupObject->AddString(cs_text);
		cboSubgroupObject->SetItemData(index, CItemData::SGO_URL);
		cs_text.LoadString(IDS_NOTES);
		index = cboSubgroupObject->AddString(cs_text);
		cboSubgroupObject->SetItemData(index, CItemData::SGO_NOTES);
	}
	cboSubgroupObject->SetCurSel(0);

	return TRUE;
}


void CExportTextXDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CExportTextXDlg)
	DDX_Check(pDX, IDC_EXPORTX_GROUP_TITLE, m_export_group_title);
	DDX_Check(pDX, IDC_EXPORTX_USER, m_export_user);
	DDX_Check(pDX, IDC_EXPORTX_NOTES, m_export_notes);
	DDX_Check(pDX, IDC_EXPORTX_PASSWORD, m_export_password);
	DDX_Check(pDX, IDC_EXPORTX_CTIME, m_export_ctime);
	DDX_Check(pDX, IDC_EXPORTX_PMTIME, m_export_pmtime);
	DDX_Check(pDX, IDC_EXPORTX_ATIME, m_export_atime);
	DDX_Check(pDX, IDC_EXPORTX_LTIME, m_export_ltime);
	DDX_Check(pDX, IDC_EXPORTX_RMTIME, m_export_rmtime);
	DDX_Check(pDX, IDC_EXPORTX_URL, m_export_url);
	DDX_Check(pDX, IDC_EXPORTX_AUTOTYPE, m_export_autotype);
	DDX_Check(pDX, IDC_EXPORTX_PWHIST, m_export_pwhist);
	DDX_Check(pDX, IDC_EXPORTX_SUBGROUP, m_export_subgroup);
	DDX_Check(pDX, IDC_EXPORTX_SUBGROUP_CASE, m_export_subgroup_case);
	DDX_Text(pDX, IDC_EXPORTX_SUBGROUP_NAME, m_export_subgroup_name);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CExportTextXDlg, CDialog)
	//{{AFX_MSG_MAP(CExportTextXDlg)
	ON_BN_CLICKED(IDC_EXPORTX_SETTIMES, OnSetTimes)
	ON_BN_CLICKED(IDC_EXPORTX_CLEARTIMES, OnClearTimes)
	ON_BN_CLICKED(IDC_EXPORTX_SUBGROUP, OnSetSubGroup)
	ON_BN_CLICKED(IDC_EXPORTX_SETALL, OnSetAll)
	ON_BN_CLICKED(IDC_EXPORTX_CLEARALL, OnClearAll)
	ON_BN_CLICKED(ID_HELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CExportTextXDlg message handlers

void CExportTextXDlg::OnHelp()
{
  CString cs_HelpTopic;
  cs_HelpTopic = app.GetHelpFileName() + _T("::/html/exportx.html");
  HtmlHelp(DWORD_PTR((LPCTSTR)cs_HelpTopic), HH_DISPLAY_TOPIC);
}

void CExportTextXDlg::OnOK()
{
	UpdateData();
	m_bsExport.reset();

	m_bsExport.set(CItemData::GROUP, m_export_group_title == 1 ? true : false);
	m_bsExport.set(CItemData::PASSWORD, m_export_password == 1 ? true : false);
	m_bsExport.set(CItemData::USER, m_export_user == 1 ? true : false);
	m_bsExport.set(CItemData::NOTES, m_export_notes == 1 ? true : false);
	m_bsExport.set(CItemData::PASSWORD, m_export_password == 1 ? true : false);
	m_bsExport.set(CItemData::CTIME, m_export_ctime == 1 ? true : false);
	m_bsExport.set(CItemData::PMTIME, m_export_pmtime == 1 ? true : false);
	m_bsExport.set(CItemData::ATIME, m_export_atime == 1 ? true : false);
	m_bsExport.set(CItemData::LTIME, m_export_ltime == 1 ? true : false);
	m_bsExport.set(CItemData::RMTIME, m_export_rmtime == 1 ? true : false);
	m_bsExport.set(CItemData::URL, m_export_url == 1 ? true : false);
	m_bsExport.set(CItemData::AUTOTYPE, m_export_autotype == 1 ? true : false);
	m_bsExport.set(CItemData::PWHIST, m_export_pwhist == 1 ? true : false);

	if (m_bsExport.count() == 0) {
		AfxMessageBox(IDS_NOFIELDSFOREXPORT);
		m_bsExport.set();  // note: impossible to set them all even via the advanced dialog
		return;
	}

	if (m_export_subgroup == 1) {
		GetDlgItemText(IDC_EXPORTX_SUBGROUP_NAME, m_export_subgroup_name);
		int nObject = ((CComboBox *)GetDlgItem(IDC_EXPORTX_SUBGROUP_OBJECT))->GetCurSel();
		if (nObject == CB_ERR) {
			AfxMessageBox(IDS_NOOBJECT);
			m_bsExport.set();  // note: impossible to set them all even via the advanced dialog
			((CComboBox *)GetDlgItem(IDC_EXPORTX_SUBGROUP_OBJECT))->SetFocus();
			return;
		}
		int nFunction = ((CComboBox *)GetDlgItem(IDC_EXPORTX_SUBGROUP_FUNCTION))->GetCurSel();
		if (nFunction == CB_ERR) {
			AfxMessageBox(IDS_NOFUNCTION);
			m_bsExport.set();  // note: impossible to set them all even via the advanced dialog
			((CComboBox *)GetDlgItem(IDC_EXPORTX_SUBGROUP_FUNCTION))->SetFocus();
			return;
		}
		m_subgroup_object = ((CComboBox *)GetDlgItem(IDC_EXPORTX_SUBGROUP_OBJECT))->GetItemData(nObject);
		m_subgroup_function = ((CComboBox *)GetDlgItem(IDC_EXPORTX_SUBGROUP_FUNCTION))->GetItemData(nFunction);
		if (m_export_subgroup_case == 1)
			m_subgroup_function *= (-1);
	}

	if (m_export_subgroup_name == _T("*"))
		m_export_subgroup_name.Empty();

	CDialog::OnOK();
}

void CExportTextXDlg::OnSetSubGroup()
{
	m_export_subgroup = ((CButton*)GetDlgItem(IDC_EXPORTX_SUBGROUP))->GetCheck();
	if (m_export_subgroup == 1) {
		GetDlgItem(IDC_EXPORTX_SUBGROUP_NAME)->EnableWindow(TRUE);
	} else {
		GetDlgItem(IDC_EXPORTX_SUBGROUP_NAME)->EnableWindow(FALSE);
	}
}

void CExportTextXDlg::OnSetAll()
{
	((CButton*)GetDlgItem(IDC_EXPORTX_GROUP_TITLE))->SetCheck(BST_CHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_USER))->SetCheck(BST_CHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_NOTES))->SetCheck(BST_CHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_PASSWORD))->SetCheck(BST_CHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_CTIME))->SetCheck(BST_CHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_PMTIME))->SetCheck(BST_CHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_ATIME))->SetCheck(BST_CHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_LTIME))->SetCheck(BST_CHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_RMTIME))->SetCheck(BST_CHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_URL))->SetCheck(BST_CHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_AUTOTYPE))->SetCheck(BST_CHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_PWHIST))->SetCheck(BST_CHECKED);
	m_export_group_title = m_export_user = m_export_notes = m_export_password =
		m_export_ctime = m_export_pmtime = m_export_atime = m_export_ltime = m_export_rmtime =
		m_export_url = m_export_autotype = m_export_pwhist = m_export_subgroup = 1;
}

void CExportTextXDlg::OnClearAll()
{
	((CButton*)GetDlgItem(IDC_EXPORTX_GROUP_TITLE))->SetCheck(BST_UNCHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_USER))->SetCheck(BST_UNCHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_NOTES))->SetCheck(BST_UNCHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_PASSWORD))->SetCheck(BST_UNCHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_CTIME))->SetCheck(BST_UNCHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_PMTIME))->SetCheck(BST_UNCHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_ATIME))->SetCheck(BST_UNCHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_LTIME))->SetCheck(BST_UNCHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_RMTIME))->SetCheck(BST_UNCHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_URL))->SetCheck(BST_UNCHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_AUTOTYPE))->SetCheck(BST_UNCHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_PWHIST))->SetCheck(BST_UNCHECKED);
	m_export_group_title = m_export_user = m_export_notes = m_export_password =
		m_export_ctime = m_export_pmtime = m_export_atime = m_export_ltime = m_export_rmtime =
		m_export_url = m_export_autotype = m_export_pwhist = m_export_subgroup = 0;

}

void CExportTextXDlg::OnSetTimes()
{
	((CButton*)GetDlgItem(IDC_EXPORTX_CTIME))->SetCheck(BST_CHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_PMTIME))->SetCheck(BST_CHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_ATIME))->SetCheck(BST_CHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_LTIME))->SetCheck(BST_CHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_RMTIME))->SetCheck(BST_CHECKED);
	m_export_ctime = m_export_pmtime = m_export_atime = m_export_ltime = m_export_rmtime = 1;
}

void CExportTextXDlg::OnClearTimes()
{
	((CButton*)GetDlgItem(IDC_EXPORTX_CTIME))->SetCheck(BST_UNCHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_PMTIME))->SetCheck(BST_UNCHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_ATIME))->SetCheck(BST_UNCHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_LTIME))->SetCheck(BST_UNCHECKED);
	((CButton*)GetDlgItem(IDC_EXPORTX_RMTIME))->SetCheck(BST_UNCHECKED);
	m_export_ctime = m_export_pmtime = m_export_atime = m_export_ltime = m_export_rmtime = 0;
}
