!(function(window) {
  "use strict";

  // 回调参数在 params 中的接口集
  var innerParamsCallbackMap = {
    httpPost: true,
    httpGet: true
  };

  var _jsAsynCall = window.external && window.external.jsAsynCall;
  var _cefQuery = window.cefQuery;
  var jsAsynCallCallbackCount = 0;

  /**
   * webJs 与 KsoApi 通信一级接口
   * @param  {String}   methodName    KsoApi方法名
   * @param  {[JSON]}   [args]        KsoApi方法约定数据格式JSON
   * @param  {[Function]} [callback]  KsoApi执行回调
   * @return {[type]}                 undefined
   */
  var jsAsynCall = function(methodName, args, callback) {
    console.log(methodName);
    var invokeParams = {
      method: methodName,
      params: args
    };

    if (callback) {
      var callbackName =
        methodName.replace(/\./g, "_") + "_async_callback_" + ++jsAsynCallCallbackCount;
      if (innerParamsCallbackMap.hasOwnProperty(methodName)) {
        args || (args = {});
        args.callback = callbackName;

        window[callbackName] = function(res) {
          delete window[callbackName];
          var result = window.Base64.decode(res);
          if (res) {
            try {
              result = JSON.parse(window.Base64.decode(res));
            } catch (e) {
              console.log(e);
            }
          }
          callback(result);
        };
      } else {
        invokeParams.callback = callbackName;
        window[callbackName] = function(res) {
          delete window[callbackName];
          var result = JSON.parse(window.Base64.decode(res));
          callback(result);
        };
      }
    }

    // "fromJSAsynCallBase64"
    // "jsAsynCall"
    var queryMethodName = "fromJSAsynCallBase64";
    var jsonIn = window.Base64.encode(JSON.stringify(invokeParams));
    if (_cefQuery) {
      _cefQuery({
        request: queryMethodName + '("' + jsonIn + '")',
        persistent: false
      });
    } else {
      _jsAsynCall(jsonIn);
    }
  };

  var jsAsynCallHelper = function(methodName, args, callback) {
    if (!callback) {
      window.top.ksoJsAsynCall(methodName, args);
      return;
    }

    var callbackName =
      window.name +
      "_" +
      methodName +
      "_async_callback_" +
      ++jsAsynCallCallbackCount;
    window[callbackName] = function(res) {
      delete window[callbackName];
      callback(res);
    }

    var callbackHelper = window[callbackName];
    window.top.ksoJsAsynCall(methodName, args, callbackHelper);
  };
  
  var registerCallback = function (funcName, callback) {
    if (!window[funcName]) {
      window[funcName] = function (res) {
        callback(JSON.parse(Base64.decode(res)));
      };
    }
  };

  var unregisterCallback = function (funcName) {
    delete window[funcName];
  };
  
  window.ksoJsAsynCall = window == window.top ? jsAsynCall : jsAsynCallHelper;
  window.ksoRegisterCallback = registerCallback;
  window.ksoUnregisterCallback = unregisterCallback;
})(window);
