/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.matchers;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.regex.charset.CompressedCodePointSet;
import com.oracle.truffle.regex.charset.Range;
import com.oracle.truffle.regex.tregex.matchers.HybridBitSetMatcherNodeGen;
import com.oracle.truffle.regex.tregex.matchers.InvertibleCharMatcher;
import com.oracle.truffle.regex.tregex.util.MathUtil;
import com.oracle.truffle.regex.util.BitSets;

public abstract class HybridBitSetMatcher
extends InvertibleCharMatcher {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] sortedRanges;
    @CompilerDirectives.CompilationFinal(dimensions=2)
    private final long[][] bitSets;

    HybridBitSetMatcher(boolean invert, int[] sortedRanges, long[][] bitSets) {
        super(invert);
        this.sortedRanges = sortedRanges;
        this.bitSets = bitSets;
        assert (bitSets.length == sortedRanges.length / 2);
    }

    public static HybridBitSetMatcher create(boolean invert, CompressedCodePointSet ccps) {
        return HybridBitSetMatcherNodeGen.create(invert, ccps.getRanges(), ccps.getBitSets());
    }

    @Specialization
    public boolean match(int c) {
        CompilerAsserts.partialEvaluationConstant((Object)((Object)this));
        return this.matchTree(0, (this.sortedRanges.length >>> 1) - 1, c);
    }

    private boolean matchTree(int fromIndex, int toIndex, int c) {
        CompilerAsserts.partialEvaluationConstant((int)fromIndex);
        CompilerAsserts.partialEvaluationConstant((int)toIndex);
        if (fromIndex > toIndex) {
            return this.result(false);
        }
        int mid = fromIndex + toIndex >>> 1;
        CompilerAsserts.partialEvaluationConstant((int)mid);
        if (c < this.sortedRanges[mid << 1]) {
            return this.matchTree(fromIndex, mid - 1, c);
        }
        if (c > this.sortedRanges[(mid << 1) + 1]) {
            return this.matchTree(mid + 1, toIndex, c);
        }
        return this.result(this.bitSets[mid] == null || BitSets.get(this.bitSets[mid], HybridBitSetMatcher.lowByte(c)));
    }

    @Override
    public int estimatedCost() {
        return 2 * (MathUtil.log2ceil(this.sortedRanges.length / 2) - 1);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        StringBuilder sb = new StringBuilder("hybrid ").append(this.modifiersToString()).append("[");
        for (int i = 0; i < this.sortedRanges.length; i += 2) {
            if (this.bitSets[i / 2] == null) {
                sb.append(Range.toString(this.sortedRanges[i], this.sortedRanges[i + 1]));
                continue;
            }
            sb.append("[range: ").append(Range.toString(this.sortedRanges[i], this.sortedRanges[i + 1])).append(", bs: ").append(BitSets.toString(this.bitSets[i / 2])).append("]");
        }
        return sb.append("]").toString();
    }
}

