/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.scripts.wizard;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.scripts.exceptions.ScriptException;
import org.phoenicis.scripts.ui.BrowserControl;
import org.phoenicis.scripts.ui.InstallationType;
import org.phoenicis.scripts.ui.MenuItem;
import org.phoenicis.scripts.ui.Message;
import org.phoenicis.scripts.ui.ProgressControl;
import org.phoenicis.scripts.ui.SetupUi;
import org.phoenicis.scripts.ui.SetupUiFactory;
import org.phoenicis.scripts.ui.UiMessageSender;
import org.phoenicis.scripts.wizard.SetupWizard;

public class UiSetupWizardImplementation
implements SetupWizard {
    private final String title;
    private final InstallationType installationType;
    private Optional<URI> miniature;
    private final UiMessageSender messageSender;
    private final SetupUiFactory setupUiFactory;
    private SetupUi setupUi;
    private final String userHome;
    private final String applicationUserRoot;
    private final String applicationName;

    public UiSetupWizardImplementation(String title, Optional<URI> miniature, InstallationType installationType, UiMessageSender messageSender, SetupUiFactory setupUiFactory, String userHome, String applicationUserRoot, String applicationName) {
        this.title = title;
        this.miniature = miniature;
        this.installationType = installationType;
        this.messageSender = messageSender;
        this.setupUiFactory = setupUiFactory;
        this.userHome = userHome;
        this.applicationUserRoot = applicationUserRoot;
        this.applicationName = applicationName;
    }

    @Override
    public void init() {
        this.messageSender.run(() -> {
            this.setupUi = this.setupUiFactory.createSetupWindow(this.title, this.miniature, this.installationType);
            return this.setupUi;
        });
    }

    @Override
    public void setLeftImageText(String leftImageText) {
        this.setupUi.setLeftImageText(leftImageText);
    }

    @Override
    public void setTopImage(String topImage) throws IOException {
        this.setupUi.setTopImage(new File(topImage));
    }

    @Override
    public void close() {
        this.messageSender.run(() -> {
            this.setupUi.close();
            return null;
        });
    }

    @Override
    public Void message(String textToShow) {
        return (Void)this.messageSender.runAndWait(message -> this.setupUi.showSimpleMessageStep((Message<Void>)message, textToShow));
    }

    @Override
    public Void presentationHtml(String htmlToShow) {
        return (Void)this.messageSender.runAndWait(message -> this.setupUi.showHtmlPresentationStep((Message<Void>)message, htmlToShow));
    }

    @Override
    public Void presentation(String programName, String programEditor, String applicationHomepage, String scriptorName) {
        String htmlToShow = "<body>" + Localisation.tr((String)"Installation wizard for {0}", (Object)programName) + ".<br><br>" + Localisation.tr((String)"Program by {0}", (Object)programEditor) + "<br><br>" + (String)Localisation.tr((Object)"For more information about this program, visit:") + String.format("<br><a href=\"%1$s\">%1$s</a><br><br>", applicationHomepage) + Localisation.tr((String)"Installation script by {0}", (Object)scriptorName) + "<br><br><br><br>" + Localisation.tr((String)"{0} will be installed in: {1}", (Object)programName, (Object)this.applicationUserRoot) + "<br><br>" + Localisation.tr((String)"{0} is not responsible for anything that might happen as a result of using these scripts.", (Object)this.applicationName) + "<br><br>" + (String)Localisation.tr((Object)"Click Next to start.") + "</body>";
        return (Void)this.messageSender.runAndWait(message -> this.setupUi.showHtmlPresentationStep((Message<Void>)message, htmlToShow));
    }

    @Override
    public Void presentation(String textToShow) {
        return (Void)this.messageSender.runAndWait(message -> this.setupUi.showPresentationStep((Message<Void>)message, textToShow));
    }

    @Override
    public Void licenceFile(String textToShow, File licenceFile) {
        Void void_;
        FileInputStream content = new FileInputStream(licenceFile);
        try {
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)content, (Writer)writer, (String)"UTF-8");
            void_ = this.licence(textToShow, writer.toString());
        }
        catch (Throwable throwable) {
            try {
                try {
                    content.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ScriptException("Cannot acces the licence file", e);
            }
        }
        content.close();
        return void_;
    }

    @Override
    public Void licenceFile(String textToShow, String licenceFilePath) {
        return this.licenceFile(textToShow, new File(licenceFilePath));
    }

    @Override
    public Void licence(String textToShow, String licenceText) {
        return (Void)this.messageSender.runAndWait(message -> this.setupUi.showLicenceStep((Message<Void>)message, textToShow, licenceText));
    }

    @Override
    public String textbox(String textToShow) {
        return this.textbox(textToShow, "");
    }

    @Override
    public String textbox(String textToShow, String defaultValue) {
        return (String)this.messageSender.runAndWait(message -> this.setupUi.showTextBoxStep((Message<String>)message, textToShow, defaultValue));
    }

    @Override
    public MenuItem menu(String textToShow, List<String> menuItems) {
        return this.menu(textToShow, menuItems, "");
    }

    @Override
    public MenuItem menu(String textToShow, List<String> menuItems, String defaultValue) {
        List<String> copiedMenuItems = List.copyOf(menuItems);
        return (MenuItem)this.messageSender.runAndWait(message -> this.setupUi.showMenuStep((Message<MenuItem>)message, textToShow, copiedMenuItems, defaultValue));
    }

    @Override
    public String browse(String textToShow) {
        return this.browse(textToShow, this.userHome, null);
    }

    @Override
    public String browse(String textToShow, String directory, List<String> allowedExtensions) {
        List<String> copiedAllowedExtensions = allowedExtensions != null ? List.copyOf(allowedExtensions) : null;
        return (String)this.messageSender.runAndWait(message -> this.setupUi.showBrowseStep((Message<String>)message, textToShow, new File(directory), copiedAllowedExtensions));
    }

    @Override
    public Void wait(String textToShow) {
        return (Void)this.messageSender.runAndWait(message -> this.setupUi.showSpinnerStep((Message<Void>)message, textToShow));
    }

    @Override
    public ProgressControl progressBar(String textToShow) {
        return (ProgressControl)this.messageSender.runAndWait(message -> this.setupUi.showProgressBar((Message<ProgressControl>)message, textToShow));
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public BrowserControl createBrowser(String textToShow) {
        return (BrowserControl)this.messageSender.runAndWait(message -> this.setupUi.showBrowser((Message<BrowserControl>)message, textToShow));
    }
}

