/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.scripts.ui;

import java.util.concurrent.Semaphore;
import org.phoenicis.scripts.exceptions.ScriptException;

public class Message<T> {
    private T message;
    private final Semaphore semaphore = new Semaphore(0);
    private Thread senderThread;

    void block() {
        this.senderThread = Thread.currentThread();
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new ScriptException(e);
        }
    }

    public void send(T message) {
        this.message = message;
        this.semaphore.release();
    }

    public void sendCancelSignal() {
        this.senderThread.interrupt();
    }

    T get() {
        if (Thread.currentThread().isInterrupted()) {
            throw new ScriptException("The script was interrupted");
        }
        return this.message;
    }
}

