/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.scripts.interpreter;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.phoenicis.scripts.session.InteractiveScriptSession;

public interface ScriptInterpreter {
    public void runScript(String var1, Runnable var2, Consumer<Exception> var3);

    default public void runScript(String scriptContent, Consumer<Exception> errorCallback) {
        this.runScript(scriptContent, () -> {}, errorCallback);
    }

    default public void runScript(File scriptFile, Consumer<Exception> errorCallback) {
        try {
            this.runScript(IOUtils.toString((InputStream)new FileInputStream(scriptFile), (String)"UTF-8"), errorCallback);
        }
        catch (Exception e) {
            errorCallback.accept(e);
        }
    }

    public InteractiveScriptSession createInteractiveSession();
}

