/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.scripts.interpreter;

import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.phoenicis.scripts.interpreter.ScriptInterpreter;
import org.phoenicis.scripts.session.InteractiveScriptSession;

public class BackgroundScriptInterpreter
implements ScriptInterpreter {
    private final ScriptInterpreter delegated;
    private final ExecutorService executorService;

    public BackgroundScriptInterpreter(ScriptInterpreter delegated, ExecutorService executorService) {
        this.delegated = delegated;
        this.executorService = executorService;
    }

    @Override
    public void runScript(String scriptContent, Runnable doneCallback, Consumer<Exception> errorCallback) {
        this.executorService.execute(() -> this.delegated.runScript(scriptContent, doneCallback, errorCallback));
    }

    @Override
    public InteractiveScriptSession createInteractiveSession() {
        InteractiveScriptSession interactiveScriptSession = this.delegated.createInteractiveSession();
        return (evaluation, responseCallback, errorCallback) -> this.executorService.execute(() -> interactiveScriptSession.eval(evaluation, responseCallback, errorCallback));
    }
}

